/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.presenter;

import android.content.Context;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.vungle.ads.AnalyticsClient;
import com.vungle.ads.ServiceLocator;
import com.vungle.ads.internal.ConfigManager;
import com.vungle.ads.internal.executor.Executors;
import com.vungle.ads.internal.executor.VungleThreadPoolExecutor;
import com.vungle.ads.internal.model.AdPayload;
import com.vungle.ads.internal.model.Placement;
import com.vungle.ads.internal.platform.Platform;
import com.vungle.ads.internal.platform.WebViewUtil;
import com.vungle.ads.internal.presenter.PreloadDelegate;
import com.vungle.ads.internal.presenter.WebViewManager;
import com.vungle.ads.internal.privacy.PrivacyManager;
import com.vungle.ads.internal.protos.Sdk;
import com.vungle.ads.internal.ui.VungleWebClient;
import com.vungle.ads.internal.util.Logger;
import com.vungle.ads.internal.util.ThreadUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001(B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u0004J&\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJM\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u00042\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%H\u0000\u00a2\u0006\u0004\b&\u0010'R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\bj\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)\u00b2\u0006\n\u0010*\u001a\u00020+X\u008a\u0084\u0002\u00b2\u0006\n\u0010\u001b\u001a\u00020\u001cX\u008a\u0084\u0002"}, d2={"Lcom/vungle/ads/internal/presenter/WebViewManager;", "", "()V", "TAG", "", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "webViewCache", "Ljava/util/LinkedHashMap;", "Lcom/vungle/ads/internal/presenter/WebViewManager$WebViewEntry;", "Lkotlin/collections/LinkedHashMap;", "destroyWebView", "", "key", "destroyWebViewInternal", "getOrCreateWebView", "Landroid/webkit/WebView;", "context", "Landroid/content/Context;", "getOrCreateWebViewClient", "Lcom/vungle/ads/internal/ui/VungleWebClient;", "advertisement", "Lcom/vungle/ads/internal/model/AdPayload;", "placement", "Lcom/vungle/ads/internal/model/Placement;", "offloadExecutor", "Lcom/vungle/ads/internal/executor/VungleThreadPoolExecutor;", "platform", "Lcom/vungle/ads/internal/platform/Platform;", "preloadWebView", "adv", "templatePath", "webSettings", "Lcom/vungle/ads/internal/model/AdPayload$WebViewSettings;", "delegate", "Lcom/vungle/ads/internal/presenter/PreloadDelegate;", "loadDuration", "", "preloadWebView$vungle_ads_release", "(Landroid/content/Context;Lcom/vungle/ads/internal/model/AdPayload;Lcom/vungle/ads/internal/model/Placement;Ljava/lang/String;Lcom/vungle/ads/internal/model/AdPayload$WebViewSettings;Lcom/vungle/ads/internal/presenter/PreloadDelegate;Ljava/lang/Long;)V", "WebViewEntry", "vungle-ads_release", "executors", "Lcom/vungle/ads/internal/executor/Executors;"})
public final class WebViewManager {
    @NotNull
    public static final WebViewManager INSTANCE = new WebViewManager();
    @NotNull
    private static final String TAG = "WebViewManager";
    @NotNull
    private static final ReentrantLock lock = new ReentrantLock();
    @NotNull
    private static final LinkedHashMap<String, WebViewEntry> webViewCache = new LinkedHashMap();

    private WebViewManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void preloadWebView$vungle_ads_release(@NotNull Context context, @NotNull AdPayload adv, @NotNull Placement placement, @NotNull String templatePath, @Nullable AdPayload.WebViewSettings webSettings, @NotNull PreloadDelegate delegate, @Nullable Long loadDuration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)adv, (String)"adv");
        Intrinsics.checkNotNullParameter((Object)placement, (String)"placement");
        Intrinsics.checkNotNullParameter((Object)templatePath, (String)"templatePath");
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Lock lock = WebViewManager.lock;
        lock.lock();
        try {
            boolean bl = false;
            Logger.Companion.d(TAG, "Preload webview start. Cache size: " + webViewCache.size());
            String key = adv.eventId();
            if (!((Map)webViewCache).containsKey(key)) {
                ThreadUtil.INSTANCE.runOnUiThread((Function0<Unit>)((Function0)new Function0<Unit>(context, adv, placement, delegate, loadDuration, templatePath, key, webSettings){
                    final /* synthetic */ Context $context;
                    final /* synthetic */ AdPayload $adv;
                    final /* synthetic */ Placement $placement;
                    final /* synthetic */ PreloadDelegate $delegate;
                    final /* synthetic */ Long $loadDuration;
                    final /* synthetic */ String $templatePath;
                    final /* synthetic */ String $key;
                    final /* synthetic */ AdPayload.WebViewSettings $webSettings;
                    {
                        this.$context = $context;
                        this.$adv = $adv;
                        this.$placement = $placement;
                        this.$delegate = $delegate;
                        this.$loadDuration = $loadDuration;
                        this.$templatePath = $templatePath;
                        this.$key = $key;
                        this.$webSettings = $webSettings;
                        super(0);
                    }

                    public final void invoke() {
                        block2: {
                            Object object;
                            Object object2 = WebViewManager.INSTANCE;
                            Object object3 = this.$context;
                            Object object4 = this.$adv;
                            Placement placement = this.$placement;
                            PreloadDelegate preloadDelegate = this.$delegate;
                            Long l = this.$loadDuration;
                            String string = this.$templatePath;
                            String string2 = this.$key;
                            AdPayload.WebViewSettings webViewSettings = this.$webSettings;
                            try {
                                WebView webView;
                                WebViewManager $this$invoke_u24lambda_u2d3 = object2;
                                boolean bl = false;
                                WebView $this$invoke_u24lambda_u2d3_u24lambda_u2d0 = webView = new WebView(object3.getApplicationContext());
                                boolean bl2 = false;
                                WebViewUtil.INSTANCE.applyWebSettings($this$invoke_u24lambda_u2d3_u24lambda_u2d0, webViewSettings);
                                WebView webView2 = webView;
                                ServiceLocator.Companion this_$iv = ServiceLocator.Companion;
                                boolean $i$f$inject = false;
                                Lazy executors$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<Executors>((Context)object3){
                                    final /* synthetic */ Context $context;
                                    {
                                        this.$context = $context;
                                        super(0);
                                    }

                                    @NotNull
                                    public final Executors invoke() {
                                        return ServiceLocator.Companion.getInstance(this.$context).getService(Executors.class);
                                    }
                                }));
                                ServiceLocator.Companion this_$iv2 = ServiceLocator.Companion;
                                boolean $i$f$inject2 = false;
                                Lazy platform$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<Platform>((Context)object3){
                                    final /* synthetic */ Context $context;
                                    {
                                        this.$context = $context;
                                        super(0);
                                    }

                                    @NotNull
                                    public final Platform invoke() {
                                        return ServiceLocator.Companion.getInstance(this.$context).getService(Platform.class);
                                    }
                                }));
                                VungleThreadPoolExecutor offloadExecutor = preloadWebView.1.1.invoke$lambda-3$lambda-1((Lazy<? extends Executors>)executors$delegate).getOffloadExecutor();
                                VungleWebClient webClient = new VungleWebClient((AdPayload)object4, placement, offloadExecutor, preloadWebView.1.1.invoke$lambda-3$lambda-2((Lazy<? extends Platform>)platform$delegate), preloadDelegate, l);
                                boolean collectedConsent = ConfigManager.INSTANCE.getGDPRIsCountryDataProtected() && Intrinsics.areEqual((Object)"unknown", (Object)PrivacyManager.INSTANCE.getConsentStatus());
                                webClient.setConsentStatus(collectedConsent, ConfigManager.INSTANCE.getGDPRConsentTitle(), ConfigManager.INSTANCE.getGDPRConsentMessage(), ConfigManager.INSTANCE.getGDPRButtonAccept(), ConfigManager.INSTANCE.getGDPRButtonDeny());
                                webView2.setWebViewClient((WebViewClient)webClient);
                                webView2.loadUrl(string);
                                ((Map)WebViewManager.access$getWebViewCache$p()).put(String.valueOf(string2), new WebViewEntry(webView2, webClient));
                                AnalyticsClient.logMetric$vungle_ads_release$default(AnalyticsClient.INSTANCE, Sdk.SDKMetric.SDKMetricType.CONCURRENT_CACHED_WEBVIEW_COUNT, WebViewManager.access$getWebViewCache$p().size(), ((AdPayload)object4).getLogEntry$vungle_ads_release(), null, 8, null);
                                object = Result.constructor-impl((Object)Logger.Companion.d("WebViewManager", "Preload complete. Cache size: " + WebViewManager.access$getWebViewCache$p().size()));
                            }
                            catch (Throwable throwable) {
                                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                            }
                            object2 = object;
                            object3 = this.$delegate;
                            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                            if (throwable == null) break block2;
                            Object it = object4 = throwable;
                            boolean bl = false;
                            Logger.Companion.e("WebViewManager", "Preload webview failed", (Throwable)it);
                            object3.onAdReadyToPlay();
                        }
                    }

                    private static final Executors invoke$lambda-3$lambda-1(Lazy<? extends Executors> $executors$delegate) {
                        Lazy<? extends Executors> lazy = $executors$delegate;
                        return (Executors)lazy.getValue();
                    }

                    private static final Platform invoke$lambda-3$lambda-2(Lazy<? extends Platform> $platform$delegate) {
                        Lazy<? extends Platform> lazy = $platform$delegate;
                        return (Platform)lazy.getValue();
                    }
                }));
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public static /* synthetic */ void preloadWebView$vungle_ads_release$default(WebViewManager webViewManager, Context context, AdPayload adPayload, Placement placement, String string, AdPayload.WebViewSettings webViewSettings, PreloadDelegate preloadDelegate, Long l, int n, Object object) {
        if ((n & 0x40) != 0) {
            l = null;
        }
        webViewManager.preloadWebView$vungle_ads_release(context, adPayload, placement, string, webViewSettings, preloadDelegate, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final WebView getOrCreateWebView(@NotNull Context context, @Nullable String key) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Lock lock = WebViewManager.lock;
        lock.lock();
        try {
            WebView webView;
            boolean bl = false;
            WebViewEntry entry = (WebViewEntry)((Map)webViewCache).get(key);
            if (entry != null) {
                Logger.Companion.d(TAG, "Reusing cached webview. Cache size: " + webViewCache.size());
                webView = entry.getWebView();
            } else {
                Logger.Companion.d(TAG, "Creating new webview. Cache size: " + webViewCache.size());
                webView = new WebView(context);
            }
            WebView webView2 = webView;
            return webView2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final VungleWebClient getOrCreateWebViewClient(@NotNull AdPayload advertisement, @NotNull Placement placement, @NotNull VungleThreadPoolExecutor offloadExecutor, @NotNull Platform platform) {
        Intrinsics.checkNotNullParameter((Object)advertisement, (String)"advertisement");
        Intrinsics.checkNotNullParameter((Object)placement, (String)"placement");
        Intrinsics.checkNotNullParameter((Object)offloadExecutor, (String)"offloadExecutor");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Lock lock = WebViewManager.lock;
        lock.lock();
        try {
            boolean bl = false;
            WebViewEntry webViewEntry = (WebViewEntry)((Map)webViewCache).get(advertisement.eventId());
            VungleWebClient webClient = webViewEntry != null ? webViewEntry.getWebViewClient() : null;
            VungleWebClient vungleWebClient = webClient;
            if (vungleWebClient == null) {
                vungleWebClient = new VungleWebClient(advertisement, placement, offloadExecutor, platform, null, null, 48, null);
            }
            VungleWebClient vungleWebClient2 = vungleWebClient;
            return vungleWebClient2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroyWebView(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Lock lock = WebViewManager.lock;
        lock.lock();
        try {
            boolean bl = false;
            INSTANCE.destroyWebViewInternal(key);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final void destroyWebViewInternal(String key) {
        webViewCache.remove(key);
    }

    public static final /* synthetic */ LinkedHashMap access$getWebViewCache$p() {
        return webViewCache;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/vungle/ads/internal/presenter/WebViewManager$WebViewEntry;", "", "webView", "Landroid/webkit/WebView;", "webViewClient", "Lcom/vungle/ads/internal/ui/VungleWebClient;", "(Landroid/webkit/WebView;Lcom/vungle/ads/internal/ui/VungleWebClient;)V", "getWebView", "()Landroid/webkit/WebView;", "getWebViewClient", "()Lcom/vungle/ads/internal/ui/VungleWebClient;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "vungle-ads_release"})
    private static final class WebViewEntry {
        @NotNull
        private final WebView webView;
        @NotNull
        private final VungleWebClient webViewClient;

        public WebViewEntry(@NotNull WebView webView, @NotNull VungleWebClient webViewClient) {
            Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
            Intrinsics.checkNotNullParameter((Object)webViewClient, (String)"webViewClient");
            this.webView = webView;
            this.webViewClient = webViewClient;
        }

        @NotNull
        public final WebView getWebView() {
            return this.webView;
        }

        @NotNull
        public final VungleWebClient getWebViewClient() {
            return this.webViewClient;
        }

        @NotNull
        public final WebView component1() {
            return this.webView;
        }

        @NotNull
        public final VungleWebClient component2() {
            return this.webViewClient;
        }

        @NotNull
        public final WebViewEntry copy(@NotNull WebView webView, @NotNull VungleWebClient webViewClient) {
            Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
            Intrinsics.checkNotNullParameter((Object)webViewClient, (String)"webViewClient");
            return new WebViewEntry(webView, webViewClient);
        }

        public static /* synthetic */ WebViewEntry copy$default(WebViewEntry webViewEntry, WebView webView, VungleWebClient vungleWebClient, int n, Object object) {
            if ((n & 1) != 0) {
                webView = webViewEntry.webView;
            }
            if ((n & 2) != 0) {
                vungleWebClient = webViewEntry.webViewClient;
            }
            return webViewEntry.copy(webView, vungleWebClient);
        }

        @NotNull
        public String toString() {
            return "WebViewEntry(webView=" + this.webView + ", webViewClient=" + this.webViewClient + ')';
        }

        public int hashCode() {
            int result = this.webView.hashCode();
            result = result * 31 + this.webViewClient.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WebViewEntry)) {
                return false;
            }
            WebViewEntry webViewEntry = (WebViewEntry)other;
            if (!Intrinsics.areEqual((Object)this.webView, (Object)webViewEntry.webView)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.webViewClient, (Object)webViewEntry.webViewClient);
        }
    }
}

