/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.presenter;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.ContextThemeWrapper;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.VisibleForTesting;
import com.vungle.ads.AnalyticsClient;
import com.vungle.ads.LinkError;
import com.vungle.ads.PrivacyUrlError;
import com.vungle.ads.ServiceLocator;
import com.vungle.ads.SingleValueMetric;
import com.vungle.ads.TpatError;
import com.vungle.ads.internal.ClickCoordinateTracker;
import com.vungle.ads.internal.ConfigManager;
import com.vungle.ads.internal.model.AdPayload;
import com.vungle.ads.internal.network.TpatRequest;
import com.vungle.ads.internal.network.TpatSender;
import com.vungle.ads.internal.omsdk.NativeOMTracker;
import com.vungle.ads.internal.omsdk.OMInjector;
import com.vungle.ads.internal.platform.Platform;
import com.vungle.ads.internal.presenter.AdEventListener;
import com.vungle.ads.internal.presenter.NativePresenterDelegate;
import com.vungle.ads.internal.privacy.PrivacyConsent;
import com.vungle.ads.internal.privacy.PrivacyManager;
import com.vungle.ads.internal.protos.Sdk;
import com.vungle.ads.internal.ui.PresenterAdOpenCallback;
import com.vungle.ads.internal.util.ExternalRouter;
import com.vungle.ads.internal.util.FileUtility;
import com.vungle.ads.internal.util.LogEntry;
import com.vungle.ads.internal.util.Logger;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\u0018\u0000 M2\u00020\u0001:\u0001MB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u00105\u001a\u000206J\u0016\u00107\u001a\u0002062\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u001fJ\b\u0010;\u001a\u00020\u001dH\u0002J\u0012\u0010<\u001a\u0002062\b\u0010=\u001a\u0004\u0018\u00010\u001fH\u0002J&\u0010>\u001a\u0002062\u0006\u0010?\u001a\u00020\u001c2\u0016\b\u0002\u0010@\u001a\u0010\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u0001\u0018\u00010'J\u0012\u0010A\u001a\u0002062\b\u0010B\u001a\u0004\u0018\u00010\u001fH\u0002J\u0010\u0010C\u001a\u0002062\b\u0010?\u001a\u0004\u0018\u00010DJ\u0006\u0010E\u001a\u000206J&\u0010F\u001a\u0002062\u0006\u0010G\u001a\u00020\u001f2\n\b\u0002\u0010?\u001a\u0004\u0018\u00010\u001f2\n\b\u0002\u0010H\u001a\u0004\u0018\u00010\u001fJ\u0010\u0010I\u001a\u0002062\b\u0010J\u001a\u0004\u0018\u00010\u000fJ\b\u0010K\u001a\u000206H\u0002J\b\u0010L\u001a\u000206H\u0002R\u0012\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0010\u001a\u00020\u00118\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001d0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010 \u001a\u0004\u0018\u00010!8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b\"\u0010#R\u001a\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001d0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010)\u001a\u0004\u0018\u00010*8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b+\u0010\u0013\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u00100\u001a\u0002018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b4\u0010%\u001a\u0004\b2\u00103\u00a8\u0006N\u00b2\u0006\n\u0010O\u001a\u00020PX\u008a\u0084\u0002"}, d2={"Lcom/vungle/ads/internal/presenter/NativeAdPresenter;", "", "context", "Landroid/content/Context;", "delegate", "Lcom/vungle/ads/internal/presenter/NativePresenterDelegate;", "advertisement", "Lcom/vungle/ads/internal/model/AdPayload;", "platform", "Lcom/vungle/ads/internal/platform/Platform;", "(Landroid/content/Context;Lcom/vungle/ads/internal/presenter/NativePresenterDelegate;Lcom/vungle/ads/internal/model/AdPayload;Lcom/vungle/ads/internal/platform/Platform;)V", "adStartTime", "", "Ljava/lang/Long;", "bus", "Lcom/vungle/ads/internal/presenter/AdEventListener;", "clickCoordinateTracker", "Lcom/vungle/ads/internal/ClickCoordinateTracker;", "getClickCoordinateTracker$vungle_ads_release$annotations", "()V", "getClickCoordinateTracker$vungle_ads_release", "()Lcom/vungle/ads/internal/ClickCoordinateTracker;", "setClickCoordinateTracker$vungle_ads_release", "(Lcom/vungle/ads/internal/ClickCoordinateTracker;)V", "currentDialog", "Landroid/app/Dialog;", "firedOMEventMap", "", "", "", "firedTpatMap", "", "logEntry", "Lcom/vungle/ads/internal/util/LogEntry;", "getLogEntry", "()Lcom/vungle/ads/internal/util/LogEntry;", "logEntry$delegate", "Lkotlin/Lazy;", "multipleOMEventEnabledMap", "", "multipleTpatEnabledMap", "omTracker", "Lcom/vungle/ads/internal/omsdk/NativeOMTracker;", "getOmTracker$vungle_ads_release$annotations", "getOmTracker$vungle_ads_release", "()Lcom/vungle/ads/internal/omsdk/NativeOMTracker;", "setOmTracker$vungle_ads_release", "(Lcom/vungle/ads/internal/omsdk/NativeOMTracker;)V", "tpatSender", "Lcom/vungle/ads/internal/network/TpatSender;", "getTpatSender", "()Lcom/vungle/ads/internal/network/TpatSender;", "tpatSender$delegate", "detach", "", "initAndStartOMTracker", "view", "Landroid/view/View;", "omSdkData", "needShowGdpr", "onDownload", "ctaUrl", "onOMEvent", "event", "args", "onPrivacy", "privacyUrl", "onViewTouched", "Landroid/view/MotionEvent;", "prepare", "processCommand", "action", "value", "setEventListener", "listener", "showGdpr", "start", "Companion", "vungle-ads_release", "omInjector", "Lcom/vungle/ads/internal/omsdk/OMInjector;"})
public final class NativeAdPresenter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final NativePresenterDelegate delegate;
    @NotNull
    private final AdPayload advertisement;
    @NotNull
    private final Platform platform;
    @Nullable
    private Long adStartTime;
    @Nullable
    private AdEventListener bus;
    @NotNull
    private final Lazy tpatSender$delegate;
    @Nullable
    private Dialog currentDialog;
    @NotNull
    private final Lazy logEntry$delegate;
    @NotNull
    private final Map<String, Boolean> firedTpatMap;
    @NotNull
    private final Map<String, Boolean> multipleTpatEnabledMap;
    @NotNull
    private final Map<Integer, Boolean> firedOMEventMap;
    @NotNull
    private final Map<Integer, Boolean> multipleOMEventEnabledMap;
    @Nullable
    private NativeOMTracker omTracker;
    @NotNull
    private ClickCoordinateTracker clickCoordinateTracker;
    @NotNull
    private static final String TAG = "NativeAdPresenter";
    @NotNull
    public static final String TPAT = "tpat";
    @NotNull
    public static final String OPEN_PRIVACY = "openPrivacy";
    @NotNull
    public static final String DOWNLOAD = "download";

    public NativeAdPresenter(@NotNull Context context, @NotNull NativePresenterDelegate delegate, @NotNull AdPayload advertisement, @NotNull Platform platform) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)advertisement, (String)"advertisement");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        this.context = context;
        this.delegate = delegate;
        this.advertisement = advertisement;
        this.platform = platform;
        Pair[] pairArray = ServiceLocator.Companion;
        Context context$iv = this.context;
        boolean $i$f$inject = false;
        this.tpatSender$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<TpatSender>(context$iv){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final TpatSender invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(TpatSender.class);
            }
        }));
        this.logEntry$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LogEntry>(this){
            final /* synthetic */ NativeAdPresenter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final LogEntry invoke() {
                return NativeAdPresenter.access$getAdvertisement$p(this.this$0).getLogEntry$vungle_ads_release();
            }
        }));
        this.firedTpatMap = new LinkedHashMap();
        pairArray = new Pair[]{TuplesKt.to((Object)"video.mute", (Object)true), TuplesKt.to((Object)"video.unmute", (Object)true)};
        this.multipleTpatEnabledMap = MapsKt.mapOf((Pair[])pairArray);
        this.firedOMEventMap = new LinkedHashMap();
        pairArray = new Pair[]{TuplesKt.to((Object)8, (Object)true), TuplesKt.to((Object)9, (Object)true), TuplesKt.to((Object)10, (Object)true)};
        this.multipleOMEventEnabledMap = MapsKt.mapOf((Pair[])pairArray);
        this.clickCoordinateTracker = new ClickCoordinateTracker(this.context, this.advertisement);
    }

    private final TpatSender getTpatSender() {
        Lazy lazy = this.tpatSender$delegate;
        return (TpatSender)lazy.getValue();
    }

    private final LogEntry getLogEntry() {
        Lazy lazy = this.logEntry$delegate;
        return (LogEntry)lazy.getValue();
    }

    @Nullable
    public final NativeOMTracker getOmTracker$vungle_ads_release() {
        return this.omTracker;
    }

    public final void setOmTracker$vungle_ads_release(@Nullable NativeOMTracker nativeOMTracker) {
        this.omTracker = nativeOMTracker;
    }

    @VisibleForTesting
    public static /* synthetic */ void getOmTracker$vungle_ads_release$annotations() {
    }

    @NotNull
    public final ClickCoordinateTracker getClickCoordinateTracker$vungle_ads_release() {
        return this.clickCoordinateTracker;
    }

    public final void setClickCoordinateTracker$vungle_ads_release(@NotNull ClickCoordinateTracker clickCoordinateTracker2) {
        Intrinsics.checkNotNullParameter((Object)clickCoordinateTracker2, (String)"<set-?>");
        this.clickCoordinateTracker = clickCoordinateTracker2;
    }

    @VisibleForTesting
    public static /* synthetic */ void getClickCoordinateTracker$vungle_ads_release$annotations() {
    }

    public final void setEventListener(@Nullable AdEventListener listener) {
        this.bus = listener;
    }

    public final void processCommand(@NotNull String action, @Nullable String event, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Logger.Companion.d(TAG, "processCommand: action=" + action + " event=" + event + " value=" + value);
        switch (action) {
            case "tpat": {
                List<String> list;
                CharSequence charSequence = event;
                if (charSequence == null || charSequence.length() == 0) {
                    new TpatError(Sdk.SDKError.Reason.EMPTY_TPAT_ERROR, "Empty tpat key").setLogEntry$vungle_ads_release(this.getLogEntry()).logErrorNoReturnValue$vungle_ads_release();
                    return;
                }
                if (!Intrinsics.areEqual((Object)this.multipleTpatEnabledMap.get(event), (Object)true) && Intrinsics.areEqual((Object)this.firedTpatMap.get(event), (Object)true)) {
                    Logger.Companion.d(TAG, "Ignore this already fired TPAT: " + event);
                    return;
                }
                this.firedTpatMap.put(event, true);
                switch (event) {
                    case "checkpoint.0": {
                        list = this.advertisement.getTpatUrls(event, this.platform.getCarrierName(), String.valueOf(this.platform.getVolumeLevel()));
                        break;
                    }
                    case "video.length": {
                        list = AdPayload.getTpatUrls$default(this.advertisement, event, value, null, 4, null);
                        break;
                    }
                    case "cta_url": {
                        String string = value;
                        if (string != null) {
                            String it = string;
                            boolean bl = false;
                            list = CollectionsKt.listOf((Object)it);
                            break;
                        }
                        list = null;
                        break;
                    }
                    default: {
                        list = AdPayload.getTpatUrls$default(this.advertisement, event, null, null, 6, null);
                    }
                }
                List<String> tpatUrls = list;
                Object object = tpatUrls;
                if (object == null || object.isEmpty()) {
                    new TpatError(Sdk.SDKError.Reason.INVALID_TPAT_KEY, "Empty urls for tpat: " + event + " value=" + value).setLogEntry$vungle_ads_release(this.getLogEntry()).logErrorNoReturnValue$vungle_ads_release();
                } else {
                    Iterable $this$forEach$iv = tpatUrls;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String url = (String)element$iv;
                        boolean bl = false;
                        TpatRequest request = new TpatRequest.Builder(url).tpatKey(event).withLogEntry(this.getLogEntry()).build();
                        TpatSender.sendTpat$default(this.getTpatSender(), request, false, 2, null);
                    }
                }
                if (Intrinsics.areEqual((Object)event, (Object)"checkpoint.0")) {
                    AnalyticsClient.logMetric$vungle_ads_release$default(AnalyticsClient.INSTANCE, new SingleValueMetric(Sdk.SDKMetric.SDKMetricType.AD_START_EVENT), this.getLogEntry(), null, 4, null);
                    AdEventListener adEventListener2 = this.bus;
                    if (adEventListener2 != null) {
                        adEventListener2.onNext("adViewed", null, this.delegate.getPlacementRefId());
                    }
                }
                return;
            }
            case "openPrivacy": {
                this.onPrivacy(value);
                return;
            }
            case "download": {
                this.onDownload(value);
                return;
            }
        }
        Logger.Companion.w(TAG, "Unknown native ad action: " + action);
    }

    public static /* synthetic */ void processCommand$default(NativeAdPresenter nativeAdPresenter, String string, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        nativeAdPresenter.processCommand(string, string2, string3);
    }

    public final void onViewTouched(@Nullable MotionEvent event) {
        block0: {
            MotionEvent motionEvent = event;
            if (motionEvent == null) break block0;
            MotionEvent it = motionEvent;
            boolean bl = false;
            Logger.Companion.d(TAG, "user interaction on Native ad");
            this.clickCoordinateTracker.trackCoordinate(it);
        }
    }

    private final void onDownload(String ctaUrl) {
        block2: {
            NativeAdPresenter.processCommand$default(this, TPAT, "clickUrl", null, 4, null);
            this.processCommand(TPAT, "cta_url", ctaUrl);
            AdPayload.AdUnit adUnit = this.advertisement.adUnit();
            String deeplinkUrl = adUnit != null ? adUnit.getDeeplinkUrl() : null;
            boolean launched2 = ExternalRouter.INSTANCE.launch$vungle_ads_release(deeplinkUrl, ctaUrl, this.context, this.getLogEntry(), new PresenterAdOpenCallback(deeplinkUrl, this){
                final /* synthetic */ String $deeplinkUrl;
                final /* synthetic */ NativeAdPresenter this$0;
                {
                    this.$deeplinkUrl = $deeplinkUrl;
                    this.this$0 = $receiver;
                }

                /*
                 * WARNING - void declaration
                 */
                public void onDeeplinkClick(boolean opened) {
                    block2: {
                        void $this$forEach$iv;
                        List deeplinkClickTpatUrls;
                        if (!opened) {
                            new LinkError(Sdk.SDKError.Reason.DEEPLINK_OPEN_FAILED, "Fail to open " + this.$deeplinkUrl).setLogEntry$vungle_ads_release(NativeAdPresenter.access$getLogEntry(this.this$0)).logErrorNoReturnValue$vungle_ads_release();
                        }
                        List list = deeplinkClickTpatUrls = AdPayload.getTpatUrls$default(NativeAdPresenter.access$getAdvertisement$p(this.this$0), "deeplink.click", String.valueOf(opened), null, 4, null);
                        if (list == null) break block2;
                        Iterable iterable = list;
                        NativeAdPresenter nativeAdPresenter = this.this$0;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            String url = (String)element$iv;
                            boolean bl = false;
                            TpatRequest request = new TpatRequest.Builder(url).tpatKey("deeplink.click").withLogEntry(NativeAdPresenter.access$getLogEntry(nativeAdPresenter)).build();
                            TpatSender.sendTpat$default(NativeAdPresenter.access$getTpatSender(nativeAdPresenter), request, false, 2, null);
                        }
                    }
                }
            });
            AdEventListener adEventListener2 = this.bus;
            if (adEventListener2 != null) {
                adEventListener2.onNext("open", "adClick", this.delegate.getPlacementRefId());
            }
            if (!launched2) break block2;
            AdEventListener adEventListener3 = this.bus;
            if (adEventListener3 != null) {
                adEventListener3.onNext("open", "adLeftApplication", this.delegate.getPlacementRefId());
            }
        }
    }

    private final void onPrivacy(String privacyUrl) {
        block1: {
            String it;
            block2: {
                AnalyticsClient.logMetric$vungle_ads_release$default(AnalyticsClient.INSTANCE, new SingleValueMetric(Sdk.SDKMetric.SDKMetricType.PRIVACY_URL_OPENED), this.getLogEntry(), null, 4, null);
                String string = privacyUrl;
                if (string == null) break block1;
                it = string;
                boolean bl = false;
                if (!FileUtility.INSTANCE.isValidUrl(privacyUrl)) {
                    new PrivacyUrlError(it).setLogEntry$vungle_ads_release(this.getLogEntry()).logErrorNoReturnValue$vungle_ads_release();
                    return;
                }
                boolean launched2 = ExternalRouter.launch$vungle_ads_release$default(ExternalRouter.INSTANCE, null, it, this.context, this.getLogEntry(), null, 16, null);
                if (!launched2) break block2;
                AdEventListener adEventListener2 = this.bus;
                if (adEventListener2 == null) break block1;
                adEventListener2.onNext("open", "adLeftApplication", this.delegate.getPlacementRefId());
                break block1;
            }
            new PrivacyUrlError(it).setLogEntry$vungle_ads_release(this.getLogEntry()).logErrorNoReturnValue$vungle_ads_release();
        }
    }

    public final void prepare() {
        this.start();
        AdEventListener adEventListener2 = this.bus;
        if (adEventListener2 != null) {
            adEventListener2.onNext("start", null, this.delegate.getPlacementRefId());
        }
        this.adStartTime = System.currentTimeMillis();
    }

    private final void start() {
        if (this.needShowGdpr()) {
            this.showGdpr();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void detach() {
        block6: {
            NativeOMTracker nativeOMTracker = this.omTracker;
            if (nativeOMTracker != null) {
                nativeOMTracker.stop();
            }
            Dialog dialog = this.currentDialog;
            if (dialog != null) {
                Dialog $this$detach_u24lambda_u2d4 = dialog;
                boolean bl = false;
                if ($this$detach_u24lambda_u2d4.isShowing()) {
                    $this$detach_u24lambda_u2d4.dismiss();
                }
            }
            Long l = this.adStartTime;
            if (l != null) {
                Long l2 = l;
                long it = ((Number)l2).longValue();
                boolean bl = false;
                long duration = System.currentTimeMillis() - it;
                List<String> list = this.advertisement.getTpatUrls("ad.close", String.valueOf(duration), String.valueOf(this.platform.getVolumeLevel()));
                if (list != null) {
                    void $this$forEach$iv;
                    Iterable iterable = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String url = (String)element$iv;
                        boolean bl2 = false;
                        TpatRequest request = new TpatRequest.Builder(url).tpatKey("ad.close").withLogEntry(this.getLogEntry()).build();
                        TpatSender.sendTpat$default(this.getTpatSender(), request, false, 2, null);
                    }
                }
            }
            AdEventListener adEventListener2 = this.bus;
            if (adEventListener2 == null) break block6;
            adEventListener2.onNext("end", null, this.delegate.getPlacementRefId());
        }
    }

    private final boolean needShowGdpr() {
        return ConfigManager.INSTANCE.getGDPRIsCountryDataProtected() && Intrinsics.areEqual((Object)"unknown", (Object)PrivacyManager.INSTANCE.getConsentStatus());
    }

    private final void showGdpr() {
        PrivacyManager.INSTANCE.updateGdprConsent("opted_out_by_timeout", "vungle_modal", null);
        if (!(this.context instanceof Activity)) {
            Logger.Companion.w(TAG, "We can not show GDPR dialog with application context.");
            return;
        }
        DialogInterface.OnClickListener listener = (arg_0, arg_1) -> NativeAdPresenter.showGdpr$lambda-7(this, arg_0, arg_1);
        String dialogTitle = ConfigManager.INSTANCE.getGDPRConsentTitle();
        String dialogBody = ConfigManager.INSTANCE.getGDPRConsentMessage();
        String dialogContinue = ConfigManager.INSTANCE.getGDPRButtonAccept();
        String dialogClose = ConfigManager.INSTANCE.getGDPRButtonDeny();
        AlertDialog.Builder dialogBuilder = new AlertDialog.Builder((Context)new ContextThemeWrapper(this.context, ((Activity)this.context).getApplicationInfo().theme));
        CharSequence charSequence = dialogTitle;
        if (!(charSequence == null || charSequence.length() == 0)) {
            dialogBuilder.setTitle((CharSequence)dialogTitle);
        }
        if (!((charSequence = (CharSequence)dialogBody) == null || charSequence.length() == 0)) {
            dialogBuilder.setMessage((CharSequence)dialogBody);
        }
        dialogBuilder.setPositiveButton((CharSequence)dialogContinue, listener);
        dialogBuilder.setNegativeButton((CharSequence)dialogClose, listener);
        dialogBuilder.setCancelable(false);
        AlertDialog dialog = dialogBuilder.create();
        dialog.setOnDismissListener(arg_0 -> NativeAdPresenter.showGdpr$lambda-8(this, arg_0));
        this.currentDialog = (Dialog)dialog;
        dialog.show();
    }

    /*
     * WARNING - void declaration
     */
    public final void initAndStartOMTracker(@NotNull View view, @NotNull String omSdkData) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)omSdkData, (String)"omSdkData");
            boolean adOmEnabled = this.advertisement.omEnabled();
            if (!(((CharSequence)omSdkData).length() > 0) || !adOmEnabled) break block1;
            ServiceLocator.Companion companion = ServiceLocator.Companion;
            Context context$iv = this.context;
            boolean $i$f$inject = false;
            Lazy omInjector$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<OMInjector>(context$iv){
                final /* synthetic */ Context $context;
                {
                    this.$context = $context;
                    super(0);
                }

                @NotNull
                public final OMInjector invoke() {
                    return ServiceLocator.Companion.getInstance(this.$context).getService(OMInjector.class);
                }
            }));
            String string = NativeAdPresenter.initAndStartOMTracker$lambda-9((Lazy<OMInjector>)omInjector$delegate).getOMSDKJS$vungle_ads_release();
            if (string != null) {
                void tracker;
                NativeOMTracker nativeOMTracker;
                String it = string;
                boolean bl = false;
                NativeOMTracker nativeOMTracker2 = nativeOMTracker = new NativeOMTracker(omSdkData, it, this.delegate.isNativeVideo());
                NativeAdPresenter nativeAdPresenter = this;
                boolean bl2 = false;
                tracker.start(view);
                nativeAdPresenter.omTracker = nativeOMTracker;
            }
        }
    }

    public final void onOMEvent(int event, @Nullable Map<String, ? extends Object> args) {
        Logger.Companion.d(TAG, "onOMEvent: event=" + event + " value=" + args);
        if (!Intrinsics.areEqual((Object)this.multipleOMEventEnabledMap.get(event), (Object)true) && Intrinsics.areEqual((Object)this.firedOMEventMap.get(event), (Object)true)) {
            Logger.Companion.d(TAG, "Ignore this already fired om event: " + event);
            return;
        }
        Integer n = event;
        this.firedOMEventMap.put(n, true);
        switch (event) {
            case 1: {
                NativeOMTracker nativeOMTracker = this.omTracker;
                if (nativeOMTracker != null) {
                    nativeOMTracker.onStatePlay();
                }
                break;
            }
            case 2: {
                NativeOMTracker nativeOMTracker = this.omTracker;
                if (nativeOMTracker != null) {
                    nativeOMTracker.onStatePaused();
                }
                break;
            }
            case 3: {
                NativeOMTracker nativeOMTracker = this.omTracker;
                if (nativeOMTracker != null) {
                    nativeOMTracker.onStateCompleted();
                }
                break;
            }
            case 8: {
                NativeOMTracker nativeOMTracker = this.omTracker;
                if (nativeOMTracker != null) {
                    nativeOMTracker.onUserInteraction();
                }
                break;
            }
            case 9: {
                NativeOMTracker nativeOMTracker = this.omTracker;
                if (nativeOMTracker != null) {
                    nativeOMTracker.onMuteChanged(true);
                }
                break;
            }
            case 10: {
                NativeOMTracker nativeOMTracker = this.omTracker;
                if (nativeOMTracker != null) {
                    nativeOMTracker.onMuteChanged(false);
                }
                break;
            }
            case 4: {
                Map<String, ? extends Object> map = args;
                Object object = map != null ? map.get("OM_KEY_DURATION") : null;
                Number number = object instanceof Number ? (Number)((Number)object) : (Number)null;
                float duration = number != null ? number.floatValue() : 0.0f;
                Map<String, ? extends Object> map2 = args;
                Object object2 = map2 != null ? map2.get("OM_KEY_VOLUME") : null;
                Number number2 = object2 instanceof Number ? (Number)((Number)object2) : (Number)null;
                float volume = number2 != null ? number2.floatValue() : 0.0f;
                NativeOMTracker nativeOMTracker = this.omTracker;
                if (nativeOMTracker != null) {
                    nativeOMTracker.onQuartileStart(duration, volume);
                }
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                NativeOMTracker nativeOMTracker = this.omTracker;
                if (nativeOMTracker != null) {
                    nativeOMTracker.onQuartileChanged(event);
                }
                break;
            }
            case 11: {
                NativeOMTracker nativeOMTracker = this.omTracker;
                if (nativeOMTracker == null) break;
                nativeOMTracker.impressionOccurred();
                break;
            }
        }
    }

    public static /* synthetic */ void onOMEvent$default(NativeAdPresenter nativeAdPresenter, int n, Map map, int n2, Object object) {
        if ((n2 & 2) != 0) {
            map = null;
        }
        nativeAdPresenter.onOMEvent(n, map);
    }

    private static final void showGdpr$lambda-7(NativeAdPresenter this$0, DialogInterface dialogInterface, int which) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String consented = "opted_out_by_timeout";
        switch (which) {
            case -2: {
                consented = PrivacyConsent.OPT_OUT.getValue();
                break;
            }
            case -1: {
                consented = PrivacyConsent.OPT_IN.getValue();
            }
        }
        PrivacyManager.INSTANCE.updateGdprConsent(consented, "vungle_modal", null);
        this$0.start();
    }

    private static final void showGdpr$lambda-8(NativeAdPresenter this$0, DialogInterface it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.currentDialog = null;
    }

    private static final OMInjector initAndStartOMTracker$lambda-9(Lazy<OMInjector> $omInjector$delegate) {
        Lazy<OMInjector> lazy = $omInjector$delegate;
        return (OMInjector)lazy.getValue();
    }

    public static final /* synthetic */ LogEntry access$getLogEntry(NativeAdPresenter $this) {
        return $this.getLogEntry();
    }

    public static final /* synthetic */ AdPayload access$getAdvertisement$p(NativeAdPresenter $this) {
        return $this.advertisement;
    }

    public static final /* synthetic */ TpatSender access$getTpatSender(NativeAdPresenter $this) {
        return $this.getTpatSender();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/vungle/ads/internal/presenter/NativeAdPresenter$Companion;", "", "()V", "DOWNLOAD", "", "OPEN_PRIVACY", "TAG", "TPAT", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

