/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.omsdk;

import android.util.Base64;
import android.view.View;
import com.iab.omid.library.vungle.adsession.AdEvents;
import com.iab.omid.library.vungle.adsession.AdSession;
import com.iab.omid.library.vungle.adsession.AdSessionConfiguration;
import com.iab.omid.library.vungle.adsession.AdSessionContext;
import com.iab.omid.library.vungle.adsession.CreativeType;
import com.iab.omid.library.vungle.adsession.ImpressionType;
import com.iab.omid.library.vungle.adsession.Owner;
import com.iab.omid.library.vungle.adsession.Partner;
import com.iab.omid.library.vungle.adsession.VerificationScriptResource;
import com.iab.omid.library.vungle.adsession.media.InteractionType;
import com.iab.omid.library.vungle.adsession.media.MediaEvents;
import com.iab.omid.library.vungle.adsession.media.Position;
import com.iab.omid.library.vungle.adsession.media.VastProperties;
import com.vungle.ads.internal.model.OmSdkData;
import com.vungle.ads.internal.omsdk.NativeOMTracker;
import com.vungle.ads.internal.util.Logger;
import java.net.URL;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlin.text.Charsets;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 (2\u00020\u0001:\u0001(B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0006J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eJ\u0006\u0010 \u001a\u00020\u0016J\u0006\u0010!\u001a\u00020\u0016J\u0006\u0010\"\u001a\u00020\u0016J\u0006\u0010#\u001a\u00020\u0016J\u000e\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/vungle/ads/internal/omsdk/NativeOMTracker;", "", "omSdkData", "", "omSdkJS", "isNativeVideo", "", "(Ljava/lang/String;Ljava/lang/String;Z)V", "adEvents", "Lcom/iab/omid/library/vungle/adsession/AdEvents;", "adSession", "Lcom/iab/omid/library/vungle/adsession/AdSession;", "()Z", "json", "Lkotlinx/serialization/json/Json;", "mediaEvents", "Lcom/iab/omid/library/vungle/adsession/media/MediaEvents;", "getNativeAdSession", "Lcom/iab/omid/library/vungle/adsession/AdSessionConfiguration;", "creativeType", "Lcom/iab/omid/library/vungle/adsession/CreativeType;", "impressionOccurred", "", "onMuteChanged", "muted", "onQuartileChanged", "quartile", "", "onQuartileStart", "duration", "", "volume", "onStateCompleted", "onStatePaused", "onStatePlay", "onUserInteraction", "start", "view", "Landroid/view/View;", "stop", "Companion", "vungle-ads_release"})
public final class NativeOMTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isNativeVideo;
    @NotNull
    private final Json json;
    @Nullable
    private AdSession adSession;
    @Nullable
    private AdEvents adEvents;
    @Nullable
    private MediaEvents mediaEvents;
    @NotNull
    private static final String TAG = "NativeAd-OMTracker";

    public NativeOMTracker(@NotNull String omSdkData, @NotNull String omSdkJS, boolean isNativeVideo) {
        block6: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)omSdkData, (String)"omSdkData");
            Intrinsics.checkNotNullParameter((Object)omSdkJS, (String)"omSdkJS");
            this.isNativeVideo = isNativeVideo;
            this.json = JsonKt.Json$default(null, (Function1)json.1.INSTANCE, (int)1, null);
            Object object2 = this;
            try {
                OmSdkData omSdkDataEntry;
                OmSdkData omSdkData2;
                byte[] decoded;
                NativeOMTracker $this$_init__u24lambda_u2d1 = object2;
                boolean bl = false;
                AdSessionConfiguration adSessionConfiguration = $this$_init__u24lambda_u2d1.isNativeVideo ? $this$_init__u24lambda_u2d1.getNativeAdSession(CreativeType.VIDEO) : $this$_init__u24lambda_u2d1.getNativeAdSession(CreativeType.NATIVE_DISPLAY);
                Partner partner = Partner.createPartner("Vungle", "7.7.0");
                if (decoded != null) {
                    decoded = Base64.decode((String)omSdkData, (int)0);
                    Intrinsics.checkNotNullExpressionValue((Object)decoded, (String)"decoded");
                    byte[] it = decoded;
                    boolean bl2 = false;
                    String jsonStr = new String(it, Charsets.UTF_8);
                    StringFormat $this$decodeFromString$iv = (StringFormat)$this$_init__u24lambda_u2d1.json;
                    boolean $i$f$decodeFromString = false;
                    SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
                    boolean $i$f$serializer = false;
                    KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(OmSdkData.class));
                    boolean $i$f$cast = false;
                    Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
                    omSdkData2 = (OmSdkData)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, jsonStr);
                } else {
                    omSdkData2 = null;
                }
                OmSdkData omSdkData3 = omSdkDataEntry = omSdkData2;
                if ((omSdkData3 != null ? omSdkData3.getVendorURL() : null) == null) {
                    Logger.Companion.e(TAG, "Invalid OMSDK data: missing vendorURL");
                } else {
                    VerificationScriptResource verificationScriptResource = VerificationScriptResource.createVerificationScriptResourceWithParameters(omSdkDataEntry.getVendorKey(), new URL(omSdkDataEntry.getVendorURL()), omSdkDataEntry.getParams());
                    Intrinsics.checkNotNullExpressionValue((Object)verificationScriptResource, (String)"verificationScriptResource");
                    List verificationScripts = CollectionsKt.listOf((Object)verificationScriptResource);
                    AdSessionContext adSessionContext = AdSessionContext.createNativeAdSessionContext(partner, omSdkJS, verificationScripts, null, null);
                    $this$_init__u24lambda_u2d1.adSession = AdSession.createAdSession(adSessionConfiguration, adSessionContext);
                }
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block6;
            Object e2 = object = throwable;
            boolean bl = false;
            Logger.Companion.e(TAG, "error occured when create omsdk adSession:", (Throwable)e2);
        }
    }

    public final boolean isNativeVideo() {
        return this.isNativeVideo;
    }

    public final void start(@NotNull View view) {
        block9: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Logger.Companion.d(TAG, "start OM tracker");
            Object object2 = this;
            try {
                Integer n;
                NativeOMTracker $this$start_u24lambda_u2d4 = object2;
                boolean bl = false;
                AdSession adSession = $this$start_u24lambda_u2d4.adSession;
                if (adSession != null) {
                    AdSession it = adSession;
                    boolean bl2 = false;
                    $this$start_u24lambda_u2d4.adEvents = AdEvents.createAdEvents(it);
                    if ($this$start_u24lambda_u2d4.isNativeVideo) {
                        $this$start_u24lambda_u2d4.mediaEvents = MediaEvents.createMediaEvents(it);
                    }
                    it.registerAdView(view);
                    it.start();
                    if ($this$start_u24lambda_u2d4.isNativeVideo) {
                        VastProperties vastProperties = VastProperties.createVastPropertiesForNonSkippableMedia(false, Position.STANDALONE);
                        AdEvents adEvents = $this$start_u24lambda_u2d4.adEvents;
                        if (adEvents != null) {
                            adEvents.loaded(vastProperties);
                        }
                    } else {
                        AdEvents adEvents = $this$start_u24lambda_u2d4.adEvents;
                        if (adEvents != null) {
                            adEvents.loaded();
                        }
                    }
                    n = Logger.Companion.d(TAG, "track event: loaded");
                } else {
                    n = null;
                }
                object = Result.constructor-impl(n);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block9;
            Object e2 = object = throwable;
            boolean bl = false;
            Logger.Companion.e(TAG, "error occured when start omsdk adSession:", (Throwable)e2);
        }
    }

    public final void stop() {
        AdSession adSession = this.adSession;
        if (adSession != null) {
            adSession.finish();
        }
        this.adSession = null;
        this.adEvents = null;
        this.mediaEvents = null;
    }

    public final void onStatePlay() {
        Logger.Companion.d(TAG, "track event: onStatePlay");
        NativeOMTracker nativeOMTracker = this;
        try {
            Unit unit;
            NativeOMTracker $this$onStatePlay_u24lambda_u2d6 = nativeOMTracker;
            boolean bl = false;
            MediaEvents mediaEvents = $this$onStatePlay_u24lambda_u2d6.mediaEvents;
            if (mediaEvents != null) {
                mediaEvents.resume();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl((Object)unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final void onStatePaused() {
        Logger.Companion.d(TAG, "track event: onStatePaused");
        NativeOMTracker nativeOMTracker = this;
        try {
            Unit unit;
            NativeOMTracker $this$onStatePaused_u24lambda_u2d7 = nativeOMTracker;
            boolean bl = false;
            MediaEvents mediaEvents = $this$onStatePaused_u24lambda_u2d7.mediaEvents;
            if (mediaEvents != null) {
                mediaEvents.pause();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl((Object)unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final void onStateCompleted() {
        Logger.Companion.d(TAG, "track event: onStateCompleted");
        NativeOMTracker nativeOMTracker = this;
        try {
            Unit unit;
            NativeOMTracker $this$onStateCompleted_u24lambda_u2d8 = nativeOMTracker;
            boolean bl = false;
            MediaEvents mediaEvents = $this$onStateCompleted_u24lambda_u2d8.mediaEvents;
            if (mediaEvents != null) {
                mediaEvents.complete();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl((Object)unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final void onQuartileStart(float duration, float volume) {
        Logger.Companion.d(TAG, "track event: onQuartileStart duration=" + duration + " volume=" + volume);
        NativeOMTracker nativeOMTracker = this;
        try {
            Unit unit;
            NativeOMTracker $this$onQuartileStart_u24lambda_u2d9 = nativeOMTracker;
            boolean bl = false;
            MediaEvents mediaEvents = $this$onQuartileStart_u24lambda_u2d9.mediaEvents;
            if (mediaEvents != null) {
                mediaEvents.start(duration, volume);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl(unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final void onQuartileChanged(int quartile) {
        Logger.Companion.d(TAG, "track event: onQuartileChanged quartile=" + quartile);
        switch (quartile) {
            case 5: {
                NativeOMTracker nativeOMTracker = this;
                try {
                    Unit unit;
                    Object $this$onQuartileChanged_u24lambda_u2d10 = nativeOMTracker;
                    boolean bl = false;
                    MediaEvents mediaEvents = ((NativeOMTracker)$this$onQuartileChanged_u24lambda_u2d10).mediaEvents;
                    if (mediaEvents != null) {
                        mediaEvents.firstQuartile();
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    $this$onQuartileChanged_u24lambda_u2d10 = Result.constructor-impl((Object)unit);
                }
                catch (Throwable bl) {
                    Object $this$onQuartileChanged_u24lambda_u2d10 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                break;
            }
            case 6: {
                NativeOMTracker nativeOMTracker = this;
                try {
                    Unit unit;
                    Object $this$onQuartileChanged_u24lambda_u2d11 = nativeOMTracker;
                    boolean bl = false;
                    MediaEvents mediaEvents = ((NativeOMTracker)$this$onQuartileChanged_u24lambda_u2d11).mediaEvents;
                    if (mediaEvents != null) {
                        mediaEvents.midpoint();
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    $this$onQuartileChanged_u24lambda_u2d11 = Result.constructor-impl((Object)unit);
                }
                catch (Throwable bl) {
                    Object $this$onQuartileChanged_u24lambda_u2d11 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                break;
            }
            case 7: {
                NativeOMTracker nativeOMTracker = this;
                try {
                    Unit unit;
                    NativeOMTracker $this$onQuartileChanged_u24lambda_u2d12 = nativeOMTracker;
                    boolean bl = false;
                    MediaEvents mediaEvents = $this$onQuartileChanged_u24lambda_u2d12.mediaEvents;
                    if (mediaEvents != null) {
                        mediaEvents.thirdQuartile();
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    Object object = Result.constructor-impl((Object)unit);
                    break;
                }
                catch (Throwable throwable) {
                    Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
            }
        }
    }

    public final void onMuteChanged(boolean muted) {
        Logger.Companion.d(TAG, "track event: onMuteChanged muted=" + muted);
        if (muted) {
            NativeOMTracker nativeOMTracker = this;
            try {
                Unit unit;
                Object $this$onMuteChanged_u24lambda_u2d13 = nativeOMTracker;
                boolean bl = false;
                MediaEvents mediaEvents = ((NativeOMTracker)$this$onMuteChanged_u24lambda_u2d13).mediaEvents;
                if (mediaEvents != null) {
                    mediaEvents.volumeChange(0.0f);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                $this$onMuteChanged_u24lambda_u2d13 = Result.constructor-impl((Object)unit);
            }
            catch (Throwable bl) {
                Object $this$onMuteChanged_u24lambda_u2d13 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
        } else {
            NativeOMTracker nativeOMTracker = this;
            try {
                Unit unit;
                NativeOMTracker $this$onMuteChanged_u24lambda_u2d14 = nativeOMTracker;
                boolean bl = false;
                MediaEvents mediaEvents = $this$onMuteChanged_u24lambda_u2d14.mediaEvents;
                if (mediaEvents != null) {
                    mediaEvents.volumeChange(1.0f);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                Object object = Result.constructor-impl((Object)unit);
            }
            catch (Throwable throwable) {
                Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
        }
    }

    public final void onUserInteraction() {
        Logger.Companion.d(TAG, "track event: onUserInteraction");
        NativeOMTracker nativeOMTracker = this;
        try {
            Unit unit;
            NativeOMTracker $this$onUserInteraction_u24lambda_u2d15 = nativeOMTracker;
            boolean bl = false;
            MediaEvents mediaEvents = $this$onUserInteraction_u24lambda_u2d15.mediaEvents;
            if (mediaEvents != null) {
                mediaEvents.adUserInteraction(InteractionType.CLICK);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl((Object)unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final void impressionOccurred() {
        Logger.Companion.d(TAG, "track event: impressionOccurred");
        NativeOMTracker nativeOMTracker = this;
        try {
            Unit unit;
            NativeOMTracker $this$impressionOccurred_u24lambda_u2d16 = nativeOMTracker;
            boolean bl = false;
            AdEvents adEvents = $this$impressionOccurred_u24lambda_u2d16.adEvents;
            if (adEvents != null) {
                adEvents.impressionOccurred();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl((Object)unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    private final AdSessionConfiguration getNativeAdSession(CreativeType creativeType) {
        AdSessionConfiguration adSessionConfiguration = AdSessionConfiguration.createAdSessionConfiguration(creativeType, ImpressionType.BEGIN_TO_RENDER, Owner.NATIVE, creativeType == CreativeType.NATIVE_DISPLAY ? Owner.NONE : Owner.NATIVE, false);
        Intrinsics.checkNotNullExpressionValue((Object)adSessionConfiguration, (String)"createAdSessionConfigura\u2026          false\n        )");
        return adSessionConfiguration;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/vungle/ads/internal/omsdk/NativeOMTracker$Companion;", "", "()V", "TAG", "", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

