/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.Window;
import androidx.annotation.VisibleForTesting;
import androidx.core.view.ViewCompat;
import com.vungle.ads.internal.util.Logger;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\b\u0000\u0018\u0000 /2\u00020\u0001:\u0004/012B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B+\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00072\b\u0010$\u001a\u0004\u0018\u00010%J\u0006\u0010&\u001a\u00020\"J\u0006\u0010'\u001a\u00020\"J\u001e\u0010(\u001a\u0004\u0018\u00010\u00072\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010#\u001a\u0004\u0018\u00010\u0007H\u0002J\u001a\u0010)\u001a\u00020\u000f2\b\u0010#\u001a\u0004\u0018\u00010\u00072\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0007H\u0007J\b\u0010-\u001a\u00020\"H\u0002J\u001c\u0010.\u001a\u00020\u000f2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010#\u001a\u0004\u0018\u00010\u0007H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u00060\u0018R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001a8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001c\u0010\u0013\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u00063"}, d2={"Lcom/vungle/ads/internal/ImpressionTracker;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "trackedViews", "", "Landroid/view/View;", "Lcom/vungle/ads/internal/ImpressionTracker$TrackingInfo;", "visibilityHandler", "Landroid/os/Handler;", "(Landroid/content/Context;Ljava/util/Map;Landroid/os/Handler;)V", "clipRect", "Landroid/graphics/Rect;", "isVisibilityScheduled", "", "onPreDrawListener", "Landroid/view/ViewTreeObserver$OnPreDrawListener;", "getOnPreDrawListener$annotations", "()V", "getOnPreDrawListener", "()Landroid/view/ViewTreeObserver$OnPreDrawListener;", "setViewTreeObserverSucceed", "visibilityRunnable", "Lcom/vungle/ads/internal/ImpressionTracker$VisibilityRunnable;", "weakViewTreeObserver", "Ljava/lang/ref/WeakReference;", "Landroid/view/ViewTreeObserver;", "getWeakViewTreeObserver$annotations", "getWeakViewTreeObserver", "()Ljava/lang/ref/WeakReference;", "setWeakViewTreeObserver", "(Ljava/lang/ref/WeakReference;)V", "addView", "", "view", "listener", "Lcom/vungle/ads/internal/ImpressionTracker$ImpressionListener;", "clear", "destroy", "getTopView", "isVisible", "minPercentageViewed", "", "removeView", "scheduleVisibilityCheck", "setViewTreeObserver", "Companion", "ImpressionListener", "TrackingInfo", "VisibilityRunnable", "vungle-ads_release"})
public final class ImpressionTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<View, TrackingInfo> trackedViews;
    @NotNull
    private final Handler visibilityHandler;
    @NotNull
    private final Rect clipRect;
    @NotNull
    private final ViewTreeObserver.OnPreDrawListener onPreDrawListener;
    @NotNull
    private WeakReference<ViewTreeObserver> weakViewTreeObserver;
    @NotNull
    private final VisibilityRunnable visibilityRunnable;
    private boolean isVisibilityScheduled;
    private boolean setViewTreeObserverSucceed;
    private static final String TAG = ImpressionTracker.class.getSimpleName();
    private static final int MIN_VISIBILITY_PERCENTAGE = 1;
    private static final int VISIBILITY_THROTTLE_MILLIS = 100;

    @VisibleForTesting
    public ImpressionTracker(@NotNull Context context, @NotNull Map<View, TrackingInfo> trackedViews, @NotNull Handler visibilityHandler) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(trackedViews, (String)"trackedViews");
        Intrinsics.checkNotNullParameter((Object)visibilityHandler, (String)"visibilityHandler");
        this.trackedViews = trackedViews;
        this.visibilityHandler = visibilityHandler;
        this.clipRect = new Rect();
        this.visibilityRunnable = new VisibilityRunnable();
        this.onPreDrawListener = () -> ImpressionTracker._init_$lambda-0(this);
        this.weakViewTreeObserver = new WeakReference<Object>(null);
        this.setViewTreeObserverSucceed = this.setViewTreeObserver(context, null);
    }

    @NotNull
    public final ViewTreeObserver.OnPreDrawListener getOnPreDrawListener() {
        return this.onPreDrawListener;
    }

    @VisibleForTesting
    public static /* synthetic */ void getOnPreDrawListener$annotations() {
    }

    @NotNull
    public final WeakReference<ViewTreeObserver> getWeakViewTreeObserver() {
        return this.weakViewTreeObserver;
    }

    public final void setWeakViewTreeObserver(@NotNull WeakReference<ViewTreeObserver> weakReference) {
        Intrinsics.checkNotNullParameter(weakReference, (String)"<set-?>");
        this.weakViewTreeObserver = weakReference;
    }

    @VisibleForTesting
    public static /* synthetic */ void getWeakViewTreeObserver$annotations() {
    }

    public ImpressionTracker(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, new WeakHashMap(10), new Handler(Looper.getMainLooper()));
    }

    private final boolean setViewTreeObserver(Context context, View view) {
        ViewTreeObserver originalViewTreeObserver = (ViewTreeObserver)this.weakViewTreeObserver.get();
        if (originalViewTreeObserver != null && originalViewTreeObserver.isAlive()) {
            return true;
        }
        View rootView = this.getTopView(context, view);
        if (rootView == null) {
            String string = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.Companion.d(string, "Unable to set ViewTreeObserver due to no available root view.");
            return false;
        }
        ViewTreeObserver viewTreeObserver = rootView.getViewTreeObserver();
        if (!viewTreeObserver.isAlive()) {
            String string = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.Companion.d(string, "The root view tree observer was not alive");
            return false;
        }
        this.weakViewTreeObserver = new WeakReference<ViewTreeObserver>(viewTreeObserver);
        viewTreeObserver.addOnPreDrawListener(this.onPreDrawListener);
        return true;
    }

    public final void addView(@NotNull View view, @Nullable ImpressionListener listener) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.setViewTreeObserverSucceed = this.setViewTreeObserver(view.getContext(), view);
        TrackingInfo trackingInfo = this.trackedViews.get(view);
        if (trackingInfo == null) {
            trackingInfo = new TrackingInfo();
            this.trackedViews.put(view, trackingInfo);
            this.scheduleVisibilityCheck();
        }
        trackingInfo.setMinViewablePercent(1);
        trackingInfo.setImpressionListener(listener);
    }

    @VisibleForTesting
    public final void removeView(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.trackedViews.remove(view);
    }

    public final void clear() {
        this.trackedViews.clear();
        this.visibilityHandler.removeMessages(0);
        this.isVisibilityScheduled = false;
    }

    public final void destroy() {
        this.clear();
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.weakViewTreeObserver.get();
        if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
            viewTreeObserver.removeOnPreDrawListener(this.onPreDrawListener);
        }
        this.weakViewTreeObserver.clear();
    }

    private final View getTopView(Context context, View view) {
        View topView = null;
        if (context instanceof Activity) {
            Window window = ((Activity)context).getWindow();
            View view2 = window != null && (window = window.getDecorView()) != null ? window.findViewById(0x1020002) : (topView = null);
        }
        if (topView == null && view != null) {
            View rootView;
            if (!ViewCompat.isAttachedToWindow((View)view)) {
                String string = TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                Logger.Companion.w(string, "Trying to call View#rootView() on an unattached View.");
            }
            if ((rootView = view.getRootView()) != null) {
                topView = rootView.findViewById(0x1020002);
            }
            if (topView == null) {
                topView = rootView;
            }
        }
        return topView;
    }

    private final void scheduleVisibilityCheck() {
        if (this.isVisibilityScheduled) {
            return;
        }
        this.isVisibilityScheduled = true;
        this.visibilityHandler.postDelayed((Runnable)this.visibilityRunnable, 100L);
    }

    private final boolean isVisible(View view, int minPercentageViewed) {
        if (view == null || view.getVisibility() != 0 || view.getParent() == null) {
            return false;
        }
        ViewParent parentView = view.getParent();
        while (parentView instanceof ViewGroup) {
            if (((ViewGroup)parentView).getVisibility() != 0) {
                Logger.Companion.w("ImpressionTracker", "Parent visibility is not visible: " + parentView);
                return false;
            }
            parentView = ((ViewGroup)parentView).getParent();
        }
        if (!view.getGlobalVisibleRect(this.clipRect)) {
            return false;
        }
        long visibleViewArea = (long)this.clipRect.height() * (long)this.clipRect.width();
        long totalViewArea = (long)view.getHeight() * (long)view.getWidth();
        return totalViewArea <= 0L ? false : (long)100 * visibleViewArea >= (long)minPercentageViewed * totalViewArea;
    }

    private static final boolean _init_$lambda-0(ImpressionTracker this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.scheduleVisibilityCheck();
        return true;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&J\u0012\u0010\u0006\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/vungle/ads/internal/ImpressionTracker$ImpressionListener;", "", "onImpression", "", "view", "Landroid/view/View;", "onViewInvisible", "vungle-ads_release"})
    public static interface ImpressionListener {
        public void onImpression(@Nullable View var1);

        public void onViewInvisible(@Nullable View var1);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/vungle/ads/internal/ImpressionTracker$TrackingInfo;", "", "()V", "impressionListener", "Lcom/vungle/ads/internal/ImpressionTracker$ImpressionListener;", "getImpressionListener", "()Lcom/vungle/ads/internal/ImpressionTracker$ImpressionListener;", "setImpressionListener", "(Lcom/vungle/ads/internal/ImpressionTracker$ImpressionListener;)V", "minViewablePercent", "", "getMinViewablePercent", "()I", "setMinViewablePercent", "(I)V", "vungle-ads_release"})
    @VisibleForTesting
    public static final class TrackingInfo {
        private int minViewablePercent;
        @Nullable
        private ImpressionListener impressionListener;

        public final int getMinViewablePercent() {
            return this.minViewablePercent;
        }

        public final void setMinViewablePercent(int n) {
            this.minViewablePercent = n;
        }

        @Nullable
        public final ImpressionListener getImpressionListener() {
            return this.impressionListener;
        }

        public final void setImpressionListener(@Nullable ImpressionListener impressionListener) {
            this.impressionListener = impressionListener;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0081\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/vungle/ads/internal/ImpressionTracker$VisibilityRunnable;", "Ljava/lang/Runnable;", "(Lcom/vungle/ads/internal/ImpressionTracker;)V", "invisibleViews", "Ljava/util/ArrayList;", "Landroid/view/View;", "visibleViews", "run", "", "vungle-ads_release"})
    @VisibleForTesting
    public final class VisibilityRunnable
    implements Runnable {
        @NotNull
        private final ArrayList<View> visibleViews = new ArrayList();
        @NotNull
        private final ArrayList<View> invisibleViews = new ArrayList();

        @Override
        public void run() {
            TrackingInfo info;
            ImpressionTracker.this.isVisibilityScheduled = false;
            for (Map.Entry entry : ImpressionTracker.this.trackedViews.entrySet()) {
                TrackingInfo value;
                int minPercentageViewed;
                View view = (View)entry.getKey();
                if (ImpressionTracker.this.isVisible(view, minPercentageViewed = (value = (TrackingInfo)entry.getValue()).getMinViewablePercent())) {
                    this.visibleViews.add(view);
                    continue;
                }
                this.invisibleViews.add(view);
            }
            for (View view : this.visibleViews) {
                info = (TrackingInfo)ImpressionTracker.this.trackedViews.get(view);
                Object object = info;
                if (object != null && (object = ((TrackingInfo)object).getImpressionListener()) != null) {
                    object.onImpression(view);
                }
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"view");
                ImpressionTracker.this.removeView(view);
            }
            this.visibleViews.clear();
            for (View view : this.invisibleViews) {
                info = (TrackingInfo)ImpressionTracker.this.trackedViews.get(view);
                Object object = info;
                if (object == null || (object = ((TrackingInfo)object).getImpressionListener()) == null) continue;
                object.onViewInvisible(view);
            }
            this.invisibleViews.clear();
            if (!ImpressionTracker.this.trackedViews.isEmpty() && !ImpressionTracker.this.setViewTreeObserverSucceed) {
                ImpressionTracker.this.scheduleVisibilityCheck();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/vungle/ads/internal/ImpressionTracker$Companion;", "", "()V", "MIN_VISIBILITY_PERCENTAGE", "", "TAG", "", "kotlin.jvm.PlatformType", "VISIBILITY_THROTTLE_MILLIS", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

