/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.util;

import android.os.Build;
import android.webkit.URLUtil;
import androidx.annotation.VisibleForTesting;
import com.vungle.ads.AssetFailedToDeleteError;
import com.vungle.ads.internal.util.Logger;
import com.vungle.ads.internal.util.SafeObjectInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u00017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J$\u0010\u0016\u001a\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0010\b\u0002\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001aH\u0007J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0018H\u0007J\"\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00182\u0010\b\u0002\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001aH\u0007J\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!H\u0002J\u001a\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u0004J\u0010\u0010%\u001a\u00020&2\b\u0010#\u001a\u0004\u0018\u00010\u0004J\u0012\u0010'\u001a\u00020\u00132\b\u0010\u001e\u001a\u0004\u0018\u00010\u0018H\u0007J&\u0010'\u001a\u00020\u00132\b\u0010\u001e\u001a\u0004\u0018\u00010\u00182\u0006\u0010 \u001a\u00020!2\n\u0010(\u001a\u00060)j\u0002`*H\u0002J$\u0010+\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\n\u0010(\u001a\u00060)j\u0002`*H\u0002J\u001d\u0010,\u001a\u0004\u0018\u0001H-\"\u0004\b\u0000\u0010-2\u0006\u0010\u001c\u001a\u00020\u0018H\u0007\u00a2\u0006\u0002\u0010.J\u0010\u0010/\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001c\u001a\u00020\u0018J\u0010\u00100\u001a\u0002012\b\u0010\u001c\u001a\u0004\u0018\u00010\u0018J\u001a\u00102\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00182\b\u00103\u001a\u0004\u0018\u000104H\u0007J\u0018\u00105\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00182\b\u00106\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R&\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00068\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\nR&\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u00068"}, d2={"Lcom/vungle/ads/internal/util/FileUtility;", "", "()V", "TAG", "", "allowedClasses", "", "Ljava/lang/Class;", "getAllowedClasses$vungle_ads_release$annotations", "getAllowedClasses$vungle_ads_release", "()Ljava/util/List;", "<set-?>", "Lcom/vungle/ads/internal/util/FileUtility$ObjectInputStreamProvider;", "objectInputStreamProvider", "getObjectInputStreamProvider", "()Lcom/vungle/ads/internal/util/FileUtility$ObjectInputStreamProvider;", "setObjectInputStreamProvider", "(Lcom/vungle/ads/internal/util/FileUtility$ObjectInputStreamProvider;)V", "closeQuietly", "", "closeable", "Ljava/io/Closeable;", "delete", "f", "Ljava/io/File;", "excludeFiles", "", "deleteAndLogIfFailed", "file", "deleteContents", "folder", "getIndentString", "indent", "", "guessFileName", "url", "ext", "isValidUrl", "", "printDirectoryTree", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "printFile", "readSerializable", "T", "(Ljava/io/File;)Ljava/lang/Object;", "readString", "size", "", "writeSerializable", "serializable", "Ljava/io/Serializable;", "writeString", "content", "ObjectInputStreamProvider", "vungle-ads_release"})
public final class FileUtility {
    @NotNull
    public static final FileUtility INSTANCE = new FileUtility();
    @NotNull
    private static ObjectInputStreamProvider objectInputStreamProvider = FileUtility::objectInputStreamProvider$lambda-0;
    @NotNull
    private static final String TAG = "FileUtility";
    @NotNull
    private static final List<Class<?>> allowedClasses;

    private FileUtility() {
    }

    @VisibleForTesting
    @NotNull
    public final ObjectInputStreamProvider getObjectInputStreamProvider() {
        return objectInputStreamProvider;
    }

    @VisibleForTesting
    public final void setObjectInputStreamProvider(@NotNull ObjectInputStreamProvider objectInputStreamProvider) {
        Intrinsics.checkNotNullParameter((Object)objectInputStreamProvider, (String)"<set-?>");
        FileUtility.objectInputStreamProvider = objectInputStreamProvider;
    }

    @NotNull
    public final List<Class<?>> getAllowedClasses$vungle_ads_release() {
        return allowedClasses;
    }

    @VisibleForTesting
    public static /* synthetic */ void getAllowedClasses$vungle_ads_release$annotations() {
    }

    @JvmStatic
    public static final void printDirectoryTree(@Nullable File folder) {
    }

    private final void printDirectoryTree(File folder, int indent, StringBuilder sb) {
        if (folder == null) {
            return;
        }
        if (!folder.isDirectory()) {
            boolean bl = false;
            String string = "folder is not a Directory";
            throw new IllegalArgumentException(string.toString());
        }
        sb.append(this.getIndentString(indent)).append("+--").append(folder.getName()).append("/\n");
        File[] fileArray = folder.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file : fileArray) {
            if (file.isDirectory()) {
                this.printDirectoryTree(file, indent + 1, sb);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
            this.printFile(file, indent + 1, sb);
        }
    }

    private final void printFile(File file, int indent, StringBuilder sb) {
        sb.append(this.getIndentString(indent)).append("+--").append(file.getName()).append('\n');
    }

    private final String getIndentString(int indent) {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < indent; ++i2) {
            sb.append("|  ");
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @JvmStatic
    public static final void delete(@Nullable File f2, @Nullable Set<String> excludeFiles) {
        try {
            if (f2 == null || !f2.exists()) {
                return;
            }
            if (f2.isDirectory()) {
                Set<String> set = excludeFiles;
                boolean bl = set != null ? set.contains(f2.getName()) : false;
                if (bl) {
                    Logger.Companion.d(TAG, "Skipping deletion of directory: " + f2.getName());
                    return;
                }
                FileUtility.deleteContents(f2, excludeFiles);
            }
            Set<String> set = excludeFiles;
            boolean bl = set != null ? set.contains(f2.getName()) : false;
            if (bl) {
                Logger.Companion.d(TAG, "Skipping deletion of file: " + f2.getName());
                return;
            }
            if (!f2.delete()) {
                Logger.Companion.d(TAG, "Failed to delete file: " + f2);
            }
        }
        catch (Exception e2) {
            Logger.Companion.e(TAG, "Failed to delete file: " + e2.getLocalizedMessage());
        }
    }

    public static /* synthetic */ void delete$default(File file, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = null;
        }
        FileUtility.delete(file, set);
    }

    @JvmStatic
    public static final void deleteContents(@NotNull File folder, @Nullable Set<String> excludeFiles) {
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        File[] fileArray = folder.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File fileInFolder : fileArray) {
            FileUtility.delete(fileInFolder, excludeFiles);
        }
    }

    public static /* synthetic */ void deleteContents$default(File file, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = null;
        }
        FileUtility.deleteContents(file, set);
    }

    @JvmStatic
    public static final void deleteAndLogIfFailed(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                Files.delete(file.toPath());
            } else if (!file.delete()) {
                new AssetFailedToDeleteError("Cannot delete " + file.getName()).logErrorNoReturnValue$vungle_ads_release();
            }
        }
        catch (Exception e2) {
            new AssetFailedToDeleteError("Failed to delete " + file.getName() + " with error :" + e2.getMessage()).logErrorNoReturnValue$vungle_ads_release();
        }
    }

    public final void closeQuietly(@Nullable Closeable closeable) {
        try {
            Closeable closeable2 = closeable;
            if (closeable2 != null) {
                closeable2.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void writeSerializable(@NotNull File file, @Nullable Serializable serializable) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.exists()) {
            FileUtility.deleteAndLogIfFailed(file);
        }
        if (serializable == null) {
            return;
        }
        FileOutputStream fout = null;
        ObjectOutputStream oout = null;
        try {
            fout = new FileOutputStream(file);
            oout = new ObjectOutputStream(fout);
            oout.writeObject(serializable);
            oout.reset();
        }
        catch (IOException e2) {
            Logger.Companion.e(TAG, String.valueOf(e2.getMessage()));
        }
        finally {
            INSTANCE.closeQuietly(oout);
            INSTANCE.closeQuietly(fout);
        }
    }

    public final void writeString(@NotNull File file, @Nullable String content) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (content == null) {
            return;
        }
        try {
            FilesKt.writeText((File)file, (String)content, (Charset)Charsets.UTF_8);
        }
        catch (IOException e2) {
            Logger.Companion.e(TAG, String.valueOf(e2.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @Nullable
    public static final <T> T readSerializable(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.exists()) {
            return null;
        }
        FileInputStream fin = null;
        ObjectInputStream oin = null;
        try {
            fin = new FileInputStream(file);
            oin = objectInputStreamProvider.provideObjectInputStream(fin);
            Object object = oin.readObject();
            return (T)object;
        }
        catch (IOException e2) {
            Logger.Companion.e(TAG, "IOException: " + e2.getMessage());
        }
        catch (ClassNotFoundException e3) {
            Logger.Companion.e(TAG, "ClassNotFoundException: " + e3.getMessage());
        }
        catch (Exception e4) {
            Logger.Companion.e(TAG, "cannot read serializable " + e4.getMessage());
        }
        finally {
            INSTANCE.closeQuietly(oin);
            INSTANCE.closeQuietly(fin);
        }
        try {
            FileUtility.delete$default(file, null, 2, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    public final String readString(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.exists()) {
            return null;
        }
        try {
            return FilesKt.readText$default((File)file, null, (int)1, null);
        }
        catch (IOException e2) {
            Logger.Companion.e(TAG, "IOException: " + e2.getMessage());
        }
        catch (Exception e3) {
            Logger.Companion.e(TAG, "cannot read string " + e3.getMessage());
        }
        return null;
    }

    public final boolean isValidUrl(@Nullable String url) {
        boolean bl;
        try {
            CharSequence charSequence = url;
            bl = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && HttpUrl.Companion.parse(url) != null;
        }
        catch (Throwable _) {
            bl = false;
        }
        return bl;
    }

    public final long size(@Nullable File file) {
        if (file == null || !file.exists()) {
            return 0L;
        }
        long length = 0L;
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children != null && !(children.length == 0)) {
                for (File child : children) {
                    length += this.size(child);
                }
            }
            return length;
        }
        return file.length();
    }

    @NotNull
    public final String guessFileName(@NotNull String url, @Nullable String ext) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String string = URLUtil.guessFileName((String)url, null, (String)ext);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"guessFileName(url, null, ext)");
        return string;
    }

    public static /* synthetic */ String guessFileName$default(FileUtility fileUtility, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return fileUtility.guessFileName(string, string2);
    }

    private static final ObjectInputStream objectInputStreamProvider$lambda-0(InputStream inputStream) {
        return new SafeObjectInputStream(inputStream, allowedClasses);
    }

    static {
        Object[] objectArray = new Class[]{LinkedHashSet.class, HashSet.class, HashMap.class, ArrayList.class, File.class};
        allowedClasses = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e0\u0080\u0001\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/vungle/ads/internal/util/FileUtility$ObjectInputStreamProvider;", "", "provideObjectInputStream", "Ljava/io/ObjectInputStream;", "inputStream", "Ljava/io/InputStream;", "vungle-ads_release"})
    public static interface ObjectInputStreamProvider {
        @NotNull
        public ObjectInputStream provideObjectInputStream(@Nullable InputStream var1) throws IOException, ClassNotFoundException;
    }
}

