/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.task;

import android.content.Context;
import com.vungle.ads.internal.task.CleanupJob;
import com.vungle.ads.internal.task.Job;
import com.vungle.ads.internal.task.JobCreator;
import com.vungle.ads.internal.task.ResendTpatJob;
import com.vungle.ads.internal.task.UnknownTagException;
import com.vungle.ads.internal.util.PathProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/vungle/ads/internal/task/VungleJobCreator;", "Lcom/vungle/ads/internal/task/JobCreator;", "context", "Landroid/content/Context;", "pathProvider", "Lcom/vungle/ads/internal/util/PathProvider;", "(Landroid/content/Context;Lcom/vungle/ads/internal/util/PathProvider;)V", "getContext", "()Landroid/content/Context;", "getPathProvider", "()Lcom/vungle/ads/internal/util/PathProvider;", "create", "Lcom/vungle/ads/internal/task/Job;", "tag", "", "vungle-ads_release"})
public final class VungleJobCreator
implements JobCreator {
    @NotNull
    private final Context context;
    @NotNull
    private final PathProvider pathProvider;

    public VungleJobCreator(@NotNull Context context, @NotNull PathProvider pathProvider) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pathProvider, (String)"pathProvider");
        this.context = context;
        this.pathProvider = pathProvider;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final PathProvider getPathProvider() {
        return this.pathProvider;
    }

    @Override
    @NotNull
    public Job create(@NotNull String tag) throws UnknownTagException {
        Job job;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        if (((CharSequence)tag).length() == 0) {
            throw new UnknownTagException("Job tag is null");
        }
        String string = tag;
        if (Intrinsics.areEqual((Object)string, (Object)"CleanupJob")) {
            job = new CleanupJob(this.context, this.pathProvider);
        } else if (Intrinsics.areEqual((Object)string, (Object)"ResendTpatJob")) {
            job = new ResendTpatJob(this.context, this.pathProvider);
        } else {
            throw new UnknownTagException("Unknown Job Type " + tag);
        }
        return job;
    }
}

