/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.task;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Bundle;
import com.vungle.ads.ServiceLocator;
import com.vungle.ads.internal.persistence.FilePreferences;
import com.vungle.ads.internal.task.Job;
import com.vungle.ads.internal.task.JobInfo;
import com.vungle.ads.internal.task.JobRunner;
import com.vungle.ads.internal.util.FileUtility;
import com.vungle.ads.internal.util.Logger;
import com.vungle.ads.internal.util.PathProvider;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\fH\u0002J\b\u0010\u000e\u001a\u00020\fH\u0002J\b\u0010\u000f\u001a\u00020\fH\u0002J\b\u0010\u0010\u001a\u00020\fH\u0002J\b\u0010\u0011\u001a\u00020\fH\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019\u00b2\u0006\n\u0010\u001a\u001a\u00020\u001bX\u008a\u0084\u0002"}, d2={"Lcom/vungle/ads/internal/task/CleanupJob;", "Lcom/vungle/ads/internal/task/Job;", "context", "Landroid/content/Context;", "pathProvider", "Lcom/vungle/ads/internal/util/PathProvider;", "(Landroid/content/Context;Lcom/vungle/ads/internal/util/PathProvider;)V", "getContext", "()Landroid/content/Context;", "getPathProvider", "()Lcom/vungle/ads/internal/util/PathProvider;", "checkIfSdkUpgraded", "", "dropV6Data", "dropV700Data", "dropV730TempData", "dropV742TpatData", "dropV750Data", "onRunJob", "", "bundle", "Landroid/os/Bundle;", "jobRunner", "Lcom/vungle/ads/internal/task/JobRunner;", "Companion", "vungle-ads_release", "filePreferences", "Lcom/vungle/ads/internal/persistence/FilePreferences;"})
public final class CleanupJob
implements Job {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final PathProvider pathProvider;
    @NotNull
    public static final String TAG = "CleanupJob";
    @NotNull
    private static final String AD_ID_KEY = "AD_ID_KEY";

    public CleanupJob(@NotNull Context context, @NotNull PathProvider pathProvider) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pathProvider, (String)"pathProvider");
        this.context = context;
        this.pathProvider = pathProvider;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final PathProvider getPathProvider() {
        return this.pathProvider;
    }

    @Override
    public int onRunJob(@NotNull Bundle bundle, @NotNull JobRunner jobRunner) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        Intrinsics.checkNotNullParameter((Object)jobRunner, (String)"jobRunner");
        File downloadsDir = this.pathProvider.getVmDir();
        File dirToDelete = null;
        dirToDelete = downloadsDir;
        Object[] objectArray2 = bundle.getString(AD_ID_KEY);
        if (objectArray2 != null) {
            Object[] adId = objectArray = objectArray2;
            boolean bl = false;
            File file = this.pathProvider.getDownloadsDirForAd((String)adId);
            if (file != null) {
                File file2;
                File it = file2 = file;
                boolean bl2 = false;
                dirToDelete = it;
            }
        }
        Logger.Companion.d(TAG, "CleanupJob: Current directory snapshot");
        try {
            if (Intrinsics.areEqual((Object)dirToDelete, (Object)downloadsDir)) {
                this.checkIfSdkUpgraded();
                objectArray = new String[]{"omsdk.js", "omsdk-session.js"};
                Set excludeFiles = SetsKt.setOf((Object[])objectArray);
                FileUtility.deleteContents(dirToDelete, excludeFiles);
            } else {
                FileUtility.delete$default(dirToDelete, null, 2, null);
            }
        }
        catch (IOException _) {
            return 1;
        }
        return 0;
    }

    private final void dropV6Data() {
        block4: {
            Logger.Companion.d(TAG, "CleanupJob: drop old files data");
            File oldDb = new File(this.context.getNoBackupFilesDir(), "vungle_db");
            if (oldDb.exists()) {
                FileUtility.delete$default(oldDb, null, 2, null);
                FileUtility.delete$default(new File(oldDb.getPath() + "-journal"), null, 2, null);
            } else {
                this.context.deleteDatabase("vungle_db");
            }
            SharedPreferences sp = this.context.getSharedPreferences("com.vungle.sdk", 0);
            String vungleCachePath = sp.getString("cache_path", null);
            if (Build.VERSION.SDK_INT >= 24) {
                this.context.deleteSharedPreferences("com.vungle.sdk");
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)sp, (String)"sp");
                SharedPreferences $this$edit_u24default$iv = sp;
                boolean commit$iv = false;
                boolean $i$f$edit = false;
                SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
                Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
                SharedPreferences.Editor $this$dropV6Data_u24lambda_u2d2 = editor$iv;
                boolean bl = false;
                $this$dropV6Data_u24lambda_u2d2.clear();
                editor$iv.apply();
            }
            File file = this.context.getNoBackupFilesDir();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"context.noBackupFilesDir");
            File dir = file;
            File vungleSettings = new File(dir, "vungle_settings");
            FileUtility.delete$default(vungleSettings, null, 2, null);
            String string = vungleCachePath;
            if (string == null) break block4;
            String it = string;
            boolean bl = false;
            FileUtility.delete$default(new File(it), null, 2, null);
        }
    }

    private final void dropV700Data() {
        File vungleDirV700 = new File(this.context.getApplicationInfo().dataDir, "vungle");
        FileUtility.delete$default(vungleDirV700, null, 2, null);
    }

    private final void dropV730TempData() {
        try {
            FileUtility.delete$default(new File(this.pathProvider.getSharedPrefsDir(), "vungleSettings"), null, 2, null);
            FileUtility.delete$default(new File(this.pathProvider.getSharedPrefsDir(), "failedTpatSet"), null, 2, null);
        }
        catch (Exception e2) {
            Logger.Companion.e(TAG, "Failed to delete temp data", e2);
        }
    }

    private final void dropV742TpatData() {
        File sharedPrefsDir = this.context.getNoBackupFilesDir();
        try {
            FileUtility.delete$default(new File(sharedPrefsDir, "failedTpats"), null, 2, null);
            FileUtility.delete$default(new File(sharedPrefsDir, "failedGenericTpats"), null, 2, null);
        }
        catch (Exception e2) {
            Logger.Companion.e(TAG, "Failed to delete 742 tpat data", e2);
        }
    }

    private final void dropV750Data() {
        File sharedPrefsDir = this.context.getNoBackupFilesDir();
        try {
            FileUtility.delete$default(new File(sharedPrefsDir, "vungle_cache/downloads"), null, 2, null);
            FileUtility.delete$default(new File(sharedPrefsDir, "vungle_cache/js"), null, 2, null);
        }
        catch (Exception e2) {
            Logger.Companion.e(TAG, "Failed to delete 750 data", e2);
        }
    }

    private final void checkIfSdkUpgraded() {
        ServiceLocator.Companion companion = ServiceLocator.Companion;
        Context context$iv = this.context;
        boolean $i$f$inject = false;
        Lazy filePreferences$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<FilePreferences>(context$iv){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final FilePreferences invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(FilePreferences.class);
            }
        }));
        int lastInstalledVersion = CleanupJob.checkIfSdkUpgraded$lambda-4((Lazy<FilePreferences>)filePreferences$delegate).getInt("VERSION_CODE", -1);
        if (lastInstalledVersion < 70602) {
            if (lastInstalledVersion < 70000) {
                this.dropV6Data();
            }
            if (lastInstalledVersion < 70100) {
                this.dropV700Data();
            }
            if (lastInstalledVersion < 70301) {
                this.dropV730TempData();
            }
            if (lastInstalledVersion < 70500) {
                this.dropV742TpatData();
            }
            if (lastInstalledVersion < 70600) {
                this.dropV750Data();
            }
            CleanupJob.checkIfSdkUpgraded$lambda-4((Lazy<FilePreferences>)filePreferences$delegate).put("VERSION_CODE", 70602).apply();
        }
    }

    private static final FilePreferences checkIfSdkUpgraded$lambda-4(Lazy<FilePreferences> $filePreferences$delegate) {
        Lazy<FilePreferences> lazy = $filePreferences$delegate;
        return (FilePreferences)lazy.getValue();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/vungle/ads/internal/task/CleanupJob$Companion;", "", "()V", "AD_ID_KEY", "", "TAG", "makeJobInfo", "Lcom/vungle/ads/internal/task/JobInfo;", "adId", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final JobInfo makeJobInfo(@Nullable String adId) {
            JobInfo jobInfo;
            Bundle bundle;
            block0: {
                void $this$makeJobInfo_u24lambda_u2d1;
                Bundle bundle2 = bundle = new Bundle();
                jobInfo = new JobInfo(CleanupJob.TAG).setPriority(0);
                boolean bl = false;
                String string = adId;
                if (string == null) break block0;
                String it = string;
                boolean bl2 = false;
                $this$makeJobInfo_u24lambda_u2d1.putString(CleanupJob.AD_ID_KEY, it);
            }
            return jobInfo.setExtras(bundle).setUpdateCurrent(adId == null);
        }

        public static /* synthetic */ JobInfo makeJobInfo$default(Companion companion, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = null;
            }
            return companion.makeJobInfo(string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

