/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.platform;

import android.content.Context;
import android.hardware.SensorManager;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.ProxyInfo;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\n\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\b*\u0004\u0018\u00010\rH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/vungle/ads/internal/platform/DeviceCheckUtils;", "", "()V", "getSensorCount", "", "context", "Landroid/content/Context;", "hasSystemAlertWindowPermission", "", "isEmulator", "isProxyEnabled", "isVpnConnected", "isEnabled", "Landroid/net/ProxyInfo;", "vungle-ads_release"})
public final class DeviceCheckUtils {
    @NotNull
    public static final DeviceCheckUtils INSTANCE = new DeviceCheckUtils();

    private DeviceCheckUtils() {
    }

    public final boolean isEmulator() {
        String string;
        String manufacturer;
        String brand;
        String product;
        String model;
        String fingerprint;
        block23: {
            block22: {
                block21: {
                    String string2;
                    block20: {
                        block19: {
                            String string3;
                            block18: {
                                block17: {
                                    String string4;
                                    block16: {
                                        block15: {
                                            String string5;
                                            block14: {
                                                block13: {
                                                    String string6;
                                                    block12: {
                                                        string6 = Build.FINGERPRINT;
                                                        if (string6 == null) break block12;
                                                        String string7 = string6.toLowerCase(Locale.ROOT);
                                                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                                                        string6 = string7;
                                                        if (string7 != null) break block13;
                                                    }
                                                    string6 = fingerprint = "";
                                                }
                                                if ((string5 = Build.MODEL) == null) break block14;
                                                String string8 = string5.toLowerCase(Locale.ROOT);
                                                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                                                string5 = string8;
                                                if (string8 != null) break block15;
                                            }
                                            string5 = model = "";
                                        }
                                        if ((string4 = Build.PRODUCT) == null) break block16;
                                        String string9 = string4.toLowerCase(Locale.ROOT);
                                        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                                        string4 = string9;
                                        if (string9 != null) break block17;
                                    }
                                    string4 = product = "";
                                }
                                if ((string3 = Build.BRAND) == null) break block18;
                                String string10 = string3.toLowerCase(Locale.ROOT);
                                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                                string3 = string10;
                                if (string10 != null) break block19;
                            }
                            string3 = brand = "";
                        }
                        if ((string2 = Build.MANUFACTURER) == null) break block20;
                        String string11 = string2.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                        string2 = string11;
                        if (string11 != null) break block21;
                    }
                    string2 = manufacturer = "";
                }
                if ((string = Build.BOARD) == null) break block22;
                String string12 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                string = string12;
                if (string12 != null) break block23;
            }
            string = "";
        }
        String board = string;
        Intrinsics.checkNotNullExpressionValue((Object)Build.SUPPORTED_ABIS, (String)"SUPPORTED_ABIS");
        String string13 = ArraysKt.joinToString$default((Object[])Build.SUPPORTED_ABIS, null, null, null, (int)0, null, null, (int)63, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String cpuAbi = string13;
        return StringsKt.contains$default((CharSequence)fingerprint, (CharSequence)"generic", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)fingerprint, (CharSequence)"emulator", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)model, (CharSequence)"google_sdk", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)model, (CharSequence)"emulator", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)product, (CharSequence)"sdk", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)product, (CharSequence)"vbox", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)brand, (CharSequence)"generic", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)manufacturer, (CharSequence)"genymotion", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)board, (CharSequence)"nox", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)cpuAbi, (CharSequence)"x86", (boolean)false, (int)2, null);
    }

    public final boolean isVpnConnected(@NotNull Context context) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object2 = this;
        try {
            boolean bl;
            block3: {
                DeviceCheckUtils $this$isVpnConnected_u24lambda_u2d1 = object2;
                boolean bl2 = false;
                Object object3 = context.getSystemService("connectivity");
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
                ConnectivityManager cm = (ConnectivityManager)object3;
                Network[] networkArray = cm.getAllNetworks();
                Intrinsics.checkNotNullExpressionValue((Object)networkArray, (String)"cm.allNetworks");
                Object[] $this$any$iv = networkArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    Network network = (Network)element$iv;
                    boolean bl3 = false;
                    NetworkCapabilities networkCapabilities = cm.getNetworkCapabilities(network);
                    boolean bl4 = networkCapabilities != null ? networkCapabilities.hasTransport(4) : false;
                    if (!bl4) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            object = Result.constructor-impl((Object)bl);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        object = false;
        return (Boolean)(Result.isFailure-impl((Object)object2) ? object : object2);
    }

    public final boolean hasSystemAlertWindowPermission(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Build.VERSION.SDK_INT >= 23 ? Settings.canDrawOverlays((Context)context) : context.checkCallingOrSelfPermission("android.permission.SYSTEM_ALERT_WINDOW") == 0;
    }

    public final int getSensorCount(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("sensor");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.hardware.SensorManager");
        SensorManager sensorManager = (SensorManager)object;
        return sensorManager.getSensorList(-1).size();
    }

    private final boolean isEnabled(ProxyInfo $this$isEnabled) {
        if ($this$isEnabled == null) {
            return false;
        }
        String string = $this$isEnabled.getHost();
        boolean hasHostPort = (string != null ? ((CharSequence)string).length() > 0 : false) && $this$isEnabled.getPort() > 0;
        boolean hasPac = $this$isEnabled.getPacFileUrl() != null && !Intrinsics.areEqual((Object)$this$isEnabled.getPacFileUrl(), (Object)Uri.EMPTY);
        return hasHostPort || hasPac;
    }

    /*
     * Unable to fully structure code
     */
    public final boolean isProxyEnabled(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        var2_2 = this;
        try {
            block7: {
                block8: {
                    $this$isProxyEnabled_u24lambda_u2d3 = var2_2;
                    $i$a$-runCatching-DeviceCheckUtils$isProxyEnabled$1 = false;
                    v0 = context.getSystemService("connectivity");
                    Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
                    cm = (ConnectivityManager)v0;
                    if (Build.VERSION.SDK_INT < 23) break block8;
                    v1 = cm.getActiveNetwork();
                    if (v1 == null) {
                        v2 = false;
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"cm.activeNetwork ?: return@runCatching false");
                        net = v1;
                        v3 = cm.getLinkProperties(net);
                        v2 = $this$isProxyEnabled_u24lambda_u2d3.isEnabled((ProxyInfo)(v3 != null ? v3.getHttpProxy() : null));
                    }
                    break block7;
                }
                v4 = cm.getAllNetworks();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"cm.allNetworks");
                $this$any$iv = v4;
                $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    n = (Network)element$iv;
                    $i$a$-any-DeviceCheckUtils$isProxyEnabled$1$1 = false;
                    v5 = cm.getNetworkInfo(n);
                    v6 = v5 != null ? v5.isConnected() : false;
                    if (!v6) ** GOTO lbl-1000
                    v7 = cm.getLinkProperties(n);
                    if ($this$isProxyEnabled_u24lambda_u2d3.isEnabled((ProxyInfo)(v7 != null ? v7.getHttpProxy() : null))) {
                        v8 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v8 = false;
                    }
                    if (!v8) continue;
                    v2 = true;
                    break block7;
                }
                v2 = false;
            }
            var3_3 = Result.constructor-impl((Object)v2);
        }
        catch (Throwable var4_5) {
            var3_3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var4_5));
        }
        var2_2 = var3_3;
        var3_3 = false;
        return (Boolean)(Result.isFailure-impl((Object)var2_2) != false ? var3_3 : var2_2);
    }
}

