/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.platform;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.media.AudioManager;
import android.os.Build;
import android.os.Environment;
import android.os.PowerManager;
import android.os.SystemClock;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import androidx.core.util.Consumer;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.appset.AppSet;
import com.google.android.gms.appset.AppSetIdClient;
import com.google.android.gms.appset.AppSetIdInfo;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.tasks.Task;
import com.vungle.ads.ServiceLocator;
import com.vungle.ads.internal.executor.VungleThreadPoolExecutor;
import com.vungle.ads.internal.model.AdvertisingInfo;
import com.vungle.ads.internal.persistence.FilePreferences;
import com.vungle.ads.internal.platform.Platform;
import com.vungle.ads.internal.platform.WebViewUtil;
import com.vungle.ads.internal.util.Logger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\u0018\u0000 ;2\u00020\u0001:\u0001;B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010(\u001a\u00020\fH\u0016J\b\u0010)\u001a\u00020\fH\u0002J\n\u0010*\u001a\u0004\u0018\u00010\u000eH\u0016J\u000f\u0010+\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010,J\b\u0010-\u001a\u00020\u001eH\u0016J\n\u0010.\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010/\u001a\u00020\fH\u0002J\b\u00100\u001a\u00020\u001eH\u0016J\b\u00101\u001a\u00020\u001eH\u0016J\b\u00102\u001a\u00020\u001eH\u0016J\u0018\u00103\u001a\u0002042\u000e\u00105\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e06H\u0016J\b\u00107\u001a\u00020\u0017H\u0016J\u0010\u00108\u001a\u00020%2\u0006\u00109\u001a\u00020%H\u0002J\b\u0010:\u001a\u000204H\u0002R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0018R\u0014\u0010\u001a\u001a\u00020\u0017X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0014\u0010\u001b\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0018R\u0014\u0010\u001c\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0018R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010 \u001a\u0004\u0018\u00010\u000e8VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0014\"\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006<\u00b2\u0006\n\u0010=\u001a\u00020>X\u008a\u0084\u0002"}, d2={"Lcom/vungle/ads/internal/platform/AndroidPlatform;", "Lcom/vungle/ads/internal/platform/Platform;", "context", "Landroid/content/Context;", "uaExecutor", "Lcom/vungle/ads/internal/executor/VungleThreadPoolExecutor;", "powerManager", "Landroid/os/PowerManager;", "audioManager", "Landroid/media/AudioManager;", "(Landroid/content/Context;Lcom/vungle/ads/internal/executor/VungleThreadPoolExecutor;Landroid/os/PowerManager;Landroid/media/AudioManager;)V", "advertisingInfo", "Lcom/vungle/ads/internal/model/AdvertisingInfo;", "appSetId", "", "appSetIdScope", "", "Ljava/lang/Integer;", "carrierName", "getCarrierName", "()Ljava/lang/String;", "gpVersion", "isBatterySaverEnabled", "", "()Z", "isSdCardPresent", "isSideLoaded", "isSilentModeEnabled", "isSoundEnabled", "sdkInstallationTime", "", "Ljava/lang/Long;", "userAgent", "getUserAgent", "setUserAgent", "(Ljava/lang/String;)V", "volumeLevel", "", "getVolumeLevel", "()F", "getAdvertisingInfo", "getAmazonAdvertisingInfo", "getAppSetId", "getAppSetIdScope", "()Ljava/lang/Integer;", "getBuildTime", "getGPVersion", "getGoogleAdvertisingInfo", "getLastBootTime", "getOSInstallationTime", "getSDKInstallationTime", "getUserAgentLazy", "", "consumer", "Landroidx/core/util/Consumer;", "isProblematicMaliDevice", "sanitizeVolume", "value", "updateAppSetID", "Companion", "vungle-ads_release", "filePreferences", "Lcom/vungle/ads/internal/persistence/FilePreferences;"})
public final class AndroidPlatform
implements Platform {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final VungleThreadPoolExecutor uaExecutor;
    @NotNull
    private final PowerManager powerManager;
    @NotNull
    private final AudioManager audioManager;
    @Nullable
    private Long sdkInstallationTime;
    @Nullable
    private String appSetId;
    @Nullable
    private Integer appSetIdScope;
    @Nullable
    private AdvertisingInfo advertisingInfo;
    @Nullable
    private String gpVersion;
    private final boolean isSideLoaded;
    @Nullable
    private String userAgent;
    @NotNull
    private static final String TAG = "AndroidPlatform";
    @NotNull
    private static final String PREF_KEY_SDK_INSTALL_TIME = "sit";

    public AndroidPlatform(@NotNull Context context, @NotNull VungleThreadPoolExecutor uaExecutor, @NotNull PowerManager powerManager, @NotNull AudioManager audioManager) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uaExecutor, (String)"uaExecutor");
        Intrinsics.checkNotNullParameter((Object)powerManager, (String)"powerManager");
        Intrinsics.checkNotNullParameter((Object)audioManager, (String)"audioManager");
        this.context = context;
        this.uaExecutor = uaExecutor;
        this.powerManager = powerManager;
        this.audioManager = audioManager;
        this.updateAppSetID();
    }

    public /* synthetic */ AndroidPlatform(Context context, VungleThreadPoolExecutor vungleThreadPoolExecutor, PowerManager powerManager, AudioManager audioManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            Object object = context.getSystemService("power");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.os.PowerManager");
            powerManager = (PowerManager)object;
        }
        if ((n & 8) != 0) {
            Object object = context.getSystemService("audio");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.media.AudioManager");
            audioManager = (AudioManager)object;
        }
        this(context, vungleThreadPoolExecutor, powerManager, audioManager);
    }

    @Override
    public boolean isBatterySaverEnabled() {
        return this.powerManager.isPowerSaveMode();
    }

    @Override
    public boolean isSideLoaded() {
        return this.isSideLoaded;
    }

    @Override
    public float getVolumeLevel() {
        float f2;
        try {
            float max = this.audioManager.getStreamMaxVolume(3);
            float current = this.audioManager.getStreamVolume(3);
            float raw2 = current / max;
            f2 = this.sanitizeVolume(raw2);
        }
        catch (Exception _) {
            f2 = 0.0f;
        }
        return f2;
    }

    @Override
    public boolean isSoundEnabled() {
        boolean bl;
        try {
            int current = this.audioManager.getStreamVolume(3);
            bl = current > 0;
        }
        catch (Exception _) {
            bl = true;
        }
        return bl;
    }

    @Override
    @NotNull
    public String getCarrierName() {
        String string = Companion.getCarrierName$vungle_ads_release(this.context);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCarrierName(context)");
        return string;
    }

    @Override
    public boolean isSdCardPresent() {
        boolean bl;
        try {
            bl = Intrinsics.areEqual((Object)Environment.getExternalStorageState(), (Object)"mounted");
        }
        catch (Exception e2) {
            Logger.Companion.e(TAG, "Acquiring external storage state failed", e2);
            bl = false;
        }
        return bl;
    }

    @Override
    public void getUserAgentLazy(@NotNull Consumer<String> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.uaExecutor.execute(() -> AndroidPlatform.getUserAgentLazy$lambda-0(this, consumer));
    }

    private final float sanitizeVolume(float value) {
        return Float.isNaN(value) || Float.isInfinite(value) ? 0.0f : (value < 0.0f ? 0.0f : (value > 1.0f ? 1.0f : value));
    }

    private final AdvertisingInfo getAmazonAdvertisingInfo() {
        AdvertisingInfo advertisingInfo = new AdvertisingInfo();
        try {
            ContentResolver cr = this.context.getContentResolver();
            advertisingInfo.setLimitAdTracking(Settings.Secure.getInt((ContentResolver)cr, (String)"limit_ad_tracking") == 1);
            advertisingInfo.setAdvertisingId(Settings.Secure.getString((ContentResolver)cr, (String)"advertising_id"));
        }
        catch (Settings.SettingNotFoundException ex) {
            Logger.Companion.e(TAG, "Error getting Amazon advertising info: Setting not found.", ex);
        }
        catch (Exception ex) {
            Logger.Companion.e(TAG, "Error getting Amazon advertising info", ex);
        }
        return advertisingInfo;
    }

    private final AdvertisingInfo getGoogleAdvertisingInfo() {
        AdvertisingInfo advertisingInfo = new AdvertisingInfo();
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.context);
            Intrinsics.checkNotNullExpressionValue((Object)info, (String)"getAdvertisingIdInfo(context)");
            AdvertisingIdClient.Info idInfo = info;
            advertisingInfo.setAdvertisingId(idInfo.getId());
            advertisingInfo.setLimitAdTracking(idInfo.isLimitAdTrackingEnabled());
        }
        catch (NoClassDefFoundError ex) {
            Logger.Companion.e(TAG, "Play services Not available: " + ex.getLocalizedMessage());
            ContentResolver cr = this.context.getContentResolver();
            advertisingInfo.setAdvertisingId(Settings.Secure.getString((ContentResolver)cr, (String)"advertising_id"));
        }
        catch (GooglePlayServicesNotAvailableException exception) {
            Logger.Companion.e(TAG, "Play services Not available: " + exception.getLocalizedMessage());
        }
        catch (Exception exception) {
            Logger.Companion.e(TAG, "Error getting Google advertising info: " + exception.getLocalizedMessage());
        }
        return advertisingInfo;
    }

    @Override
    @NotNull
    public AdvertisingInfo getAdvertisingInfo() {
        AdvertisingInfo newAdvertisingInfo;
        AdvertisingInfo advertisingInfo = this.advertisingInfo;
        if (advertisingInfo != null) {
            AdvertisingInfo cachedAdvInfo = advertisingInfo;
            boolean bl = false;
            CharSequence charSequence = cachedAdvInfo.getAdvertisingId();
            if (!(charSequence == null || charSequence.length() == 0)) {
                return cachedAdvInfo;
            }
        }
        this.advertisingInfo = newAdvertisingInfo = StringsKt.equals((String)Build.MANUFACTURER, (String)"Amazon", (boolean)true) ? this.getAmazonAdvertisingInfo() : this.getGoogleAdvertisingInfo();
        return newAdvertisingInfo;
    }

    @Override
    @Nullable
    public String getAppSetId() {
        return this.appSetId;
    }

    @Override
    @Nullable
    public Integer getAppSetIdScope() {
        return this.appSetIdScope;
    }

    @Override
    public long getOSInstallationTime() {
        Object object;
        Object $this$getOSInstallationTime_u24lambda_u2d2;
        Object object2 = this;
        try {
            $this$getOSInstallationTime_u24lambda_u2d2 = object2;
            boolean bl = false;
            PackageInfo packageInfo = Build.VERSION.SDK_INT >= 33 ? ((AndroidPlatform)$this$getOSInstallationTime_u24lambda_u2d2).context.getPackageManager().getPackageInfo("android", PackageManager.PackageInfoFlags.of((long)0L)) : ((AndroidPlatform)$this$getOSInstallationTime_u24lambda_u2d2).context.getPackageManager().getPackageInfo("android", 0);
            $this$getOSInstallationTime_u24lambda_u2d2 = Result.constructor-impl((Object)packageInfo.firstInstallTime);
        }
        catch (Throwable bl) {
            $this$getOSInstallationTime_u24lambda_u2d2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$getOSInstallationTime_u24lambda_u2d2;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable e2 = throwable;
            boolean bl = false;
            if (e2 instanceof PackageManager.NameNotFoundException) {
                Logger.Companion.e(TAG, "Error getting OS installation time: " + ((PackageManager.NameNotFoundException)e2).getLocalizedMessage());
            }
            object = -1L;
        }
        return ((Number)object).longValue();
    }

    @Override
    public long getSDKInstallationTime() {
        long l;
        ServiceLocator.Companion companion = ServiceLocator.Companion;
        Context context$iv = this.context;
        boolean $i$f$inject = false;
        Lazy filePreferences$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<FilePreferences>(context$iv){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final FilePreferences invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(FilePreferences.class);
            }
        }));
        Long this_$iv = this.sdkInstallationTime;
        if (this_$iv != null) {
            long it = ((Number)this_$iv).longValue();
            boolean bl = false;
            return it;
        }
        long storedTime = AndroidPlatform.getSDKInstallationTime$lambda-4((Lazy<FilePreferences>)filePreferences$delegate).getLong(PREF_KEY_SDK_INSTALL_TIME, 0L);
        if (storedTime != 0L) {
            l = storedTime;
        } else {
            long now = System.currentTimeMillis();
            AndroidPlatform.getSDKInstallationTime$lambda-4((Lazy<FilePreferences>)filePreferences$delegate).put(PREF_KEY_SDK_INSTALL_TIME, now).apply();
            l = now;
        }
        long result = l;
        this.sdkInstallationTime = result;
        return result;
    }

    @Override
    public long getLastBootTime() {
        return System.currentTimeMillis() - SystemClock.elapsedRealtime();
    }

    @Override
    public long getBuildTime() {
        return Build.TIME;
    }

    @Override
    public boolean isProblematicMaliDevice() {
        String string = Build.HARDWARE;
        boolean isMali = string != null ? StringsKt.contains((CharSequence)string, (CharSequence)"mali", (boolean)true) : false;
        int n = Build.VERSION.SDK_INT;
        boolean isAffectedApi = 29 <= n ? n < 34 : false;
        return isMali && isAffectedApi;
    }

    @Override
    @Nullable
    public String getGPVersion() {
        String string = this.gpVersion;
        if (string != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        try {
            String string2;
            PackageInfo packageInfo = Build.VERSION.SDK_INT >= 33 ? this.context.getPackageManager().getPackageInfo("com.android.vending", PackageManager.PackageInfoFlags.of((long)0L)) : this.context.getPackageManager().getPackageInfo("com.android.vending", 0);
            String it = string2 = packageInfo.versionName;
            boolean bl = false;
            this.gpVersion = it;
            string = string2;
        }
        catch (PackageManager.NameNotFoundException _) {
            string = null;
        }
        return string;
    }

    private final void updateAppSetID() {
        CharSequence charSequence = this.appSetId;
        if (!(charSequence == null || charSequence.length() == 0)) {
            return;
        }
        try {
            AppSetIdClient appSetIdClient = AppSet.getClient((Context)this.context);
            Intrinsics.checkNotNullExpressionValue((Object)appSetIdClient, (String)"getClient(context)");
            AppSetIdClient client = appSetIdClient;
            Task task = client.getAppSetIdInfo();
            Intrinsics.checkNotNullExpressionValue((Object)task, (String)"client.appSetIdInfo");
            Task task2 = task;
            task2.addOnSuccessListener(arg_0 -> AndroidPlatform.updateAppSetID$lambda-8(this, arg_0));
        }
        catch (NoClassDefFoundError ex) {
            Logger.Companion.e(TAG, "Required libs to get AppSetID Not available: " + ex.getLocalizedMessage());
        }
        catch (Exception ex) {
            Logger.Companion.e(TAG, "Error getting AppSetID: " + ex.getLocalizedMessage());
        }
    }

    @Override
    @Nullable
    public String getUserAgent() {
        String string = this.userAgent;
        if (string == null) {
            string = System.getProperty("http.agent");
        }
        return string;
    }

    public void setUserAgent(@Nullable String string) {
        this.userAgent = string;
    }

    @Override
    public boolean isSilentModeEnabled() {
        boolean bl;
        try {
            bl = this.audioManager.getRingerMode() == 0 || this.audioManager.getRingerMode() == 1;
        }
        catch (Exception _) {
            bl = false;
        }
        return bl;
    }

    private static final void getUserAgentLazy$lambda-0(AndroidPlatform this$0, Consumer $consumer) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$consumer, (String)"$consumer");
        WebViewUtil.INSTANCE.getUserAgent(this$0.context, (Consumer<String>)$consumer);
    }

    private static final FilePreferences getSDKInstallationTime$lambda-4(Lazy<FilePreferences> $filePreferences$delegate) {
        Lazy<FilePreferences> lazy = $filePreferences$delegate;
        return (FilePreferences)lazy.getValue();
    }

    private static final void updateAppSetID$lambda-8(AndroidPlatform this$0, AppSetIdInfo info) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (info != null) {
            this$0.appSetId = info.getId();
            this$0.appSetIdScope = info.getScope();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0006\u001a\n \u0007*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/vungle/ads/internal/platform/AndroidPlatform$Companion;", "", "()V", "PREF_KEY_SDK_INSTALL_TIME", "", "TAG", "getCarrierName", "kotlin.jvm.PlatformType", "context", "Landroid/content/Context;", "getCarrierName$vungle_ads_release", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        public final String getCarrierName$vungle_ads_release(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Object object = context.getSystemService("phone");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.telephony.TelephonyManager");
            return ((TelephonyManager)object).getNetworkOperatorName();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

