/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal;

import android.content.Context;
import com.vungle.ads.VungleAdSize;
import com.vungle.ads.VungleError;
import com.vungle.ads.internal.AdInternal;
import com.vungle.ads.internal.model.AdPayload;
import com.vungle.ads.internal.model.Placement;
import com.vungle.ads.internal.presenter.AdPlayCallback;
import com.vungle.ads.internal.presenter.AdPlayCallbackWrapper;
import com.vungle.ads.internal.util.ViewUtility;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0010\u00a2\u0006\u0002\b\u0010J\b\u0010\u0011\u001a\u00020\u0005H\u0016J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0015\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lcom/vungle/ads/internal/BannerAdInternal;", "Lcom/vungle/ads/internal/AdInternal;", "context", "Landroid/content/Context;", "adSize", "Lcom/vungle/ads/VungleAdSize;", "(Landroid/content/Context;Lcom/vungle/ads/VungleAdSize;)V", "updatedAdSize", "getUpdatedAdSize$vungle_ads_release", "()Lcom/vungle/ads/VungleAdSize;", "setUpdatedAdSize$vungle_ads_release", "(Lcom/vungle/ads/VungleAdSize;)V", "adLoadedAndUpdateConfigure", "", "advertisement", "Lcom/vungle/ads/internal/model/AdPayload;", "adLoadedAndUpdateConfigure$vungle_ads_release", "getAdSizeForAdRequest", "isValidAdSize", "", "isValidAdTypeForPlacement", "placement", "Lcom/vungle/ads/internal/model/Placement;", "wrapCallback", "Lcom/vungle/ads/internal/presenter/AdPlayCallbackWrapper;", "adPlayCallback", "Lcom/vungle/ads/internal/presenter/AdPlayCallback;", "wrapCallback$vungle_ads_release", "vungle-ads_release"})
public final class BannerAdInternal
extends AdInternal {
    @NotNull
    private final VungleAdSize adSize;
    @Nullable
    private VungleAdSize updatedAdSize;

    public BannerAdInternal(@NotNull Context context, @NotNull VungleAdSize adSize) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)adSize, (String)"adSize");
        super(context);
        this.adSize = adSize;
    }

    @Nullable
    public final VungleAdSize getUpdatedAdSize$vungle_ads_release() {
        return this.updatedAdSize;
    }

    public final void setUpdatedAdSize$vungle_ads_release(@Nullable VungleAdSize vungleAdSize) {
        this.updatedAdSize = vungleAdSize;
    }

    @NotNull
    public final AdPlayCallbackWrapper wrapCallback$vungle_ads_release(@NotNull AdPlayCallback adPlayCallback2) {
        Intrinsics.checkNotNullParameter((Object)adPlayCallback2, (String)"adPlayCallback");
        return new AdPlayCallbackWrapper(adPlayCallback2, this){
            final /* synthetic */ BannerAdInternal this$0;
            {
                this.this$0 = $receiver;
                super($adPlayCallback);
            }

            public void onAdStart(@Nullable String id) {
                this.this$0.setAdState(AdInternal.AdState.PLAYING);
                super.onAdStart(id);
            }

            public void onAdEnd(@Nullable String id) {
                this.this$0.setAdState(AdInternal.AdState.FINISHED);
                super.onAdEnd(id);
            }

            public void onFailure(@NotNull VungleError error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                this.this$0.setAdState(AdInternal.AdState.ERROR);
                super.onFailure(error);
            }
        };
    }

    @Override
    public boolean isValidAdTypeForPlacement(@NotNull Placement placement) {
        Intrinsics.checkNotNullParameter((Object)placement, (String)"placement");
        return placement.isBanner() || placement.isMREC() || placement.isInline();
    }

    @Override
    public boolean isValidAdSize(@Nullable VungleAdSize adSize) {
        VungleAdSize vungleAdSize = adSize;
        boolean validSize = vungleAdSize != null ? vungleAdSize.isValidSize$vungle_ads_release() : false;
        return validSize;
    }

    @Override
    @NotNull
    public VungleAdSize getAdSizeForAdRequest() {
        return this.adSize;
    }

    @Override
    public void adLoadedAndUpdateConfigure$vungle_ads_release(@NotNull AdPayload advertisement) {
        Intrinsics.checkNotNullParameter((Object)advertisement, (String)"advertisement");
        super.adLoadedAndUpdateConfigure$vungle_ads_release(advertisement);
        if (this.adSize.isAdaptiveWidth$vungle_ads_release() || this.adSize.isAdaptiveHeight$vungle_ads_release()) {
            Pair<Integer, Integer> pair = ViewUtility.INSTANCE.getDeviceWidthAndHeightWithOrientation(this.getContext(), 0);
            int deviceWidth = ((Number)pair.component1()).intValue();
            int deviceHeight = ((Number)pair.component2()).intValue();
            int w = this.adSize.isAdaptiveWidth$vungle_ads_release() ? advertisement.adWidth() : this.adSize.getWidth();
            int h2 = this.adSize.isAdaptiveHeight$vungle_ads_release() ? advertisement.adHeight() : this.adSize.getHeight();
            int adWidth = Math.min(deviceWidth, w);
            int adHeight = Math.min(deviceHeight, h2);
            if (this.adSize.isAdaptiveHeight$vungle_ads_release() && this.adSize.getHeight() > 0) {
                adHeight = Math.min(this.adSize.getHeight(), adHeight);
            }
            this.updatedAdSize = new VungleAdSize(adWidth, adHeight);
        }
    }
}

