/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.presenter;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.ContextThemeWrapper;
import android.view.View;
import androidx.annotation.VisibleForTesting;
import com.vungle.ads.AnalyticsClient;
import com.vungle.ads.LinkError;
import com.vungle.ads.PrivacyUrlError;
import com.vungle.ads.ServiceLocator;
import com.vungle.ads.SingleValueMetric;
import com.vungle.ads.TpatError;
import com.vungle.ads.internal.ConfigManager;
import com.vungle.ads.internal.executor.Executors;
import com.vungle.ads.internal.model.AdPayload;
import com.vungle.ads.internal.network.TpatSender;
import com.vungle.ads.internal.network.VungleApiClient;
import com.vungle.ads.internal.omsdk.NativeOMTracker;
import com.vungle.ads.internal.platform.Platform;
import com.vungle.ads.internal.presenter.AdEventListener;
import com.vungle.ads.internal.presenter.NativePresenterDelegate;
import com.vungle.ads.internal.privacy.PrivacyConsent;
import com.vungle.ads.internal.privacy.PrivacyManager;
import com.vungle.ads.internal.protos.Sdk;
import com.vungle.ads.internal.signals.SignalManager;
import com.vungle.ads.internal.ui.PresenterAdOpenCallback;
import com.vungle.ads.internal.util.ExternalRouter;
import com.vungle.ads.internal.util.FileUtility;
import com.vungle.ads.internal.util.LogEntry;
import com.vungle.ads.internal.util.Logger;
import com.vungle.ads.internal.util.PathProvider;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 J2\u00020\u0001:\u0001JB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u00102\u001a\u000203J\u000e\u00104\u001a\u0002032\u0006\u00105\u001a\u000206J\b\u00107\u001a\u00020\u0011H\u0002J\u0012\u00108\u001a\u0002032\b\u00109\u001a\u0004\u0018\u000106H\u0002J\u0006\u0010:\u001a\u000203J\u0012\u0010;\u001a\u0002032\b\u0010<\u001a\u0004\u0018\u000106H\u0002J\u0006\u0010=\u001a\u000203J\u001a\u0010>\u001a\u0002032\u0006\u0010?\u001a\u0002062\n\b\u0002\u0010@\u001a\u0004\u0018\u000106J\u0010\u0010A\u001a\u0002032\b\u0010B\u001a\u0004\u0018\u00010\u0013J\b\u0010C\u001a\u000203H\u0002J\b\u0010D\u001a\u000203H\u0002J\u000e\u0010E\u001a\u0002032\u0006\u0010F\u001a\u00020GJ\u0010\u0010H\u001a\u0002032\u0006\u0010I\u001a\u000206H\u0002R\u0012\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R\u001d\u0010\u001c\u001a\u0004\u0018\u00010\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u001b\u001a\u0004\b\u001e\u0010\u001fR\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010#\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\u001b\u001a\u0004\b%\u0010&R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010(\u001a\u00020)8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010\u001b\u001a\u0004\b*\u0010+R\u001b\u0010-\u001a\u00020.8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u0010\u001b\u001a\u0004\b/\u00100\u00a8\u0006K"}, d2={"Lcom/vungle/ads/internal/presenter/NativeAdPresenter;", "", "context", "Landroid/content/Context;", "delegate", "Lcom/vungle/ads/internal/presenter/NativePresenterDelegate;", "advertisement", "Lcom/vungle/ads/internal/model/AdPayload;", "executor", "Ljava/util/concurrent/Executor;", "platform", "Lcom/vungle/ads/internal/platform/Platform;", "(Landroid/content/Context;Lcom/vungle/ads/internal/presenter/NativePresenterDelegate;Lcom/vungle/ads/internal/model/AdPayload;Ljava/util/concurrent/Executor;Lcom/vungle/ads/internal/platform/Platform;)V", "adStartTime", "", "Ljava/lang/Long;", "adViewed", "", "bus", "Lcom/vungle/ads/internal/presenter/AdEventListener;", "currentDialog", "Landroid/app/Dialog;", "executors", "Lcom/vungle/ads/internal/executor/Executors;", "getExecutors", "()Lcom/vungle/ads/internal/executor/Executors;", "executors$delegate", "Lkotlin/Lazy;", "logEntry", "Lcom/vungle/ads/internal/util/LogEntry;", "getLogEntry", "()Lcom/vungle/ads/internal/util/LogEntry;", "logEntry$delegate", "omTracker", "Lcom/vungle/ads/internal/omsdk/NativeOMTracker;", "pathProvider", "Lcom/vungle/ads/internal/util/PathProvider;", "getPathProvider", "()Lcom/vungle/ads/internal/util/PathProvider;", "pathProvider$delegate", "signalManager", "Lcom/vungle/ads/internal/signals/SignalManager;", "getSignalManager", "()Lcom/vungle/ads/internal/signals/SignalManager;", "signalManager$delegate", "vungleApiClient", "Lcom/vungle/ads/internal/network/VungleApiClient;", "getVungleApiClient", "()Lcom/vungle/ads/internal/network/VungleApiClient;", "vungleApiClient$delegate", "detach", "", "initOMTracker", "omSdkData", "", "needShowGdpr", "onDownload", "ctaUrl", "onImpression", "onPrivacy", "privacyUrl", "prepare", "processCommand", "action", "value", "setEventListener", "listener", "showGdpr", "start", "startTracking", "rootView", "Landroid/view/View;", "triggerEventMetricForTpat", "key", "Companion", "vungle-ads_release"})
public final class NativeAdPresenter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final NativePresenterDelegate delegate;
    @Nullable
    private final AdPayload advertisement;
    @NotNull
    private Executor executor;
    @NotNull
    private final Platform platform;
    @Nullable
    private Long adStartTime;
    @Nullable
    private AdEventListener bus;
    @NotNull
    private final Lazy vungleApiClient$delegate;
    @NotNull
    private final Lazy executors$delegate;
    @NotNull
    private final Lazy pathProvider$delegate;
    @NotNull
    private final Lazy signalManager$delegate;
    @Nullable
    private Dialog currentDialog;
    @NotNull
    private final Lazy logEntry$delegate;
    private boolean adViewed;
    @Nullable
    private NativeOMTracker omTracker;
    @NotNull
    private static final String TAG = "NativeAdPresenter";
    @NotNull
    public static final String VIDEO_VIEWED = "videoViewed";
    @NotNull
    public static final String TPAT = "tpat";
    @NotNull
    public static final String OPEN_PRIVACY = "openPrivacy";
    @NotNull
    public static final String DOWNLOAD = "download";
    @NotNull
    private static final Map<String, Sdk.SDKMetric.SDKMetricType> eventMap;

    public NativeAdPresenter(@NotNull Context context, @NotNull NativePresenterDelegate delegate, @Nullable AdPayload advertisement, @NotNull Executor executor, @NotNull Platform platform) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        this.context = context;
        this.delegate = delegate;
        this.advertisement = advertisement;
        this.executor = executor;
        this.platform = platform;
        ServiceLocator.Companion companion = ServiceLocator.Companion;
        Context context$iv = this.context;
        boolean $i$f$inject = false;
        this.vungleApiClient$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<VungleApiClient>(context$iv){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final VungleApiClient invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(VungleApiClient.class);
            }
        }));
        ServiceLocator.Companion this_$iv = ServiceLocator.Companion;
        context$iv = this.context;
        $i$f$inject = false;
        this.executors$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<Executors>(context$iv){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final Executors invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(Executors.class);
            }
        }));
        this_$iv = ServiceLocator.Companion;
        context$iv = this.context;
        $i$f$inject = false;
        this.pathProvider$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<PathProvider>(context$iv){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final PathProvider invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(PathProvider.class);
            }
        }));
        this_$iv = ServiceLocator.Companion;
        context$iv = this.context;
        $i$f$inject = false;
        this.signalManager$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<SignalManager>(context$iv){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final SignalManager invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(SignalManager.class);
            }
        }));
        this.logEntry$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LogEntry>(this){
            final /* synthetic */ NativeAdPresenter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final LogEntry invoke() {
                AdPayload adPayload = NativeAdPresenter.access$getAdvertisement$p(this.this$0);
                return adPayload != null ? adPayload.getLogEntry$vungle_ads_release() : null;
            }
        }));
    }

    private final VungleApiClient getVungleApiClient() {
        Lazy lazy = this.vungleApiClient$delegate;
        return (VungleApiClient)lazy.getValue();
    }

    private final Executors getExecutors() {
        Lazy lazy = this.executors$delegate;
        return (Executors)lazy.getValue();
    }

    private final PathProvider getPathProvider() {
        Lazy lazy = this.pathProvider$delegate;
        return (PathProvider)lazy.getValue();
    }

    private final SignalManager getSignalManager() {
        Lazy lazy = this.signalManager$delegate;
        return (SignalManager)lazy.getValue();
    }

    private final LogEntry getLogEntry() {
        Lazy lazy = this.logEntry$delegate;
        return (LogEntry)lazy.getValue();
    }

    public final void setEventListener(@Nullable AdEventListener listener) {
        this.bus = listener;
    }

    public final void processCommand(@NotNull String action, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        switch (action) {
            case "videoViewed": {
                if (this.bus == null || this.adViewed) {
                    return;
                }
                this.adViewed = true;
                AdEventListener adEventListener2 = this.bus;
                if (adEventListener2 != null) {
                    adEventListener2.onNext("adViewed", null, this.delegate.getPlacementRefId());
                }
                TpatSender tpatSender = new TpatSender(this.getVungleApiClient(), this.getLogEntry(), this.getExecutors().getIoExecutor(), this.getPathProvider(), this.getSignalManager());
                List<String> list = this.delegate.getImpressionUrls();
                if (list != null) {
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String url = (String)element$iv;
                        boolean bl = false;
                        tpatSender.sendTpat(url, this.executor);
                    }
                }
                return;
            }
            case "tpat": {
                List<String> list;
                CharSequence tpatSender = value;
                if (tpatSender == null || tpatSender.length() == 0) {
                    new TpatError(Sdk.SDKError.Reason.EMPTY_TPAT_ERROR, "Empty tpat key").setLogEntry$vungle_ads_release(this.getLogEntry()).logErrorNoReturnValue$vungle_ads_release();
                    return;
                }
                this.triggerEventMetricForTpat(value);
                if (Intrinsics.areEqual((Object)value, (Object)"checkpoint.0")) {
                    AdPayload adPayload = this.advertisement;
                    list = adPayload != null ? adPayload.getTpatUrls(value, this.platform.getCarrierName(), String.valueOf(this.platform.getVolumeLevel())) : null;
                } else {
                    AdPayload adPayload = this.advertisement;
                    list = adPayload != null ? AdPayload.getTpatUrls$default(adPayload, value, null, null, 6, null) : null;
                }
                List<String> urls = list;
                Collection collection = urls;
                if (collection == null || collection.isEmpty()) {
                    new TpatError(Sdk.SDKError.Reason.INVALID_TPAT_KEY, "Empty urls for tpat: " + value).setLogEntry$vungle_ads_release(this.getLogEntry()).logErrorNoReturnValue$vungle_ads_release();
                } else {
                    TpatSender tpatSender2 = new TpatSender(this.getVungleApiClient(), this.getLogEntry(), this.getExecutors().getIoExecutor(), this.getPathProvider(), this.getSignalManager());
                    Iterable $this$forEach$iv = urls;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String url = (String)element$iv;
                        boolean bl = false;
                        tpatSender2.sendTpat(url, this.executor);
                    }
                }
                return;
            }
            case "openPrivacy": {
                this.onPrivacy(value);
                return;
            }
            case "download": {
                this.onDownload(value);
                return;
            }
        }
        Logger.Companion.w(TAG, "Unknown native ad action: " + action);
    }

    public static /* synthetic */ void processCommand$default(NativeAdPresenter nativeAdPresenter, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        nativeAdPresenter.processCommand(string, string2);
    }

    private final void onDownload(String ctaUrl) {
        block6: {
            Object object;
            AdPayload adPayload = this.advertisement;
            List urls = adPayload != null ? AdPayload.getTpatUrls$default(adPayload, "clickUrl", null, null, 6, null) : null;
            TpatSender tpatSender = new TpatSender(this.getVungleApiClient(), this.getLogEntry(), this.getExecutors().getIoExecutor(), this.getPathProvider(), this.getSignalManager());
            Collection collection = urls;
            if (collection == null || collection.isEmpty()) {
                new TpatError(Sdk.SDKError.Reason.EMPTY_TPAT_ERROR, "Empty tpat key: clickUrl").setLogEntry$vungle_ads_release(this.getLogEntry()).logErrorNoReturnValue$vungle_ads_release();
            } else {
                Iterable $this$forEach$iv = urls;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String url = (String)element$iv;
                    boolean bl = false;
                    tpatSender.sendTpat(url, this.executor);
                }
            }
            String string = ctaUrl;
            if (string != null) {
                String it = string;
                boolean bl = false;
                tpatSender.sendTpat(it, this.executor);
            }
            String deeplinkUrl = (object = this.advertisement) != null && (object = ((AdPayload)object).adUnit()) != null ? ((AdPayload.AdUnit)object).getDeeplinkUrl() : null;
            boolean launched2 = ExternalRouter.launch(deeplinkUrl, ctaUrl, this.context, this.getLogEntry(), new PresenterAdOpenCallback(deeplinkUrl, this, tpatSender){
                final /* synthetic */ String $deeplinkUrl;
                final /* synthetic */ NativeAdPresenter this$0;
                final /* synthetic */ TpatSender $tpatSender;
                {
                    this.$deeplinkUrl = $deeplinkUrl;
                    this.this$0 = $receiver;
                    this.$tpatSender = $tpatSender;
                }

                /*
                 * WARNING - void declaration
                 */
                public void onDeeplinkClick(boolean opened) {
                    block2: {
                        void $this$forEach$iv;
                        List deeplinkClickTpatUrls;
                        if (!opened) {
                            new LinkError(Sdk.SDKError.Reason.DEEPLINK_OPEN_FAILED, "Fail to open " + this.$deeplinkUrl).setLogEntry$vungle_ads_release(NativeAdPresenter.access$getLogEntry(this.this$0)).logErrorNoReturnValue$vungle_ads_release();
                        }
                        AdPayload adPayload = NativeAdPresenter.access$getAdvertisement$p(this.this$0);
                        List list = deeplinkClickTpatUrls = adPayload != null ? AdPayload.getTpatUrls$default(adPayload, "deeplink.click", String.valueOf(opened), null, 4, null) : null;
                        if (list == null) break block2;
                        Iterable iterable = list;
                        TpatSender tpatSender = this.$tpatSender;
                        NativeAdPresenter nativeAdPresenter = this.this$0;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            String url = (String)element$iv;
                            boolean bl = false;
                            tpatSender.sendTpat(url, NativeAdPresenter.access$getExecutor$p(nativeAdPresenter));
                        }
                    }
                }
            });
            AdEventListener adEventListener2 = this.bus;
            if (adEventListener2 != null) {
                adEventListener2.onNext("open", "adClick", this.delegate.getPlacementRefId());
            }
            if (!launched2) break block6;
            AdEventListener adEventListener3 = this.bus;
            if (adEventListener3 != null) {
                adEventListener3.onNext("open", "adLeftApplication", this.delegate.getPlacementRefId());
            }
        }
    }

    private final void onPrivacy(String privacyUrl) {
        block1: {
            String it;
            block2: {
                String string = privacyUrl;
                if (string == null) break block1;
                it = string;
                boolean bl = false;
                if (!FileUtility.INSTANCE.isValidUrl(privacyUrl)) {
                    new PrivacyUrlError(it).setLogEntry$vungle_ads_release(this.getLogEntry()).logErrorNoReturnValue$vungle_ads_release();
                    return;
                }
                boolean launched2 = ExternalRouter.launch$default(null, it, this.context, this.getLogEntry(), null, 16, null);
                if (!launched2) break block2;
                AdEventListener adEventListener2 = this.bus;
                if (adEventListener2 == null) break block1;
                adEventListener2.onNext("open", "adLeftApplication", this.delegate.getPlacementRefId());
                break block1;
            }
            new PrivacyUrlError(it).setLogEntry$vungle_ads_release(this.getLogEntry()).logErrorNoReturnValue$vungle_ads_release();
        }
    }

    public final void prepare() {
        this.start();
        AdEventListener adEventListener2 = this.bus;
        if (adEventListener2 != null) {
            adEventListener2.onNext("start", null, this.delegate.getPlacementRefId());
        }
        this.adStartTime = System.currentTimeMillis();
    }

    private final void start() {
        if (this.needShowGdpr()) {
            this.showGdpr();
        }
    }

    public final void detach() {
        block5: {
            NativeOMTracker nativeOMTracker = this.omTracker;
            if (nativeOMTracker != null) {
                nativeOMTracker.stop();
            }
            Dialog dialog = this.currentDialog;
            if (dialog != null) {
                Dialog $this$detach_u24lambda_u2d5 = dialog;
                boolean bl = false;
                if ($this$detach_u24lambda_u2d5.isShowing()) {
                    $this$detach_u24lambda_u2d5.dismiss();
                }
            }
            Long l = this.adStartTime;
            if (l != null) {
                List<String> list;
                Long l2 = l;
                long it = ((Number)l2).longValue();
                boolean bl = false;
                long duration = System.currentTimeMillis() - it;
                TpatSender tpatSender = new TpatSender(this.getVungleApiClient(), this.getLogEntry(), this.getExecutors().getIoExecutor(), this.getPathProvider(), this.getSignalManager());
                AdPayload adPayload = this.advertisement;
                if (adPayload != null && (list = adPayload.getTpatUrls("ad.close", String.valueOf(duration), String.valueOf(this.platform.getVolumeLevel()))) != null) {
                    List<String> it2 = list;
                    boolean bl2 = false;
                    tpatSender.sendTpats((Iterable<String>)it2, this.executor);
                }
            }
            AdEventListener adEventListener2 = this.bus;
            if (adEventListener2 == null) break block5;
            adEventListener2.onNext("end", null, this.delegate.getPlacementRefId());
        }
    }

    private final boolean needShowGdpr() {
        return ConfigManager.INSTANCE.getGDPRIsCountryDataProtected() && Intrinsics.areEqual((Object)"unknown", (Object)PrivacyManager.INSTANCE.getConsentStatus());
    }

    private final void showGdpr() {
        PrivacyManager.INSTANCE.updateGdprConsent("opted_out_by_timeout", "vungle_modal", null);
        if (!(this.context instanceof Activity)) {
            Logger.Companion.w(TAG, "We can not show GDPR dialog with application context.");
            return;
        }
        DialogInterface.OnClickListener listener = (arg_0, arg_1) -> NativeAdPresenter.showGdpr$lambda-8(this, arg_0, arg_1);
        String dialogTitle = ConfigManager.INSTANCE.getGDPRConsentTitle();
        String dialogBody = ConfigManager.INSTANCE.getGDPRConsentMessage();
        String dialogContinue = ConfigManager.INSTANCE.getGDPRButtonAccept();
        String dialogClose = ConfigManager.INSTANCE.getGDPRButtonDeny();
        AlertDialog.Builder dialogBuilder = new AlertDialog.Builder((Context)new ContextThemeWrapper(this.context, ((Activity)this.context).getApplicationInfo().theme));
        CharSequence charSequence = dialogTitle;
        if (!(charSequence == null || charSequence.length() == 0)) {
            dialogBuilder.setTitle((CharSequence)dialogTitle);
        }
        if (!((charSequence = (CharSequence)dialogBody) == null || charSequence.length() == 0)) {
            dialogBuilder.setMessage((CharSequence)dialogBody);
        }
        dialogBuilder.setPositiveButton((CharSequence)dialogContinue, listener);
        dialogBuilder.setNegativeButton((CharSequence)dialogClose, listener);
        dialogBuilder.setCancelable(false);
        AlertDialog dialog = dialogBuilder.create();
        dialog.setOnDismissListener(arg_0 -> NativeAdPresenter.showGdpr$lambda-9(this, arg_0));
        this.currentDialog = (Dialog)dialog;
        dialog.show();
    }

    public final void initOMTracker(@NotNull String omSdkData) {
        Intrinsics.checkNotNullParameter((Object)omSdkData, (String)"omSdkData");
        AdPayload adPayload = this.advertisement;
        boolean adOmEnabled = adPayload != null ? adPayload.omEnabled() : false;
        if (((CharSequence)omSdkData).length() > 0 && ConfigManager.INSTANCE.omEnabled() && adOmEnabled) {
            this.omTracker = new NativeOMTracker(omSdkData);
        }
    }

    public final void startTracking(@NotNull View rootView) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
            NativeOMTracker nativeOMTracker = this.omTracker;
            if (nativeOMTracker == null) break block0;
            nativeOMTracker.start(rootView);
        }
    }

    public final void onImpression() {
        block0: {
            NativeOMTracker nativeOMTracker = this.omTracker;
            if (nativeOMTracker == null) break block0;
            nativeOMTracker.impressionOccurred();
        }
    }

    private final void triggerEventMetricForTpat(String key) {
        Sdk.SDKMetric.SDKMetricType event = eventMap.get(key);
        if (event != null) {
            AnalyticsClient.logMetric$vungle_ads_release$default(AnalyticsClient.INSTANCE, new SingleValueMetric(event), this.getLogEntry(), null, 4, null);
        }
    }

    private static final void showGdpr$lambda-8(NativeAdPresenter this$0, DialogInterface dialogInterface, int which) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String consented = "opted_out_by_timeout";
        switch (which) {
            case -2: {
                consented = PrivacyConsent.OPT_OUT.getValue();
                break;
            }
            case -1: {
                consented = PrivacyConsent.OPT_IN.getValue();
            }
        }
        PrivacyManager.INSTANCE.updateGdprConsent(consented, "vungle_modal", null);
        this$0.start();
    }

    private static final void showGdpr$lambda-9(NativeAdPresenter this$0, DialogInterface it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.currentDialog = null;
    }

    public static final /* synthetic */ LogEntry access$getLogEntry(NativeAdPresenter $this) {
        return $this.getLogEntry();
    }

    public static final /* synthetic */ AdPayload access$getAdvertisement$p(NativeAdPresenter $this) {
        return $this.advertisement;
    }

    public static final /* synthetic */ Executor access$getExecutor$p(NativeAdPresenter $this) {
        return $this.executor;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"checkpoint.0", (Object)((Object)Sdk.SDKMetric.SDKMetricType.AD_START_EVENT)), TuplesKt.to((Object)"clickUrl", (Object)((Object)Sdk.SDKMetric.SDKMetricType.AD_CLICK_EVENT))};
        eventMap = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R(\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\n8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/vungle/ads/internal/presenter/NativeAdPresenter$Companion;", "", "()V", "DOWNLOAD", "", "OPEN_PRIVACY", "TAG", "TPAT", "VIDEO_VIEWED", "eventMap", "", "Lcom/vungle/ads/internal/protos/Sdk$SDKMetric$SDKMetricType;", "getEventMap$vungle_ads_release$annotations", "getEventMap$vungle_ads_release", "()Ljava/util/Map;", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, Sdk.SDKMetric.SDKMetricType> getEventMap$vungle_ads_release() {
            return eventMap;
        }

        @VisibleForTesting
        public static /* synthetic */ void getEventMap$vungle_ads_release$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

