/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.platform;

import android.content.Context;
import android.os.Build;
import android.util.AndroidRuntimeException;
import android.webkit.WebSettings;
import androidx.core.util.Consumer;
import com.vungle.ads.internal.util.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/vungle/ads/internal/platform/WebViewUtil;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getUserAgent", "", "consumer", "Landroidx/core/util/Consumer;", "", "Companion", "vungle-ads_release"})
public final class WebViewUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    private static final String TAG = WebViewUtil.class.getSimpleName();

    public WebViewUtil(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    public final void getUserAgent(@NotNull Consumer<String> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        if (Build.VERSION.SDK_INT >= 17) {
            try {
                String userAgent = WebSettings.getDefaultUserAgent((Context)this.context);
                consumer.accept((Object)userAgent);
            }
            catch (Exception e2) {
                if (e2 instanceof AndroidRuntimeException) {
                    String string = TAG;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                    Logger.Companion.e(string, "WebView could be missing here");
                }
                consumer.accept(null);
            }
            return;
        }
        consumer.accept(null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/vungle/ads/internal/platform/WebViewUtil$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

