/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.network;

import androidx.annotation.VisibleForTesting;
import com.vungle.ads.TpatError;
import com.vungle.ads.internal.model.ErrorInfo;
import com.vungle.ads.internal.network.GenericTpatRequest;
import com.vungle.ads.internal.network.HttpMethod;
import com.vungle.ads.internal.network.VungleApiClient;
import com.vungle.ads.internal.persistence.FilePreferences;
import com.vungle.ads.internal.protos.Sdk;
import com.vungle.ads.internal.signals.SignalManager;
import com.vungle.ads.internal.util.LogEntry;
import com.vungle.ads.internal.util.Logger;
import com.vungle.ads.internal.util.PathProvider;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.text.Regex;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0004\u0018\u0000 32\u00020\u0001:\u00013B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0014\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017H\u0002J\u0014\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001b0\u0017H\u0002J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0018H\u0007J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0018H\u0002J\u0015\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b%J\u001c\u0010&\u001a\u00020\u001f2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017H\u0002J\u001c\u0010(\u001a\u00020\u001f2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001b0\u0017H\u0002J&\u0010)\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020,2\u0006\u0010$\u001a\u00020\u0007J\u0016\u0010-\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u0007J\u001c\u0010.\u001a\u00020\u001f2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u0018002\u0006\u0010$\u001a\u00020\u0007J\u0016\u00101\u001a\u00020\u001f2\u0006\u00102\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u0007R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00064"}, d2={"Lcom/vungle/ads/internal/network/TpatSender;", "", "vungleApiClient", "Lcom/vungle/ads/internal/network/VungleApiClient;", "logEntry", "Lcom/vungle/ads/internal/util/LogEntry;", "ioExecutor", "Ljava/util/concurrent/Executor;", "pathProvider", "Lcom/vungle/ads/internal/util/PathProvider;", "signalManager", "Lcom/vungle/ads/internal/signals/SignalManager;", "(Lcom/vungle/ads/internal/network/VungleApiClient;Lcom/vungle/ads/internal/util/LogEntry;Ljava/util/concurrent/Executor;Lcom/vungle/ads/internal/util/PathProvider;Lcom/vungle/ads/internal/signals/SignalManager;)V", "genericTpatFilePreferences", "Lcom/vungle/ads/internal/persistence/FilePreferences;", "getLogEntry", "()Lcom/vungle/ads/internal/util/LogEntry;", "getSignalManager", "()Lcom/vungle/ads/internal/signals/SignalManager;", "tpatFilePreferences", "getVungleApiClient", "()Lcom/vungle/ads/internal/network/VungleApiClient;", "getStoredGenericTpats", "", "", "Lcom/vungle/ads/internal/network/GenericTpatRequest;", "getStoredTpats", "", "injectSessionIdToUrl", "url", "logTpatError", "", "error", "Lcom/vungle/ads/internal/model/ErrorInfo;", "urlWithSessionId", "resendStoredTpats", "executor", "resendStoredTpats$vungle_ads_release", "saveStoredGenericTpats", "tpats", "saveStoredTpats", "sendGenericTpat", "request", "retry", "", "sendTpat", "sendTpats", "urls", "", "sendWinNotification", "urlString", "Companion", "vungle-ads_release"})
public final class TpatSender {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VungleApiClient vungleApiClient;
    @Nullable
    private final LogEntry logEntry;
    @Nullable
    private final SignalManager signalManager;
    @NotNull
    private final FilePreferences tpatFilePreferences;
    @NotNull
    private final FilePreferences genericTpatFilePreferences;
    @NotNull
    private static final String TAG = "TpatSender";
    @NotNull
    private static final String FAILED_TPATS = "FAILED_TPATS";
    @NotNull
    private static final String FAILED_GENERIC_TPATS = "FAILED_GENERIC_TPATS";
    private static final int MAX_RETRIES = 5;

    public TpatSender(@NotNull VungleApiClient vungleApiClient, @Nullable LogEntry logEntry2, @NotNull Executor ioExecutor, @NotNull PathProvider pathProvider, @Nullable SignalManager signalManager) {
        Intrinsics.checkNotNullParameter((Object)vungleApiClient, (String)"vungleApiClient");
        Intrinsics.checkNotNullParameter((Object)ioExecutor, (String)"ioExecutor");
        Intrinsics.checkNotNullParameter((Object)pathProvider, (String)"pathProvider");
        this.vungleApiClient = vungleApiClient;
        this.logEntry = logEntry2;
        this.signalManager = signalManager;
        this.tpatFilePreferences = FilePreferences.Companion.get(ioExecutor, pathProvider, "failedTpats");
        this.genericTpatFilePreferences = FilePreferences.Companion.get(ioExecutor, pathProvider, "failedGenericTpats");
    }

    public /* synthetic */ TpatSender(VungleApiClient vungleApiClient, LogEntry logEntry2, Executor executor, PathProvider pathProvider, SignalManager signalManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            logEntry2 = null;
        }
        if ((n & 0x10) != 0) {
            signalManager = null;
        }
        this(vungleApiClient, logEntry2, executor, pathProvider, signalManager);
    }

    @NotNull
    public final VungleApiClient getVungleApiClient() {
        return this.vungleApiClient;
    }

    @Nullable
    public final LogEntry getLogEntry() {
        return this.logEntry;
    }

    @Nullable
    public final SignalManager getSignalManager() {
        return this.signalManager;
    }

    public final void sendWinNotification(@NotNull String urlString, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        String url = this.injectSessionIdToUrl(urlString);
        executor.execute(() -> TpatSender.sendWinNotification$lambda-0(this, url));
    }

    public final void sendTpats(@NotNull Iterable<String> urls, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Iterable<String> $this$forEach$iv = urls;
        boolean $i$f$forEach = false;
        Iterator<String> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            String element$iv;
            String it = element$iv = iterator.next();
            boolean bl = false;
            this.sendTpat(it, executor);
        }
    }

    public final void sendTpat(@NotNull String url, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        String urlWithSessionId = this.injectSessionIdToUrl(url);
        executor.execute(() -> TpatSender.sendTpat$lambda-2(this, url, urlWithSessionId));
    }

    public final void sendGenericTpat(@NotNull String url, @NotNull GenericTpatRequest request, boolean retry, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        String urlWithSessionId = this.injectSessionIdToUrl(url);
        executor.execute(() -> TpatSender.sendGenericTpat$lambda-3(this, url, request, urlWithSessionId, retry));
    }

    private final Map<String, Integer> getStoredTpats() {
        Object object;
        block8: {
            block7: {
                Map map;
                Object object2;
                String storedTpats = this.tpatFilePreferences.getString(FAILED_TPATS);
                object = storedTpats;
                if (object == null) break block7;
                String it = object;
                boolean bl = false;
                Object object3 = this;
                try {
                    TpatSender $this$getStoredTpats_u24lambda_u2d6_u24lambda_u2d4 = object3;
                    boolean bl2 = false;
                    StringFormat $this$decodeFromString$iv = (StringFormat)Json.Default;
                    boolean $i$f$decodeFromString = false;
                    SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
                    boolean $i$f$serializer = false;
                    KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.mutableCollectionType((KType)Reflection.typeOf(Map.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(String.class)), (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE)))));
                    boolean $i$f$cast = false;
                    Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
                    object2 = Result.constructor-impl((Object)((Map)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, it)));
                }
                catch (Throwable bl2) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
                }
                object3 = object2;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
                if (throwable != null) {
                    Object it2 = object2 = throwable;
                    boolean bl3 = false;
                    Logger.Companion.e(TAG, "Failed to decode stored tpats: " + it2);
                }
                if ((map = (Map)(Result.isFailure-impl((Object)object3) ? null : object3)) == null) {
                    map = new LinkedHashMap();
                }
                object = map;
                if (map != null) break block8;
            }
            object = new LinkedHashMap();
        }
        return object;
    }

    private final Map<String, GenericTpatRequest> getStoredGenericTpats() {
        Object object;
        block8: {
            block7: {
                Map map;
                Object object2;
                String storedTpats = this.genericTpatFilePreferences.getString(FAILED_GENERIC_TPATS);
                object = storedTpats;
                if (object == null) break block7;
                String it = object;
                boolean bl = false;
                Object object3 = this;
                try {
                    TpatSender $this$getStoredGenericTpats_u24lambda_u2d9_u24lambda_u2d7 = object3;
                    boolean bl2 = false;
                    StringFormat $this$decodeFromString$iv = (StringFormat)Json.Default;
                    boolean $i$f$decodeFromString = false;
                    SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
                    boolean $i$f$serializer = false;
                    KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.mutableCollectionType((KType)Reflection.typeOf(Map.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(String.class)), (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(GenericTpatRequest.class)))));
                    boolean $i$f$cast = false;
                    Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
                    object2 = Result.constructor-impl((Object)((Map)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, it)));
                }
                catch (Throwable bl2) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
                }
                object3 = object2;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
                if (throwable != null) {
                    Object it2 = object2 = throwable;
                    boolean bl3 = false;
                    Logger.Companion.e(TAG, "Failed to decode stored generic tpats: " + it2);
                }
                if ((map = (Map)(Result.isFailure-impl((Object)object3) ? null : object3)) == null) {
                    map = new LinkedHashMap();
                }
                object = map;
                if (map != null) break block8;
            }
            object = new LinkedHashMap();
        }
        return object;
    }

    private final void saveStoredTpats(Map<String, Integer> tpats) {
        block2: {
            Object object;
            Object object2 = this;
            try {
                TpatSender $this$saveStoredTpats_u24lambda_u2d10 = object2;
                boolean bl = false;
                FilePreferences filePreferences = $this$saveStoredTpats_u24lambda_u2d10.tpatFilePreferences;
                StringFormat $this$encodeToString$iv = (StringFormat)Json.Default;
                boolean $i$f$encodeToString = false;
                SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
                boolean $i$f$serializer = false;
                KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.mutableCollectionType((KType)Reflection.typeOf(Map.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(String.class)), (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE)))));
                boolean $i$f$cast = false;
                Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
                filePreferences.put(FAILED_TPATS, $this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, tpats)).apply();
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block2;
            Object e2 = object = throwable;
            boolean bl = false;
            Logger.Companion.e(TAG, "Failed to encode the about to storing tpats: " + tpats);
        }
    }

    private final void saveStoredGenericTpats(Map<String, GenericTpatRequest> tpats) {
        block2: {
            Object object;
            Object object2 = this;
            try {
                TpatSender $this$saveStoredGenericTpats_u24lambda_u2d12 = object2;
                boolean bl = false;
                FilePreferences filePreferences = $this$saveStoredGenericTpats_u24lambda_u2d12.genericTpatFilePreferences;
                StringFormat $this$encodeToString$iv = (StringFormat)Json.Default;
                boolean $i$f$encodeToString = false;
                SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
                boolean $i$f$serializer = false;
                KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.mutableCollectionType((KType)Reflection.typeOf(Map.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(String.class)), (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(GenericTpatRequest.class)))));
                boolean $i$f$cast = false;
                Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
                filePreferences.put(FAILED_GENERIC_TPATS, $this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, tpats)).apply();
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block2;
            Object e2 = object = throwable;
            boolean bl = false;
            Logger.Companion.e(TAG, "Failed to encode the about to storing generic tpats: " + tpats);
        }
    }

    private final void logTpatError(ErrorInfo error, String urlWithSessionId) {
        Logger.Companion.e(TAG, "Failed with " + error.getDescription() + ", url:" + urlWithSessionId);
        new TpatError(error.getReason(), "Fail to send " + urlWithSessionId + ", error: " + error.getDescription()).setLogEntry$vungle_ads_release(this.logEntry).logErrorNoReturnValue$vungle_ads_release();
    }

    public final void resendStoredTpats$vungle_ads_release(@NotNull Executor executor) {
        String url;
        Map.Entry<String, Integer> entry;
        Map.Entry<String, Object> element$iv;
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Map<String, Object> $this$forEach$iv = this.getStoredTpats();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Object>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = element$iv = iterator.next();
            boolean bl = false;
            url = entry.getKey();
            this.sendTpat(url, executor);
        }
        $this$forEach$iv = this.getStoredGenericTpats();
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = element$iv = iterator.next();
            boolean bl = false;
            url = entry.getKey();
            GenericTpatRequest request = (GenericTpatRequest)((Object)entry.getValue());
            this.sendGenericTpat(url, new GenericTpatRequest(request.getMethod(), request.getHeaders(), request.getBody(), 0, 8, null), true, executor);
        }
    }

    @VisibleForTesting
    @NotNull
    public final String injectSessionIdToUrl(@NotNull String url) {
        String string;
        Object sessionId;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Object object = this.signalManager;
        if (object == null || (object = ((SignalManager)object).getUuid()) == null) {
            object = "";
        }
        if (((CharSequence)(sessionId = object)).length() > 0) {
            CharSequence charSequence = url;
            String string2 = Pattern.quote("{{{session_id}}}");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"quote(Constants.SESSION_ID)");
            String string3 = string2;
            string = new Regex(string3).replace(charSequence, (String)sessionId);
        } else {
            string = url;
        }
        return string;
    }

    private static final void sendWinNotification$lambda-0(TpatSender this$0, String $url) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$url, (String)"$url");
        ErrorInfo error = VungleApiClient.pingTPAT$default(this$0.vungleApiClient, $url, null, null, null, this$0.logEntry, 14, null);
        if (error != null) {
            new TpatError(Sdk.SDKError.Reason.AD_WIN_NOTIFICATION_ERROR, "Fail to send " + $url + ", error: " + error.getDescription()).setLogEntry$vungle_ads_release(this$0.logEntry).logErrorNoReturnValue$vungle_ads_release();
        }
    }

    private static final void sendTpat$lambda-2(TpatSender this$0, String $url, String $urlWithSessionId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$url, (String)"$url");
        Intrinsics.checkNotNullParameter((Object)$urlWithSessionId, (String)"$urlWithSessionId");
        Map<String, Integer> storedTpats = this$0.getStoredTpats();
        Integer n = storedTpats.get($url);
        int attemptNumber = n != null ? n : 0;
        ErrorInfo error = VungleApiClient.pingTPAT$default(this$0.vungleApiClient, $urlWithSessionId, null, null, null, this$0.logEntry, 14, null);
        if (error == null) {
            if (attemptNumber != 0) {
                storedTpats.remove($url);
                this$0.saveStoredTpats(storedTpats);
            }
        } else {
            if (!error.getErrorIsTerminal()) {
                if (attemptNumber >= 5) {
                    storedTpats.remove($url);
                    this$0.saveStoredTpats(storedTpats);
                    new TpatError(Sdk.SDKError.Reason.TPAT_RETRY_FAILED, $urlWithSessionId).setLogEntry$vungle_ads_release(this$0.logEntry).logErrorNoReturnValue$vungle_ads_release();
                } else {
                    storedTpats.put($url, attemptNumber + 1);
                    this$0.saveStoredTpats(storedTpats);
                }
            }
            this$0.logTpatError(error, $urlWithSessionId);
        }
    }

    private static final void sendGenericTpat$lambda-3(TpatSender this$0, String $url, GenericTpatRequest $request, String $urlWithSessionId, boolean $retry) {
        ErrorInfo errorInfo;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$url, (String)"$url");
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        Intrinsics.checkNotNullParameter((Object)$urlWithSessionId, (String)"$urlWithSessionId");
        Map<String, GenericTpatRequest> storedTpats = this$0.getStoredGenericTpats();
        GenericTpatRequest genericTpatRequest = storedTpats.get($url);
        int attemptNumber = genericTpatRequest != null ? genericTpatRequest.getAttempt() : 0;
        switch (WhenMappings.$EnumSwitchMapping$0[$request.getMethod().ordinal()]) {
            case 1: {
                errorInfo = VungleApiClient.pingTPAT$default(this$0.vungleApiClient, $urlWithSessionId, $request.getHeaders(), null, null, this$0.logEntry, 12, null);
                break;
            }
            case 2: {
                errorInfo = this$0.vungleApiClient.pingTPAT($urlWithSessionId, $request.getHeaders(), $request.getBody(), HttpMethod.POST, this$0.logEntry);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ErrorInfo error = errorInfo;
        if (error == null) {
            if (attemptNumber != 0) {
                storedTpats.remove($url);
                this$0.saveStoredGenericTpats(storedTpats);
            }
        } else {
            if (!error.getErrorIsTerminal() && $retry) {
                if (attemptNumber >= 5) {
                    storedTpats.remove($url);
                    this$0.saveStoredGenericTpats(storedTpats);
                    new TpatError(Sdk.SDKError.Reason.TPAT_RETRY_FAILED, $urlWithSessionId).setLogEntry$vungle_ads_release(this$0.logEntry).logErrorNoReturnValue$vungle_ads_release();
                } else {
                    GenericTpatRequest genericTpatRequest2 = storedTpats.get($url);
                    GenericTpatRequest genericTpatRequest3 = genericTpatRequest2 != null ? GenericTpatRequest.copy$default(genericTpatRequest2, null, null, null, attemptNumber + 1, 7, null) : null;
                    GenericTpatRequest genericTpatRequest4 = genericTpatRequest3;
                    if (genericTpatRequest4 == null) {
                        genericTpatRequest4 = new GenericTpatRequest($request.getMethod(), $request.getHeaders(), $request.getBody(), attemptNumber + 1);
                    }
                    storedTpats.put($url, genericTpatRequest4);
                    this$0.saveStoredGenericTpats(storedTpats);
                }
            }
            this$0.logTpatError(error, $urlWithSessionId);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/vungle/ads/internal/network/TpatSender$Companion;", "", "()V", "FAILED_GENERIC_TPATS", "", "FAILED_TPATS", "MAX_RETRIES", "", "TAG", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HttpMethod.values().length];
            nArray[HttpMethod.GET.ordinal()] = 1;
            nArray[HttpMethod.POST.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

