/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.load;

import com.vungle.ads.MraidJsError;
import com.vungle.ads.internal.ConfigManager;
import com.vungle.ads.internal.downloader.AssetDownloadListener;
import com.vungle.ads.internal.downloader.DownloadRequest;
import com.vungle.ads.internal.downloader.Downloader;
import com.vungle.ads.internal.executor.VungleThreadPoolExecutor;
import com.vungle.ads.internal.load.MraidJsLoader;
import com.vungle.ads.internal.model.AdAsset;
import com.vungle.ads.internal.model.AdPayload;
import com.vungle.ads.internal.protos.Sdk;
import com.vungle.ads.internal.util.FileUtility;
import com.vungle.ads.internal.util.Logger;
import com.vungle.ads.internal.util.PathProvider;
import java.io.File;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/vungle/ads/internal/load/MraidJsLoader;", "", "()V", "MRAID_AVAILABLE", "", "MRAID_DOWNLOADED", "MRAID_DOWNLOAD_FAILED", "MRAID_INVALID_ENDPOINT", "TAG", "", "isDownloading", "Ljava/util/concurrent/atomic/AtomicBoolean;", "listeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/vungle/ads/internal/load/MraidJsLoader$DownloadResultListener;", "downloadJs", "", "pathProvider", "Lcom/vungle/ads/internal/util/PathProvider;", "downloader", "Lcom/vungle/ads/internal/downloader/Downloader;", "executor", "Lcom/vungle/ads/internal/executor/VungleThreadPoolExecutor;", "downloadResultListener", "advertisement", "Lcom/vungle/ads/internal/model/AdPayload;", "notifyListeners", "downloadResult", "DownloadResultListener", "vungle-ads_release"})
public final class MraidJsLoader {
    @NotNull
    public static final MraidJsLoader INSTANCE = new MraidJsLoader();
    @NotNull
    private static final String TAG = "MraidJsLoader";
    public static final int MRAID_DOWNLOADED = 10;
    public static final int MRAID_INVALID_ENDPOINT = 11;
    public static final int MRAID_DOWNLOAD_FAILED = 12;
    public static final int MRAID_AVAILABLE = 13;
    @NotNull
    private static final AtomicBoolean isDownloading = new AtomicBoolean(false);
    @NotNull
    private static final CopyOnWriteArrayList<DownloadResultListener> listeners = new CopyOnWriteArrayList();

    private MraidJsLoader() {
    }

    public final void downloadJs(@NotNull PathProvider pathProvider, @NotNull Downloader downloader, @NotNull VungleThreadPoolExecutor executor, @Nullable DownloadResultListener downloadResultListener, @Nullable AdPayload advertisement) {
        Intrinsics.checkNotNullParameter((Object)pathProvider, (String)"pathProvider");
        Intrinsics.checkNotNullParameter((Object)downloader, (String)"downloader");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        executor.execute(() -> MraidJsLoader.downloadJs$lambda-1(downloadResultListener, advertisement, pathProvider, downloader, executor));
    }

    public static /* synthetic */ void downloadJs$default(MraidJsLoader mraidJsLoader, PathProvider pathProvider, Downloader downloader, VungleThreadPoolExecutor vungleThreadPoolExecutor, DownloadResultListener downloadResultListener, AdPayload adPayload, int n, Object object) {
        if ((n & 8) != 0) {
            downloadResultListener = null;
        }
        if ((n & 0x10) != 0) {
            adPayload = null;
        }
        mraidJsLoader.downloadJs(pathProvider, downloader, vungleThreadPoolExecutor, downloadResultListener, adPayload);
    }

    private final void notifyListeners(int downloadResult) {
        Iterable $this$forEach$iv = listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DownloadResultListener it = (DownloadResultListener)element$iv;
            boolean bl = false;
            it.onDownloadResult(downloadResult);
        }
        listeners.clear();
        isDownloading.set(false);
    }

    private static final void downloadJs$lambda-1(DownloadResultListener $downloadResultListener, AdPayload $advertisement, PathProvider $pathProvider, Downloader $downloader, VungleThreadPoolExecutor $executor) {
        Intrinsics.checkNotNullParameter((Object)$pathProvider, (String)"$pathProvider");
        Intrinsics.checkNotNullParameter((Object)$downloader, (String)"$downloader");
        Intrinsics.checkNotNullParameter((Object)$executor, (String)"$executor");
        try {
            Object it;
            DownloadResultListener downloadResultListener = $downloadResultListener;
            if (downloadResultListener != null) {
                it = downloadResultListener;
                boolean bl = false;
                listeners.add((DownloadResultListener)it);
            }
            if (isDownloading.getAndSet(true)) {
                Logger.Companion.w(TAG, "mraid js is downloading, waiting for the previous request.");
                return;
            }
            String mraidEndpoint = ConfigManager.INSTANCE.getMraidEndpoint();
            it = mraidEndpoint;
            if (it == null || it.length() == 0) {
                AdPayload adPayload = $advertisement;
                new MraidJsError(Sdk.SDKError.Reason.MRAID_DOWNLOAD_JS_ERROR, "Mraid endpoint is empty").setLogEntry$vungle_ads_release(adPayload != null ? adPayload.getLogEntry$vungle_ads_release() : null).logErrorNoReturnValue$vungle_ads_release();
                INSTANCE.notifyListeners(11);
                return;
            }
            File mraidJsPath = $pathProvider.getJsAssetDir(ConfigManager.INSTANCE.getMraidJsVersion());
            File mraidJsFile = new File(mraidJsPath, "mraid.min.js");
            if (mraidJsFile.exists()) {
                Logger.Companion.w(TAG, "mraid js already downloaded");
                INSTANCE.notifyListeners(13);
                return;
            }
            File jsPath = $pathProvider.getJsDir();
            FileUtility.deleteContents(jsPath);
            String string = mraidEndpoint + "/mraid.min.js";
            String string2 = mraidJsFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"mraidJsFile.absolutePath");
            AdAsset mraidJsAsset = new AdAsset("mraid.min.js", string, string2, AdAsset.FileType.ASSET, true);
            AdPayload adPayload = $advertisement;
            DownloadRequest mraidDownloadRequest = new DownloadRequest(DownloadRequest.Priority.HIGH, mraidJsAsset, adPayload != null ? adPayload.getLogEntry$vungle_ads_release() : null);
            $downloader.download(mraidDownloadRequest, new AssetDownloadListener($executor, $advertisement, jsPath, mraidJsFile){
                final /* synthetic */ VungleThreadPoolExecutor $executor;
                final /* synthetic */ AdPayload $advertisement;
                final /* synthetic */ File $jsPath;
                final /* synthetic */ File $mraidJsFile;
                {
                    this.$executor = $executor;
                    this.$advertisement = $advertisement;
                    this.$jsPath = $jsPath;
                    this.$mraidJsFile = $mraidJsFile;
                }

                public void onError(@Nullable AssetDownloadListener.DownloadError error, @NotNull DownloadRequest downloadRequest) {
                    Intrinsics.checkNotNullParameter((Object)downloadRequest, (String)"downloadRequest");
                    this.$executor.execute(() -> downloadJs.1.2.onError$lambda-0(error, downloadRequest, this.$advertisement, this.$jsPath));
                }

                public void onSuccess(@NotNull File file, @NotNull DownloadRequest downloadRequest) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    Intrinsics.checkNotNullParameter((Object)downloadRequest, (String)"downloadRequest");
                    this.$executor.execute(() -> downloadJs.1.2.onSuccess$lambda-1(file, this.$mraidJsFile, this.$advertisement, this.$jsPath));
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private static final void onError$lambda-0(AssetDownloadListener.DownloadError $error, DownloadRequest $downloadRequest, AdPayload $advertisement, File $jsPath) {
                    Intrinsics.checkNotNullParameter((Object)$downloadRequest, (String)"$downloadRequest");
                    Intrinsics.checkNotNullParameter((Object)$jsPath, (String)"$jsPath");
                    try {
                        Object object;
                        AssetDownloadListener.DownloadError downloadError = $error;
                        String errorMessage = "download mraid js error: " + (downloadError != null ? Integer.valueOf(downloadError.getServerCode()) : null) + ". Failed to load " + $downloadRequest.getAsset().getServerPath() + ", reason: " + ((object = $error) != null && (object = ((AssetDownloadListener.DownloadError)object).getCause()) != null ? ((Throwable)object).getMessage() : null);
                        Logger.Companion.d("MraidJsLoader", errorMessage);
                        AdPayload adPayload = $advertisement;
                        new MraidJsError(Sdk.SDKError.Reason.MRAID_DOWNLOAD_JS_ERROR, errorMessage).setLogEntry$vungle_ads_release(adPayload != null ? adPayload.getLogEntry$vungle_ads_release() : null).logErrorNoReturnValue$vungle_ads_release();
                        FileUtility.deleteContents($jsPath);
                    }
                    catch (Exception e2) {
                        Logger.Companion.e("MraidJsLoader", "Failed to delete js assets", e2);
                    }
                    finally {
                        MraidJsLoader.access$notifyListeners(MraidJsLoader.INSTANCE, 12);
                    }
                }

                private static final void onSuccess$lambda-1(File $file, File $mraidJsFile, AdPayload $advertisement, File $jsPath) {
                    Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
                    Intrinsics.checkNotNullParameter((Object)$mraidJsFile, (String)"$mraidJsFile");
                    Intrinsics.checkNotNullParameter((Object)$jsPath, (String)"$jsPath");
                    try {
                        if ($file.exists() && $file.length() > 0L) {
                            MraidJsLoader.access$notifyListeners(MraidJsLoader.INSTANCE, 10);
                        } else {
                            AdPayload adPayload = $advertisement;
                            new MraidJsError(Sdk.SDKError.Reason.MRAID_JS_WRITE_FAILED, "Mraid js downloaded but write failure: " + $mraidJsFile.getAbsolutePath()).setLogEntry$vungle_ads_release(adPayload != null ? adPayload.getLogEntry$vungle_ads_release() : null).logErrorNoReturnValue$vungle_ads_release();
                            FileUtility.deleteContents($jsPath);
                            MraidJsLoader.access$notifyListeners(MraidJsLoader.INSTANCE, 12);
                        }
                    }
                    catch (Exception e2) {
                        Logger.Companion.e("MraidJsLoader", "Failed to delete js assets", e2);
                        MraidJsLoader.access$notifyListeners(MraidJsLoader.INSTANCE, 12);
                    }
                }
            });
        }
        catch (Exception e2) {
            Logger.Companion.e(TAG, "Failed to download mraid js", e2);
        }
    }

    public static final /* synthetic */ void access$notifyListeners(MraidJsLoader $this, int downloadResult) {
        $this.notifyListeners(downloadResult);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/vungle/ads/internal/load/MraidJsLoader$DownloadResultListener;", "", "onDownloadResult", "", "downloadResult", "", "vungle-ads_release"})
    public static interface DownloadResultListener {
        public void onDownloadResult(int var1);
    }
}

