/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.downloader;

import com.vungle.ads.AnalyticsClient;
import com.vungle.ads.TimeIntervalMetric;
import com.vungle.ads.internal.model.AdAsset;
import com.vungle.ads.internal.protos.Sdk;
import com.vungle.ads.internal.util.LogEntry;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001 B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u0016\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u0010J\u0006\u0010\u001c\u001a\u00020\u0019J\u0006\u0010\u001d\u001a\u00020\u0019J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0013\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006!"}, d2={"Lcom/vungle/ads/internal/downloader/DownloadRequest;", "", "priority", "Lcom/vungle/ads/internal/downloader/DownloadRequest$Priority;", "asset", "Lcom/vungle/ads/internal/model/AdAsset;", "logEntry", "Lcom/vungle/ads/internal/util/LogEntry;", "(Lcom/vungle/ads/internal/downloader/DownloadRequest$Priority;Lcom/vungle/ads/internal/model/AdAsset;Lcom/vungle/ads/internal/util/LogEntry;)V", "getAsset", "()Lcom/vungle/ads/internal/model/AdAsset;", "cancelled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "downloadDuration", "Lcom/vungle/ads/TimeIntervalMetric;", "isHtmlTemplate", "", "()Z", "isMainVideo", "isTemplate", "getLogEntry$vungle_ads_release", "()Lcom/vungle/ads/internal/util/LogEntry;", "getPriority", "()Lcom/vungle/ads/internal/downloader/DownloadRequest$Priority;", "cancel", "", "", "isCancelled", "startRecord", "stopRecord", "toString", "", "Priority", "vungle-ads_release"})
public final class DownloadRequest {
    @NotNull
    private final Priority priority;
    @NotNull
    private final AdAsset asset;
    @Nullable
    private final LogEntry logEntry;
    @NotNull
    private final AtomicBoolean cancelled;
    @Nullable
    private TimeIntervalMetric downloadDuration;

    public DownloadRequest(@NotNull Priority priority, @NotNull AdAsset asset, @Nullable LogEntry logEntry2) {
        Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"priority");
        Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
        this.priority = priority;
        this.asset = asset;
        this.logEntry = logEntry2;
        this.cancelled = new AtomicBoolean(false);
    }

    public /* synthetic */ DownloadRequest(Priority priority, AdAsset adAsset, LogEntry logEntry2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            logEntry2 = null;
        }
        this(priority, adAsset, logEntry2);
    }

    @NotNull
    public final Priority getPriority() {
        return this.priority;
    }

    @NotNull
    public final AdAsset getAsset() {
        return this.asset;
    }

    @Nullable
    public final LogEntry getLogEntry$vungle_ads_release() {
        return this.logEntry;
    }

    public final boolean isTemplate() {
        return this.asset.getFileType() == AdAsset.FileType.ZIP || this.isHtmlTemplate();
    }

    public final boolean isHtmlTemplate() {
        return Intrinsics.areEqual((Object)this.asset.getAdIdentifier(), (Object)"vmURL");
    }

    public final boolean isMainVideo() {
        return Intrinsics.areEqual((Object)this.asset.getAdIdentifier(), (Object)"MAIN_VIDEO");
    }

    @NotNull
    public String toString() {
        return "DownloadRequest{, priority=" + (Object)((Object)this.priority) + ", url='" + this.asset.getServerPath() + "', path='" + this.asset.getLocalPath() + "', cancelled=" + this.cancelled + ", logEntry=" + this.logEntry + '}';
    }

    public final void cancel() {
        this.cancelled.set(true);
    }

    public final boolean isCancelled() {
        return this.cancelled.get();
    }

    public final int getPriority() {
        return this.priority.getPriority();
    }

    public final void startRecord() {
        block0: {
            TimeIntervalMetric timeIntervalMetric = this.downloadDuration = new TimeIntervalMetric(Sdk.SDKMetric.SDKMetricType.TEMPLATE_DOWNLOAD_DURATION_MS);
            if (timeIntervalMetric == null) break block0;
            timeIntervalMetric.markStart();
        }
    }

    public final void stopRecord() {
        block0: {
            TimeIntervalMetric timeIntervalMetric = this.downloadDuration;
            if (timeIntervalMetric == null) break block0;
            TimeIntervalMetric it = timeIntervalMetric;
            boolean bl = false;
            it.markEnd();
            AnalyticsClient.INSTANCE.logMetric$vungle_ads_release(it, this.logEntry, this.asset.getServerPath());
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/vungle/ads/internal/downloader/DownloadRequest$Priority;", "", "priority", "", "(Ljava/lang/String;II)V", "getPriority", "()I", "CRITICAL", "HIGHEST", "HIGH", "LOWEST", "vungle-ads_release"})
    public static final class Priority
    extends Enum<Priority> {
        private final int priority;
        public static final /* enum */ Priority CRITICAL = new Priority(-2147483647);
        public static final /* enum */ Priority HIGHEST = new Priority(0);
        public static final /* enum */ Priority HIGH = new Priority(1);
        public static final /* enum */ Priority LOWEST = new Priority(Integer.MAX_VALUE);
        private static final /* synthetic */ Priority[] $VALUES;

        private Priority(int priority) {
            this.priority = priority;
        }

        public final int getPriority() {
            return this.priority;
        }

        public static Priority[] values() {
            return (Priority[])$VALUES.clone();
        }

        public static Priority valueOf(String value) {
            return Enum.valueOf(Priority.class, value);
        }

        static {
            $VALUES = priorityArray = new Priority[]{Priority.CRITICAL, Priority.HIGHEST, Priority.HIGH, Priority.LOWEST};
        }
    }
}

