/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.util;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.webkit.WebView;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J\"\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\r"}, d2={"Lcom/vungle/ads/internal/util/ViewUtility;", "", "()V", "dpToPixels", "", "context", "Landroid/content/Context;", "dp", "getDeviceWidthAndHeightWithOrientation", "Lkotlin/Pair;", "orientation", "getWebView", "Landroid/webkit/WebView;", "vungle-ads_release"})
public final class ViewUtility {
    @NotNull
    public static final ViewUtility INSTANCE = new ViewUtility();

    private ViewUtility() {
    }

    public final int dpToPixels(@NotNull Context context, int dp) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)((float)dp * scale + 0.5f);
    }

    @NotNull
    public final WebView getWebView(@NotNull Context context) throws InstantiationException {
        WebView webView;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            webView = new WebView(context);
        }
        catch (Resources.NotFoundException e2) {
            throw new InstantiationException("Cannot instantiate WebView due to Resources.NotFoundException: " + (Object)((Object)e2) + ".message");
        }
        catch (Exception e3) {
            throw new InstantiationException(e3.getMessage());
        }
        return webView;
    }

    @NotNull
    public final Pair<Integer, Integer> getDeviceWidthAndHeightWithOrientation(@NotNull Context context, int orientation) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Resources resource = context.getApplicationContext().getResources();
        DisplayMetrics displayMetrics = resource.getDisplayMetrics();
        Configuration configuration = resource.getConfiguration();
        int curOrientation = configuration.orientation;
        int requiredOrientation = orientation == 0 ? curOrientation : orientation;
        return requiredOrientation == curOrientation ? new Pair((Object)Math.round((float)displayMetrics.widthPixels / displayMetrics.density), (Object)Math.round((float)displayMetrics.heightPixels / displayMetrics.density)) : new Pair((Object)Math.round((float)displayMetrics.heightPixels / displayMetrics.density), (Object)Math.round((float)displayMetrics.widthPixels / displayMetrics.density));
    }
}

