/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.task;

import android.os.Bundle;
import android.os.Process;
import com.vungle.ads.internal.task.Job;
import com.vungle.ads.internal.task.JobCreator;
import com.vungle.ads.internal.task.JobInfo;
import com.vungle.ads.internal.task.JobRunner;
import com.vungle.ads.internal.task.PriorityRunnable;
import com.vungle.ads.internal.task.ThreadPriorityHelper;
import com.vungle.ads.internal.util.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\f\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/vungle/ads/internal/task/JobRunnable;", "Lcom/vungle/ads/internal/task/PriorityRunnable;", "jobinfo", "Lcom/vungle/ads/internal/task/JobInfo;", "creator", "Lcom/vungle/ads/internal/task/JobCreator;", "jobRunner", "Lcom/vungle/ads/internal/task/JobRunner;", "threadPriorityHelper", "Lcom/vungle/ads/internal/task/ThreadPriorityHelper;", "(Lcom/vungle/ads/internal/task/JobInfo;Lcom/vungle/ads/internal/task/JobCreator;Lcom/vungle/ads/internal/task/JobRunner;Lcom/vungle/ads/internal/task/ThreadPriorityHelper;)V", "priority", "", "getPriority$annotations", "()V", "getPriority", "()I", "run", "", "Companion", "vungle-ads_release"})
public final class JobRunnable
extends PriorityRunnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JobInfo jobinfo;
    @NotNull
    private final JobCreator creator;
    @NotNull
    private final JobRunner jobRunner;
    @Nullable
    private final ThreadPriorityHelper threadPriorityHelper;
    private static final String TAG = JobRunnable.class.getSimpleName();

    public JobRunnable(@NotNull JobInfo jobinfo, @NotNull JobCreator creator, @NotNull JobRunner jobRunner, @Nullable ThreadPriorityHelper threadPriorityHelper) {
        Intrinsics.checkNotNullParameter((Object)jobinfo, (String)"jobinfo");
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        Intrinsics.checkNotNullParameter((Object)jobRunner, (String)"jobRunner");
        this.jobinfo = jobinfo;
        this.creator = creator;
        this.jobRunner = jobRunner;
        this.threadPriorityHelper = threadPriorityHelper;
    }

    @Override
    public int getPriority() {
        return this.jobinfo.getPriority();
    }

    public static /* synthetic */ void getPriority$annotations() {
    }

    @Override
    public void run() {
        if (this.threadPriorityHelper != null) {
            try {
                int targetPriority = this.threadPriorityHelper.makeAndroidThreadPriority(this.jobinfo);
                Process.setThreadPriority((int)targetPriority);
                String string = TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                Logger.Companion.d(string, "Setting process thread prio = " + targetPriority + " for " + this.jobinfo.getJobTag());
            }
            catch (Throwable throwable) {
                String string = TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                Logger.Companion.e(string, "Error on setting process thread priority");
            }
        }
        try {
            long nextReschedule;
            String jobTag = this.jobinfo.getJobTag();
            Bundle params = this.jobinfo.getExtras();
            String string = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.Companion.d(string, "Start job " + jobTag + "Thread " + Thread.currentThread().getName());
            Job job = this.creator.create(jobTag);
            int result = job.onRunJob(params, this.jobRunner);
            String string2 = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
            Logger.Companion.d(string2, "On job finished " + jobTag + " with result " + result);
            if (result == 2 && (nextReschedule = this.jobinfo.makeNextRescedule()) > 0L) {
                this.jobinfo.setDelay(nextReschedule);
                this.jobRunner.execute(this.jobinfo);
                String string3 = TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"TAG");
                Logger.Companion.d(string3, "Rescheduling " + jobTag + " in " + nextReschedule);
            }
        }
        catch (Exception e2) {
            String string = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.Companion.e(string, "Cannot create job" + e2.getLocalizedMessage());
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/vungle/ads/internal/task/JobRunnable$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

