/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.privacy;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import androidx.annotation.VisibleForTesting;
import com.vungle.ads.ServiceLocator;
import com.vungle.ads.internal.ConfigManager;
import com.vungle.ads.internal.model.ConfigPayload;
import com.vungle.ads.internal.persistence.FilePreferences;
import com.vungle.ads.internal.privacy.COPPA;
import com.vungle.ads.internal.privacy.PrivacyConsent;
import com.vungle.ads.internal.util.Logger;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001CB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020\fJ\u0006\u0010#\u001a\u00020\fJ\u0006\u0010$\u001a\u00020\fJ\u0006\u0010%\u001a\u00020\fJ\u0006\u0010&\u001a\u00020\u0010J\u0006\u0010'\u001a\u00020(J\u0011\u0010)\u001a\u0004\u0018\u00010\u0007H\u0001\u00a2\u0006\u0004\b*\u0010+J\r\u0010,\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010+J\u0006\u0010-\u001a\u00020\fJ\u000e\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201J\u0010\u00102\u001a\u00020/2\u0006\u00103\u001a\u00020\u0004H\u0002J\u0010\u00104\u001a\u00020/2\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\u0010\u00105\u001a\u00020/2\u0006\u0010\u0014\u001a\u00020\u0007H\u0007J(\u00106\u001a\u00020/2\u0006\u00103\u001a\u00020\f2\u0006\u00107\u001a\u00020\f2\u0006\u00108\u001a\u00020\f2\u0006\u00109\u001a\u00020\u0010H\u0002J\r\u0010:\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b;J\u0006\u0010<\u001a\u00020\u0007J\u0006\u0010=\u001a\u00020\u0007J\u000e\u0010>\u001a\u00020/2\u0006\u00103\u001a\u00020\u0004J\u000e\u0010?\u001a\u00020/2\u0006\u0010@\u001a\u00020\u0007J\u000e\u0010A\u001a\u00020/2\u0006\u0010@\u001a\u00020\u0007J \u0010B\u001a\u00020/2\u0006\u00103\u001a\u00020\f2\u0006\u00107\u001a\u00020\f2\b\u00108\u001a\u0004\u0018\u00010\fR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0015\u001a\u0004\u0018\u00010\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006D"}, d2={"Lcom/vungle/ads/internal/privacy/PrivacyManager;", "", "()V", "ccpaConsent", "Lcom/vungle/ads/internal/privacy/PrivacyConsent;", "coppaStatus", "Ljava/util/concurrent/atomic/AtomicReference;", "", "disableAdId", "filePreferences", "Lcom/vungle/ads/internal/persistence/FilePreferences;", "gdprConsent", "", "gdprConsentMessageVersion", "gdprConsentSource", "gdprConsentTimestamp", "", "Ljava/lang/Long;", "initialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "value", "previousTcfToken", "getPreviousTcfToken", "()Ljava/lang/String;", "setPreviousTcfToken", "(Ljava/lang/String;)V", "sharedPreferences", "Landroid/content/SharedPreferences;", "getSharedPreferences", "()Landroid/content/SharedPreferences;", "setSharedPreferences", "(Landroid/content/SharedPreferences;)V", "allowDeviceIDFromTCF", "Lcom/vungle/ads/internal/privacy/PrivacyManager$DeviceIdAllowed;", "getCcpaStatus", "getConsentMessageVersion", "getConsentSource", "getConsentStatus", "getConsentTimestamp", "getCoppaStatus", "Lcom/vungle/ads/internal/privacy/COPPA;", "getDisableAdId", "getDisableAdId$vungle_ads_release", "()Ljava/lang/Boolean;", "getGdprAppliesFromPreferences", "getIABTCFString", "init", "", "context", "Landroid/content/Context;", "saveCcpaConsent", "consent", "saveCoppaConsent", "saveDisableAdId", "saveGdprConsent", "source", "consentMessageVersion", "consentTimestamp", "shouldReturnTrueForLegacy", "shouldReturnTrueForLegacy$vungle_ads_release", "shouldSendAdIds", "shouldSendTCFString", "updateCcpaConsent", "updateCoppaConsent", "newValue", "updateDisableAdId", "updateGdprConsent", "DeviceIdAllowed", "vungle-ads_release"})
public final class PrivacyManager {
    @NotNull
    public static final PrivacyManager INSTANCE = new PrivacyManager();
    @NotNull
    private static final AtomicReference<Boolean> disableAdId = new AtomicReference();
    @NotNull
    private static final AtomicReference<Boolean> coppaStatus = new AtomicReference();
    @NotNull
    private static final AtomicBoolean initialized = new AtomicBoolean(false);
    @Nullable
    private static String gdprConsent;
    @Nullable
    private static String gdprConsentSource;
    @Nullable
    private static String gdprConsentMessageVersion;
    @Nullable
    private static Long gdprConsentTimestamp;
    @Nullable
    private static PrivacyConsent ccpaConsent;
    @Nullable
    private static FilePreferences filePreferences;
    @Nullable
    private static SharedPreferences sharedPreferences;

    private PrivacyManager() {
    }

    @Nullable
    public final SharedPreferences getSharedPreferences() {
        return sharedPreferences;
    }

    public final void setSharedPreferences(@Nullable SharedPreferences sharedPreferences) {
        PrivacyManager.sharedPreferences = sharedPreferences;
    }

    @Nullable
    public final String getPreviousTcfToken() {
        FilePreferences filePreferences = PrivacyManager.filePreferences;
        return filePreferences != null ? filePreferences.getString("previous_tcf_token", "") : null;
    }

    public final void setPreviousTcfToken(@Nullable String value) {
        block0: {
            FilePreferences filePreferences;
            CharSequence charSequence = value;
            if (charSequence == null || charSequence.length() == 0 || (filePreferences = PrivacyManager.filePreferences) == null || (filePreferences = filePreferences.put("previous_tcf_token", value)) == null) break block0;
            filePreferences.apply();
        }
    }

    public final synchronized void init(@NotNull Context context) {
        FilePreferences filePreferences;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (initialized.get()) {
            Logger.Companion.w("PrivacyManager", "PrivacyManager already initialized");
            return;
        }
        sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        PrivacyManager.filePreferences = filePreferences = ServiceLocator.Companion.getInstance(context).getService(FilePreferences.class);
        Boolean disableAdIdFlag = disableAdId.get();
        if (disableAdIdFlag != null) {
            this.saveDisableAdId(disableAdIdFlag);
        } else {
            Boolean storedDisableAdId;
            Boolean bl = storedDisableAdId = filePreferences.getBoolean("disable_ad_id");
            if (bl != null) {
                boolean $this$init_u24lambda_u2d0 = bl;
                boolean bl2 = false;
                disableAdId.set($this$init_u24lambda_u2d0);
            }
        }
        String gdpr = gdprConsent;
        if (gdpr != null) {
            String string;
            String string2 = gdprConsentSource;
            if (string2 == null) {
                string2 = "";
            }
            if ((string = gdprConsentMessageVersion) == null) {
                string = "";
            }
            Long l = gdprConsentTimestamp;
            this.saveGdprConsent(gdpr, string2, string, l != null ? l : 0L);
        } else {
            String storedGdpr = filePreferences.getString("gdpr_status");
            String $this$init_u24lambda_u2d0 = storedGdpr;
            gdprConsent = Intrinsics.areEqual((Object)$this$init_u24lambda_u2d0, (Object)PrivacyConsent.OPT_IN.getValue()) ? PrivacyConsent.OPT_IN.getValue() : (Intrinsics.areEqual((Object)$this$init_u24lambda_u2d0, (Object)PrivacyConsent.OPT_OUT.getValue()) ? PrivacyConsent.OPT_OUT.getValue() : storedGdpr);
            gdprConsentSource = filePreferences.getString("gdpr_source");
            gdprConsentMessageVersion = filePreferences.getString("gdpr_message_version");
            gdprConsentTimestamp = filePreferences.getLong("gdpr_timestamp", 0L);
        }
        PrivacyConsent ccpaStatus = ccpaConsent;
        if (ccpaStatus != null) {
            this.saveCcpaConsent(ccpaStatus);
        } else {
            String storedCcpa = filePreferences.getString("ccpa_status");
            ccpaConsent = Intrinsics.areEqual((Object)PrivacyConsent.OPT_OUT.getValue(), (Object)storedCcpa) ? PrivacyConsent.OPT_OUT : PrivacyConsent.OPT_IN;
        }
        Boolean coppa = coppaStatus.get();
        if (coppa != null) {
            this.saveCoppaConsent(coppa);
        } else {
            Boolean storedCoppa;
            Boolean bl = storedCoppa = filePreferences.getBoolean("is_coppa");
            if (bl != null) {
                boolean $this$init_u24lambda_u2d1 = bl;
                boolean bl3 = false;
                coppaStatus.set($this$init_u24lambda_u2d1);
            }
        }
        initialized.set(true);
    }

    public final void updateGdprConsent(@NotNull String consent, @NotNull String source, @Nullable String consentMessageVersion) {
        Intrinsics.checkNotNullParameter((Object)consent, (String)"consent");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        gdprConsent = consent;
        gdprConsentSource = source;
        gdprConsentMessageVersion = consentMessageVersion;
        long gdprConsentTimestamp = System.currentTimeMillis() / (long)1000;
        PrivacyManager.gdprConsentTimestamp = gdprConsentTimestamp;
        String string = gdprConsentMessageVersion;
        if (string == null) {
            string = "";
        }
        this.saveGdprConsent(consent, source, string, gdprConsentTimestamp);
    }

    private final void saveGdprConsent(String consent, String source, String consentMessageVersion, long consentTimestamp) {
        block0: {
            FilePreferences filePreferences;
            FilePreferences filePreferences2;
            FilePreferences filePreferences3;
            FilePreferences filePreferences4;
            FilePreferences filePreferences5 = PrivacyManager.filePreferences;
            if (filePreferences5 == null || (filePreferences4 = filePreferences5.put("gdpr_status", consent)) == null || (filePreferences3 = filePreferences4.put("gdpr_source", source)) == null || (filePreferences2 = filePreferences3.put("gdpr_message_version", consentMessageVersion)) == null || (filePreferences = filePreferences2.put("gdpr_timestamp", consentTimestamp)) == null) break block0;
            filePreferences.apply();
        }
    }

    public final void updateCcpaConsent(@NotNull PrivacyConsent consent) {
        Intrinsics.checkNotNullParameter((Object)((Object)consent), (String)"consent");
        ccpaConsent = consent;
        this.saveCcpaConsent(consent);
    }

    @NotNull
    public final String getCcpaStatus() {
        Object object = ccpaConsent;
        if (object == null || (object = object.getValue()) == null) {
            object = PrivacyConsent.OPT_IN.getValue();
        }
        return object;
    }

    private final void saveCcpaConsent(PrivacyConsent consent) {
        block0: {
            FilePreferences filePreferences = PrivacyManager.filePreferences;
            if (filePreferences == null || (filePreferences = filePreferences.put("ccpa_status", consent.getValue())) == null) break block0;
            filePreferences.apply();
        }
    }

    public final void updateCoppaConsent(boolean newValue) {
        coppaStatus.set(newValue);
        this.saveCoppaConsent(newValue);
    }

    private final void saveCoppaConsent(boolean value) {
        block0: {
            FilePreferences filePreferences = PrivacyManager.filePreferences;
            if (filePreferences == null || (filePreferences = filePreferences.put("is_coppa", value)) == null) break block0;
            filePreferences.apply();
        }
    }

    public final void updateDisableAdId(boolean newValue) {
        disableAdId.set(newValue);
        this.saveDisableAdId(newValue);
    }

    @VisibleForTesting
    public final void saveDisableAdId(boolean value) {
        block0: {
            FilePreferences filePreferences = PrivacyManager.filePreferences;
            if (filePreferences == null || (filePreferences = filePreferences.put("disable_ad_id", value)) == null) break block0;
            filePreferences.apply();
        }
    }

    @NotNull
    public final String getConsentStatus() {
        String string = gdprConsent;
        if (string == null) {
            string = "unknown";
        }
        return string;
    }

    @NotNull
    public final String getConsentSource() {
        String string = gdprConsentSource;
        if (string == null) {
            string = "no_interaction";
        }
        return string;
    }

    @NotNull
    public final String getConsentMessageVersion() {
        String string = gdprConsentMessageVersion;
        if (string == null) {
            string = "";
        }
        return string;
    }

    public final long getConsentTimestamp() {
        Long l = gdprConsentTimestamp;
        return l != null ? l : 0L;
    }

    @NotNull
    public final COPPA getCoppaStatus() {
        if (coppaStatus.get() == null) {
            return COPPA.COPPA_NOTSET;
        }
        if (Intrinsics.areEqual((Object)coppaStatus.get(), (Object)true)) {
            return COPPA.COPPA_ENABLED;
        }
        if (Intrinsics.areEqual((Object)coppaStatus.get(), (Object)false)) {
            return COPPA.COPPA_DISABLED;
        }
        return COPPA.COPPA_NOTSET;
    }

    @VisibleForTesting
    @Nullable
    public final Boolean getDisableAdId$vungle_ads_release() {
        return disableAdId.get();
    }

    public final boolean shouldSendAdIds() {
        boolean bl;
        DeviceIdAllowed tcfStatus = this.allowDeviceIDFromTCF();
        switch (WhenMappings.$EnumSwitchMapping$0[tcfStatus.ordinal()]) {
            case 1: {
                bl = false;
                break;
            }
            case 2: 
            case 3: {
                Boolean value = this.getDisableAdId$vungle_ads_release();
                if (value != null && !value.booleanValue()) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @Nullable
    public final Boolean getGdprAppliesFromPreferences() {
        Boolean bl;
        Integer gdprAppliesValue;
        Integer n;
        SharedPreferences sharedPreferences = PrivacyManager.sharedPreferences;
        Integer n2 = n = (gdprAppliesValue = sharedPreferences != null ? Integer.valueOf(sharedPreferences.getInt("IABTCF_gdprApplies", -1)) : null);
        int n3 = 1;
        if (n2 != null && n2 == n3) {
            bl = true;
        } else {
            Integer n4 = n;
            bl = n4 != null && n4 == 0 ? Boolean.valueOf(false) : null;
        }
        return bl;
    }

    @NotNull
    public final String getIABTCFString() {
        SharedPreferences sharedPreferences = PrivacyManager.sharedPreferences;
        String string = sharedPreferences != null ? sharedPreferences.getString("IABTCF_TCString", "") : null;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final DeviceIdAllowed allowDeviceIDFromTCF() {
        DeviceIdAllowed deviceIdAllowed;
        block6: {
            Boolean bl;
            block5: {
                Boolean sharedPreferencesGDPRApplies = this.getGdprAppliesFromPreferences();
                bl = sharedPreferencesGDPRApplies;
                if (!Intrinsics.areEqual((Object)bl, (Object)true)) break block5;
                ConfigPayload.IABSettings.TcfStatus tcfStatus = ConfigManager.INSTANCE.getTcfStatus();
                switch (tcfStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$1[tcfStatus.ordinal()]) {
                    case 1: {
                        deviceIdAllowed = DeviceIdAllowed.DISABLE_ID;
                        break block6;
                    }
                    case 2: {
                        deviceIdAllowed = DeviceIdAllowed.ALLOW_ID;
                        break block6;
                    }
                    case -1: 
                    case 3: {
                        deviceIdAllowed = DeviceIdAllowed.FALLBACK;
                        break block6;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            deviceIdAllowed = bl == null ? DeviceIdAllowed.FALLBACK : DeviceIdAllowed.ALLOW_ID;
        }
        return deviceIdAllowed;
    }

    public final boolean shouldReturnTrueForLegacy$vungle_ads_release() {
        boolean bl;
        String newTcfToken = this.getIABTCFString();
        if (!Intrinsics.areEqual((Object)this.getPreviousTcfToken(), (Object)newTcfToken)) {
            this.setPreviousTcfToken(newTcfToken);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean shouldSendTCFString() {
        boolean bl;
        block5: {
            block4: {
                Boolean sharedPreferencesGDPRApplies = this.getGdprAppliesFromPreferences();
                if (!Intrinsics.areEqual((Object)sharedPreferencesGDPRApplies, (Object)true)) break block4;
                ConfigPayload.IABSettings.TcfStatus tcfStatus = ConfigManager.INSTANCE.getTcfStatus();
                switch (tcfStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$1[tcfStatus.ordinal()]) {
                    case 1: 
                    case 2: {
                        bl = true;
                        break block5;
                    }
                    case -1: 
                    case 3: {
                        bl = this.shouldReturnTrueForLegacy$vungle_ads_release();
                        break block5;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/vungle/ads/internal/privacy/PrivacyManager$DeviceIdAllowed;", "", "(Ljava/lang/String;I)V", "ALLOW_ID", "DISABLE_ID", "FALLBACK", "vungle-ads_release"})
    public static final class DeviceIdAllowed
    extends Enum<DeviceIdAllowed> {
        public static final /* enum */ DeviceIdAllowed ALLOW_ID = new DeviceIdAllowed();
        public static final /* enum */ DeviceIdAllowed DISABLE_ID = new DeviceIdAllowed();
        public static final /* enum */ DeviceIdAllowed FALLBACK = new DeviceIdAllowed();
        private static final /* synthetic */ DeviceIdAllowed[] $VALUES;

        public static DeviceIdAllowed[] values() {
            return (DeviceIdAllowed[])$VALUES.clone();
        }

        public static DeviceIdAllowed valueOf(String value) {
            return Enum.valueOf(DeviceIdAllowed.class, value);
        }

        static {
            $VALUES = deviceIdAllowedArray = new DeviceIdAllowed[]{DeviceIdAllowed.ALLOW_ID, DeviceIdAllowed.DISABLE_ID, DeviceIdAllowed.FALLBACK};
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[DeviceIdAllowed.values().length];
            nArray[DeviceIdAllowed.DISABLE_ID.ordinal()] = 1;
            nArray[DeviceIdAllowed.FALLBACK.ordinal()] = 2;
            nArray[DeviceIdAllowed.ALLOW_ID.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ConfigPayload.IABSettings.TcfStatus.values().length];
            nArray[ConfigPayload.IABSettings.TcfStatus.DISABLE_ID.ordinal()] = 1;
            nArray[ConfigPayload.IABSettings.TcfStatus.ALLOW_ID.ordinal()] = 2;
            nArray[ConfigPayload.IABSettings.TcfStatus.LEGACY.ordinal()] = 3;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

