/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.presenter;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.ContextThemeWrapper;
import android.view.View;
import com.vungle.ads.AnalyticsClient;
import com.vungle.ads.PrivacyUrlError;
import com.vungle.ads.ServiceLocator;
import com.vungle.ads.internal.ConfigManager;
import com.vungle.ads.internal.executor.Executors;
import com.vungle.ads.internal.model.AdPayload;
import com.vungle.ads.internal.network.TpatSender;
import com.vungle.ads.internal.network.VungleApiClient;
import com.vungle.ads.internal.omsdk.NativeOMTracker;
import com.vungle.ads.internal.platform.Platform;
import com.vungle.ads.internal.presenter.AdEventListener;
import com.vungle.ads.internal.presenter.NativePresenterDelegate;
import com.vungle.ads.internal.privacy.PrivacyConsent;
import com.vungle.ads.internal.privacy.PrivacyManager;
import com.vungle.ads.internal.signals.SignalManager;
import com.vungle.ads.internal.ui.PresenterAdOpenCallback;
import com.vungle.ads.internal.ui.PresenterAppLeftCallback;
import com.vungle.ads.internal.util.ExternalRouter;
import com.vungle.ads.internal.util.FileUtility;
import com.vungle.ads.internal.util.Logger;
import com.vungle.ads.internal.util.PathProvider;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 C2\u00020\u0001:\u0001CB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010-\u001a\u00020.J\u000e\u0010/\u001a\u00020.2\u0006\u00100\u001a\u000201J\b\u00102\u001a\u00020\u0011H\u0002J\u0012\u00103\u001a\u00020.2\b\u00104\u001a\u0004\u0018\u000101H\u0002J\u0006\u00105\u001a\u00020.J\u0012\u00106\u001a\u00020.2\b\u00107\u001a\u0004\u0018\u000101H\u0002J\u0006\u00108\u001a\u00020.J\u001a\u00109\u001a\u00020.2\u0006\u0010:\u001a\u0002012\n\b\u0002\u0010;\u001a\u0004\u0018\u000101J\u0010\u0010<\u001a\u00020.2\b\u0010=\u001a\u0004\u0018\u00010\u0013J\b\u0010>\u001a\u00020.H\u0002J\b\u0010?\u001a\u00020.H\u0002J\u000e\u0010@\u001a\u00020.2\u0006\u0010A\u001a\u00020BR\u0012\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001e\u001a\u00020\u001f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u001b\u001a\u0004\b \u0010!R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010#\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\u001b\u001a\u0004\b%\u0010&R\u001b\u0010(\u001a\u00020)8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010\u001b\u001a\u0004\b*\u0010+\u00a8\u0006D"}, d2={"Lcom/vungle/ads/internal/presenter/NativeAdPresenter;", "", "context", "Landroid/content/Context;", "delegate", "Lcom/vungle/ads/internal/presenter/NativePresenterDelegate;", "advertisement", "Lcom/vungle/ads/internal/model/AdPayload;", "executor", "Ljava/util/concurrent/Executor;", "platform", "Lcom/vungle/ads/internal/platform/Platform;", "(Landroid/content/Context;Lcom/vungle/ads/internal/presenter/NativePresenterDelegate;Lcom/vungle/ads/internal/model/AdPayload;Ljava/util/concurrent/Executor;Lcom/vungle/ads/internal/platform/Platform;)V", "adStartTime", "", "Ljava/lang/Long;", "adViewed", "", "bus", "Lcom/vungle/ads/internal/presenter/AdEventListener;", "currentDialog", "Landroid/app/Dialog;", "executors", "Lcom/vungle/ads/internal/executor/Executors;", "getExecutors", "()Lcom/vungle/ads/internal/executor/Executors;", "executors$delegate", "Lkotlin/Lazy;", "omTracker", "Lcom/vungle/ads/internal/omsdk/NativeOMTracker;", "pathProvider", "Lcom/vungle/ads/internal/util/PathProvider;", "getPathProvider", "()Lcom/vungle/ads/internal/util/PathProvider;", "pathProvider$delegate", "signalManager", "Lcom/vungle/ads/internal/signals/SignalManager;", "getSignalManager", "()Lcom/vungle/ads/internal/signals/SignalManager;", "signalManager$delegate", "vungleApiClient", "Lcom/vungle/ads/internal/network/VungleApiClient;", "getVungleApiClient", "()Lcom/vungle/ads/internal/network/VungleApiClient;", "vungleApiClient$delegate", "detach", "", "initOMTracker", "omSdkData", "", "needShowGdpr", "onDownload", "ctaUrl", "onImpression", "onPrivacy", "privacyUrl", "prepare", "processCommand", "action", "value", "setEventListener", "listener", "showGdpr", "start", "startTracking", "rootView", "Landroid/view/View;", "Companion", "vungle-ads_release"})
public final class NativeAdPresenter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final NativePresenterDelegate delegate;
    @Nullable
    private final AdPayload advertisement;
    @NotNull
    private Executor executor;
    @NotNull
    private final Platform platform;
    @Nullable
    private Long adStartTime;
    @Nullable
    private AdEventListener bus;
    @NotNull
    private final Lazy vungleApiClient$delegate;
    @NotNull
    private final Lazy executors$delegate;
    @NotNull
    private final Lazy pathProvider$delegate;
    @NotNull
    private final Lazy signalManager$delegate;
    @Nullable
    private Dialog currentDialog;
    private boolean adViewed;
    @Nullable
    private NativeOMTracker omTracker;
    @NotNull
    private static final String TAG = "NativeAdPresenter";
    @NotNull
    public static final String VIDEO_VIEWED = "videoViewed";
    @NotNull
    public static final String TPAT = "tpat";
    @NotNull
    public static final String OPEN_PRIVACY = "openPrivacy";
    @NotNull
    public static final String DOWNLOAD = "download";

    public NativeAdPresenter(@NotNull Context context, @NotNull NativePresenterDelegate delegate, @Nullable AdPayload advertisement, @NotNull Executor executor, @NotNull Platform platform) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        this.context = context;
        this.delegate = delegate;
        this.advertisement = advertisement;
        this.executor = executor;
        this.platform = platform;
        ServiceLocator.Companion companion = ServiceLocator.Companion;
        Context context$iv = this.context;
        boolean $i$f$inject = false;
        this.vungleApiClient$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<VungleApiClient>(context$iv){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final VungleApiClient invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(VungleApiClient.class);
            }
        }));
        ServiceLocator.Companion this_$iv = ServiceLocator.Companion;
        context$iv = this.context;
        $i$f$inject = false;
        this.executors$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<Executors>(context$iv){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final Executors invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(Executors.class);
            }
        }));
        this_$iv = ServiceLocator.Companion;
        context$iv = this.context;
        $i$f$inject = false;
        this.pathProvider$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<PathProvider>(context$iv){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final PathProvider invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(PathProvider.class);
            }
        }));
        this_$iv = ServiceLocator.Companion;
        context$iv = this.context;
        $i$f$inject = false;
        this.signalManager$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<SignalManager>(context$iv){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final SignalManager invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(SignalManager.class);
            }
        }));
    }

    private final VungleApiClient getVungleApiClient() {
        Lazy lazy = this.vungleApiClient$delegate;
        return (VungleApiClient)lazy.getValue();
    }

    private final Executors getExecutors() {
        Lazy lazy = this.executors$delegate;
        return (Executors)lazy.getValue();
    }

    private final PathProvider getPathProvider() {
        Lazy lazy = this.pathProvider$delegate;
        return (PathProvider)lazy.getValue();
    }

    private final SignalManager getSignalManager() {
        Lazy lazy = this.signalManager$delegate;
        return (SignalManager)lazy.getValue();
    }

    public final void setEventListener(@Nullable AdEventListener listener) {
        this.bus = listener;
    }

    public final void processCommand(@NotNull String action, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        switch (action) {
            case "videoViewed": {
                if (this.bus == null || this.adViewed) {
                    return;
                }
                this.adViewed = true;
                AdEventListener adEventListener2 = this.bus;
                if (adEventListener2 != null) {
                    adEventListener2.onNext("adViewed", null, this.delegate.getPlacementRefId());
                }
                AdPayload adPayload = this.advertisement;
                AdPayload adPayload2 = this.advertisement;
                TpatSender tpatSender = new TpatSender(this.getVungleApiClient(), this.delegate.getPlacementRefId(), adPayload != null ? adPayload.getCreativeId() : null, adPayload2 != null ? adPayload2.eventId() : null, this.getExecutors().getIoExecutor(), this.getPathProvider(), this.getSignalManager());
                List<String> list = this.delegate.getImpressionUrls();
                if (list != null) {
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String url = (String)element$iv;
                        boolean bl = false;
                        tpatSender.sendTpat(url, this.executor);
                    }
                }
                return;
            }
            case "tpat": {
                List<String> list;
                CharSequence tpatSender = value;
                if (tpatSender == null || tpatSender.length() == 0) {
                    AdPayload adPayload = this.advertisement;
                    AnalyticsClient.logError$vungle_ads_release$default(AnalyticsClient.INSTANCE, 129, "Empty tpat key", this.delegate.getPlacementRefId(), adPayload != null ? adPayload.getCreativeId() : null, null, 16, null);
                    return;
                }
                if (Intrinsics.areEqual((Object)value, (Object)"checkpoint.0")) {
                    AdPayload adPayload = this.advertisement;
                    list = adPayload != null ? adPayload.getTpatUrls(value, this.platform.getCarrierName(), String.valueOf(this.platform.getVolumeLevel())) : null;
                } else {
                    AdPayload adPayload = this.advertisement;
                    list = adPayload != null ? AdPayload.getTpatUrls$default(adPayload, value, null, null, 6, null) : null;
                }
                List<String> urls = list;
                Collection collection = urls;
                if (collection == null || collection.isEmpty()) {
                    AdPayload adPayload = this.advertisement;
                    AnalyticsClient.logError$vungle_ads_release$default(AnalyticsClient.INSTANCE, 128, "Empty urls for tpat: " + value, this.delegate.getPlacementRefId(), adPayload != null ? adPayload.getCreativeId() : null, null, 16, null);
                } else {
                    AdPayload adPayload = this.advertisement;
                    AdPayload adPayload3 = this.advertisement;
                    TpatSender tpatSender2 = new TpatSender(this.getVungleApiClient(), this.delegate.getPlacementRefId(), adPayload != null ? adPayload.getCreativeId() : null, adPayload3 != null ? adPayload3.eventId() : null, this.getExecutors().getIoExecutor(), this.getPathProvider(), this.getSignalManager());
                    Iterable $this$forEach$iv = urls;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String url = (String)element$iv;
                        boolean bl = false;
                        tpatSender2.sendTpat(url, this.executor);
                    }
                }
                return;
            }
            case "openPrivacy": {
                this.onPrivacy(value);
                return;
            }
            case "download": {
                this.onDownload(value);
                return;
            }
        }
        Logger.Companion.w(TAG, "Unknown native ad action: " + action);
    }

    public static /* synthetic */ void processCommand$default(NativeAdPresenter nativeAdPresenter, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        nativeAdPresenter.processCommand(string, string2);
    }

    private final void onDownload(String ctaUrl) {
        block4: {
            Object object;
            AdPayload adPayload = this.advertisement;
            List urls = adPayload != null ? AdPayload.getTpatUrls$default(adPayload, "clickUrl", null, null, 6, null) : null;
            AdPayload adPayload2 = this.advertisement;
            AdPayload adPayload3 = this.advertisement;
            TpatSender tpatSender = new TpatSender(this.getVungleApiClient(), this.delegate.getPlacementRefId(), adPayload2 != null ? adPayload2.getCreativeId() : null, adPayload3 != null ? adPayload3.eventId() : null, this.getExecutors().getIoExecutor(), this.getPathProvider(), this.getSignalManager());
            Collection collection = urls;
            if (collection == null || collection.isEmpty()) {
                AdPayload adPayload4 = this.advertisement;
                AnalyticsClient.logError$vungle_ads_release$default(AnalyticsClient.INSTANCE, 129, "Empty tpat key: clickUrl", this.delegate.getPlacementRefId(), adPayload4 != null ? adPayload4.getCreativeId() : null, null, 16, null);
            } else {
                Iterable $this$forEach$iv = urls;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String url = (String)element$iv;
                    boolean bl = false;
                    tpatSender.sendTpat(url, this.executor);
                }
            }
            String string = ctaUrl;
            if (string != null) {
                String it = string;
                boolean bl = false;
                tpatSender.sendTpat(it, this.executor);
            }
            String deeplinkUrl = (object = this.advertisement) != null && (object = ((AdPayload)object).adUnit()) != null ? ((AdPayload.AdUnit)object).getDeeplinkUrl() : null;
            ExternalRouter.launch(deeplinkUrl, ctaUrl, this.context, new PresenterAppLeftCallback(this.bus, null), new PresenterAdOpenCallback(this, tpatSender){
                final /* synthetic */ NativeAdPresenter this$0;
                final /* synthetic */ TpatSender $tpatSender;
                {
                    this.this$0 = $receiver;
                    this.$tpatSender = $tpatSender;
                }

                /*
                 * WARNING - void declaration
                 */
                public void onDeeplinkClick(boolean opened) {
                    block1: {
                        void $this$forEach$iv;
                        List deeplinkClickTpatUrls;
                        AdPayload adPayload = NativeAdPresenter.access$getAdvertisement$p(this.this$0);
                        List list = deeplinkClickTpatUrls = adPayload != null ? AdPayload.getTpatUrls$default(adPayload, "deeplink.click", String.valueOf(opened), null, 4, null) : null;
                        if (list == null) break block1;
                        Iterable iterable = list;
                        TpatSender tpatSender = this.$tpatSender;
                        NativeAdPresenter nativeAdPresenter = this.this$0;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            String url = (String)element$iv;
                            boolean bl = false;
                            tpatSender.sendTpat(url, NativeAdPresenter.access$getExecutor$p(nativeAdPresenter));
                        }
                    }
                }
            });
            AdEventListener adEventListener2 = this.bus;
            if (adEventListener2 == null) break block4;
            adEventListener2.onNext("open", "adClick", this.delegate.getPlacementRefId());
        }
    }

    private final void onPrivacy(String privacyUrl) {
        block2: {
            String string = privacyUrl;
            if (string == null) break block2;
            String it = string;
            boolean bl = false;
            if (!FileUtility.INSTANCE.isValidUrl(privacyUrl)) {
                AdPayload adPayload = this.advertisement;
                AdPayload adPayload2 = this.advertisement;
                new PrivacyUrlError(it).setPlacementId$vungle_ads_release(this.delegate.getPlacementRefId()).setCreativeId$vungle_ads_release(adPayload != null ? adPayload.getCreativeId() : null).setEventId$vungle_ads_release(adPayload2 != null ? adPayload2.eventId() : null).logErrorNoReturnValue$vungle_ads_release();
                return;
            }
            boolean launched = ExternalRouter.launch(null, it, this.context, new PresenterAppLeftCallback(this.bus, this.delegate.getPlacementRefId()), null);
            if (!launched) {
                new PrivacyUrlError(it).logErrorNoReturnValue$vungle_ads_release();
            }
        }
    }

    public final void prepare() {
        this.start();
        AdEventListener adEventListener2 = this.bus;
        if (adEventListener2 != null) {
            adEventListener2.onNext("start", null, this.delegate.getPlacementRefId());
        }
        this.adStartTime = System.currentTimeMillis();
    }

    private final void start() {
        if (this.needShowGdpr()) {
            this.showGdpr();
        }
    }

    public final void detach() {
        block5: {
            NativeOMTracker nativeOMTracker = this.omTracker;
            if (nativeOMTracker != null) {
                nativeOMTracker.stop();
            }
            Dialog dialog = this.currentDialog;
            if (dialog != null) {
                Dialog $this$detach_u24lambda_u2d5 = dialog;
                boolean bl = false;
                if ($this$detach_u24lambda_u2d5.isShowing()) {
                    $this$detach_u24lambda_u2d5.dismiss();
                }
            }
            Long l = this.adStartTime;
            if (l != null) {
                List<String> list;
                Long l2 = l;
                long it = ((Number)l2).longValue();
                boolean bl = false;
                long duration = System.currentTimeMillis() - it;
                AdPayload adPayload = this.advertisement;
                AdPayload adPayload2 = this.advertisement;
                AdPayload adPayload3 = this.advertisement;
                TpatSender tpatSender = new TpatSender(this.getVungleApiClient(), adPayload != null ? adPayload.placementId() : null, adPayload2 != null ? adPayload2.getCreativeId() : null, adPayload3 != null ? adPayload3.eventId() : null, this.getExecutors().getIoExecutor(), this.getPathProvider(), this.getSignalManager());
                AdPayload adPayload4 = this.advertisement;
                if (adPayload4 != null && (list = adPayload4.getTpatUrls("ad.close", String.valueOf(duration), String.valueOf(this.platform.getVolumeLevel()))) != null) {
                    List<String> it2 = list;
                    boolean bl2 = false;
                    tpatSender.sendTpats((Iterable<String>)it2, this.executor);
                }
            }
            AdEventListener adEventListener2 = this.bus;
            if (adEventListener2 == null) break block5;
            adEventListener2.onNext("end", null, this.delegate.getPlacementRefId());
        }
    }

    private final boolean needShowGdpr() {
        return ConfigManager.INSTANCE.getGDPRIsCountryDataProtected() && Intrinsics.areEqual((Object)"unknown", (Object)PrivacyManager.INSTANCE.getConsentStatus());
    }

    private final void showGdpr() {
        PrivacyManager.INSTANCE.updateGdprConsent("opted_out_by_timeout", "vungle_modal", null);
        if (!(this.context instanceof Activity)) {
            Logger.Companion.w(TAG, "We can not show GDPR dialog with application context.");
            return;
        }
        DialogInterface.OnClickListener listener = (arg_0, arg_1) -> NativeAdPresenter.showGdpr$lambda-8(this, arg_0, arg_1);
        String dialogTitle = ConfigManager.INSTANCE.getGDPRConsentTitle();
        String dialogBody = ConfigManager.INSTANCE.getGDPRConsentMessage();
        String dialogContinue = ConfigManager.INSTANCE.getGDPRButtonAccept();
        String dialogClose = ConfigManager.INSTANCE.getGDPRButtonDeny();
        AlertDialog.Builder dialogBuilder = new AlertDialog.Builder((Context)new ContextThemeWrapper(this.context, ((Activity)this.context).getApplicationInfo().theme));
        CharSequence charSequence = dialogTitle;
        if (!(charSequence == null || charSequence.length() == 0)) {
            dialogBuilder.setTitle((CharSequence)dialogTitle);
        }
        if (!((charSequence = (CharSequence)dialogBody) == null || charSequence.length() == 0)) {
            dialogBuilder.setMessage((CharSequence)dialogBody);
        }
        dialogBuilder.setPositiveButton((CharSequence)dialogContinue, listener);
        dialogBuilder.setNegativeButton((CharSequence)dialogClose, listener);
        dialogBuilder.setCancelable(false);
        AlertDialog dialog = dialogBuilder.create();
        dialog.setOnDismissListener(arg_0 -> NativeAdPresenter.showGdpr$lambda-9(this, arg_0));
        this.currentDialog = (Dialog)dialog;
        dialog.show();
    }

    public final void initOMTracker(@NotNull String omSdkData) {
        Intrinsics.checkNotNullParameter((Object)omSdkData, (String)"omSdkData");
        AdPayload adPayload = this.advertisement;
        boolean adOmEnabled = adPayload != null ? adPayload.omEnabled() : false;
        if (((CharSequence)omSdkData).length() > 0 && ConfigManager.INSTANCE.omEnabled() && adOmEnabled) {
            this.omTracker = new NativeOMTracker(omSdkData);
        }
    }

    public final void startTracking(@NotNull View rootView) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
            NativeOMTracker nativeOMTracker = this.omTracker;
            if (nativeOMTracker == null) break block0;
            nativeOMTracker.start(rootView);
        }
    }

    public final void onImpression() {
        block0: {
            NativeOMTracker nativeOMTracker = this.omTracker;
            if (nativeOMTracker == null) break block0;
            nativeOMTracker.impressionOccurred();
        }
    }

    private static final void showGdpr$lambda-8(NativeAdPresenter this$0, DialogInterface dialogInterface, int which) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String consented = "opted_out_by_timeout";
        switch (which) {
            case -2: {
                consented = PrivacyConsent.OPT_OUT.getValue();
                break;
            }
            case -1: {
                consented = PrivacyConsent.OPT_IN.getValue();
            }
        }
        PrivacyManager.INSTANCE.updateGdprConsent(consented, "vungle_modal", null);
        this$0.start();
    }

    private static final void showGdpr$lambda-9(NativeAdPresenter this$0, DialogInterface it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.currentDialog = null;
    }

    public static final /* synthetic */ AdPayload access$getAdvertisement$p(NativeAdPresenter $this) {
        return $this.advertisement;
    }

    public static final /* synthetic */ Executor access$getExecutor$p(NativeAdPresenter $this) {
        return $this.executor;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/vungle/ads/internal/presenter/NativeAdPresenter$Companion;", "", "()V", "DOWNLOAD", "", "OPEN_PRIVACY", "TAG", "TPAT", "VIDEO_VIEWED", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

