/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.network;

import androidx.annotation.VisibleForTesting;
import com.vungle.ads.AnalyticsClient;
import com.vungle.ads.TpatRetryFailure;
import com.vungle.ads.internal.load.BaseAdLoader;
import com.vungle.ads.internal.network.VungleApiClient;
import com.vungle.ads.internal.persistence.FilePreferences;
import com.vungle.ads.internal.protos.Sdk;
import com.vungle.ads.internal.signals.SignalManager;
import com.vungle.ads.internal.util.Logger;
import com.vungle.ads.internal.util.PathProvider;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.text.Regex;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u001c\n\u0002\b\u0004\u0018\u0000 +2\u00020\u0001:\u0001+BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ$\u0010\u0019\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001b0\u001aj\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001b`\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005H\u0007J\u0015\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\"J,\u0010#\u001a\u00020 2\"\u0010$\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001b0\u001aj\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001b`\u001cH\u0002J\u0016\u0010%\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\tJ\u001c\u0010&\u001a\u00020 2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00050(2\u0006\u0010!\u001a\u00020\tJ\u0016\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\tR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006,"}, d2={"Lcom/vungle/ads/internal/network/TpatSender;", "", "vungleApiClient", "Lcom/vungle/ads/internal/network/VungleApiClient;", "placementId", "", "creativeId", "eventId", "ioExecutor", "Ljava/util/concurrent/Executor;", "pathProvider", "Lcom/vungle/ads/internal/util/PathProvider;", "signalManager", "Lcom/vungle/ads/internal/signals/SignalManager;", "(Lcom/vungle/ads/internal/network/VungleApiClient;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/concurrent/Executor;Lcom/vungle/ads/internal/util/PathProvider;Lcom/vungle/ads/internal/signals/SignalManager;)V", "getCreativeId", "()Ljava/lang/String;", "getEventId", "getPlacementId", "getSignalManager", "()Lcom/vungle/ads/internal/signals/SignalManager;", "tpatFilePreferences", "Lcom/vungle/ads/internal/persistence/FilePreferences;", "getVungleApiClient", "()Lcom/vungle/ads/internal/network/VungleApiClient;", "getStoredTpats", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "injectSessionIdToUrl", "url", "resendStoredTpats", "", "executor", "resendStoredTpats$vungle_ads_release", "saveStoredTpats", "tpats", "sendTpat", "sendTpats", "urls", "", "sendWinNotification", "urlString", "Companion", "vungle-ads_release"})
public final class TpatSender {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VungleApiClient vungleApiClient;
    @Nullable
    private final String placementId;
    @Nullable
    private final String creativeId;
    @Nullable
    private final String eventId;
    @Nullable
    private final SignalManager signalManager;
    @NotNull
    private final FilePreferences tpatFilePreferences;
    @NotNull
    private static final String TAG = "TpatSender";
    @NotNull
    private static final String FAILED_TPATS = "FAILED_TPATS";
    private static final int MAX_RETRIES = 5;

    public TpatSender(@NotNull VungleApiClient vungleApiClient, @Nullable String placementId, @Nullable String creativeId, @Nullable String eventId, @NotNull Executor ioExecutor, @NotNull PathProvider pathProvider, @Nullable SignalManager signalManager) {
        Intrinsics.checkNotNullParameter((Object)vungleApiClient, (String)"vungleApiClient");
        Intrinsics.checkNotNullParameter((Object)ioExecutor, (String)"ioExecutor");
        Intrinsics.checkNotNullParameter((Object)pathProvider, (String)"pathProvider");
        this.vungleApiClient = vungleApiClient;
        this.placementId = placementId;
        this.creativeId = creativeId;
        this.eventId = eventId;
        this.signalManager = signalManager;
        this.tpatFilePreferences = FilePreferences.Companion.get(ioExecutor, pathProvider, "failedTpats");
    }

    public /* synthetic */ TpatSender(VungleApiClient vungleApiClient, String string, String string2, String string3, Executor executor, PathProvider pathProvider, SignalManager signalManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            signalManager = null;
        }
        this(vungleApiClient, string, string2, string3, executor, pathProvider, signalManager);
    }

    @NotNull
    public final VungleApiClient getVungleApiClient() {
        return this.vungleApiClient;
    }

    @Nullable
    public final String getPlacementId() {
        return this.placementId;
    }

    @Nullable
    public final String getCreativeId() {
        return this.creativeId;
    }

    @Nullable
    public final String getEventId() {
        return this.eventId;
    }

    @Nullable
    public final SignalManager getSignalManager() {
        return this.signalManager;
    }

    public final void sendWinNotification(@NotNull String urlString, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        String url = this.injectSessionIdToUrl(urlString);
        executor.execute(() -> TpatSender.sendWinNotification$lambda-0(this, url));
    }

    public final void sendTpats(@NotNull Iterable<String> urls, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Iterable<String> $this$forEach$iv = urls;
        boolean $i$f$forEach = false;
        Iterator<String> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            String element$iv;
            String it = element$iv = iterator.next();
            boolean bl = false;
            this.sendTpat(it, executor);
        }
    }

    public final void sendTpat(@NotNull String url, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        String urlWithSessionId = this.injectSessionIdToUrl(url);
        executor.execute(() -> TpatSender.sendTpat$lambda-2(this, url, urlWithSessionId));
    }

    private final HashMap<String, Integer> getStoredTpats() {
        HashMap hashMap;
        String storedTpats = this.tpatFilePreferences.getString(FAILED_TPATS);
        try {
            HashMap hashMap2;
            if (storedTpats != null) {
                StringFormat $this$decodeFromString$iv = (StringFormat)Json.Default;
                boolean $i$f$decodeFromString = false;
                SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
                boolean $i$f$serializer = false;
                KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(HashMap.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(String.class)), (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE))));
                boolean $i$f$cast = false;
                Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
                hashMap2 = (HashMap)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, storedTpats);
            } else {
                hashMap2 = new HashMap();
            }
            hashMap = hashMap2;
        }
        catch (Exception e2) {
            Logger.Companion.e(TAG, "Failed to decode stored tpats: " + storedTpats);
            hashMap = new HashMap();
        }
        return hashMap;
    }

    private final void saveStoredTpats(HashMap<String, Integer> tpats) {
        try {
            StringFormat $this$encodeToString$iv = (StringFormat)Json.Default;
            boolean $i$f$encodeToString = false;
            SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(HashMap.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(String.class)), (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE))));
            boolean $i$f$cast = false;
            Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
            this.tpatFilePreferences.put(FAILED_TPATS, $this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, tpats)).apply();
        }
        catch (Exception e2) {
            Logger.Companion.e(TAG, "Failed to encode the about to storing tpats: " + tpats);
        }
    }

    public final void resendStoredTpats$vungle_ads_release(@NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Map $this$forEach$iv = this.getStoredTpats();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String url = (String)entry.getKey();
            this.sendTpat(url, executor);
        }
    }

    @VisibleForTesting
    @NotNull
    public final String injectSessionIdToUrl(@NotNull String url) {
        String string;
        Object sessionId;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Object object = this.signalManager;
        if (object == null || (object = ((SignalManager)object).getUuid()) == null) {
            object = "";
        }
        if (((CharSequence)(sessionId = object)).length() > 0) {
            CharSequence charSequence = url;
            String string2 = Pattern.quote("{{{session_id}}}");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"quote(Constants.SESSION_ID)");
            String string3 = string2;
            string = new Regex(string3).replace(charSequence, (String)sessionId);
        } else {
            string = url;
        }
        return string;
    }

    private static final void sendWinNotification$lambda-0(TpatSender this$0, String $url) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$url, (String)"$url");
        BaseAdLoader.ErrorInfo error = this$0.vungleApiClient.pingTPAT($url);
        if (error != null) {
            AnalyticsClient.INSTANCE.logError$vungle_ads_release(Sdk.SDKError.Reason.AD_WIN_NOTIFICATION_ERROR, "Fail to send " + $url + ", error: " + error.getDescription(), this$0.placementId, this$0.creativeId, this$0.eventId);
        }
    }

    private static final void sendTpat$lambda-2(TpatSender this$0, String $url, String $urlWithSessionId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$url, (String)"$url");
        Intrinsics.checkNotNullParameter((Object)$urlWithSessionId, (String)"$urlWithSessionId");
        HashMap<String, Integer> storedTpats = this$0.getStoredTpats();
        Integer n = storedTpats.get($url);
        if (n == null) {
            n = 0;
        }
        int attemptNumber = ((Number)n).intValue();
        BaseAdLoader.ErrorInfo error = this$0.vungleApiClient.pingTPAT($urlWithSessionId);
        if (error == null) {
            if (attemptNumber != 0) {
                storedTpats.remove($url);
                this$0.saveStoredTpats(storedTpats);
            }
        } else {
            if (!error.getErrorIsTerminal()) {
                if (attemptNumber >= 5) {
                    storedTpats.remove($url);
                    this$0.saveStoredTpats(storedTpats);
                    new TpatRetryFailure($urlWithSessionId).logErrorNoReturnValue$vungle_ads_release();
                } else {
                    ((Map)storedTpats).put($url, attemptNumber + 1);
                    this$0.saveStoredTpats(storedTpats);
                }
            }
            Logger.Companion.e(TAG, "TPAT failed with " + error.getDescription() + ", url:" + $urlWithSessionId);
            if (error.getReason() == 29) {
                AnalyticsClient.logMetric$vungle_ads_release$default(AnalyticsClient.INSTANCE, Sdk.SDKMetric.SDKMetricType.NOTIFICATION_REDIRECT, 0L, this$0.placementId, null, null, $urlWithSessionId, 26, null);
            } else {
                AnalyticsClient.INSTANCE.logError$vungle_ads_release(Sdk.SDKError.Reason.TPAT_ERROR, "Fail to send " + $urlWithSessionId + ", error: " + error.getDescription(), this$0.placementId, this$0.creativeId, this$0.eventId);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/vungle/ads/internal/network/TpatSender$Companion;", "", "()V", "FAILED_TPATS", "", "MAX_RETRIES", "", "TAG", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

