/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal;

import android.content.Context;
import androidx.annotation.VisibleForTesting;
import androidx.core.content.PermissionChecker;
import com.vungle.ads.AnalyticsClient;
import com.vungle.ads.InitializationListener;
import com.vungle.ads.InvalidAppId;
import com.vungle.ads.NetworkPermissionsNotGranted;
import com.vungle.ads.OutOfMemory;
import com.vungle.ads.SdkVersionTooLow;
import com.vungle.ads.ServiceLocator;
import com.vungle.ads.VungleAds;
import com.vungle.ads.VungleError;
import com.vungle.ads.internal.ConfigManager;
import com.vungle.ads.internal.downloader.Downloader;
import com.vungle.ads.internal.executor.Executors;
import com.vungle.ads.internal.load.MraidJsLoader;
import com.vungle.ads.internal.model.ConfigPayload;
import com.vungle.ads.internal.network.VungleApiClient;
import com.vungle.ads.internal.persistence.FilePreferences;
import com.vungle.ads.internal.platform.Platform;
import com.vungle.ads.internal.privacy.PrivacyManager;
import com.vungle.ads.internal.signals.SignalManager;
import com.vungle.ads.internal.task.CleanupJob;
import com.vungle.ads.internal.task.JobRunner;
import com.vungle.ads.internal.task.ResendTpatJob;
import com.vungle.ads.internal.util.ActivityManager;
import com.vungle.ads.internal.util.Logger;
import com.vungle.ads.internal.util.PathProvider;
import com.vungle.ads.internal.util.ThreadUtil;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\r\u0010\u0013\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0014J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0005J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0006\u0010\u0006\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u000eH\u0002J\u0016\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0012R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0006\u001a\u00020\u00078\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006#\u00b2\u0006\n\u0010$\u001a\u00020%X\u008a\u0084\u0002\u00b2\u0006\n\u0010&\u001a\u00020'X\u008a\u0084\u0002\u00b2\u0006\n\u0010(\u001a\u00020)X\u008a\u0084\u0002\u00b2\u0006\n\u0010(\u001a\u00020)X\u008a\u0084\u0002\u00b2\u0006\n\u0010*\u001a\u00020+X\u008a\u0084\u0002\u00b2\u0006\n\u0010&\u001a\u00020'X\u008a\u0084\u0002\u00b2\u0006\n\u0010,\u001a\u00020-X\u008a\u0084\u0002\u00b2\u0006\n\u0010.\u001a\u00020/X\u008a\u0084\u0002\u00b2\u0006\n\u00100\u001a\u000201X\u008a\u0084\u0002\u00b2\u0006\n\u00102\u001a\u000203X\u008a\u0084\u0002\u00b2\u0006\n\u0010&\u001a\u00020'X\u008a\u0084\u0002"}, d2={"Lcom/vungle/ads/internal/VungleInitializer;", "", "()V", "initializationCallbackArray", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/vungle/ads/InitializationListener;", "isInitialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isInitialized$vungle_ads_release$annotations", "isInitialized$vungle_ads_release", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "setInitialized$vungle_ads_release", "(Ljava/util/concurrent/atomic/AtomicBoolean;)V", "configure", "", "context", "Landroid/content/Context;", "appId", "", "deInit", "deInit$vungle_ads_release", "downloadMraidJs", "init", "initializationCallback", "isAppIdInvalid", "", "onInitError", "exception", "Lcom/vungle/ads/VungleError;", "onInitSuccess", "setIntegrationName", "wrapperFramework", "Lcom/vungle/ads/VungleAds$WrapperFramework;", "wrapperFrameworkVersion", "Companion", "vungle-ads_release", "platform", "Lcom/vungle/ads/internal/platform/Platform;", "sdkExecutors", "Lcom/vungle/ads/internal/executor/Executors;", "vungleApiClient", "Lcom/vungle/ads/internal/network/VungleApiClient;", "filePreferences", "Lcom/vungle/ads/internal/persistence/FilePreferences;", "signalManager", "Lcom/vungle/ads/internal/signals/SignalManager;", "jobRunner", "Lcom/vungle/ads/internal/task/JobRunner;", "pathProvider", "Lcom/vungle/ads/internal/util/PathProvider;", "downloader", "Lcom/vungle/ads/internal/downloader/Downloader;"})
public final class VungleInitializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private AtomicBoolean isInitialized = new AtomicBoolean(false);
    @NotNull
    private final CopyOnWriteArrayList<InitializationListener> initializationCallbackArray = new CopyOnWriteArrayList();
    @NotNull
    private static final String TAG = "VungleInitializer";

    @NotNull
    public final AtomicBoolean isInitialized$vungle_ads_release() {
        return this.isInitialized;
    }

    public final void setInitialized$vungle_ads_release(@NotNull AtomicBoolean atomicBoolean) {
        Intrinsics.checkNotNullParameter((Object)atomicBoolean, (String)"<set-?>");
        this.isInitialized = atomicBoolean;
    }

    @VisibleForTesting
    public static /* synthetic */ void isInitialized$vungle_ads_release$annotations() {
    }

    public final void init(@NotNull String appId, @NotNull Context context, @NotNull InitializationListener initializationCallback) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)initializationCallback, (String)"initializationCallback");
        this.initializationCallbackArray.add(initializationCallback);
        ActivityManager.Companion.init(context);
        if (this.isAppIdInvalid(appId)) {
            this.onInitError(new InvalidAppId().logError$vungle_ads_release());
            return;
        }
        ServiceLocator.Companion this_$iv = ServiceLocator.Companion;
        boolean $i$f$inject = false;
        Lazy platform$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<Platform>(context){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final Platform invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(Platform.class);
            }
        }));
        if (!VungleInitializer.init$lambda-0((Lazy<? extends Platform>)platform$delegate).isAtLeastMinimumSDK()) {
            Logger.Companion.e(TAG, "SDK is supported only for API versions 21 and above");
            this.onInitError(new SdkVersionTooLow().logError$vungle_ads_release());
            return;
        }
        ConfigManager.INSTANCE.setAppId$vungle_ads_release(appId);
        if (this.isInitialized.get()) {
            Logger.Companion.d(TAG, "init already complete");
            this.onInitSuccess();
            return;
        }
        if (PermissionChecker.checkCallingOrSelfPermission((Context)context, (String)"android.permission.ACCESS_NETWORK_STATE") != 0 || PermissionChecker.checkCallingOrSelfPermission((Context)context, (String)"android.permission.INTERNET") != 0) {
            Logger.Companion.e(TAG, "Network permissions not granted");
            this.onInitError(new NetworkPermissionsNotGranted());
            return;
        }
        ServiceLocator.Companion this_$iv2 = ServiceLocator.Companion;
        boolean $i$f$inject2 = false;
        Lazy sdkExecutors$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<Executors>(context){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final Executors invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(Executors.class);
            }
        }));
        ServiceLocator.Companion this_$iv3 = ServiceLocator.Companion;
        boolean $i$f$inject3 = false;
        Lazy vungleApiClient$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<VungleApiClient>(context){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final VungleApiClient invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(VungleApiClient.class);
            }
        }));
        VungleInitializer.init$lambda-1((Lazy<? extends Executors>)sdkExecutors$delegate).getBackgroundExecutor().execute(() -> VungleInitializer.init$lambda-3(context, appId, this, vungleApiClient$delegate), () -> VungleInitializer.init$lambda-4(this));
    }

    private final boolean isAppIdInvalid(String appId) {
        return StringsKt.isBlank((CharSequence)appId);
    }

    private final void configure(Context context, String appId) {
        ServiceLocator.Companion this_$iv = ServiceLocator.Companion;
        boolean $i$f$inject = false;
        Lazy vungleApiClient$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<VungleApiClient>(context){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final VungleApiClient invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(VungleApiClient.class);
            }
        }));
        try {
            boolean fromCachedConfig = false;
            ServiceLocator.Companion this_$iv2 = ServiceLocator.Companion;
            boolean $i$f$inject2 = false;
            Lazy filePreferences$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<FilePreferences>(context){
                final /* synthetic */ Context $context;
                {
                    this.$context = $context;
                    super(0);
                }

                @NotNull
                public final FilePreferences invoke() {
                    return ServiceLocator.Companion.getInstance(this.$context).getService(FilePreferences.class);
                }
            }));
            ConfigPayload initialConfigPayload = ConfigManager.INSTANCE.getCachedConfig(VungleInitializer.configure$lambda-6((Lazy<FilePreferences>)filePreferences$delegate), appId);
            if (initialConfigPayload != null) {
                fromCachedConfig = true;
                ConfigManager.initWithConfig$vungle_ads_release$default(ConfigManager.INSTANCE, context, initialConfigPayload, true, null, 8, null);
            }
            ServiceLocator.Companion this_$iv3 = ServiceLocator.Companion;
            boolean $i$f$inject3 = false;
            Lazy sdkExecutors$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<Executors>(context){
                final /* synthetic */ Context $context;
                {
                    this.$context = $context;
                    super(0);
                }

                @NotNull
                public final Executors invoke() {
                    return ServiceLocator.Companion.getInstance(this.$context).getService(Executors.class);
                }
            }));
            ServiceLocator.Companion this_$iv4 = ServiceLocator.Companion;
            boolean $i$f$inject4 = false;
            Lazy signalManager$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<SignalManager>(context){
                final /* synthetic */ Context $context;
                {
                    this.$context = $context;
                    super(0);
                }

                @NotNull
                public final SignalManager invoke() {
                    return ServiceLocator.Companion.getInstance(this.$context).getService(SignalManager.class);
                }
            }));
            AnalyticsClient.INSTANCE.init$vungle_ads_release(VungleInitializer.configure$lambda-5((Lazy<VungleApiClient>)vungleApiClient$delegate), VungleInitializer.configure$lambda-7((Lazy<? extends Executors>)sdkExecutors$delegate).getLoggerExecutor(), ConfigManager.INSTANCE.getLogLevel(), ConfigManager.INSTANCE.getMetricsEnabled(), VungleInitializer.configure$lambda-8((Lazy<SignalManager>)signalManager$delegate));
            this.isInitialized.set(true);
            this.onInitSuccess();
            Logger.Companion.d(TAG, "Running cleanup and resend tpat jobs. " + Thread.currentThread().getId());
            ServiceLocator.Companion this_$iv5 = ServiceLocator.Companion;
            boolean $i$f$inject5 = false;
            Lazy jobRunner$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<JobRunner>(context){
                final /* synthetic */ Context $context;
                {
                    this.$context = $context;
                    super(0);
                }

                @NotNull
                public final JobRunner invoke() {
                    return ServiceLocator.Companion.getInstance(this.$context).getService(JobRunner.class);
                }
            }));
            VungleInitializer.configure$lambda-9((Lazy<? extends JobRunner>)jobRunner$delegate).execute(CleanupJob.Companion.makeJobInfo$default(CleanupJob.Companion, null, 1, null));
            VungleInitializer.configure$lambda-9((Lazy<? extends JobRunner>)jobRunner$delegate).execute(ResendTpatJob.Companion.makeJobInfo());
            if (!fromCachedConfig) {
                ConfigManager.INSTANCE.fetchConfigAsync$vungle_ads_release(context, (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(this, context){
                    final /* synthetic */ VungleInitializer this$0;
                    final /* synthetic */ Context $context;
                    {
                        this.this$0 = $receiver;
                        this.$context = $context;
                        super(1);
                    }

                    public final void invoke(boolean result) {
                        if (result) {
                            VungleInitializer.access$downloadMraidJs(this.this$0, this.$context);
                        }
                    }
                }));
            } else {
                this.downloadMraidJs(context);
            }
        }
        catch (Throwable throwable) {
            Logger.Companion.e(TAG, "Cannot get config", throwable);
        }
    }

    private final void downloadMraidJs(Context context) {
        ServiceLocator.Companion this_$iv = ServiceLocator.Companion;
        boolean $i$f$inject = false;
        Lazy pathProvider$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<PathProvider>(context){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final PathProvider invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(PathProvider.class);
            }
        }));
        ServiceLocator.Companion this_$iv2 = ServiceLocator.Companion;
        boolean $i$f$inject2 = false;
        Lazy downloader$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<Downloader>(context){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final Downloader invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(Downloader.class);
            }
        }));
        ServiceLocator.Companion this_$iv3 = ServiceLocator.Companion;
        boolean $i$f$inject3 = false;
        Lazy sdkExecutors$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<Executors>(context){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final Executors invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(Executors.class);
            }
        }));
        MraidJsLoader.downloadJs$default(MraidJsLoader.INSTANCE, VungleInitializer.downloadMraidJs$lambda-10((Lazy<PathProvider>)pathProvider$delegate), VungleInitializer.downloadMraidJs$lambda-11((Lazy<? extends Downloader>)downloader$delegate), VungleInitializer.downloadMraidJs$lambda-12((Lazy<? extends Executors>)sdkExecutors$delegate).getBackgroundExecutor(), null, 8, null);
    }

    private final void onInitError(VungleError exception) {
        ThreadUtil.INSTANCE.runOnUiThread(() -> VungleInitializer.onInitError$lambda-14(this, exception));
        String string = exception.getLocalizedMessage();
        if (string == null) {
            string = "Exception code is " + exception.getCode();
        }
        String exMsg = string;
        Logger.Companion.e(TAG, exMsg);
    }

    private final void onInitSuccess() {
        Logger.Companion.d(TAG, "onSuccess " + Thread.currentThread().getId());
        ThreadUtil.INSTANCE.runOnUiThread(() -> VungleInitializer.onInitSuccess$lambda-16(this));
    }

    public final boolean isInitialized() {
        return this.isInitialized.get();
    }

    public final void deInit$vungle_ads_release() {
        ServiceLocator.Companion.deInit();
        VungleApiClient.Companion.reset$vungle_ads_release();
        this.isInitialized.set(false);
    }

    public final void setIntegrationName(@NotNull VungleAds.WrapperFramework wrapperFramework, @NotNull String wrapperFrameworkVersion) {
        Intrinsics.checkNotNullParameter((Object)((Object)wrapperFramework), (String)"wrapperFramework");
        Intrinsics.checkNotNullParameter((Object)wrapperFrameworkVersion, (String)"wrapperFrameworkVersion");
        if (wrapperFramework == VungleAds.WrapperFramework.none) {
            Logger.Companion.e(TAG, "Wrapper is null or is none");
            return;
        }
        String originalHeader = VungleApiClient.Companion.getHeaderUa();
        String wrapperVersion = ((CharSequence)wrapperFrameworkVersion).length() > 0 ? '/' + wrapperFrameworkVersion : "";
        String newMediation = wrapperFramework.name() + wrapperVersion;
        if (StringsKt.contains$default((CharSequence)originalHeader, (CharSequence)newMediation, (boolean)false, (int)2, null)) {
            Logger.Companion.w(TAG, "Wrapper info already set");
            return;
        }
        VungleApiClient.Companion.setHeaderUa(originalHeader + ';' + newMediation);
        if (this.isInitialized()) {
            Logger.Companion.w(TAG, "VUNGLE WARNING: SDK already initialized, you should've set wrapper info before");
        }
    }

    private static final Platform init$lambda-0(Lazy<? extends Platform> $platform$delegate) {
        Lazy<? extends Platform> lazy = $platform$delegate;
        return (Platform)lazy.getValue();
    }

    private static final Executors init$lambda-1(Lazy<? extends Executors> $sdkExecutors$delegate) {
        Lazy<? extends Executors> lazy = $sdkExecutors$delegate;
        return (Executors)lazy.getValue();
    }

    private static final VungleApiClient init$lambda-2(Lazy<VungleApiClient> $vungleApiClient$delegate) {
        Lazy<VungleApiClient> lazy = $vungleApiClient$delegate;
        return (VungleApiClient)lazy.getValue();
    }

    private static final void init$lambda-3(Context $context, String $appId, VungleInitializer this$0, Lazy $vungleApiClient$delegate) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$appId, (String)"$appId");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$vungleApiClient$delegate, (String)"$vungleApiClient$delegate");
        PrivacyManager.INSTANCE.init($context);
        VungleInitializer.init$lambda-2((Lazy<VungleApiClient>)$vungleApiClient$delegate).initialize($appId);
        this$0.configure($context, $appId);
    }

    private static final void init$lambda-4(VungleInitializer this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.onInitError(new OutOfMemory("Config: Out of Memory").logError$vungle_ads_release());
    }

    private static final VungleApiClient configure$lambda-5(Lazy<VungleApiClient> $vungleApiClient$delegate) {
        Lazy<VungleApiClient> lazy = $vungleApiClient$delegate;
        return (VungleApiClient)lazy.getValue();
    }

    private static final FilePreferences configure$lambda-6(Lazy<FilePreferences> $filePreferences$delegate) {
        Lazy<FilePreferences> lazy = $filePreferences$delegate;
        return (FilePreferences)lazy.getValue();
    }

    private static final Executors configure$lambda-7(Lazy<? extends Executors> $sdkExecutors$delegate) {
        Lazy<? extends Executors> lazy = $sdkExecutors$delegate;
        return (Executors)lazy.getValue();
    }

    private static final SignalManager configure$lambda-8(Lazy<SignalManager> $signalManager$delegate) {
        Lazy<SignalManager> lazy = $signalManager$delegate;
        return (SignalManager)lazy.getValue();
    }

    private static final JobRunner configure$lambda-9(Lazy<? extends JobRunner> $jobRunner$delegate) {
        Lazy<? extends JobRunner> lazy = $jobRunner$delegate;
        return (JobRunner)lazy.getValue();
    }

    private static final PathProvider downloadMraidJs$lambda-10(Lazy<PathProvider> $pathProvider$delegate) {
        Lazy<PathProvider> lazy = $pathProvider$delegate;
        return (PathProvider)lazy.getValue();
    }

    private static final Downloader downloadMraidJs$lambda-11(Lazy<? extends Downloader> $downloader$delegate) {
        Lazy<? extends Downloader> lazy = $downloader$delegate;
        return (Downloader)lazy.getValue();
    }

    private static final Executors downloadMraidJs$lambda-12(Lazy<? extends Executors> $sdkExecutors$delegate) {
        Lazy<? extends Executors> lazy = $sdkExecutors$delegate;
        return (Executors)lazy.getValue();
    }

    private static final void onInitError$lambda-14(VungleInitializer this$0, VungleError $exception) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$exception, (String)"$exception");
        Logger.Companion.e(TAG, "onError");
        Iterable $this$forEach$iv = this$0.initializationCallbackArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InitializationListener it = (InitializationListener)element$iv;
            boolean bl = false;
            it.onError($exception);
        }
        this$0.initializationCallbackArray.clear();
    }

    private static final void onInitSuccess$lambda-16(VungleInitializer this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$forEach$iv = this$0.initializationCallbackArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InitializationListener it = (InitializationListener)element$iv;
            boolean bl = false;
            it.onSuccess();
        }
        this$0.initializationCallbackArray.clear();
    }

    public static final /* synthetic */ void access$downloadMraidJs(VungleInitializer $this, Context context) {
        $this.downloadMraidJs(context);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/vungle/ads/internal/VungleInitializer$Companion;", "", "()V", "TAG", "", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

