package com.vungle.ads.internal.util

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.media.AudioManager
import com.vungle.ads.internal.ui.VungleWebClient

internal class RingerModeReceiver : BroadcastReceiver() {

    var webClient: VungleWebClient? = null
    override fun onReceive(context: Context?, intent: Intent?) {
        try {
            if (intent?.action == AudioManager.RINGER_MODE_CHANGED_ACTION) {
                // Handle the RINGER_MODE_CHANGED broadcast here
                val ringerMode = intent.getIntExtra(AudioManager.EXTRA_RINGER_MODE, -1)
                Logger.d("RingerModeReceiver", "receive ringermode: $ringerMode")
                when (ringerMode) {
                    AudioManager.RINGER_MODE_NORMAL -> {
                        webClient?.notifySilentModeChange(false)
                    }

                    AudioManager.RINGER_MODE_SILENT -> {
                        // Ringer mode changed to silent
                        webClient?.notifySilentModeChange(true)
                    }

                    AudioManager.RINGER_MODE_VIBRATE -> {
                        // Ringer mode changed to vibrate
                        webClient?.notifySilentModeChange(true)

                    }
                }
            }
        } catch (ex: Exception) {
            ex.localizedMessage?.let { Logger.e("RingerModeReceiver", it) }
        }

    }
}