package com.vungle.ads.internal

internal object Constants {
    const val MRAID_JS_FILE_NAME = "mraid.min.js"
    @JvmField
    val DEFAULT_ADS_ENDPOINT = "https://adx.ads.vungle.com/api/ads"
    @JvmField
    val DEFAULT_ERROR_LOGS_ENDPOINT = "https://events.ads.vungle.com/sdk/error_logs"
    @JvmField
    val DEFAULT_METRICS_ENDPOINT = "https://events.ads.vungle.com/sdk/metrics"

    //TPAT Events
    const val CHECKPOINT_0 = "checkpoint.0"
    const val REMOTE_PLAY_KEY = "{{{remote_play}}}"
    const val DEEPLINK_CLICK = "deeplink.click"
    const val DEEPLINK_SUCCESS_KEY = "{{{is_success}}}"
    const val SESSION_ID = "{{{session_id}}}"

    const val AD_CLOSE_TPAT_KEY = "ad.close"
    const val AD_LOAD_DURATION_TPAT_KEY = "ad.loadDuration"

    /** Total time that user spent on watching Ad
    In topic schema 'ad_duration', long */
    const val AD_DURATION_KEY = "{{{dur}}}"

    /** Network Carrier
    In topic schema 'network_operator', string */
    const val NETWORK_OPERATOR_KEY = "{{{carrier}}}"

    /** Time taken from publisher ad request to delegate callback that ad is available.
     * Including viewed and non-viewed Ad, so sent during ad load".
     * In topic schema 'time_to_download', long */
    const val AD_LOAD_DURATION_KEY = "{{{time_dl}}}"

    /** Volume of Phone at time of ad playback
    In topic schema 'volume', double */
    const val DEVICE_VOLUME_KEY = "{{{vol}}}"

    // Cacheable assets token
    const val KEY_MAIN_VIDEO = "MAIN_VIDEO"

    // Placement type
    const val PLACEMENT_TYPE_INTERSTITIAL = "interstitial"
    const val PLACEMENT_TYPE_REWARDED = "rewarded"
    const val PLACEMENT_TYPE_BANNER = "banner"
    const val PLACEMENT_TYPE_MREC = "mrec"
    const val PLACEMENT_TYPE_NATIVE = "native"
    const val PLACEMENT_TYPE_IN_LINE = "in_line"
    const val PLACEMENT_TYPE_APP_OPEN = "appopen"

    // Template type
    const val TEMPLATE_TYPE_FULLSCREEN = "fullscreen"
    const val TEMPLATE_TYPE_BANNER = "banner"
    const val TEMPLATE_TYPE_MREC = "mrec"
    const val TEMPLATE_TYPE_NATIVE = "native"
    const val TEMPLATE_TYPE_IN_LINE = "in_line"

    // Index page file name for ad
    const val AD_INDEX_FILE_NAME = "index.html"

    // MRAID JS file name for ad
    const val AD_MRAID_JS_FILE_NAME = "mraid.js"

}
