package com.vungle.ads.fpd

import com.vungle.ads.internal.util.RangeUtil
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
class Revenue {
    @SerialName("total_earnings_usd")
    private var totalEarningsUSD: Float? = null

    @SerialName("earnings_by_placement_usd")
    private var earningsByPlacementUSD: Float? = null

    @SerialName("top_n_adomain")
    private var topNAdomain: MutableList<String>? = null

    @SerialName("is_user_a_purchaser")
    private var isUserAPurchaser: Boolean? = null

    @SerialName("is_user_a_subscriber")
    private var isUserASubscriber: Boolean? = null

    @SerialName("last_7_days_total_spend_usd")
    private var last7DaysTotalSpendUSD: Float? = null

    @SerialName("last_7_days_median_spend_usd")
    private var last7DaysMedianSpendUSD: Float? = null

    @SerialName("last_7_days_mean_spend_usd")
    private var last7DaysMeanSpendUSD: Float? = null

    @SerialName("last_30_days_total_spend_usd")
    private var last30DaysTotalSpendUSD: Float? = null

    @SerialName("last_30_days_median_spend_usd")
    private var last30DaysMedianSpendUSD: Float? = null

    @SerialName("last_30_days_mean_spend_usd")
    private var last30DaysMeanSpendUSD: Float? = null

    @SerialName("last_7_days_user_pltv_usd")
    private var last7DaysUserPltvUSD: Float? = null

    @SerialName("last_7_days_user_ltv_usd")
    private var last7DaysUserLtvUSD: Float? = null

    @SerialName("last_30_days_user_pltv_usd")
    private var last30DaysUserPltvUSD: Float? = null

    @SerialName("last_30_days_user_ltv_usd")
    private var last30DaysUserLtvUSD: Float? = null

    @SerialName("last_7_days_placement_fill_rate")
    private var last7DaysPlacementFillRate: Float? = null

    @SerialName("last_30_days_placement_fill_rate")
    private var last30DaysPlacementFillRate: Float? = null

    // Setter methods
    fun setTotalEarningsUsd(totalEarningsUsd: Float): Revenue {
        if (RangeUtil.isInRange(totalEarningsUsd, 0f)) {
            this.totalEarningsUSD = totalEarningsUsd
        }
        return this
    }

    fun setEarningsByPlacement(earningsByPlacement: Float): Revenue {
        if (RangeUtil.isInRange(earningsByPlacement, 0f)) {
            this.earningsByPlacementUSD = earningsByPlacement
        }
        return this
    }

    fun setTopNAdomain(topNAdomain: List<String>?): Revenue {
        this.topNAdomain = topNAdomain?.toMutableList()
        return this
    }

    fun setIsUserAPurchaser(isUserAPurchaser: Boolean): Revenue {
        this.isUserAPurchaser = isUserAPurchaser
        return this
    }

    fun setIsUserASubscriber(isUserASubscriber: Boolean): Revenue {
        this.isUserASubscriber = isUserASubscriber
        return this
    }

    fun setLast7DaysMedianSpendUsd(last7DaysMedianSpendUsd: Float): Revenue {
        if (RangeUtil.isInRange(last7DaysMedianSpendUsd, 0f)) {
            this.last7DaysMedianSpendUSD = last7DaysMedianSpendUsd
        }
        return this
    }

    fun setLast7DaysTotalSpendUsd(last7DaysTotalSpendUsd: Float): Revenue {
        if (RangeUtil.isInRange(last7DaysTotalSpendUsd, 0f)) {
            this.last7DaysTotalSpendUSD = last7DaysTotalSpendUsd
        }
        return this
    }

    fun setLast30DaysTotalSpendUsd(last30DaysTotalSpendUsd: Float): Revenue {
        if (RangeUtil.isInRange(last30DaysTotalSpendUsd, 0f)) {
            this.last30DaysTotalSpendUSD = last30DaysTotalSpendUsd
        }
        return this
    }

    fun setLast7DaysMeanSpendUsd(last7DaysMeanSpendUsd: Float): Revenue {
        if (RangeUtil.isInRange(last7DaysMeanSpendUsd, 0f)) {
            this.last7DaysMeanSpendUSD = last7DaysMeanSpendUsd
        }
        return this
    }

    fun setLast30DaysMedianSpendUsd(last30DaysMedianSpendUsd: Float): Revenue {
        if (RangeUtil.isInRange(last30DaysMedianSpendUsd, 0f)) {
            this.last30DaysMedianSpendUSD = last30DaysMedianSpendUsd
        }
        return this
    }

    fun setLast30DaysMeanSpendUsd(last30DaysMeanSpendUsd: Float): Revenue {
        if (RangeUtil.isInRange(last30DaysMeanSpendUsd, 0f)) {
            this.last30DaysMeanSpendUSD = last30DaysMeanSpendUsd
        }
        return this
    }

    fun setLast7DaysUserPltvUsd(last7DaysUserPltvUsd: Float): Revenue {
        if (RangeUtil.isInRange(last7DaysUserPltvUsd, 0f)) {
            this.last7DaysUserPltvUSD = last7DaysUserPltvUsd
        }
        return this
    }

    fun setLast7DaysUserLtvUsd(last7DaysUserLtvUsd: Float): Revenue {
        if (RangeUtil.isInRange(last7DaysUserLtvUsd, 0f)) {
            this.last7DaysUserLtvUSD = last7DaysUserLtvUsd
        }
        return this
    }

    fun setLast30DaysUserPltvUsd(last30DaysUserPltvUsd: Float): Revenue {
        if (RangeUtil.isInRange(last30DaysUserPltvUsd, 0f)) {
            this.last30DaysUserPltvUSD = last30DaysUserPltvUsd
        }
        return this
    }

    fun setLast30DaysUserLtvUsd(last30DaysUserLtvUsd: Float): Revenue {
        if (RangeUtil.isInRange(last30DaysUserLtvUsd, 0f)) {
            this.last30DaysUserLtvUSD = last30DaysUserLtvUsd
        }
        return this
    }

    fun setLast7DaysPlacementFillRate(last7DaysPlacementFillRate: Float): Revenue {
        if (RangeUtil.isInRange(last7DaysPlacementFillRate, 0f, 100f)) {
            this.last7DaysPlacementFillRate = last7DaysPlacementFillRate
        }
        return this
    }

    fun setLast30DaysPlacementFillRate(last30DaysPlacementFillRate: Float): Revenue {
        if (RangeUtil.isInRange(last30DaysPlacementFillRate, 0f, 100f)) {
            this.last30DaysPlacementFillRate = last30DaysPlacementFillRate
        }
        return this
    }
}