/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.util;

import androidx.annotation.VisibleForTesting;
import com.vungle.ads.internal.util.FileUtility;
import com.vungle.ads.internal.util.Logger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0017\u0018B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0006H\u0007J,\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\u00062\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007J\u0018\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/vungle/ads/internal/util/UnzipUtility;", "", "()V", "BUFFER_SIZE", "", "TAG", "", "kotlin.jvm.PlatformType", "extractFile", "", "zipIn", "Ljava/io/InputStream;", "filePath", "unzip", "", "Ljava/io/File;", "zipFilePath", "destDirectory", "filter", "Lcom/vungle/ads/internal/util/UnzipUtility$Filter;", "validateFilename", "filename", "intendedDir", "Filter", "ZipSecurityException", "vungle-ads_release"})
public final class UnzipUtility {
    @NotNull
    public static final UnzipUtility INSTANCE = new UnzipUtility();
    private static final int BUFFER_SIZE = 4096;
    private static final String TAG = UnzipUtility.class.getCanonicalName();

    private UnzipUtility() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    @NotNull
    public final List<File> unzip(@Nullable String zipFilePath, @NotNull String destDirectory, @Nullable Filter filter) throws IOException {
        Intrinsics.checkNotNullParameter((Object)destDirectory, (String)"destDirectory");
        CharSequence charSequence = zipFilePath;
        if (charSequence == null || charSequence.length() == 0) {
            throw new IOException("Path is empty");
        }
        File src = new File(zipFilePath);
        if (!src.exists()) {
            throw new IOException("File does not exist");
        }
        File destDir = new File(destDirectory);
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        ZipFile zipFile = null;
        List extractedFiles = new ArrayList();
        try {
            zipFile = new ZipFile(src);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String filePath = destDirectory + File.separator + entry.getName();
                if (filter != null && !filter.matches(filePath)) continue;
                this.validateFilename(filePath, destDirectory);
                if (entry.isDirectory()) {
                    File dir = new File(filePath);
                    if (dir.exists()) continue;
                    dir.mkdirs();
                    continue;
                }
                InputStream inputStream = zipFile.getInputStream(entry);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"zipFile.getInputStream(entry)");
                this.extractFile(inputStream, filePath);
                extractedFiles.add(new File(filePath));
            }
        }
        catch (Throwable throwable) {
            try {
                ZipFile zipFile2;
                ZipFile zipFile3 = zipFile2 = zipFile;
                if (zipFile3 != null) {
                    zipFile3.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            ZipFile zipFile4 = zipFile;
            zipFile4.close();
        }
        catch (IOException iOException) {}
        return extractedFiles;
    }

    public static /* synthetic */ List unzip$default(UnzipUtility unzipUtility, String string, String string2, Filter filter, int n, Object object) throws IOException {
        if ((n & 4) != 0) {
            filter = null;
        }
        return unzipUtility.unzip(string, string2, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final void extractFile(@NotNull InputStream zipIn, @Nullable String filePath) throws IOException {
        Intrinsics.checkNotNullParameter((Object)zipIn, (String)"zipIn");
        File dest = new File(filePath);
        FileUtility.delete(dest);
        File parentDir = dest.getParentFile();
        if (parentDir != null && !parentDir.exists()) {
            parentDir.mkdirs();
        }
        BufferedOutputStream bos = null;
        FileOutputStream fos = null;
        try {
            FileOutputStream fileOutputStream;
            FileOutputStream it = fileOutputStream = new FileOutputStream(filePath);
            boolean bl = false;
            fos = it;
            OutputStream outputStream = fileOutputStream;
            bos = new BufferedOutputStream(outputStream);
            byte[] bytesIn = new byte[4096];
            int read = 0;
            while (true) {
                int n;
                int it2 = n = zipIn.read(bytesIn);
                boolean bl2 = false;
                read = it2;
                if (n != -1) {
                    bos.write(bytesIn, 0, read);
                    continue;
                }
                break;
            }
        }
        finally {
            FileUtility.INSTANCE.closeQuietly(zipIn);
            FileUtility.INSTANCE.closeQuietly(bos);
            FileUtility.INSTANCE.closeQuietly(fos);
        }
    }

    private final String validateFilename(String filename, String intendedDir) throws IOException {
        File f2 = new File(filename);
        String canonicalPath = f2.getCanonicalPath();
        File iD = new File(intendedDir);
        String canonicalID = iD.getCanonicalPath();
        Intrinsics.checkNotNullExpressionValue((Object)canonicalPath, (String)"canonicalPath");
        Intrinsics.checkNotNullExpressionValue((Object)canonicalID, (String)"canonicalID");
        if (!StringsKt.startsWith$default((String)canonicalPath, (String)canonicalID, (boolean)false, (int)2, null)) {
            String msg = "File is outside extraction target directory.";
            String string = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.Companion.e(string, msg);
            throw new ZipSecurityException(msg);
        }
        return canonicalPath;
    }

    @JvmOverloads
    @NotNull
    public final List<File> unzip(@Nullable String zipFilePath, @NotNull String destDirectory) throws IOException {
        Intrinsics.checkNotNullParameter((Object)destDirectory, (String)"destDirectory");
        return UnzipUtility.unzip$default(this, zipFilePath, destDirectory, null, 4, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/vungle/ads/internal/util/UnzipUtility$ZipSecurityException;", "Ljava/io/IOException;", "message", "", "(Ljava/lang/String;)V", "vungle-ads_release"})
    public static final class ZipSecurityException
    extends IOException {
        public ZipSecurityException(@Nullable String message) {
            super(message);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/vungle/ads/internal/util/UnzipUtility$Filter;", "", "matches", "", "extractPath", "", "vungle-ads_release"})
    public static interface Filter {
        public boolean matches(@Nullable String var1);
    }
}

