/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.task;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import androidx.annotation.VisibleForTesting;
import com.vungle.ads.internal.task.JobCreator;
import com.vungle.ads.internal.task.JobInfo;
import com.vungle.ads.internal.task.JobRunnable;
import com.vungle.ads.internal.task.JobRunner;
import com.vungle.ads.internal.task.ThreadPriorityHelper;
import com.vungle.ads.internal.util.Logger;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 \u001b2\u00020\u0001:\u0003\u001b\u001c\u001dB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0011H\u0002J\r\u0010\u0018\u001a\u00020\u0019H\u0001\u00a2\u0006\u0002\b\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/vungle/ads/internal/task/VungleJobRunner;", "Lcom/vungle/ads/internal/task/JobRunner;", "creator", "Lcom/vungle/ads/internal/task/JobCreator;", "executor", "Ljava/util/concurrent/Executor;", "threadPriorityHelper", "Lcom/vungle/ads/internal/task/ThreadPriorityHelper;", "(Lcom/vungle/ads/internal/task/JobCreator;Ljava/util/concurrent/Executor;Lcom/vungle/ads/internal/task/ThreadPriorityHelper;)V", "nextCheck", "", "pendingJobs", "", "Lcom/vungle/ads/internal/task/VungleJobRunner$PendingJob;", "pendingRunnable", "Ljava/lang/Runnable;", "cancelPendingJob", "", "tag", "", "execute", "jobInfo", "Lcom/vungle/ads/internal/task/JobInfo;", "executePendingJobs", "getPendingJobSize", "", "getPendingJobSize$vungle_ads_release", "Companion", "PendingJob", "PendingRunnable", "vungle-ads_release"})
public final class VungleJobRunner
implements JobRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JobCreator creator;
    @NotNull
    private final Executor executor;
    @Nullable
    private final ThreadPriorityHelper threadPriorityHelper;
    @NotNull
    private final List<PendingJob> pendingJobs;
    @NotNull
    private final Runnable pendingRunnable;
    private long nextCheck;
    @NotNull
    private static final Handler handler = new Handler(Looper.getMainLooper());
    private static final String TAG = VungleJobRunner.class.getSimpleName();

    public VungleJobRunner(@NotNull JobCreator creator, @NotNull Executor executor, @Nullable ThreadPriorityHelper threadPriorityHelper) {
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.creator = creator;
        this.executor = executor;
        this.threadPriorityHelper = threadPriorityHelper;
        this.nextCheck = Long.MAX_VALUE;
        this.pendingJobs = new CopyOnWriteArrayList();
        this.pendingRunnable = new PendingRunnable(new WeakReference<VungleJobRunner>(this));
    }

    @Override
    public synchronized void execute(@NotNull JobInfo jobInfo) {
        block2: {
            JobInfo jobInfoCopy;
            Intrinsics.checkNotNullParameter((Object)jobInfo, (String)"jobInfo");
            JobInfo jobInfo2 = jobInfoCopy = jobInfo.copy();
            if (jobInfo2 == null) break block2;
            JobInfo it = jobInfo2;
            boolean bl = false;
            String jobTag = it.getJobTag();
            long delay = it.getDelay();
            it.setDelay(0L);
            if (it.getUpdateCurrent()) {
                for (PendingJob job : this.pendingJobs) {
                    JobInfo jobInfo3 = job.getInfo();
                    if (!Intrinsics.areEqual((Object)(jobInfo3 != null ? jobInfo3.getJobTag() : null), (Object)jobTag)) continue;
                    String string = TAG;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                    Logger.Companion.d(string, "replacing pending job with new " + jobTag);
                    this.pendingJobs.remove(job);
                }
            }
            this.pendingJobs.add(new PendingJob(SystemClock.uptimeMillis() + delay, it));
            this.executePendingJobs();
        }
    }

    @VisibleForTesting
    public final int getPendingJobSize$vungle_ads_release() {
        return this.pendingJobs.size();
    }

    @Override
    public synchronized void cancelPendingJob(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        List jobsToRemove = new ArrayList();
        for (PendingJob pendingJob : this.pendingJobs) {
            JobInfo jobInfo = pendingJob.getInfo();
            if (!Intrinsics.areEqual((Object)(jobInfo != null ? jobInfo.getJobTag() : null), (Object)tag)) continue;
            jobsToRemove.add(pendingJob);
        }
        this.pendingJobs.removeAll(jobsToRemove);
    }

    private final synchronized void executePendingJobs() {
        long now = SystemClock.uptimeMillis();
        long nextCheck = Long.MAX_VALUE;
        for (PendingJob job : this.pendingJobs) {
            if (now >= job.getUptimeMillis()) {
                this.pendingJobs.remove(job);
                if (job.getInfo() != null) {
                    JobInfo it;
                    boolean bl = false;
                    this.executor.execute(new JobRunnable(it, this.creator, this, this.threadPriorityHelper));
                }
                continue;
            }
            nextCheck = Math.min(nextCheck, job.getUptimeMillis());
        }
        if (nextCheck != Long.MAX_VALUE && nextCheck != this.nextCheck) {
            handler.removeCallbacks(this.pendingRunnable);
            handler.postAtTime(this.pendingRunnable, (Object)TAG, nextCheck);
        }
        this.nextCheck = nextCheck;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/vungle/ads/internal/task/VungleJobRunner$PendingJob;", "", "uptimeMillis", "", "info", "Lcom/vungle/ads/internal/task/JobInfo;", "(JLcom/vungle/ads/internal/task/JobInfo;)V", "getInfo", "()Lcom/vungle/ads/internal/task/JobInfo;", "setInfo", "(Lcom/vungle/ads/internal/task/JobInfo;)V", "getUptimeMillis", "()J", "vungle-ads_release"})
    private static final class PendingJob {
        private final long uptimeMillis;
        @Nullable
        private JobInfo info;

        public PendingJob(long uptimeMillis, @Nullable JobInfo info) {
            this.uptimeMillis = uptimeMillis;
            this.info = info;
        }

        public final long getUptimeMillis() {
            return this.uptimeMillis;
        }

        @Nullable
        public final JobInfo getInfo() {
            return this.info;
        }

        public final void setInfo(@Nullable JobInfo jobInfo) {
            this.info = jobInfo;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016R \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\u000b"}, d2={"Lcom/vungle/ads/internal/task/VungleJobRunner$PendingRunnable;", "Ljava/lang/Runnable;", "runner", "Ljava/lang/ref/WeakReference;", "Lcom/vungle/ads/internal/task/VungleJobRunner;", "(Ljava/lang/ref/WeakReference;)V", "getRunner", "()Ljava/lang/ref/WeakReference;", "setRunner", "run", "", "vungle-ads_release"})
    private static final class PendingRunnable
    implements Runnable {
        @NotNull
        private WeakReference<VungleJobRunner> runner;

        public PendingRunnable(@NotNull WeakReference<VungleJobRunner> runner) {
            Intrinsics.checkNotNullParameter(runner, (String)"runner");
            this.runner = runner;
        }

        @NotNull
        public final WeakReference<VungleJobRunner> getRunner() {
            return this.runner;
        }

        public final void setRunner(@NotNull WeakReference<VungleJobRunner> weakReference) {
            Intrinsics.checkNotNullParameter(weakReference, (String)"<set-?>");
            this.runner = weakReference;
        }

        @Override
        public void run() {
            block0: {
                VungleJobRunner ref;
                VungleJobRunner vungleJobRunner = ref = (VungleJobRunner)this.runner.get();
                if (vungleJobRunner == null) break block0;
                vungleJobRunner.executePendingJobs();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/vungle/ads/internal/task/VungleJobRunner$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "handler", "Landroid/os/Handler;", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

