/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.presenter;

import com.vungle.ads.VungleError;
import com.vungle.ads.internal.model.Placement;
import com.vungle.ads.internal.presenter.AdPlayCallback;
import com.vungle.ads.internal.util.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0016\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\"\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u0010R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/vungle/ads/internal/presenter/AdEventListener;", "", "playAdCallback", "Lcom/vungle/ads/internal/presenter/AdPlayCallback;", "placement", "Lcom/vungle/ads/internal/model/Placement;", "(Lcom/vungle/ads/internal/presenter/AdPlayCallback;Lcom/vungle/ads/internal/model/Placement;)V", "adRewarded", "", "getPlayAdCallback$vungle_ads_release", "()Lcom/vungle/ads/internal/presenter/AdPlayCallback;", "onError", "", "error", "Lcom/vungle/ads/VungleError;", "placementId", "", "onNext", "s", "value", "id", "Companion", "vungle-ads_release"})
public class AdEventListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final AdPlayCallback playAdCallback;
    @Nullable
    private Placement placement;
    private boolean adRewarded;
    @NotNull
    private static final String TAG = "AdEventListener";

    public AdEventListener(@Nullable AdPlayCallback playAdCallback, @Nullable Placement placement) {
        this.playAdCallback = playAdCallback;
        this.placement = placement;
    }

    @Nullable
    public final AdPlayCallback getPlayAdCallback$vungle_ads_release() {
        return this.playAdCallback;
    }

    public final void onNext(@NotNull String s, @Nullable String value, @Nullable String id) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Logger.Companion.d(TAG, "s=" + s + ", value=" + value + ", id=" + id);
        switch (s) {
            case "start": {
                AdPlayCallback adPlayCallback2 = this.playAdCallback;
                if (adPlayCallback2 != null) {
                    adPlayCallback2.onAdStart(id);
                }
                break;
            }
            case "adViewed": {
                AdPlayCallback adPlayCallback3 = this.playAdCallback;
                if (adPlayCallback3 != null) {
                    adPlayCallback3.onAdImpression(id);
                }
                break;
            }
            case "successfulView": {
                Placement placement = this.placement;
                boolean bl = placement != null ? placement.isIncentivized() : false;
                if (!bl || this.adRewarded) break;
                this.adRewarded = true;
                AdPlayCallback adPlayCallback4 = this.playAdCallback;
                if (adPlayCallback4 != null) {
                    adPlayCallback4.onAdRewarded(id);
                }
                break;
            }
            case "end": {
                AdPlayCallback adPlayCallback5 = this.playAdCallback;
                if (adPlayCallback5 != null) {
                    adPlayCallback5.onAdEnd(id);
                }
                break;
            }
            case "open": {
                String string = value;
                if (Intrinsics.areEqual((Object)string, (Object)"adClick")) {
                    AdPlayCallback adPlayCallback6 = this.playAdCallback;
                    if (adPlayCallback6 != null) {
                        adPlayCallback6.onAdClick(id);
                    }
                    break;
                }
                if (!Intrinsics.areEqual((Object)string, (Object)"adLeftApplication")) break;
                AdPlayCallback adPlayCallback7 = this.playAdCallback;
                if (adPlayCallback7 == null) break;
                adPlayCallback7.onAdLeftApplication(id);
                break;
            }
        }
    }

    public final void onError(@NotNull VungleError error, @Nullable String placementId) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        if (this.playAdCallback != null) {
            this.playAdCallback.onFailure(error);
            Logger.Companion.e(TAG, "AdEventListener#PlayAdCallback " + placementId, error);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/vungle/ads/internal/presenter/AdEventListener$Companion;", "", "()V", "TAG", "", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

