@file:JvmName("Logger")

package com.vungle.ads.internal.util

import android.util.Log
import com.vungle.ads.BuildConfig
import java.util.regex.Pattern

/**
 * Use this class to do all Logging instead of calling Log.d, Log.e or Log.w
 */
class Logger {

    companion object {
        private var enabled: Boolean = BuildConfig.DEBUG

        fun enable(enabled: Boolean) {
            Companion.enabled = enabled || BuildConfig.DEBUG
        }

        @JvmStatic
        fun d(tag: String, message: String): Int {
            if (!enabled) {
                return -1
            }
            return Log.d(tag, message.eraseSensitiveData())
        }

        @JvmStatic
        fun e(tag: String, message: String): Int {
            if (!enabled) {
                return -1
            }
            return Log.e(tag, message.eraseSensitiveData())
        }

        @JvmStatic
        fun e(tag: String, message: String, throwable: Throwable): Int {
            if (!enabled) {
                return -1
            }
            return if (BuildConfig.DEBUG) {
                Log.e(tag, message.eraseSensitiveData(), throwable)
            } else {
                Log.e(
                    tag,
                    "${message.eraseSensitiveData()}; error: ${throwable.localizedMessage}"
                )
            }
        }

        @JvmStatic
        fun w(tag: String, message: String): Int {
            if (!enabled) {
                return -1
            }
            return Log.w(tag, message.eraseSensitiveData())
        }

        @JvmStatic
        fun w(tag: String, message: String, throwable: Throwable): Int {
            if (!enabled) {
                return -1
            }
            return if (BuildConfig.DEBUG) {
                Log.e(tag, message.eraseSensitiveData(), throwable)
            } else {
                Log.e(
                    tag,
                    "${message.eraseSensitiveData()}; error: ${throwable.localizedMessage}"
                )
            }
        }

        fun String.eraseSensitiveData(): String {
            return this.replace(
                Pattern.compile("[\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3}").toRegex(),
                "xxx.xxx.xxx.xxx"
            )
        }


    }

}