/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.signals;

import android.content.Context;
import android.content.res.Resources;
import androidx.annotation.VisibleForTesting;
import com.vungle.ads.ServiceLocator;
import com.vungle.ads.internal.ConfigManager;
import com.vungle.ads.internal.executor.Executors;
import com.vungle.ads.internal.model.UnclosedAd;
import com.vungle.ads.internal.persistence.FilePreferences;
import com.vungle.ads.internal.session.UnclosedAdDetector;
import com.vungle.ads.internal.signals.SessionData;
import com.vungle.ads.internal.signals.SignalManager;
import com.vungle.ads.internal.signals.SignaledAd;
import com.vungle.ads.internal.util.ActivityManager;
import com.vungle.ads.internal.util.Logger;
import com.vungle.ads.internal.util.PathProvider;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\u0018\u0000 L2\u00020\u0001:\u0001LB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u00108\u001a\u000209J\b\u0010:\u001a\u0004\u0018\u00010\"J\u000e\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\"J\u0006\u0010>\u001a\u000209J\u000e\u0010?\u001a\u0002092\u0006\u0010@\u001a\u00020AJ\b\u0010B\u001a\u000209H\u0002J\u0018\u0010C\u001a\u0002092\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010D\u001a\u00020<J\u000e\u0010E\u001a\u0002092\u0006\u0010@\u001a\u00020AJ\u0010\u0010F\u001a\u00020(2\b\u0010G\u001a\u0004\u0018\u00010\u0003J\b\u0010H\u001a\u000209H\u0002J\b\u0010I\u001a\u000209H\u0002J\u0010\u0010J\u001a\u0002092\b\u0010K\u001a\u0004\u0018\u00010\"R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R$\u0010\u0007\u001a\u00020\b8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u001b\u0010\u0018\u001a\u00020\u00198FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00100!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u0012\"\u0004\b/\u0010\u0014R\u001a\u00100\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u0012\"\u0004\b2\u0010\u0014R\u000e\u00103\u001a\u000204X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u00105\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b6\u00107\u00a8\u0006M\u00b2\u0006\n\u0010N\u001a\u00020OX\u008a\u0084\u0002\u00b2\u0006\n\u0010P\u001a\u00020QX\u008a\u0084\u0002"}, d2={"Lcom/vungle/ads/internal/signals/SignalManager;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "currentSession", "Lcom/vungle/ads/internal/signals/SessionData;", "getCurrentSession$vungle_ads_release$annotations", "()V", "getCurrentSession$vungle_ads_release", "()Lcom/vungle/ads/internal/signals/SessionData;", "setCurrentSession$vungle_ads_release", "(Lcom/vungle/ads/internal/signals/SessionData;)V", "enterBackgroundTime", "", "getEnterBackgroundTime", "()J", "setEnterBackgroundTime", "(J)V", "enterForegroundTime", "getEnterForegroundTime", "setEnterForegroundTime", "filePreferences", "Lcom/vungle/ads/internal/persistence/FilePreferences;", "getFilePreferences", "()Lcom/vungle/ads/internal/persistence/FilePreferences;", "filePreferences$delegate", "Lkotlin/Lazy;", "json", "Lkotlinx/serialization/json/Json;", "mapOfLastLoadTimes", "Ljava/util/concurrent/ConcurrentHashMap;", "", "getMapOfLastLoadTimes", "()Ljava/util/concurrent/ConcurrentHashMap;", "setMapOfLastLoadTimes", "(Ljava/util/concurrent/ConcurrentHashMap;)V", "sessionCount", "", "getSessionCount", "()I", "setSessionCount", "(I)V", "sessionDuration", "getSessionDuration", "setSessionDuration", "sessionSeriesCreatedTime", "getSessionSeriesCreatedTime", "setSessionSeriesCreatedTime", "unclosedAdDetector", "Lcom/vungle/ads/internal/session/UnclosedAdDetector;", "uuid", "getUuid", "()Ljava/lang/String;", "createNewSessionData", "", "generateSignals", "getSignaledAd", "Lcom/vungle/ads/internal/signals/SignaledAd;", "placementId", "increaseSessionDepthCounter", "recordUnclosedAd", "unclosedAd", "Lcom/vungle/ads/internal/model/UnclosedAd;", "registerNotifications", "registerSignaledAd", "signaledAd", "removeUnclosedAd", "screenOrientation", "ctx", "updateSessionCount", "updateSessionDuration", "updateTemplateSignals", "signals", "Companion", "vungle-ads_release", "executors", "Lcom/vungle/ads/internal/executor/Executors;", "pathProvider", "Lcom/vungle/ads/internal/util/PathProvider;"})
public final class SignalManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final Json json;
    private long enterBackgroundTime;
    private long enterForegroundTime;
    private long sessionDuration;
    private int sessionCount;
    private long sessionSeriesCreatedTime;
    @NotNull
    private SessionData currentSession;
    @NotNull
    private ConcurrentHashMap<String, Long> mapOfLastLoadTimes;
    @NotNull
    private final Lazy filePreferences$delegate;
    @NotNull
    private UnclosedAdDetector unclosedAdDetector;
    @NotNull
    private static final String TAG = "SignalManager";
    private static final int SESSION_COUNT_NOT_SET = -1;
    public static final int SIGNAL_VERSION = 1;
    public static final long TWENTY_FOUR_HOURS_MILLIS = 86400000L;
    @NotNull
    public static final String SESSION_COUNT_KEY = "vungle_signal_session_count";
    @NotNull
    public static final String SESSION_TIME_KEY = "vungle_signal_session_creation_time";

    /*
     * WARNING - void declaration
     */
    public SignalManager(@NotNull Context context) {
        void $this$encodeToString$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.json = JsonKt.Json$default(null, (Function1)json.1.INSTANCE, (int)1, null);
        this.enterForegroundTime = System.currentTimeMillis();
        this.sessionCount = -1;
        this.mapOfLastLoadTimes = new ConcurrentHashMap();
        ServiceLocator.Companion companion = ServiceLocator.Companion;
        Object context$iv = this.context;
        boolean $i$f$inject = false;
        this.filePreferences$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<FilePreferences>(context$iv){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final FilePreferences invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(FilePreferences.class);
            }
        }));
        this.registerNotifications();
        this.sessionSeriesCreatedTime = this.getFilePreferences().getLong(SESSION_TIME_KEY, -1L);
        this.updateSessionCount();
        this.currentSession = new SessionData(this.sessionCount);
        context$iv = ServiceLocator.Companion;
        Object context$iv2 = this.context;
        boolean $i$f$inject2 = false;
        Lazy executors$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<Executors>(context$iv2){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final Executors invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(Executors.class);
            }
        }));
        context$iv2 = ServiceLocator.Companion;
        Context context$iv3 = this.context;
        boolean $i$f$inject3 = false;
        Lazy pathProvider$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<PathProvider>(context$iv3){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final PathProvider invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(PathProvider.class);
            }
        }));
        this.unclosedAdDetector = new UnclosedAdDetector(this.context, this.currentSession.getSessionId(), SignalManager._init_$lambda-0((Lazy<? extends Executors>)executors$delegate), SignalManager._init_$lambda-1((Lazy<PathProvider>)pathProvider$delegate));
        this.currentSession.setUnclosedAd(this.unclosedAdDetector.retrieveUnclosedAd());
        StringBuilder stringBuilder = new StringBuilder().append("unclosedad: ");
        StringFormat this_$iv = (StringFormat)this.json;
        List<UnclosedAd> value$iv = this.currentSession.getUnclosedAd();
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(UnclosedAd.class))));
        boolean $i$f$cast = false;
        Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
        Logger.Companion.w(TAG, stringBuilder.append($this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, value$iv)).toString());
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public final long getEnterBackgroundTime() {
        return this.enterBackgroundTime;
    }

    public final void setEnterBackgroundTime(long l) {
        this.enterBackgroundTime = l;
    }

    public final long getEnterForegroundTime() {
        return this.enterForegroundTime;
    }

    public final void setEnterForegroundTime(long l) {
        this.enterForegroundTime = l;
    }

    public final long getSessionDuration() {
        return this.sessionDuration;
    }

    public final void setSessionDuration(long l) {
        this.sessionDuration = l;
    }

    public final int getSessionCount() {
        return this.sessionCount;
    }

    public final void setSessionCount(int n) {
        this.sessionCount = n;
    }

    public final long getSessionSeriesCreatedTime() {
        return this.sessionSeriesCreatedTime;
    }

    public final void setSessionSeriesCreatedTime(long l) {
        this.sessionSeriesCreatedTime = l;
    }

    @NotNull
    public final SessionData getCurrentSession$vungle_ads_release() {
        return this.currentSession;
    }

    public final void setCurrentSession$vungle_ads_release(@NotNull SessionData sessionData) {
        Intrinsics.checkNotNullParameter((Object)sessionData, (String)"<set-?>");
        this.currentSession = sessionData;
    }

    @VisibleForTesting(otherwise=2)
    public static /* synthetic */ void getCurrentSession$vungle_ads_release$annotations() {
    }

    @NotNull
    public final ConcurrentHashMap<String, Long> getMapOfLastLoadTimes() {
        return this.mapOfLastLoadTimes;
    }

    public final void setMapOfLastLoadTimes(@NotNull ConcurrentHashMap<String, Long> concurrentHashMap) {
        Intrinsics.checkNotNullParameter(concurrentHashMap, (String)"<set-?>");
        this.mapOfLastLoadTimes = concurrentHashMap;
    }

    @NotNull
    public final FilePreferences getFilePreferences() {
        Lazy lazy = this.filePreferences$delegate;
        return (FilePreferences)lazy.getValue();
    }

    @NotNull
    public final String getUuid() {
        return this.currentSession.getSessionId();
    }

    private final void updateSessionCount() {
        if (this.sessionCount == -1) {
            this.sessionCount = this.getFilePreferences().getInt(SESSION_COUNT_KEY, 0);
        }
        long currentTime = System.currentTimeMillis();
        long timeDifference = currentTime - this.sessionSeriesCreatedTime;
        if (this.sessionSeriesCreatedTime < 0L || timeDifference >= 86400000L) {
            this.sessionCount = 1;
            this.getFilePreferences().put(SESSION_TIME_KEY, currentTime);
            this.sessionSeriesCreatedTime = currentTime;
        } else {
            int n = this.sessionCount;
            this.sessionCount = n + 1;
        }
        this.getFilePreferences().put(SESSION_COUNT_KEY, this.sessionCount);
        this.getFilePreferences().apply();
    }

    private final void registerNotifications() {
        ActivityManager.Companion.addLifecycleListener(new ActivityManager.LifeCycleCallback(this){
            final /* synthetic */ SignalManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void onResume() {
                super.onResume();
                long now = System.currentTimeMillis();
                long millisSinceLastBackground = now - this.this$0.getEnterBackgroundTime();
                if (millisSinceLastBackground > ConfigManager.INSTANCE.getSignalsSessionTimeout()) {
                    this.this$0.createNewSessionData();
                }
                this.this$0.setEnterForegroundTime(now);
                this.this$0.setEnterBackgroundTime(0L);
            }

            public void onPause() {
                super.onPause();
                this.this$0.setEnterBackgroundTime(System.currentTimeMillis());
                SignalManager signalManager = this.this$0;
                signalManager.setSessionDuration(signalManager.getSessionDuration() + (this.this$0.getEnterBackgroundTime() - this.this$0.getEnterForegroundTime()));
            }
        });
    }

    public final void createNewSessionData() {
        SessionData newSessionData;
        this.updateSessionCount();
        this.currentSession = newSessionData = new SessionData(this.sessionCount);
    }

    @NotNull
    public final synchronized SignaledAd getSignaledAd(@NotNull String placementId) {
        Intrinsics.checkNotNullParameter((Object)placementId, (String)"placementId");
        long now = System.currentTimeMillis();
        Long lastAdLoadTime = this.mapOfLastLoadTimes.containsKey(placementId) ? this.mapOfLastLoadTimes.get(placementId) : null;
        Long l = now;
        ((Map)this.mapOfLastLoadTimes).put(placementId, l);
        return new SignaledAd(lastAdLoadTime, now);
    }

    public final synchronized void increaseSessionDepthCounter() {
        SessionData sessionData = this.currentSession;
        int n = sessionData.getSessionDepthCounter();
        sessionData.setSessionDepthCounter(n + 1);
    }

    public final void recordUnclosedAd(@NotNull UnclosedAd unclosedAd) {
        Intrinsics.checkNotNullParameter((Object)unclosedAd, (String)"unclosedAd");
        if (ConfigManager.INSTANCE.signalsDisabled()) {
            return;
        }
        this.unclosedAdDetector.addUnclosedAd(unclosedAd);
    }

    public final void removeUnclosedAd(@NotNull UnclosedAd unclosedAd) {
        Intrinsics.checkNotNullParameter((Object)unclosedAd, (String)"unclosedAd");
        if (ConfigManager.INSTANCE.signalsDisabled()) {
            return;
        }
        this.unclosedAdDetector.removeUnclosedAd(unclosedAd);
    }

    public final void registerSignaledAd(@Nullable Context context, @NotNull SignaledAd signaledAd) {
        Intrinsics.checkNotNullParameter((Object)signaledAd, (String)"signaledAd");
        this.currentSession.getSignaledAd().clear();
        this.currentSession.getSignaledAd().add(signaledAd);
        this.currentSession.getSignaledAd().get(0).setScreenOrientation(this.screenOrientation(context));
    }

    public final void updateTemplateSignals(@Nullable String signals) {
        CharSequence charSequence = signals;
        if (!(charSequence == null || charSequence.length() == 0) && !((Collection)this.currentSession.getSignaledAd()).isEmpty()) {
            this.currentSession.getSignaledAd().get(0).setTemplateSignals(signals);
        }
    }

    private final void updateSessionDuration() {
        this.currentSession.setSessionDuration(this.sessionDuration + System.currentTimeMillis() - this.enterForegroundTime);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String generateSignals() {
        String string;
        this.updateSessionDuration();
        try {
            void $this$encodeToString$iv;
            StringBuilder stringBuilder = new StringBuilder().append("1:");
            string = (StringFormat)this.json;
            SessionData value$iv = this.currentSession;
            boolean $i$f$encodeToString = false;
            SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(SessionData.class));
            boolean $i$f$cast = false;
            Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
            string = stringBuilder.append($this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, (Object)value$iv)).toString();
        }
        catch (Exception e2) {
            string = null;
        }
        catch (Error e3) {
            string = null;
        }
        return string;
    }

    public final int screenOrientation(@Nullable Context ctx) {
        int n;
        Context contextImpl;
        Resources resources;
        Integer n2;
        Context context = ctx;
        if (context == null) {
            context = this.context;
        }
        Integer n3 = n2 = (resources = (contextImpl = context).getResources()) != null && (resources = resources.getConfiguration()) != null ? Integer.valueOf(resources.orientation) : null;
        int n4 = 2;
        if (n3 != null && n3 == n4) {
            n = 2;
        } else {
            Integer n5 = n2;
            n4 = 1;
            if (n5 != null && n5 == n4) {
                n = 1;
            } else {
                Integer n6 = n2;
                n = n6 != null && n6 == 0 ? 0 : -1;
            }
        }
        return n;
    }

    private static final Executors _init_$lambda-0(Lazy<? extends Executors> $executors$delegate) {
        Lazy<? extends Executors> lazy = $executors$delegate;
        return (Executors)lazy.getValue();
    }

    private static final PathProvider _init_$lambda-1(Lazy<PathProvider> $pathProvider$delegate) {
        Lazy<PathProvider> lazy = $pathProvider$delegate;
        return (PathProvider)lazy.getValue();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/vungle/ads/internal/signals/SignalManager$Companion;", "", "()V", "SESSION_COUNT_KEY", "", "SESSION_COUNT_NOT_SET", "", "SESSION_TIME_KEY", "SIGNAL_VERSION", "TAG", "TWENTY_FOUR_HOURS_MILLIS", "", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

