/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.session;

import android.content.Context;
import com.vungle.ads.internal.executor.Executors;
import com.vungle.ads.internal.executor.FutureResult;
import com.vungle.ads.internal.model.UnclosedAd;
import com.vungle.ads.internal.session.UnclosedAdDetector;
import com.vungle.ads.internal.util.FileUtility;
import com.vungle.ads.internal.util.Logger;
import com.vungle.ads.internal.util.PathProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0005\u0018\u0000 \"2\u00020\u0001:\u0001\"B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0015J\u001e\u0010\u0019\u001a\u0002H\u001a\"\u0006\b\u0000\u0010\u001a\u0018\u00012\u0006\u0010\u001b\u001a\u00020\u0005H\u0082\b\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u001eH\u0002J\u000e\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0015J\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00150\u001eJ\u0016\u0010!\u001a\u00020\u00172\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u001eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/vungle/ads/internal/session/UnclosedAdDetector;", "", "context", "Landroid/content/Context;", "sessionId", "", "executors", "Lcom/vungle/ads/internal/executor/Executors;", "pathProvider", "Lcom/vungle/ads/internal/util/PathProvider;", "(Landroid/content/Context;Ljava/lang/String;Lcom/vungle/ads/internal/executor/Executors;Lcom/vungle/ads/internal/util/PathProvider;)V", "getContext", "()Landroid/content/Context;", "getExecutors", "()Lcom/vungle/ads/internal/executor/Executors;", "file", "Ljava/io/File;", "getPathProvider", "()Lcom/vungle/ads/internal/util/PathProvider;", "unclosedAdList", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/vungle/ads/internal/model/UnclosedAd;", "addUnclosedAd", "", "ad", "decodeJson", "T", "jsonString", "(Ljava/lang/String;)Ljava/lang/Object;", "readUnclosedAdFromFile", "", "removeUnclosedAd", "retrieveUnclosedAd", "writeUnclosedAdToFile", "Companion", "vungle-ads_release"})
public final class UnclosedAdDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final String sessionId;
    @NotNull
    private final Executors executors;
    @NotNull
    private final PathProvider pathProvider;
    @NotNull
    private File file;
    @NotNull
    private final CopyOnWriteArrayList<UnclosedAd> unclosedAdList;
    @NotNull
    private static final String FILENAME = "unclosed_ad";
    @NotNull
    private static final Json json = JsonKt.Json$default(null, (Function1)Companion.json.1.INSTANCE, (int)1, null);

    public UnclosedAdDetector(@NotNull Context context, @NotNull String sessionId, @NotNull Executors executors, @NotNull PathProvider pathProvider) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)executors, (String)"executors");
        Intrinsics.checkNotNullParameter((Object)pathProvider, (String)"pathProvider");
        this.context = context;
        this.sessionId = sessionId;
        this.executors = executors;
        this.pathProvider = pathProvider;
        this.file = this.pathProvider.getUnclosedAdFile(FILENAME);
        this.unclosedAdList = new CopyOnWriteArrayList();
        if (this.file != null && !this.file.exists()) {
            this.file.createNewFile();
        }
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final Executors getExecutors() {
        return this.executors;
    }

    @NotNull
    public final PathProvider getPathProvider() {
        return this.pathProvider;
    }

    public final void addUnclosedAd(@NotNull UnclosedAd ad) {
        Intrinsics.checkNotNullParameter((Object)ad, (String)"ad");
        ad.setSessionId(this.sessionId);
        this.unclosedAdList.add(ad);
        this.writeUnclosedAdToFile((List<UnclosedAd>)this.unclosedAdList);
    }

    public final void removeUnclosedAd(@NotNull UnclosedAd ad) {
        Intrinsics.checkNotNullParameter((Object)ad, (String)"ad");
        if (this.unclosedAdList.contains(ad)) {
            this.unclosedAdList.remove(ad);
            this.writeUnclosedAdToFile((List<UnclosedAd>)this.unclosedAdList);
        }
    }

    @NotNull
    public final List<UnclosedAd> retrieveUnclosedAd() {
        List unclosedAdList = new ArrayList();
        List<UnclosedAd> list = this.readUnclosedAdFromFile();
        if (list != null) {
            List<UnclosedAd> it = list;
            boolean bl = false;
            unclosedAdList.addAll((Collection)it);
        }
        this.executors.getIoExecutor().execute(() -> UnclosedAdDetector.retrieveUnclosedAd$lambda-1(this));
        return unclosedAdList;
    }

    private final /* synthetic */ <T> T decodeJson(String jsonString) {
        boolean $i$f$decodeJson = false;
        StringFormat $this$decodeFromString$iv = (StringFormat)json;
        boolean $i$f$decodeFromString = false;
        SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        Intrinsics.reifiedOperationMarker((int)6, (String)"T");
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, null);
        boolean $i$f$cast = false;
        Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
        return (T)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, jsonString);
    }

    private final List<UnclosedAd> readUnclosedAdFromFile() {
        FutureResult<List> futureResult = new FutureResult<List>(this.executors.getIoExecutor().submit(() -> UnclosedAdDetector.readUnclosedAdFromFile$lambda-2(this)));
        return futureResult.get(1000L, TimeUnit.MILLISECONDS);
    }

    private final void writeUnclosedAdToFile(List<UnclosedAd> unclosedAdList) {
        StringFormat $this$encodeToString$iv = (StringFormat)json;
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(UnclosedAd.class))));
        boolean $i$f$cast = false;
        Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
        String jsonContent = $this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, unclosedAdList);
        this.executors.getIoExecutor().execute(() -> UnclosedAdDetector.writeUnclosedAdToFile$lambda-3(this, jsonContent));
    }

    private static final void retrieveUnclosedAd$lambda-1(UnclosedAdDetector this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            FileUtility.deleteAndLogIfFailed(this$0.file);
        }
        catch (Exception ex) {
            Logger.Companion.e("UnclosedAdDetector", "Fail to delete file " + ex.getMessage());
        }
    }

    private static final List readUnclosedAdFromFile$lambda-2(UnclosedAdDetector this$0) {
        List list;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            List list2;
            String jsonString = FileUtility.INSTANCE.readString(this$0.file);
            CharSequence charSequence = jsonString;
            if (!(charSequence == null || charSequence.length() == 0)) {
                UnclosedAdDetector this_$iv = this$0;
                boolean $i$f$decodeJson = false;
                StringFormat $this$decodeFromString$iv$iv = (StringFormat)json;
                boolean $i$f$decodeFromString = false;
                SerializersModule $this$serializer$iv$iv$iv = $this$decodeFromString$iv$iv.getSerializersModule();
                boolean $i$f$serializer = false;
                KSerializer $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(UnclosedAd.class))));
                boolean $i$f$cast = false;
                Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
                list2 = (List)$this$decodeFromString$iv$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv$iv, jsonString);
            } else {
                list2 = new ArrayList();
            }
            list = list2;
        }
        catch (Exception ex) {
            Logger.Companion.e("UnclosedAdDetector", "Fail to read unclosed ad file " + ex.getMessage());
            list = new ArrayList();
        }
        return list;
    }

    private static final void writeUnclosedAdToFile$lambda-3(UnclosedAdDetector this$0, String $jsonContent) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$jsonContent, (String)"$jsonContent");
        FileUtility.INSTANCE.writeString(this$0.file, $jsonContent);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/vungle/ads/internal/session/UnclosedAdDetector$Companion;", "", "()V", "FILENAME", "", "json", "Lkotlinx/serialization/json/Json;", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

