/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.persistence;

import androidx.annotation.VisibleForTesting;
import com.vungle.ads.internal.persistence.FilePreferences;
import com.vungle.ads.internal.persistence.FilePreferences$MapEntry$;
import com.vungle.ads.internal.util.FileUtility;
import com.vungle.ads.internal.util.PathProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\n\u0018\u0000 !2\u00020\u0001:\u0002!\"B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0015\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0012J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0013\u001a\u00020\u0007J\u0016\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007J\u0018\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0007H\u0002J\b\u0010\u001d\u001a\u00020\u0010H\u0002J\u0016\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0012J\u0016\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0017J\u0016\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0019J\u0016\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/vungle/ads/internal/persistence/FilePreferences;", "", "ioExecutor", "Ljava/util/concurrent/Executor;", "pathProvider", "Lcom/vungle/ads/internal/util/PathProvider;", "filename", "", "(Ljava/util/concurrent/Executor;Lcom/vungle/ads/internal/util/PathProvider;Ljava/lang/String;)V", "file", "Ljava/io/File;", "json", "Lkotlinx/serialization/json/Json;", "values", "Ljava/util/concurrent/ConcurrentHashMap;", "apply", "", "getBoolean", "", "key", "(Ljava/lang/String;)Ljava/lang/Boolean;", "defaultValue", "getInt", "", "getLong", "", "getString", "migrateOldData", "fileName", "persistDataset", "put", "value", "remove", "Companion", "MapEntry", "vungle-ads_release"})
public final class FilePreferences {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Executor ioExecutor;
    @NotNull
    private final File file;
    @NotNull
    private final ConcurrentHashMap<String, String> values;
    @NotNull
    private final Json json;
    @NotNull
    public static final String FILENAME = "vungleSettings";
    @NotNull
    public static final String TPAT_FAILED_FILENAME = "failedTpatSet";
    @NotNull
    public static final String OLD_FILENAME = "settings_vungle";
    @NotNull
    public static final String OLD_TPAT_FAILED_FILENAME = "failedTpats";
    @NotNull
    private static final ConcurrentHashMap<String, FilePreferences> filePreferenceMap = new ConcurrentHashMap();

    /*
     * WARNING - void declaration
     */
    private FilePreferences(Executor ioExecutor, PathProvider pathProvider, String filename) {
        block5: {
            String string;
            this.ioExecutor = ioExecutor;
            this.file = new File(pathProvider.getSharedPrefsDir(), filename);
            this.values = new ConcurrentHashMap();
            this.json = JsonKt.Json$default(null, (Function1)json.1.INSTANCE, (int)1, null);
            String string2 = filename;
            if (Intrinsics.areEqual((Object)string2, (Object)FILENAME)) {
                this.migrateOldData(pathProvider, OLD_FILENAME);
            } else if (Intrinsics.areEqual((Object)string2, (Object)TPAT_FAILED_FILENAME)) {
                this.migrateOldData(pathProvider, OLD_TPAT_FAILED_FILENAME);
            }
            String string3 = FileUtility.INSTANCE.readString(this.file);
            if (string3 == null) break block5;
            String configureString = string = string3;
            boolean bl = false;
            if (!StringsKt.isBlank((CharSequence)configureString)) {
                void $this$associateTo$iv$iv;
                void $this$associate$iv;
                Object $this$decodeFromString$iv = (StringFormat)this.json;
                boolean $i$f$decodeFromString = false;
                SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
                boolean $i$f$serializer22 = false;
                KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(MapEntry.class))));
                boolean $i$f$cast = false;
                Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
                List dataList = (List)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, configureString);
                $this$decodeFromString$iv = dataList;
                ConcurrentHashMap<String, String> concurrentHashMap = this.values;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                void $i$f$serializer22 = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    Map map = destination$iv$iv;
                    MapEntry it = (MapEntry)element$iv$iv;
                    boolean bl2 = false;
                    Pair pair = TuplesKt.to((Object)it.getKey(), (Object)it.getValue());
                    map.put(pair.getFirst(), pair.getSecond());
                }
                concurrentHashMap.putAll(destination$iv$iv);
            }
        }
    }

    public final void apply() {
        this.ioExecutor.execute(() -> FilePreferences.apply$lambda-0(this));
    }

    @NotNull
    public final FilePreferences put(@NotNull String key, boolean value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ((Map)this.values).put(key, String.valueOf(value));
        return this;
    }

    public final boolean getBoolean(@NotNull String key, boolean defaultValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String value = this.values.get(key);
        CharSequence charSequence = value;
        return !(charSequence == null || charSequence.length() == 0) ? Boolean.parseBoolean(value) : defaultValue;
    }

    @Nullable
    public final Boolean getBoolean(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String value = this.values.get(key);
        CharSequence charSequence = value;
        return !(charSequence == null || charSequence.length() == 0) ? Boolean.valueOf(Boolean.parseBoolean(value)) : null;
    }

    @NotNull
    public final FilePreferences put(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ((Map)this.values).put(key, value);
        return this;
    }

    @NotNull
    public final FilePreferences remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (this.values.containsKey(key)) {
            this.values.remove(key);
        }
        return this;
    }

    @NotNull
    public final String getString(@NotNull String key, @NotNull String defaultValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        String value = this.values.get(key);
        String string = value;
        if (string == null) {
            string = defaultValue;
        }
        return string;
    }

    @Nullable
    public final String getString(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String value = this.values.get(key);
        String string = value;
        if (string == null) {
            string = null;
        }
        return string;
    }

    @NotNull
    public final FilePreferences put(@NotNull String key, int value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ((Map)this.values).put(key, String.valueOf(value));
        return this;
    }

    public final int getInt(@NotNull String key, int defaultValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String value = this.values.get(key);
        CharSequence charSequence = value;
        return !(charSequence == null || charSequence.length() == 0) ? Integer.parseInt(value) : defaultValue;
    }

    @NotNull
    public final FilePreferences put(@NotNull String key, long value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ((Map)this.values).put(key, String.valueOf(value));
        return this;
    }

    public final long getLong(@NotNull String key, long defaultValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String value = this.values.get(key);
        CharSequence charSequence = value;
        return !(charSequence == null || charSequence.length() == 0) ? Long.parseLong(value) : defaultValue;
    }

    /*
     * WARNING - void declaration
     */
    private final void persistDataset() {
        void $this$mapTo$iv$iv;
        Map $this$map$iv = this.values;
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new MapEntry((String)it.getKey(), (String)it.getValue()));
        }
        List entries = (List)destination$iv$iv;
        StringFormat $this$encodeToString$iv = (StringFormat)this.json;
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(MapEntry.class))));
        boolean $i$f$cast = false;
        Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
        String jsonContent = $this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, (Object)entries);
        FileUtility.INSTANCE.writeString(this.file, jsonContent);
    }

    private final void migrateOldData(PathProvider pathProvider, String fileName) {
        File oldFile = new File(pathProvider.getSharedPrefsDir(), fileName);
        if (oldFile.exists()) {
            Object saved = FileUtility.readSerializable(oldFile);
            if (saved instanceof HashMap) {
                Unit unit;
                Map $this$forEach$iv = (Map)saved;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    String string;
                    String string2;
                    Map map;
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = iterator.next();
                    boolean bl = false;
                    Object v = it.getValue();
                    if (v instanceof String) {
                        map = this.values;
                        Object k = it.getKey();
                        Intrinsics.checkNotNull(k, (String)"null cannot be cast to non-null type kotlin.String");
                        string2 = (String)k;
                        Object v2 = it.getValue();
                        Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type kotlin.String");
                        string = (String)v2;
                        map.put(string2, string);
                        continue;
                    }
                    if (v instanceof Boolean) {
                        map = this.values;
                        Object k = it.getKey();
                        Intrinsics.checkNotNull(k, (String)"null cannot be cast to non-null type kotlin.String");
                        string2 = (String)k;
                        Object v3 = it.getValue();
                        Intrinsics.checkNotNull(v3, (String)"null cannot be cast to non-null type kotlin.Boolean");
                        string = String.valueOf((Boolean)v3);
                        map.put(string2, string);
                        continue;
                    }
                    if (v instanceof Integer) {
                        map = this.values;
                        Object k = it.getKey();
                        Intrinsics.checkNotNull(k, (String)"null cannot be cast to non-null type kotlin.String");
                        string2 = (String)k;
                        Object v4 = it.getValue();
                        Intrinsics.checkNotNull(v4, (String)"null cannot be cast to non-null type kotlin.Int");
                        string = String.valueOf((Integer)v4);
                        map.put(string2, string);
                        continue;
                    }
                    if (!(v instanceof Long)) continue;
                    map = this.values;
                    Object k = it.getKey();
                    Intrinsics.checkNotNull(k, (String)"null cannot be cast to non-null type kotlin.String");
                    string2 = (String)k;
                    Object v5 = it.getValue();
                    Intrinsics.checkNotNull(v5, (String)"null cannot be cast to non-null type kotlin.Long");
                    string = String.valueOf((Long)v5);
                    map.put(string2, string);
                }
                Unit it = unit = Unit.INSTANCE;
                boolean bl = false;
                this.persistDataset();
            }
            FileUtility.deleteAndLogIfFailed(oldFile);
        }
    }

    private static final void apply$lambda-0(FilePreferences this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.persistDataset();
    }

    @JvmStatic
    @NotNull
    public static final synchronized FilePreferences get(@NotNull Executor ioExecutor, @NotNull PathProvider pathProvider, @NotNull String filename) {
        return Companion.get(ioExecutor, pathProvider, filename);
    }

    public /* synthetic */ FilePreferences(Executor ioExecutor, PathProvider pathProvider, String filename, DefaultConstructorMarker $constructor_marker) {
        this(ioExecutor, pathProvider, filename);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\r\u0010\f\u001a\u00020\rH\u0001\u00a2\u0006\u0002\b\u000eJ\"\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0004H\u0007R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/vungle/ads/internal/persistence/FilePreferences$Companion;", "", "()V", "FILENAME", "", "getFILENAME$annotations", "OLD_FILENAME", "OLD_TPAT_FAILED_FILENAME", "TPAT_FAILED_FILENAME", "filePreferenceMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/vungle/ads/internal/persistence/FilePreferences;", "clear", "", "clear$vungle_ads_release", "get", "ioExecutor", "Ljava/util/concurrent/Executor;", "pathProvider", "Lcom/vungle/ads/internal/util/PathProvider;", "filename", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getFILENAME$annotations() {
        }

        @JvmStatic
        @NotNull
        public final synchronized FilePreferences get(@NotNull Executor ioExecutor, @NotNull PathProvider pathProvider, @NotNull String filename) {
            Intrinsics.checkNotNullParameter((Object)ioExecutor, (String)"ioExecutor");
            Intrinsics.checkNotNullParameter((Object)pathProvider, (String)"pathProvider");
            Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
            ConcurrentMap $this$getOrPut$iv = filePreferenceMap;
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(filename);
            if (object == null) {
                boolean bl = false;
                FilePreferences default$iv = new FilePreferences(ioExecutor, pathProvider, filename, null);
                boolean bl2 = false;
                object = $this$getOrPut$iv.putIfAbsent(filename, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            Intrinsics.checkNotNullExpressionValue(object, (String)"filePreferenceMap.getOrP\u2026, filename)\n            }");
            return (FilePreferences)object;
        }

        public static /* synthetic */ FilePreferences get$default(Companion companion, Executor executor, PathProvider pathProvider, String string, int n, Object object) {
            if ((n & 4) != 0) {
                string = FilePreferences.FILENAME;
            }
            return companion.get(executor, pathProvider, string);
        }

        @VisibleForTesting
        public final void clear$vungle_ads_release() {
            filePreferenceMap.clear();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Serializable
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001d\u001eB-\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tB\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001J!\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u00c7\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u001f"}, d2={"Lcom/vungle/ads/internal/persistence/FilePreferences$MapEntry;", "", "seen1", "", "key", "", "value", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Ljava/lang/String;Ljava/lang/String;)V", "getKey", "()Ljava/lang/String;", "getValue", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "$serializer", "Companion", "vungle-ads_release"})
    public static final class MapEntry {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String key;
        @NotNull
        private final String value;

        public MapEntry(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.key = key;
            this.value = value;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public final String component1() {
            return this.key;
        }

        @NotNull
        public final String component2() {
            return this.value;
        }

        @NotNull
        public final MapEntry copy(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new MapEntry(key, value);
        }

        public static /* synthetic */ MapEntry copy$default(MapEntry mapEntry, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = mapEntry.key;
            }
            if ((n & 2) != 0) {
                string2 = mapEntry.value;
            }
            return mapEntry.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "MapEntry(key=" + this.key + ", value=" + this.value + ')';
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = result * 31 + this.value.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MapEntry)) {
                return false;
            }
            MapEntry mapEntry = (MapEntry)other;
            if (!Intrinsics.areEqual((Object)this.key, (Object)mapEntry.key)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.value, (Object)mapEntry.value);
        }

        @JvmStatic
        public static final void write$Self(@NotNull MapEntry self, @NotNull CompositeEncoder output, @NotNull SerialDescriptor serialDesc) {
            Intrinsics.checkNotNullParameter((Object)self, (String)"self");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)serialDesc, (String)"serialDesc");
            output.encodeStringElement(serialDesc, 0, self.key);
            output.encodeStringElement(serialDesc, 1, self.value);
        }

        @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
        public /* synthetic */ MapEntry(int seen1, String key, String value, SerializationConstructorMarker serializationConstructorMarker) {
            if (3 != (3 & seen1)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen1, (int)3, (SerialDescriptor)MapEntry$$serializer.INSTANCE.getDescriptor());
            }
            this.key = key;
            this.value = value;
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lcom/vungle/ads/internal/persistence/FilePreferences$MapEntry$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/vungle/ads/internal/persistence/FilePreferences$MapEntry;", "vungle-ads_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<MapEntry> serializer() {
                return (KSerializer)MapEntry$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

