/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.bidding;

import android.content.Context;
import com.vungle.ads.AnalyticsClient;
import com.vungle.ads.ServiceLocator;
import com.vungle.ads.internal.ConfigManager;
import com.vungle.ads.internal.bidding.BidTokenEncoder;
import com.vungle.ads.internal.model.CommonRequestBody;
import com.vungle.ads.internal.model.RtbRequest;
import com.vungle.ads.internal.model.RtbToken;
import com.vungle.ads.internal.network.VungleApiClient;
import com.vungle.ads.internal.util.ActivityManager;
import com.vungle.ads.internal.util.InputOutputUtils;
import com.vungle.ads.internal.util.Logger;
import java.io.IOException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0006\u0010\r\u001a\u00020\fJ\b\u0010\u000e\u001a\u0004\u0018\u00010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010\u00b2\u0006\n\u0010\u0011\u001a\u00020\u0012X\u008a\u0084\u0002"}, d2={"Lcom/vungle/ads/internal/bidding/BidTokenEncoder;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "enterBackgroundTime", "", "json", "Lkotlinx/serialization/json/Json;", "ordinalView", "", "bidTokenV5", "", "constructV5Token", "encode", "Companion", "vungle-ads_release", "vungleApiClient", "Lcom/vungle/ads/internal/network/VungleApiClient;"})
public final class BidTokenEncoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    private int ordinalView;
    @NotNull
    private final Json json;
    private long enterBackgroundTime;
    private static final int TOKEN_VERSION = 5;

    public BidTokenEncoder(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.json = JsonKt.Json$default(null, (Function1)json.1.INSTANCE, (int)1, null);
        ActivityManager.Companion.addLifecycleListener(new ActivityManager.LifeCycleCallback(){

            @Override
            public void onResume() {
                super.onResume();
                if (System.currentTimeMillis() > enterBackgroundTime + ConfigManager.INSTANCE.getSessionTimeout()) {
                    ordinalView = 0;
                    enterBackgroundTime = 0L;
                }
            }

            @Override
            public void onPause() {
                super.onPause();
                enterBackgroundTime = System.currentTimeMillis();
            }
        });
    }

    @Nullable
    public final String encode() {
        int n = this.ordinalView;
        this.ordinalView = n + 1;
        return this.bidTokenV5();
    }

    private final String bidTokenV5() {
        String string;
        try {
            String token = this.constructV5Token();
            Logger.Companion.w("BidTokenEncoder", "BidToken: " + token);
            String converted = InputOutputUtils.INSTANCE.convertForSending(token);
            Logger.Companion.w("BidTokenEncoder", "After conversion: 5:" + converted);
            string = "5:" + converted;
        }
        catch (IOException e2) {
            AnalyticsClient.logError$vungle_ads_release$default(AnalyticsClient.INSTANCE, 116, "Fail to gzip bidtoken " + e2.getLocalizedMessage(), null, null, null, 28, null);
            string = null;
        }
        return string;
    }

    @NotNull
    public final String constructV5Token() {
        ServiceLocator.Companion companion = ServiceLocator.Companion;
        Context context$iv = this.context;
        boolean $i$f$inject = false;
        Lazy vungleApiClient$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<VungleApiClient>(context$iv){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final VungleApiClient invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(VungleApiClient.class);
            }
        }));
        CommonRequestBody commonRequestBody = BidTokenEncoder.constructV5Token$lambda-0((Lazy<VungleApiClient>)vungleApiClient$delegate).requestBody(!ConfigManager.INSTANCE.signalsDisabled());
        RtbToken body = new RtbToken(commonRequestBody.getDevice(), commonRequestBody.getUser(), commonRequestBody.getExt(), new RtbRequest(VungleApiClient.Companion.getHeaderUa()), this.ordinalView);
        StringFormat $this$encodeToString$iv = (StringFormat)this.json;
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(RtbToken.class));
        boolean $i$f$cast = false;
        Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
        return $this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, (Object)body);
    }

    private static final VungleApiClient constructV5Token$lambda-0(Lazy<VungleApiClient> $vungleApiClient$delegate) {
        Lazy<VungleApiClient> lazy = $vungleApiClient$delegate;
        return (VungleApiClient)lazy.getValue();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/vungle/ads/internal/bidding/BidTokenEncoder$Companion;", "", "()V", "TOKEN_VERSION", "", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

