/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.utility;

import android.os.Handler;
import androidx.annotation.NonNull;

public class RefreshHandler
extends Handler {
    private static final int ID = 0;
    private static final int DISABLE_REFRESH_VALUE = 0;
    private long handlerStartTime;
    private long handlerTimeElapsed;
    private final long refreshDuration;
    private Runnable runnable;

    public RefreshHandler(@NonNull Runnable runnable, long refreshInterval) {
        this.refreshDuration = refreshInterval;
        this.runnable = runnable;
    }

    public synchronized void pause() {
        if (this.hasMessages(0)) {
            this.handlerTimeElapsed += System.currentTimeMillis() - this.handlerStartTime;
            this.removeMessages(0);
            this.removeCallbacks(this.runnable);
        }
    }

    public synchronized void start() {
        if (this.refreshDuration <= 0L) {
            return;
        }
        if (!this.hasMessages(0)) {
            long delay = this.refreshDuration - this.handlerTimeElapsed;
            this.handlerStartTime = System.currentTimeMillis();
            this.postDelayed(this.runnable, delay);
        }
    }

    public synchronized void clean() {
        this.removeMessages(0);
        this.removeCallbacks(this.runnable);
        this.handlerTimeElapsed = 0L;
        this.handlerStartTime = 0L;
    }
}

