/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.utility;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import com.vungle.warren.utility.Scheduler;

public class HandlerScheduler
implements Scheduler {
    private Handler handler = new Handler(Looper.getMainLooper());

    @Override
    public void schedule(@NonNull Runnable runnable, @NonNull String tag, long delay) {
        this.handler.postAtTime(runnable, (Object)tag, this.calculateTime(delay));
    }

    private long calculateTime(long delay) {
        return SystemClock.uptimeMillis() + delay;
    }

    @Override
    public void schedule(@NonNull Runnable runnable, long delay) {
        this.handler.postAtTime(runnable, this.calculateTime(delay));
    }

    @Override
    public void cancel(@NonNull String tag) {
        this.handler.removeCallbacksAndMessages((Object)tag);
    }

    @Override
    public void cancelAll() {
        this.handler.removeCallbacksAndMessages(null);
    }
}

