/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.utility;

import android.app.Activity;
import android.app.Application;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;

public class ActivityManager
implements Application.ActivityLifecycleCallbacks {
    public static final String TAG = ActivityManager.class.getSimpleName();
    private static final ActivityManager instance = new ActivityManager();
    private boolean initialized;
    private int started;
    private int resumed;
    private CopyOnWriteArraySet<LifeCycleCallback> callbacks = new CopyOnWriteArraySet();
    private ConcurrentHashMap<LeftApplicationCallback, LifeCycleCallback> adLeftCallbacks = new ConcurrentHashMap();
    @VisibleForTesting
    static final long TIMEOUT = 3000L;
    private Handler handler;
    private boolean paused = true;
    private boolean stopped = true;
    @VisibleForTesting
    static final long CONFIG_CHANGE_DELAY = 700L;
    private Runnable configChangeRunnable = new Runnable(){

        @Override
        public void run() {
            if (ActivityManager.this.resumed == 0 && !ActivityManager.this.paused) {
                ActivityManager.this.paused = true;
                for (LifeCycleCallback callback : ActivityManager.this.callbacks) {
                    callback.onPause();
                }
            }
            if (ActivityManager.this.started == 0 && ActivityManager.this.paused && !ActivityManager.this.stopped) {
                ActivityManager.this.stopped = true;
                for (LifeCycleCallback callback : ActivityManager.this.callbacks) {
                    callback.onStop();
                }
            }
        }
    };

    private ActivityManager() {
    }

    public static ActivityManager getInstance() {
        return instance;
    }

    public void init(Context context) {
        if (this.initialized) {
            return;
        }
        this.handler = new Handler(Looper.getMainLooper());
        Application app = (Application)context.getApplicationContext();
        app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        this.initialized = true;
    }

    @VisibleForTesting
    void deInit(Context context) {
        Application app = (Application)context.getApplicationContext();
        app.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        this.started = 0;
        this.resumed = 0;
        this.paused = true;
        this.stopped = true;
        this.initialized = false;
        this.callbacks.clear();
        this.adLeftCallbacks.clear();
    }

    public static void startWhenForeground(Context context, final Intent intent) {
        final WeakReference<Context> weakContext = new WeakReference<Context>(context);
        if (ActivityManager.getInstance().inForeground()) {
            ActivityManager.startActivityHandleException(context, intent);
        } else {
            instance.addListener(new LifeCycleCallback(){

                @Override
                public void onStart() {
                    super.onStart();
                    instance.removeListener(this);
                    Context context = (Context)weakContext.get();
                    if (context != null) {
                        ActivityManager.startActivityHandleException(context, intent);
                    }
                }
            });
        }
    }

    @VisibleForTesting
    protected boolean inForeground() {
        return !this.initialized || this.started > 0;
    }

    private void addListener(LifeCycleCallback callback) {
        this.callbacks.add(callback);
    }

    private void removeListener(LifeCycleCallback callback) {
        this.callbacks.remove(callback);
    }

    public void onActivityCreated(@NonNull Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(@NonNull Activity activity) {
        ++this.started;
        if (this.started == 1 && this.stopped) {
            this.stopped = false;
            for (LifeCycleCallback callback : this.callbacks) {
                callback.onStart();
            }
        }
    }

    public void onActivityStopped(@NonNull Activity activity) {
        this.started = Math.max(0, this.started - 1);
        this.handler.postDelayed(this.configChangeRunnable, 700L);
    }

    public void onActivityResumed(@NonNull Activity activity) {
        ++this.resumed;
        if (this.resumed == 1) {
            if (this.paused) {
                this.paused = false;
                for (LifeCycleCallback callback : this.callbacks) {
                    callback.onResume();
                }
            } else {
                this.handler.removeCallbacks(this.configChangeRunnable);
            }
        }
    }

    public void onActivityPaused(@NonNull Activity activity) {
        this.resumed = Math.max(0, this.resumed - 1);
        this.handler.postDelayed(this.configChangeRunnable, 700L);
    }

    public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
    }

    public void onActivityDestroyed(@NonNull Activity activity) {
    }

    public void addOnNextAppLeftCallback(@NonNull LeftApplicationCallback leftCallback) {
        if (!this.initialized) {
            leftCallback.onLeftApplication();
            return;
        }
        final WeakReference<LeftApplicationCallback> weakCallback = new WeakReference<LeftApplicationCallback>(leftCallback);
        final Runnable cancelRunnable = new Runnable(){

            @Override
            public void run() {
                ActivityManager.this.handler.removeCallbacks((Runnable)this);
                ActivityManager.this.removeOnNextAppLeftCallback((LeftApplicationCallback)weakCallback.get());
            }
        };
        LifeCycleCallback callback = new LifeCycleCallback(){
            boolean wasPaused = false;

            @Override
            public void onStop() {
                super.onStop();
                LeftApplicationCallback leftCallback = (LeftApplicationCallback)weakCallback.get();
                if (this.wasPaused && leftCallback != null && ActivityManager.this.adLeftCallbacks.containsKey(leftCallback)) {
                    leftCallback.onLeftApplication();
                }
                ActivityManager.this.removeOnNextAppLeftCallback(leftCallback);
                ActivityManager.this.handler.removeCallbacks(cancelRunnable);
            }

            @Override
            public void onResume() {
                super.onResume();
                ActivityManager.this.handler.postDelayed(cancelRunnable, 1400L);
            }

            @Override
            public void onPause() {
                super.onPause();
                this.wasPaused = true;
                ActivityManager.this.handler.removeCallbacks(cancelRunnable);
            }
        };
        this.adLeftCallbacks.put(leftCallback, callback);
        if (this.inForeground()) {
            this.handler.postDelayed(cancelRunnable, 3000L);
            this.addListener(callback);
        } else {
            ActivityManager.getInstance().addListener(new LifeCycleCallback(){

                @Override
                public void onStart() {
                    instance.removeListener(this);
                    LifeCycleCallback callback = (LifeCycleCallback)ActivityManager.this.adLeftCallbacks.get(weakCallback.get());
                    if (callback != null) {
                        ActivityManager.this.handler.postDelayed(cancelRunnable, 3000L);
                        ActivityManager.this.addListener(callback);
                    }
                }
            });
        }
    }

    private void removeOnNextAppLeftCallback(@Nullable LeftApplicationCallback leftCallback) {
        if (leftCallback == null) {
            return;
        }
        LifeCycleCallback callback = this.adLeftCallbacks.remove(leftCallback);
        if (callback != null) {
            this.removeListener(callback);
        }
    }

    private static void startActivityHandleException(Context context, Intent startIntent) {
        try {
            context.startActivity(startIntent);
        }
        catch (ActivityNotFoundException actNotFoundException) {
            Log.e((String)TAG, (String)("Cannot find activity to handle the Implicit intent: " + actNotFoundException.getLocalizedMessage()));
        }
    }

    public static interface LeftApplicationCallback {
        public void onLeftApplication();
    }

    static class LifeCycleCallback {
        LifeCycleCallback() {
        }

        public void onStart() {
        }

        public void onStop() {
        }

        public void onResume() {
        }

        public void onPause() {
        }
    }
}

