/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.ui.view;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewManager;
import android.view.ViewParent;
import android.webkit.WebView;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.vungle.warren.AdConfig;
import com.vungle.warren.PresentationFactory;
import com.vungle.warren.VungleNativeAd;
import com.vungle.warren.error.VungleException;
import com.vungle.warren.ui.CloseDelegate;
import com.vungle.warren.ui.JavascriptBridge;
import com.vungle.warren.ui.contract.AdContract;
import com.vungle.warren.ui.contract.WebAdContract;
import com.vungle.warren.ui.view.VungleWebClient;
import com.vungle.warren.ui.view.WebSettingsUtils;
import com.vungle.warren.utility.ExternalRouter;
import java.util.concurrent.atomic.AtomicReference;

public class VungleNativeView
extends WebView
implements WebAdContract.WebAdView,
VungleNativeAd {
    private static final String TAG = VungleNativeView.class.getName();
    private WebAdContract.WebAdPresenter presenter;
    private BroadcastReceiver broadcastReceiver;
    private final AdContract.AdvertisementPresenter.EventListener listener;
    private final String placementID;
    private final AdConfig config;
    PresentationFactory presenterFactory;
    private AtomicReference<Boolean> isAdVisible = new AtomicReference();

    public void onResume() {
        super.onResume();
        Log.d((String)TAG, (String)"Resuming Flex");
        this.setAdVisibility(true);
    }

    public void onPause() {
        super.onPause();
        this.setAdVisibility(false);
    }

    public VungleNativeView(@NonNull Context context, @NonNull String placementID, @Nullable AdConfig config, @NonNull PresentationFactory presentationFactory, @NonNull AdContract.AdvertisementPresenter.EventListener listener) {
        super(context);
        this.listener = listener;
        this.placementID = placementID;
        this.config = config;
        this.presenterFactory = presentationFactory;
        this.setLayerType(2, null);
        this.setBackgroundColor(0);
    }

    private void prepare(Bundle savedInstanceState) {
        WebSettingsUtils.applyDefault(this);
        this.addJavascriptInterface(new JavascriptBridge(this.presenter), "Android");
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
        if (Build.VERSION.SDK_INT < 17) {
            this.setAdVisibility(true);
        } else {
            this.getSettings().setMediaPlaybackRequiresUserGesture(false);
        }
    }

    @Override
    public void finishDisplayingAd() {
        this.finishDisplayingAdInternal(true);
    }

    public void finishDisplayingAdInternal(boolean isFinishByExternalApi) {
        if (this.presenter != null) {
            int flag = 2 | (isFinishByExternalApi ? 4 : 0);
            this.presenter.stop(flag);
        } else if (this.presenterFactory != null) {
            this.presenterFactory.destroy();
            this.presenterFactory = null;
            this.listener.onError(new VungleException(25), this.placementID);
        }
        this.destroyAdView();
    }

    @Override
    public View renderNativeView() {
        return this;
    }

    @Override
    public void setAdVisibility(boolean isVisible) {
        if (this.presenter != null) {
            this.presenter.setAdVisibility(isVisible);
        } else {
            this.isAdVisible.set(isVisible);
        }
    }

    @Override
    public void setPresenter(@NonNull WebAdContract.WebAdPresenter presenter) {
    }

    @Override
    public void setOrientation(int orientation) {
    }

    @Override
    public void showWebsite(@NonNull String url) {
        this.loadUrl(url);
    }

    @Override
    public String getWebsiteUrl() {
        return this.getUrl();
    }

    @Override
    public void close() {
        if (this.presenter != null) {
            if (this.presenter.handleExit(null)) {
                this.finishDisplayingAdInternal(false);
            }
        } else if (this.presenterFactory != null) {
            this.presenterFactory.destroy();
            this.presenterFactory = null;
            this.listener.onError(new VungleException(25), this.placementID);
        }
    }

    @Override
    public void destroyAdView() {
        this.removeJavascriptInterface("Android");
        this.loadUrl("about:blank");
    }

    @Override
    public boolean hasWebView() {
        return true;
    }

    @Override
    public void showCloseButton() {
        throw new UnsupportedOperationException("VungleNativeView does not implement a close button");
    }

    @Override
    public void open(@NonNull String url) {
        Log.d((String)TAG, (String)("Opening " + url));
        if (!ExternalRouter.launch(url, this.getContext())) {
            Log.e((String)TAG, (String)("Cannot open url " + url));
        }
    }

    @Override
    public void showDialog(@Nullable String dialogTitle, @Nullable String dialogBody, @NonNull String dialogContinue, @NonNull String dialogClose, @Nullable DialogInterface.OnClickListener responseListener) {
        throw new UnsupportedOperationException("VungleNativeView does not implement a dialog.");
    }

    @Override
    public void setImmersiveMode() {
    }

    @Override
    public void resumeWeb() {
        this.onResume();
    }

    @Override
    public void pauseWeb() {
        this.onPause();
    }

    @Override
    public void removeWebView() {
        ViewParent viewParent = this.getParent();
        if (viewParent instanceof ViewManager) {
            ((ViewManager)viewParent).removeView((View)this);
        }
    }

    @Override
    public void updateWindow(boolean isFlexView) {
    }

    @Override
    public void setVisibility(boolean isVisible) {
        int setVisibilityState = isVisible ? 0 : 4;
        this.setVisibility(setVisibilityState);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.presenterFactory != null && this.presenter == null) {
            this.presenterFactory.getNativeViewPresentation(this.placementID, this.config, new CloseDelegate(){

                @Override
                public void close() {
                    VungleNativeView.this.finishDisplayingAdInternal(false);
                }
            }, new PresentationFactory.ViewCallback(){

                @Override
                public void onResult(@Nullable Pair<WebAdContract.WebAdPresenter, VungleWebClient> result, @Nullable VungleException error) {
                    VungleNativeView.this.presenterFactory = null;
                    if (result == null || error != null) {
                        if (VungleNativeView.this.listener != null) {
                            VungleNativeView.this.listener.onError(error != null ? error : new VungleException(10), VungleNativeView.this.placementID);
                        }
                        return;
                    }
                    VungleNativeView.this.presenter = (WebAdContract.WebAdPresenter)result.first;
                    VungleWebClient webViewClient = (VungleWebClient)result.second;
                    VungleNativeView.this.setWebViewClient(webViewClient);
                    VungleNativeView.this.presenter.setEventListener(VungleNativeView.this.listener);
                    VungleNativeView.this.presenter.attach(VungleNativeView.this, null);
                    VungleNativeView.this.prepare(null);
                    if (VungleNativeView.this.isAdVisible.get() != null) {
                        VungleNativeView.this.setAdVisibility((Boolean)VungleNativeView.this.isAdVisible.get());
                    }
                }
            });
        }
        this.broadcastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String command = intent.getStringExtra("command");
                if ("stopAll".equalsIgnoreCase(command)) {
                    VungleNativeView.this.finishDisplayingAdInternal(false);
                }
            }
        };
        LocalBroadcastManager.getInstance((Context)this.getContext()).registerReceiver(this.broadcastReceiver, new IntentFilter("AdvertisementBus"));
        this.resumeWeb();
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        this.setAdVisibility(hasWindowFocus);
    }

    protected void onDetachedFromWindow() {
        LocalBroadcastManager.getInstance((Context)this.getContext()).unregisterReceiver(this.broadcastReceiver);
        super.onDetachedFromWindow();
        if (this.presenterFactory != null) {
            this.presenterFactory.destroy();
        }
        this.pauseWeb();
    }
}

