/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.ui.presenter;

import android.content.ActivityNotFoundException;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.WebView;
import android.webkit.WebViewRenderProcess;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.vungle.warren.SessionData;
import com.vungle.warren.analytics.AdAnalytics;
import com.vungle.warren.error.VungleException;
import com.vungle.warren.model.Advertisement;
import com.vungle.warren.model.Cookie;
import com.vungle.warren.model.Placement;
import com.vungle.warren.model.Report;
import com.vungle.warren.persistence.Repository;
import com.vungle.warren.ui.DurationRecorder;
import com.vungle.warren.ui.PresenterAppLeftCallback;
import com.vungle.warren.ui.contract.AdContract;
import com.vungle.warren.ui.contract.WebAdContract;
import com.vungle.warren.ui.state.OptionsState;
import com.vungle.warren.ui.view.WebViewAPI;
import com.vungle.warren.utility.ActivityManager;
import com.vungle.warren.utility.AsyncFileUtils;
import com.vungle.warren.utility.Scheduler;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class MRAIDAdPresenter
implements WebAdContract.WebAdPresenter,
WebViewAPI.MRAIDDelegate,
WebViewAPI.WebClientErrorHandler {
    private static final String TAG = MRAIDAdPresenter.class.getCanonicalName();
    private static final String EXTRA_INCENTIVIZED_SENT = "incentivized_sent";
    private static final String CLOSE = "close";
    private static final String CONSENT_ACTION = "consentAction";
    private static final String ACTION_WITH_VALUE = "actionWithValue";
    private static final String VIDEO_VIEWED = "videoViewed";
    private static final String TPAT = "tpat";
    private static final String ACTION = "action";
    private static final String OPEN = "open";
    private static final String OPEN_NON_MRAID = "openNonMraid";
    private static final String USE_CUSTOM_CLOSE = "useCustomClose";
    private static final String USE_CUSTOM_PRIVACY = "useCustomPrivacy";
    private static final String OPEN_PRIVACY = "openPrivacy";
    private static final String SUCCESSFUL_VIEW = "successfulView";
    private static final String EXTRA_REPORT = "saved_report";
    private static final String FLEXVIEW = "flexview";
    private final Scheduler scheduler;
    private final AdAnalytics analytics;
    private Map<String, Cookie> cookieMap = new HashMap<String, Cookie>();
    private AsyncFileUtils.ExistenceOperation fileExistenceOperation;
    private AdContract.AdvertisementPresenter.EventListener bus;
    private Advertisement advertisement;
    private Report report;
    @NonNull
    private final Placement placement;
    private WebViewAPI webClient;
    private Repository repository;
    private File assetDir;
    private WebAdContract.WebAdView adView;
    private boolean backEnabled;
    private long duration;
    private SessionData sessionData;
    private AtomicBoolean sendReportIncentivized = new AtomicBoolean(false);
    private AtomicBoolean isDestroying = new AtomicBoolean(false);
    private Repository.SaveCallback repoCallback = new Repository.SaveCallback(){
        boolean errorHappened = false;

        @Override
        public void onSaved() {
        }

        @Override
        public void onError(Exception e) {
            if (this.errorHappened) {
                return;
            }
            this.errorHappened = true;
            MRAIDAdPresenter.this.makeBusError(26);
            MRAIDAdPresenter.this.closeView();
        }
    };
    private DurationRecorder durationRecorder;
    private ActivityManager activityManager;

    public MRAIDAdPresenter(@NonNull Advertisement advertisement, @NonNull Placement placement, @NonNull Repository repository, @NonNull Scheduler scheduler, @NonNull AdAnalytics adAnalytics, @NonNull WebViewAPI webViewAPI, @Nullable OptionsState state, @NonNull File assetDir, @NonNull SessionData sessionData, @NonNull ActivityManager activityManager) {
        this.advertisement = advertisement;
        this.repository = repository;
        this.placement = placement;
        this.scheduler = scheduler;
        this.analytics = adAnalytics;
        this.webClient = webViewAPI;
        this.assetDir = assetDir;
        this.activityManager = activityManager;
        this.sessionData = sessionData;
        this.loadData(state);
    }

    @Override
    public void setEventListener(@Nullable AdContract.AdvertisementPresenter.EventListener listener) {
        this.bus = listener;
    }

    public void reportAction(@NonNull String action, @Nullable String value) {
        if (action.equals("videoLength")) {
            this.duration = Long.parseLong(value);
            this.report.setVideoLength(this.duration);
            this.repository.save(this.report, this.repoCallback);
            return;
        }
        this.report.recordAction(action, value, System.currentTimeMillis());
        this.repository.save(this.report, this.repoCallback);
    }

    @Override
    public void onViewConfigurationChanged() {
        this.adView.updateWindow(this.advertisement.getTemplateType().equals(FLEXVIEW));
        this.webClient.notifyPropertiesChange(true);
    }

    @Override
    public void attach(@NonNull WebAdContract.WebAdView adView, @Nullable OptionsState state) {
        this.isDestroying.set(false);
        this.adView = adView;
        adView.setPresenter(this);
        int settings = this.advertisement.getAdConfig().getSettings();
        if (settings > 0) {
            this.backEnabled = (settings & 2) == 2;
        }
        int requestedOrientation = -1;
        int adOrientation = this.advertisement.getAdConfig().getAdOrientation();
        if (adOrientation == 3) {
            switch (this.advertisement.getOrientation()) {
                case 0: {
                    requestedOrientation = 7;
                    break;
                }
                case 1: {
                    requestedOrientation = 6;
                }
            }
        } else {
            requestedOrientation = adOrientation == 0 ? 7 : (adOrientation == 1 ? 6 : 4);
        }
        Log.d((String)TAG, (String)("Requested Orientation " + requestedOrientation));
        adView.setOrientation(requestedOrientation);
        this.prepare(state);
    }

    @Override
    public void detach(boolean changingConfiguration) {
        int flag = (changingConfiguration ? 1 : 0) | 2;
        if (this.fileExistenceOperation != null) {
            this.fileExistenceOperation.cancel();
        }
        this.stop(flag);
        this.adView.destroyAdView();
    }

    private void prepare(@Nullable OptionsState state) {
        int delay;
        Cookie gdprConsent;
        Cookie incentivizedCookie;
        String userIdFromCookie;
        this.webClient.setMRAIDDelegate(this);
        this.webClient.setErrorHandler(this);
        File template = new File(this.assetDir.getPath() + File.separator + "template");
        this.loadMraid(template);
        if (FLEXVIEW.equals(this.advertisement.getTemplateType()) && this.advertisement.getAdConfig().getFlexViewCloseTime() > 0) {
            this.scheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    long closeTime = System.currentTimeMillis();
                    MRAIDAdPresenter.this.report.recordAction("mraidCloseByTimer", "", closeTime);
                    MRAIDAdPresenter.this.report.recordAction("mraidClose", "", closeTime);
                    MRAIDAdPresenter.this.repository.save(MRAIDAdPresenter.this.report, MRAIDAdPresenter.this.repoCallback);
                    MRAIDAdPresenter.this.closeView();
                }
            }, (long)this.advertisement.getAdConfig().getFlexViewCloseTime() * 1000L);
        }
        String string = userIdFromCookie = (incentivizedCookie = this.cookieMap.get("incentivizedTextSetByPub")) == null ? null : incentivizedCookie.getString("userID");
        if (this.report == null) {
            this.report = new Report(this.advertisement, this.placement, System.currentTimeMillis(), userIdFromCookie, this.sessionData);
            this.report.setTtDownload(this.advertisement.getTtDownload());
            this.repository.save(this.report, this.repoCallback);
        }
        if (this.durationRecorder == null) {
            this.durationRecorder = new DurationRecorder(this.report, this.repository, this.repoCallback);
        }
        if ((gdprConsent = this.cookieMap.get("consentIsImportantToVungle")) != null) {
            boolean collectConsent = gdprConsent.getBoolean("is_country_data_protected") != false && "unknown".equals(gdprConsent.getString("consent_status"));
            this.webClient.setConsentStatus(collectConsent, gdprConsent.getString("consent_title"), gdprConsent.getString("consent_message"), gdprConsent.getString("button_accept"), gdprConsent.getString("button_deny"));
            if (collectConsent) {
                gdprConsent.putValue("consent_status", "opted_out_by_timeout");
                gdprConsent.putValue("timestamp", System.currentTimeMillis() / 1000L);
                gdprConsent.putValue("consent_source", "vungle_modal");
                this.repository.save(gdprConsent, this.repoCallback);
            }
        }
        if ((delay = this.advertisement.getShowCloseDelay(this.placement.isIncentivized())) > 0) {
            this.scheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    MRAIDAdPresenter.this.backEnabled = true;
                }
            }, delay);
        } else {
            this.backEnabled = true;
        }
        this.adView.updateWindow(FLEXVIEW.equals(this.advertisement.getTemplateType()));
        if (this.bus != null) {
            this.bus.onNext("start", null, this.placement.getId());
        }
    }

    private void loadMraid(@NonNull File template) {
        File dest = new File(template.getParent());
        final File indexHtml = new File(dest.getPath() + File.separator + "index.html");
        this.fileExistenceOperation = AsyncFileUtils.isFileExistAsync(indexHtml, new AsyncFileUtils.FileExistCallback(){

            @Override
            public void status(boolean isExist) {
                if (!isExist) {
                    MRAIDAdPresenter.this.makeBusError(27);
                    MRAIDAdPresenter.this.makeBusError(10);
                    MRAIDAdPresenter.this.adView.close();
                    return;
                }
                MRAIDAdPresenter.this.adView.showWebsite("file://" + indexHtml.getPath());
            }
        });
    }

    @Override
    public void start() {
        if (!this.adView.hasWebView()) {
            this.reportErrorAndCloseAd(31);
            return;
        }
        this.adView.setImmersiveMode();
        this.adView.resumeWeb();
        this.setAdVisibility(true);
    }

    @Override
    public void stop(@AdContract.AdStopReason int stopReason) {
        boolean isChangingConfigurations = (stopReason & 1) != 0;
        boolean isFinishing = (stopReason & 2) != 0;
        boolean isFinishByAPI = (stopReason & 4) != 0;
        this.adView.pauseWeb();
        this.setAdVisibility(false);
        if (!isChangingConfigurations && isFinishing && !this.isDestroying.getAndSet(true)) {
            if (this.webClient != null) {
                this.webClient.setMRAIDDelegate(null);
            }
            if (isFinishByAPI) {
                this.reportAction("mraidCloseByApi", null);
            }
            this.repository.save(this.report, this.repoCallback);
            if (this.bus != null) {
                this.bus.onNext("end", this.report.isCTAClicked() ? "isCTAClicked" : null, this.placement.getId());
            }
        }
    }

    @Override
    public void setAdVisibility(boolean isViewable) {
        this.webClient.setAdVisibility(isViewable);
        if (isViewable) {
            this.durationRecorder.start();
        } else {
            this.durationRecorder.stop();
        }
    }

    @Override
    public void generateSaveState(@Nullable OptionsState state) {
        if (state == null) {
            return;
        }
        this.repository.save(this.report, this.repoCallback);
        state.put(EXTRA_REPORT, this.report.getId());
        state.put(EXTRA_INCENTIVIZED_SENT, this.sendReportIncentivized.get());
    }

    @Override
    public void restoreFromSave(@Nullable OptionsState state) {
        if (state == null) {
            return;
        }
        boolean incentivizedShown = state.getBoolean(EXTRA_INCENTIVIZED_SENT, false);
        if (incentivizedShown) {
            this.sendReportIncentivized.set(incentivizedShown);
        }
        if (this.report == null) {
            this.adView.close();
            return;
        }
    }

    @Override
    public boolean handleExit(@Nullable String flexViewCloseApiPlacementID) {
        if (flexViewCloseApiPlacementID != null) {
            if (this.advertisement == null) {
                Log.e((String)TAG, (String)"Unable to close advertisement");
                return false;
            }
            if (!this.placement.getId().equals(flexViewCloseApiPlacementID)) {
                Log.e((String)TAG, (String)"Cannot close FlexView Ad with invalid placement reference id");
                return false;
            }
            if (!FLEXVIEW.equals(this.advertisement.getTemplateType())) {
                Log.e((String)TAG, (String)"Cannot close a Non FlexView ad");
                return false;
            }
            this.adView.showWebsite("javascript:window.vungle.mraidBridgeExt.requestMRAIDClose()");
            this.reportAction("mraidCloseByApi", null);
            return true;
        }
        if (this.backEnabled) {
            this.adView.showWebsite("javascript:window.vungle.mraidBridgeExt.requestMRAIDClose()");
        }
        return false;
    }

    @Override
    public boolean processCommand(@NonNull String command, @NonNull JsonObject arguments) {
        switch (command) {
            case "close": {
                this.reportAction("mraidClose", null);
                this.closeView();
                return true;
            }
            case "consentAction": {
                Cookie gdprConsent = this.cookieMap.get("consentIsImportantToVungle");
                if (gdprConsent == null) {
                    gdprConsent = new Cookie("consentIsImportantToVungle");
                }
                String value = arguments.get("event").getAsString();
                gdprConsent.putValue("consent_status", value);
                gdprConsent.putValue("consent_source", "vungle_modal");
                gdprConsent.putValue("timestamp", System.currentTimeMillis() / 1000L);
                this.repository.save(gdprConsent, this.repoCallback);
                return true;
            }
            case "actionWithValue": {
                String action = arguments.get("event").getAsString();
                String value = arguments.get("value").getAsString();
                this.report.recordAction(action, value, System.currentTimeMillis());
                this.repository.save(this.report, this.repoCallback);
                if (action.equals(VIDEO_VIEWED) && this.duration > 0L) {
                    int percent = 0;
                    try {
                        float position = Float.parseFloat(value);
                        percent = (int)(position / (float)this.duration * 100.0f);
                    }
                    catch (NumberFormatException nfe) {
                        Log.e((String)TAG, (String)"value for videoViewed is null !");
                    }
                    if (percent > 0) {
                        if (this.bus != null) {
                            this.bus.onNext("percentViewed:" + percent, null, this.placement.getId());
                        }
                        Cookie configCookie = this.cookieMap.get("configSettings");
                        if (this.placement.isIncentivized() && percent > 75 && configCookie != null && configCookie.getBoolean("isReportIncentivizedEnabled").booleanValue() && !this.sendReportIncentivized.getAndSet(true)) {
                            JsonObject body = new JsonObject();
                            body.add("placement_reference_id", (JsonElement)new JsonPrimitive(this.placement.getId()));
                            body.add("app_id", (JsonElement)new JsonPrimitive(this.advertisement.getAppID()));
                            body.add("adStartTime", (JsonElement)new JsonPrimitive((Number)this.report.getAdStartTime()));
                            body.add("user", (JsonElement)new JsonPrimitive(this.report.getUserID()));
                            this.analytics.ri(body);
                        }
                    }
                    this.durationRecorder.update();
                }
                if (action.equals("videoLength")) {
                    this.duration = Long.parseLong(value);
                    this.reportAction("videoLength", value);
                    this.webClient.notifyPropertiesChange(true);
                }
                this.adView.setVisibility(true);
                return true;
            }
            case "tpat": {
                String event = arguments.get("event").getAsString();
                this.analytics.ping(this.advertisement.getTpatUrls(event));
                return true;
            }
            case "action": {
                return true;
            }
            case "open": 
            case "openNonMraid": {
                this.reportAction("download", null);
                if (OPEN.equalsIgnoreCase(command)) {
                    this.reportAction("mraidOpen", null);
                } else if (OPEN_NON_MRAID.equalsIgnoreCase(command)) {
                    this.reportAction("nonMraidOpen", null);
                }
                String url = arguments.get("url").getAsString();
                this.activityManager.addOnNextAppLeftCallback(new PresenterAppLeftCallback(this.bus, this.placement));
                if (url == null || url.isEmpty()) {
                    Log.e((String)TAG, (String)"CTA destination URL is not configured properly");
                } else {
                    this.adView.open(url);
                }
                if (this.bus != null) {
                    this.bus.onNext(OPEN, "adClick", this.placement.getId());
                }
                return true;
            }
            case "useCustomClose": {
                String value;
                switch (value = arguments.get("sdkCloseButton").getAsString()) {
                    case "gone": 
                    case "invisible": 
                    case "visible": {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown value " + value);
                    }
                }
                return true;
            }
            case "useCustomPrivacy": {
                String value;
                switch (value = arguments.get(USE_CUSTOM_PRIVACY).getAsString()) {
                    case "gone": 
                    case "true": 
                    case "false": {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown value " + value);
                    }
                }
                return true;
            }
            case "openPrivacy": {
                String url = arguments.get("url").getAsString();
                this.activityManager.addOnNextAppLeftCallback(new PresenterAppLeftCallback(this.bus, this.placement));
                this.adView.open(url);
                return true;
            }
            case "successfulView": {
                if (this.bus != null) {
                    this.bus.onNext(SUCCESSFUL_VIEW, null, this.placement.getId());
                }
                Cookie configCookie = this.cookieMap.get("configSettings");
                if (this.placement.isIncentivized() && configCookie != null && configCookie.getBoolean("isReportIncentivizedEnabled").booleanValue() && !this.sendReportIncentivized.getAndSet(true)) {
                    JsonObject body = new JsonObject();
                    body.add("placement_reference_id", (JsonElement)new JsonPrimitive(this.placement.getId()));
                    body.add("app_id", (JsonElement)new JsonPrimitive(this.advertisement.getAppID()));
                    body.add("adStartTime", (JsonElement)new JsonPrimitive((Number)this.report.getAdStartTime()));
                    body.add("user", (JsonElement)new JsonPrimitive(this.report.getUserID()));
                    this.analytics.ri(body);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void onMraidAction(@NonNull String action) {
        switch (action) {
            case "close": {
                this.closeView();
                break;
            }
            case "download": {
                this.download();
                break;
            }
            case "privacy": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown action " + action);
            }
        }
    }

    private void download() {
        this.reportAction("cta", "");
        try {
            this.analytics.ping(new String[]{this.advertisement.getCTAURL(true)});
            this.activityManager.addOnNextAppLeftCallback(new PresenterAppLeftCallback(this.bus, this.placement));
            this.adView.open(this.advertisement.getCTAURL(false));
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            // empty catch block
        }
    }

    private void closeView() {
        this.adView.close();
        this.scheduler.cancelAll();
    }

    private void loadData(OptionsState state) {
        this.cookieMap.put("incentivizedTextSetByPub", this.repository.load("incentivizedTextSetByPub", Cookie.class).get());
        this.cookieMap.put("consentIsImportantToVungle", this.repository.load("consentIsImportantToVungle", Cookie.class).get());
        this.cookieMap.put("configSettings", this.repository.load("configSettings", Cookie.class).get());
        if (state != null) {
            Report restoredReport;
            String reportId = state.getString(EXTRA_REPORT);
            Report report = restoredReport = TextUtils.isEmpty((CharSequence)reportId) ? null : this.repository.load(reportId, Report.class).get();
            if (restoredReport != null) {
                this.report = restoredReport;
            }
        }
    }

    @Override
    public void onReceivedError(String errorDesc) {
        if (this.report != null) {
            this.report.recordError(errorDesc);
            this.repository.save(this.report, this.repoCallback);
        }
    }

    @Override
    public boolean onWebRenderingProcessGone(WebView view, boolean didCrash) {
        this.handleWebViewException(31);
        return true;
    }

    @Override
    public void onRenderProcessUnresponsive(@NonNull WebView webView, @Nullable WebViewRenderProcess webViewRenderProcess) {
        this.handleWebViewException(32);
    }

    private void handleWebViewException(@VungleException.ExceptionCode int reason) {
        if (this.adView != null) {
            this.adView.removeWebView();
        }
        this.reportErrorAndCloseAd(reason);
    }

    private void reportErrorAndCloseAd(@VungleException.ExceptionCode int reason) {
        this.makeBusError(reason);
        this.closeView();
    }

    private void makeBusError(@VungleException.ExceptionCode int code) {
        if (this.bus != null) {
            this.bus.onError(new VungleException(code), this.placement.getId());
        }
    }
}

