/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.tasks;

import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import com.vungle.warren.AdLoader;
import com.vungle.warren.model.Advertisement;
import com.vungle.warren.model.Placement;
import com.vungle.warren.persistence.DatabaseHelper;
import com.vungle.warren.persistence.Designer;
import com.vungle.warren.persistence.Repository;
import com.vungle.warren.tasks.Job;
import com.vungle.warren.tasks.JobInfo;
import com.vungle.warren.tasks.JobRunner;
import com.vungle.warren.utility.FileUtility;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public class CleanupJob
implements Job {
    static final String TAG = CleanupJob.class.getCanonicalName();
    private final Designer designer;
    private final Repository repository;
    private final AdLoader adLoader;

    CleanupJob(@NonNull Designer designer, @NonNull Repository repository, @NonNull AdLoader adLoader) {
        this.designer = designer;
        this.repository = repository;
        this.adLoader = adLoader;
    }

    @Override
    public int onRunJob(Bundle bundle, JobRunner jobRunner) {
        if (this.designer == null || this.repository == null) {
            return 1;
        }
        Log.d((String)TAG, (String)"CleanupJob: Current directory snapshot");
        FileUtility.printDirectoryTree(this.designer.getCacheDirectory());
        File[] assets = this.designer.getCacheDirectory().listFiles();
        List<Placement> cachedPlacements = this.repository.loadAll(Placement.class).get();
        if (cachedPlacements == null || cachedPlacements.size() == 0) {
            return 0;
        }
        Collection<Placement> validPlacements = this.repository.loadValidPlacements().get();
        HashSet<String> validIds = new HashSet<String>();
        try {
            for (Placement p : cachedPlacements) {
                if (validPlacements != null && !validPlacements.isEmpty() && !validPlacements.contains(p)) {
                    Log.d((String)TAG, (String)String.format(Locale.ENGLISH, "Placement %s is no longer valid, deleting it and its advertisement", p.getId()));
                    this.repository.delete(p);
                    continue;
                }
                List<String> ads = this.repository.findAdsForPlacement(p.getId()).get();
                if (ads == null) continue;
                for (String advertisementId : ads) {
                    Advertisement advertisement = this.repository.load(advertisementId, Advertisement.class).get();
                    if (advertisement != null) {
                        if (advertisement.getExpireTime() <= System.currentTimeMillis() && advertisement.getState() != 2) {
                            this.repository.deleteAdvertisement(advertisementId);
                            if (!p.isAutoCached()) continue;
                            this.adLoader.loadEndless(p, 1000L);
                            continue;
                        }
                        validIds.add(advertisement.getId());
                        Log.w((String)TAG, (String)("setting valid adv " + advertisementId + " for placement " + p.getId()));
                        continue;
                    }
                    Log.w((String)TAG, (String)("removing adv " + advertisementId + " from placement " + p.getId()));
                    this.repository.deleteAdvertisement(p.getId());
                }
            }
            List<Advertisement> cachedAds = this.repository.loadAll(Advertisement.class).get();
            if (cachedAds != null) {
                for (Advertisement ad : cachedAds) {
                    if (ad.getState() == 2) {
                        validIds.add(ad.getId());
                        Log.d((String)TAG, (String)("found adv in viewing state " + ad.getId()));
                        continue;
                    }
                    if (validIds.contains(ad.getId())) continue;
                    Log.e((String)TAG, (String)("delete ad " + ad.getId()));
                    this.repository.deleteAdvertisement(ad.getId());
                }
            }
            for (File f : assets) {
                String id = f.getName();
                if (validIds.contains(id)) continue;
                Log.v((String)TAG, (String)String.format(Locale.ENGLISH, "Deleting assets under directory %s", f.getName()));
                FileUtility.delete(f);
            }
        }
        catch (DatabaseHelper.DBException ignored) {
            return 1;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Failed to delete asset directory!", (Throwable)e);
            return 1;
        }
        return 0;
    }

    public static JobInfo makeJobInfo() {
        return new JobInfo(TAG).setPriority(0).setUpdateCurrent(true);
    }
}

