/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.network;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vungle.warren.network.Call;
import com.vungle.warren.network.Callback;
import com.vungle.warren.network.Response;
import com.vungle.warren.network.converters.Converter;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

final class OkHttpCall<T>
implements Call<T> {
    private static final String TAG = OkHttpCall.class.getSimpleName();
    private final Converter<ResponseBody, T> converter;
    private okhttp3.Call rawCall;

    OkHttpCall(@NonNull okhttp3.Call call, Converter<ResponseBody, T> converter) {
        this.rawCall = call;
        this.converter = converter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response<T> execute() throws IOException {
        okhttp3.Call call;
        OkHttpCall okHttpCall = this;
        synchronized (okHttpCall) {
            call = this.rawCall;
        }
        return this.parseResponse(call.execute(), this.converter);
    }

    @Override
    public void enqueue(final Callback<T> callback) {
        this.rawCall.enqueue(new okhttp3.Callback(){

            public void onResponse(@NonNull okhttp3.Call call, @NonNull okhttp3.Response rawResponse) {
                Response response;
                try {
                    response = OkHttpCall.this.parseResponse(rawResponse, OkHttpCall.this.converter);
                }
                catch (Throwable e) {
                    this.callFailure(e);
                    return;
                }
                try {
                    callback.onResponse(OkHttpCall.this, response);
                }
                catch (Throwable t) {
                    Log.w((String)TAG, (String)"Error on excuting callback", (Throwable)t);
                }
            }

            public void onFailure(@NonNull okhttp3.Call call, @NonNull IOException e) {
                this.callFailure(e);
            }

            private void callFailure(Throwable e) {
                try {
                    callback.onFailure(OkHttpCall.this, e);
                }
                catch (Throwable t) {
                    Log.w((String)TAG, (String)"Error on executing callback", (Throwable)t);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response<T> parseResponse(okhttp3.Response rawResponse, Converter<ResponseBody, T> converter) throws IOException {
        ResponseBody rawBody = rawResponse.body();
        int code = (rawResponse = rawResponse.newBuilder().body((ResponseBody)new NoContentResponseBody(rawBody.contentType(), rawBody.contentLength())).build()).code();
        if (code < 200 || code >= 300) {
            try {
                Buffer buffer = new Buffer();
                rawBody.source().readAll((Sink)buffer);
                ResponseBody bufferedBody = ResponseBody.create((MediaType)rawBody.contentType(), (long)rawBody.contentLength(), (BufferedSource)buffer);
                Response response = Response.error(bufferedBody, rawResponse);
                return response;
            }
            finally {
                rawBody.close();
            }
        }
        if (code == 204 || code == 205) {
            rawBody.close();
            return Response.success(null, rawResponse);
        }
        ExceptionCatchingResponseBody catchingBody = new ExceptionCatchingResponseBody(rawBody);
        try {
            return Response.success(converter.convert(catchingBody), rawResponse);
        }
        catch (RuntimeException e) {
            catchingBody.throwIfCaught();
            throw e;
        }
    }

    static final class ExceptionCatchingResponseBody
    extends ResponseBody {
        private final ResponseBody delegate;
        @Nullable
        IOException thrownException;

        ExceptionCatchingResponseBody(ResponseBody delegate) {
            this.delegate = delegate;
        }

        public MediaType contentType() {
            return this.delegate.contentType();
        }

        public long contentLength() {
            return this.delegate.contentLength();
        }

        public BufferedSource source() {
            return Okio.buffer((Source)new ForwardingSource((Source)this.delegate.source()){

                public long read(@NonNull Buffer sink, long byteCount) throws IOException {
                    try {
                        return super.read(sink, byteCount);
                    }
                    catch (IOException e) {
                        ExceptionCatchingResponseBody.this.thrownException = e;
                        throw e;
                    }
                }
            });
        }

        public void close() {
            this.delegate.close();
        }

        void throwIfCaught() throws IOException {
            if (this.thrownException != null) {
                throw this.thrownException;
            }
        }
    }

    static final class NoContentResponseBody
    extends ResponseBody {
        @Nullable
        private final MediaType contentType;
        private final long contentLength;

        NoContentResponseBody(@Nullable MediaType contentType, long contentLength) {
            this.contentType = contentType;
            this.contentLength = contentLength;
        }

        public MediaType contentType() {
            return this.contentType;
        }

        public long contentLength() {
            return this.contentLength;
        }

        @NonNull
        public BufferedSource source() {
            throw new IllegalStateException("Cannot read raw response body of a converted body.");
        }
    }
}

