/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.model;

import android.content.ContentValues;
import androidx.annotation.NonNull;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.vungle.warren.model.Report;
import com.vungle.warren.persistence.ContentValuesUtil;
import com.vungle.warren.persistence.DBAdapter;
import com.vungle.warren.persistence.IdColumns;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class ReportDBAdapter
implements DBAdapter<Report> {
    private Gson gson = new GsonBuilder().create();
    Type stringType = new TypeToken<ArrayList<String>>(){}.getType();
    Type userActionsType = new TypeToken<ArrayList<Report.UserAction>>(){}.getType();
    public static final String CREATE_REPORT_TABLE_QUERY = "CREATE TABLE IF NOT EXISTS report(_id INTEGER PRIMARY KEY AUTOINCREMENT, item_id TEXT UNIQUE,appId TEXT, placementId TEXT, adToken TEXT, incentivized SHORT, header_bidding SHORT, adStartTime NUMERIC, url TEXT, ad_duration NUMERIC, tt_download NUMERIC, campaign TEXT, videoViewed NUMERIC, ad_type TEXT, template_id TEXT, was_CTAC_licked SHORT, clicked_through TEXT, errors TEXT, user_actions TEXT, user_id TEXT, ordinal INT, videoLength NUMERIC, status INT, ad_size TEXT, init_timestamp NUMERIC, asset_download_duration NUMERIC)";

    @Override
    public ContentValues toContentValues(Report item) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("item_id", item.getId());
        contentValues.put("ad_duration", Long.valueOf(item.adDuration));
        contentValues.put("adStartTime", Long.valueOf(item.adStartTime));
        contentValues.put("adToken", item.adToken);
        contentValues.put("ad_type", item.adType);
        contentValues.put("appId", item.appId);
        contentValues.put("campaign", item.campaign);
        contentValues.put("incentivized", Boolean.valueOf(item.incentivized));
        contentValues.put("header_bidding", Boolean.valueOf(item.headerBidding));
        contentValues.put("ordinal", Integer.valueOf(item.ordinal));
        contentValues.put("placementId", item.placementId);
        contentValues.put("template_id", item.templateId);
        contentValues.put("tt_download", Long.valueOf(item.ttDownload));
        contentValues.put("url", item.url);
        contentValues.put("user_id", item.userID);
        contentValues.put("videoLength", Long.valueOf(item.videoLength));
        contentValues.put("videoViewed", Integer.valueOf(item.videoViewed));
        contentValues.put("was_CTAC_licked", Boolean.valueOf(item.wasCTAClicked));
        contentValues.put("user_actions", this.gson.toJson(new ArrayList<Report.UserAction>(item.userActions), this.userActionsType));
        contentValues.put("clicked_through", this.gson.toJson(new ArrayList<String>(item.clickedThrough), this.stringType));
        contentValues.put("errors", this.gson.toJson(new ArrayList<String>(item.errors), this.stringType));
        contentValues.put("status", Integer.valueOf(item.status));
        contentValues.put("ad_size", item.adSize);
        contentValues.put("init_timestamp", Long.valueOf(item.initTimeStamp));
        contentValues.put("asset_download_duration", Long.valueOf(item.assetDownloadDuration));
        return contentValues;
    }

    @Override
    @NonNull
    public Report fromContentValues(ContentValues values) {
        Report item = new Report();
        item.adDuration = values.getAsLong("ad_duration");
        item.adStartTime = values.getAsLong("adStartTime");
        item.adToken = values.getAsString("adToken");
        item.adType = values.getAsString("ad_type");
        item.appId = values.getAsString("appId");
        item.campaign = values.getAsString("campaign");
        item.ordinal = values.getAsInteger("ordinal");
        item.placementId = values.getAsString("placementId");
        item.templateId = values.getAsString("template_id");
        item.ttDownload = values.getAsLong("tt_download");
        item.url = values.getAsString("url");
        item.userID = values.getAsString("user_id");
        item.videoLength = values.getAsLong("videoLength");
        item.videoViewed = values.getAsInteger("videoViewed");
        item.wasCTAClicked = ContentValuesUtil.getBoolean(values, "was_CTAC_licked");
        item.incentivized = ContentValuesUtil.getBoolean(values, "incentivized");
        item.headerBidding = ContentValuesUtil.getBoolean(values, "header_bidding");
        item.status = values.getAsInteger("status");
        item.adSize = values.getAsString("ad_size");
        item.initTimeStamp = values.getAsLong("init_timestamp");
        item.assetDownloadDuration = values.getAsLong("asset_download_duration");
        List clicks = (List)this.gson.fromJson(values.getAsString("clicked_through"), this.stringType);
        List errors = (List)this.gson.fromJson(values.getAsString("errors"), this.stringType);
        List userActions = (List)this.gson.fromJson(values.getAsString("user_actions"), this.userActionsType);
        if (clicks != null) {
            item.clickedThrough.addAll(clicks);
        }
        if (errors != null) {
            item.errors.addAll(errors);
        }
        if (userActions != null) {
            item.userActions.addAll(userActions);
        }
        return item;
    }

    @Override
    public String tableName() {
        return "report";
    }

    public static interface ReportColumns
    extends IdColumns {
        public static final String TABLE_NAME = "report";
        public static final String COLUMN_PLACEMENT_ID = "placementId";
        public static final String COLUMN_AD_TOKEN = "adToken";
        public static final String COLUMN_APP_ID = "appId";
        public static final String COLUMN_INCENTIVIZED = "incentivized";
        public static final String COLUMN_HEADERBIDDING = "header_bidding";
        public static final String COLUMN_AD_START_TIME = "adStartTime";
        public static final String COLUMN_URL = "url";
        public static final String COLUMN_AD_DURATION = "ad_duration";
        public static final String COLUMN_TT_DOWNLOAD = "tt_download";
        public static final String COLUMN_CAMPAIGN = "campaign";
        public static final String COLUMN_VIDEO_VIEWED = "videoViewed";
        public static final String COLUMN_AD_TYPE = "ad_type";
        public static final String COLUMN_TEMPATE_ID = "template_id";
        public static final String COLUMN_WAS_CTA_CLICKED = "was_CTAC_licked";
        public static final String COLUMN_CLICKED_THROUGH = "clicked_through";
        public static final String COLUMN_ERRORS = "errors";
        public static final String COLUMN_USER_ACTIONS = "user_actions";
        public static final String COLUMN_USER_ID = "user_id";
        public static final String COLUMN_ORDINAL = "ordinal";
        public static final String COLUMN_VIDEO_LENGTH = "videoLength";
        public static final String COLUMN_REPORT_STATUS = "status";
        public static final String COLUMN_AD_SIZE = "ad_size";
        public static final String COLUMN_INIT_TIMESTAMP = "init_timestamp";
        public static final String COLUMN_ASSET_DOWNLOAD_DURATION = "asset_download_duration";
    }
}

