/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.model;

import android.util.Log;
import androidx.annotation.NonNull;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.vungle.warren.AdConfig;
import com.vungle.warren.model.JsonUtil;

public class Placement {
    private static final String TAG = "Placement";
    String identifier;
    boolean autoCached;
    boolean incentivized;
    long wakeupTime;
    int adRefreshDuration;
    int autoCachePriority;
    boolean headerBidding;
    boolean isValid;
    @PlacementAdType
    int placementAdType = 0;
    public static final int TYPE_DEFAULT = 0;
    public static final int TYPE_VUNGLE_BANNER = 1;
    protected AdConfig.AdSize adSize;

    public Placement(String identifier) {
        this.identifier = identifier;
        this.autoCached = false;
        this.incentivized = false;
        this.headerBidding = false;
    }

    Placement() {
    }

    public Placement(JsonObject jsonObject) throws IllegalArgumentException {
        if (!jsonObject.has("reference_id")) {
            throw new IllegalArgumentException("Missing placement reference ID, cannot use placement!");
        }
        this.identifier = jsonObject.get("reference_id").getAsString();
        boolean bl = this.autoCached = jsonObject.has("is_auto_cached") && jsonObject.get("is_auto_cached").getAsBoolean();
        if (jsonObject.has("cache_priority") && this.autoCached) {
            try {
                this.autoCachePriority = jsonObject.get("cache_priority").getAsInt();
                if (this.autoCachePriority < 1) {
                    this.autoCachePriority = Integer.MAX_VALUE;
                }
            }
            catch (Exception e) {
                this.autoCachePriority = Integer.MAX_VALUE;
            }
        } else {
            this.autoCachePriority = Integer.MAX_VALUE;
        }
        this.incentivized = jsonObject.has("is_incentivized") && jsonObject.get("is_incentivized").getAsBoolean();
        this.adRefreshDuration = jsonObject.has("ad_refresh_duration") ? jsonObject.get("ad_refresh_duration").getAsInt() : 0;
        boolean bl2 = this.headerBidding = jsonObject.has("header_bidding") && jsonObject.get("header_bidding").getAsBoolean();
        if (JsonUtil.hasNonNull((JsonElement)jsonObject, "supported_template_types")) {
            JsonArray supportedTemplatesTypesArray = jsonObject.getAsJsonArray("supported_template_types");
            for (JsonElement jsonElement : supportedTemplatesTypesArray) {
                Log.d((String)"PlacementModel", (String)("SupportedTemplatesTypes : " + jsonElement.getAsString()));
                if (jsonElement.getAsString().equals("banner")) {
                    this.placementAdType = 1;
                    break;
                }
                this.placementAdType = 0;
            }
        }
    }

    public void snooze(long sleepTime) {
        this.wakeupTime = System.currentTimeMillis() + sleepTime * 1000L;
    }

    public long getWakeupTime() {
        return this.wakeupTime;
    }

    public void setWakeupTime(long wakeupTime) {
        this.wakeupTime = wakeupTime;
    }

    @NonNull
    public String getId() {
        return this.identifier;
    }

    public void setValid(boolean valid) {
        this.isValid = valid;
    }

    @PlacementAdType
    public int getPlacementAdType() {
        return this.placementAdType;
    }

    public AdConfig.AdSize getAdSize() {
        return this.adSize == null ? AdConfig.AdSize.VUNGLE_DEFAULT : this.adSize;
    }

    public void setAdSize(AdConfig.AdSize adSize) {
        this.adSize = adSize;
    }

    public int getAdRefreshDuration() {
        if (this.adRefreshDuration <= 0) {
            return 0;
        }
        return this.adRefreshDuration;
    }

    public int getAutoCachePriority() {
        return this.autoCachePriority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Placement placement = (Placement)o;
        if (this.autoCached != placement.autoCached) {
            return false;
        }
        if (this.incentivized != placement.incentivized) {
            return false;
        }
        if (this.headerBidding != placement.headerBidding) {
            return false;
        }
        if (this.wakeupTime != placement.wakeupTime) {
            return false;
        }
        if (this.isValid != placement.isValid) {
            return false;
        }
        if (this.adRefreshDuration != placement.adRefreshDuration) {
            return false;
        }
        if (this.getAdSize() != placement.getAdSize()) {
            return false;
        }
        return !(this.identifier != null ? !this.identifier.equals(placement.identifier) : placement.identifier != null);
    }

    public int hashCode() {
        int result = this.identifier != null ? this.identifier.hashCode() : 0;
        result = 31 * result + (this.autoCached ? 1 : 0);
        result = 31 * result + (this.incentivized ? 1 : 0);
        result = 31 * result + (this.headerBidding ? 1 : 0);
        result = 31 * result + (int)(this.wakeupTime ^ this.wakeupTime >>> 32);
        result = 31 * result + (this.adRefreshDuration ^ this.adRefreshDuration >>> 32);
        result = 31 * result + this.getAdSize().hashCode();
        return result;
    }

    public boolean isAutoCached() {
        if (AdConfig.AdSize.isBannerAdSize(this.adSize)) {
            return true;
        }
        return this.autoCached;
    }

    public boolean isIncentivized() {
        return this.incentivized;
    }

    public boolean isHeaderBidding() {
        return this.headerBidding;
    }

    public String toString() {
        return "Placement{identifier='" + this.identifier + '\'' + ", autoCached=" + this.autoCached + ", incentivized=" + this.incentivized + ", headerBidding=" + this.headerBidding + ", wakeupTime=" + this.wakeupTime + ", refreshTime=" + this.adRefreshDuration + ", adSize=" + this.getAdSize().getName() + ", autoCachePriority=" + this.autoCachePriority + '}';
    }

    public static @interface PlacementAdType {
    }
}

