/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.model;

import android.content.ContentValues;
import android.util.Pair;
import androidx.annotation.NonNull;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.vungle.warren.AdConfig;
import com.vungle.warren.model.Advertisement;
import com.vungle.warren.persistence.ContentValuesUtil;
import com.vungle.warren.persistence.DBAdapter;
import com.vungle.warren.persistence.IdColumns;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class AdvertisementDBAdapter
implements DBAdapter<Advertisement> {
    private Gson gson = new GsonBuilder().create();
    private Type stringArrayType = new TypeToken<String[]>(){}.getType();
    private Type stringMapType = new TypeToken<Map<String, String>>(){}.getType();
    private Type checkpointListType = new TypeToken<List<Advertisement.Checkpoint>>(){}.getType();
    private Type cacheableMapType = new TypeToken<Map<String, Pair<String, String>>>(){}.getType();
    public static final String CREATE_ADVERTISEMENT_TABLE_QUERY = "CREATE TABLE IF NOT EXISTS advertisement(_id INTEGER PRIMARY KEY AUTOINCREMENT,  item_id TEXT UNIQUE, ad_config TEXT,ad_type INT, expire_time NUMERIC, delay NUMERIC, show_close_delay INT, show_close_incentivized INT, countdown INT, video_height INT, video_width INT, cta_overlay_enabled SHORT, cta_click_area NUMERIC, retry_count INT, enable_moat SHORT, requires_non_market_install SHORT, app_id TEXT, campaign TEXT, video_url TEXT, md5 TEXT, postroll_bundle_url TEXT, cta_destination_url TEXT, cta_url TEXT, ad_token TEXT, video_identifier TEXT, mute_urls TEXT, unmute_urls TEXT, close_urls TEXT, postroll_click_urls TEXT, postroll_view_urls TEXT, click_urls TEXT, video_click_urls TEXT, template_url TEXT, TEMPLATE_ID TEXT, TEMPLATE_TYPE TEXT, moat_extra_vast TEXT, ad_market_id TEXT,bid_token TEXT,  checkpoints TEXT, template_settings TEXT, mraid_files TEXT, cacheable_assets TEXT, state INT, placement_id TEXT, tt_download NUMERIC,asset_download_timestamp NUMERIC,asset_download_duration NUMERIC,ad_request_start_time NUMERIC)";

    @Override
    public ContentValues toContentValues(Advertisement item) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("item_id", item.identifier);
        contentValues.put("ad_type", Integer.valueOf(item.getAdType()));
        contentValues.put("expire_time", Long.valueOf(item.expireTime));
        contentValues.put("delay", Integer.valueOf(item.delay));
        contentValues.put("show_close_delay", Integer.valueOf(item.showCloseDelay));
        contentValues.put("show_close_incentivized", Integer.valueOf(item.showCloseIncentivized));
        contentValues.put("countdown", Integer.valueOf(item.countdown));
        contentValues.put("video_width", Integer.valueOf(item.videoWidth));
        contentValues.put("video_height", Integer.valueOf(item.videoHeight));
        contentValues.put("cta_overlay_enabled", Boolean.valueOf(item.ctaOverlayEnabled));
        contentValues.put("cta_click_area", Boolean.valueOf(item.ctaClickArea));
        contentValues.put("retry_count", Integer.valueOf(item.retryCount));
        contentValues.put("enable_moat", Boolean.valueOf(item.enableMoat));
        contentValues.put("requires_non_market_install", Boolean.valueOf(item.requiresNonMarketInstall));
        contentValues.put("app_id", item.appID);
        contentValues.put("campaign", item.campaign);
        contentValues.put("video_url", item.videoUrl);
        contentValues.put("md5", item.md5);
        contentValues.put("postroll_bundle_url", item.postrollBundleUrl);
        contentValues.put("cta_destination_url", item.ctaDestinationUrl);
        contentValues.put("cta_url", item.ctaUrl);
        contentValues.put("ad_token", item.adToken);
        contentValues.put("video_identifier", item.videoIdentifier);
        contentValues.put("template_url", item.templateUrl);
        contentValues.put("TEMPLATE_ID", item.templateId);
        contentValues.put("TEMPLATE_TYPE", item.templateType);
        contentValues.put("moat_extra_vast", item.moatExtraVast);
        contentValues.put("ad_market_id", item.adMarketId);
        contentValues.put("bid_token", item.bidToken);
        contentValues.put("state", Integer.valueOf(item.state));
        contentValues.put("placement_id", item.placementId);
        contentValues.put("ad_config", this.gson.toJson((Object)item.adConfig));
        contentValues.put("mute_urls", this.gson.toJson((Object)item.muteUrls, this.stringArrayType));
        contentValues.put("unmute_urls", this.gson.toJson((Object)item.unmuteUrls, this.stringArrayType));
        contentValues.put("close_urls", this.gson.toJson((Object)item.closeUrls, this.stringArrayType));
        contentValues.put("postroll_click_urls", this.gson.toJson((Object)item.postRollClickUrls, this.stringArrayType));
        contentValues.put("postroll_view_urls", this.gson.toJson((Object)item.postRollViewUrls, this.stringArrayType));
        contentValues.put("click_urls", this.gson.toJson((Object)item.clickUrls, this.stringArrayType));
        contentValues.put("video_click_urls", this.gson.toJson((Object)item.videoClickUrls, this.stringArrayType));
        contentValues.put("checkpoints", this.gson.toJson(item.checkpoints, this.checkpointListType));
        contentValues.put("template_settings", this.gson.toJson(item.templateSettings, this.stringMapType));
        contentValues.put("mraid_files", this.gson.toJson(item.mraidFiles, this.stringMapType));
        contentValues.put("cacheable_assets", this.gson.toJson(item.cacheableAssets, this.cacheableMapType));
        contentValues.put("tt_download", Long.valueOf(item.ttDownload));
        contentValues.put("asset_download_timestamp", Long.valueOf(item.assetDownloadStartTime));
        contentValues.put("asset_download_duration", Long.valueOf(item.assetDownloadDuration));
        contentValues.put("ad_request_start_time", Long.valueOf(item.adRequestStartTime));
        return contentValues;
    }

    @Override
    @NonNull
    public Advertisement fromContentValues(ContentValues values) {
        Advertisement item = new Advertisement();
        item.identifier = values.getAsString("item_id");
        item.adType = values.getAsInteger("ad_type");
        item.expireTime = values.getAsLong("expire_time");
        item.delay = values.getAsInteger("delay");
        item.showCloseDelay = values.getAsInteger("show_close_delay");
        item.showCloseIncentivized = values.getAsInteger("show_close_incentivized");
        item.countdown = values.getAsInteger("countdown");
        item.videoWidth = values.getAsInteger("video_width");
        item.videoHeight = values.getAsInteger("video_height");
        item.retryCount = values.getAsInteger("retry_count");
        item.requiresNonMarketInstall = ContentValuesUtil.getBoolean(values, "requires_non_market_install");
        item.appID = values.getAsString("app_id");
        item.campaign = values.getAsString("campaign");
        item.videoUrl = values.getAsString("video_url");
        item.md5 = values.getAsString("md5");
        item.postrollBundleUrl = values.getAsString("postroll_bundle_url");
        item.ctaDestinationUrl = values.getAsString("cta_destination_url");
        item.ctaUrl = values.getAsString("cta_url");
        item.adToken = values.getAsString("ad_token");
        item.videoIdentifier = values.getAsString("video_identifier");
        item.templateUrl = values.getAsString("template_url");
        item.templateId = values.getAsString("TEMPLATE_ID");
        item.templateType = values.getAsString("TEMPLATE_TYPE");
        item.moatExtraVast = values.getAsString("moat_extra_vast");
        item.adMarketId = values.getAsString("ad_market_id");
        item.bidToken = values.getAsString("bid_token");
        item.state = values.getAsInteger("state");
        item.placementId = values.getAsString("placement_id");
        item.enableMoat = ContentValuesUtil.getBoolean(values, "enable_moat");
        item.ctaOverlayEnabled = ContentValuesUtil.getBoolean(values, "cta_overlay_enabled");
        item.ctaClickArea = ContentValuesUtil.getBoolean(values, "cta_click_area");
        item.adConfig = (AdConfig)this.gson.fromJson(values.getAsString("ad_config"), AdConfig.class);
        item.muteUrls = (String[])this.gson.fromJson(values.getAsString("mute_urls"), this.stringArrayType);
        item.unmuteUrls = (String[])this.gson.fromJson(values.getAsString("unmute_urls"), this.stringArrayType);
        item.closeUrls = (String[])this.gson.fromJson(values.getAsString("close_urls"), this.stringArrayType);
        item.postRollClickUrls = (String[])this.gson.fromJson(values.getAsString("postroll_click_urls"), this.stringArrayType);
        item.postRollViewUrls = (String[])this.gson.fromJson(values.getAsString("postroll_view_urls"), this.stringArrayType);
        item.clickUrls = (String[])this.gson.fromJson(values.getAsString("click_urls"), this.stringArrayType);
        item.videoClickUrls = (String[])this.gson.fromJson(values.getAsString("video_click_urls"), this.stringArrayType);
        item.checkpoints = (List)this.gson.fromJson(values.getAsString("checkpoints"), this.checkpointListType);
        item.templateSettings = (Map)this.gson.fromJson(values.getAsString("template_settings"), this.stringMapType);
        item.mraidFiles = (Map)this.gson.fromJson(values.getAsString("mraid_files"), this.stringMapType);
        item.cacheableAssets = (Map)this.gson.fromJson(values.getAsString("cacheable_assets"), this.cacheableMapType);
        item.ttDownload = values.getAsLong("tt_download");
        item.assetDownloadStartTime = values.getAsLong("asset_download_timestamp");
        item.assetDownloadDuration = values.getAsLong("asset_download_duration");
        item.adRequestStartTime = values.getAsLong("ad_request_start_time");
        return item;
    }

    @Override
    public String tableName() {
        return "advertisement";
    }

    public static interface AdvertisementColumns
    extends IdColumns {
        public static final String TABLE_NAME = "advertisement";
        public static final String COLUMN_AD_TYPE = "ad_type";
        public static final String COLUMN_APP_ID = "app_id";
        public static final String COLUMN_EXPIRE_TIME = "expire_time";
        public static final String COLUMN_CHEKPOINTS = "checkpoints";
        public static final String COLUMN_MUTE_URLS = "mute_urls";
        public static final String COLUMN_UNMUTE_URLS = "unmute_urls";
        public static final String COLUMN_CLOSE_URLS = "close_urls";
        public static final String COLUMN_POSTROLL_CLICK_URLS = "postroll_click_urls";
        public static final String COLUMN_POSTROLL_VIEW_URLS = "postroll_view_urls";
        public static final String COLUMN_CLICK_URLS = "click_urls";
        public static final String COLUMN_VIDEO_CLICK_URLS = "video_click_urls";
        public static final String COLUMN_DELAY = "delay";
        public static final String COLUMN_CAMPAIGN = "campaign";
        public static final String COLUMN_SHOW_CLOSE_DELAY = "show_close_delay";
        public static final String COLUMN_SHOW_CLOSE_INCENTIVISED = "show_close_incentivized";
        public static final String COLUMN_COUNTDOWN = "countdown";
        public static final String COLUMN_VIDEO_URL = "video_url";
        public static final String COLUMN_VIDEO_WIDTH = "video_width";
        public static final String COLUMN_VIDEO_HEIGHT = "video_height";
        public static final String COLUMN_MD5 = "md5";
        public static final String COLUMN_POSTROLL_BUNDLE_URL = "postroll_bundle_url";
        public static final String COLUMN_CTA_OVERLAY_ENABLED = "cta_overlay_enabled";
        public static final String COLUMN_CTA_CLICK_AREA = "cta_click_area";
        public static final String COLUMN_CTA_DESTINATION_URL = "cta_destination_url";
        public static final String COLUMN_CTA_URL = "cta_url";
        public static final String COLUMN_AD_CONFIG = "ad_config";
        public static final String COLUMN_RETRY_COUNT = "retry_count";
        public static final String COLUMN_AD_TOKEN = "ad_token";
        public static final String COLUMN_VIDEO_IDENTIFIER = "video_identifier";
        public static final String COLUMN_TEMPLATE_URL = "template_url";
        public static final String COLUMN_TEMPLATE_SETTINGS = "template_settings";
        public static final String COLUMN_MRAID_FILES = "mraid_files";
        public static final String COLUMN_TEMPLATE_ID = "TEMPLATE_ID";
        public static final String COLUMN_TEMPLATE_TYPE = "TEMPLATE_TYPE";
        public static final String COLUMN_ENABLE_MOAT = "enable_moat";
        public static final String COLUMN_MOAT_EXTRA_VAST = "moat_extra_vast";
        public static final String COLUMN_REQUIRES_NON_MARKET_INSTALL = "requires_non_market_install";
        public static final String COLUMN_AD_MARKET_ID = "ad_market_id";
        public static final String COLUMN_BID_TOKEN = "bid_token";
        public static final String COLUMN_PLACEMENT_ID = "placement_id";
        public static final String COLUMN_STATE = "state";
        public static final String COLUMN_CACHEABLE_ASSETS = "cacheable_assets";
        public static final String COLUMN_TT_DOWNLOAD = "tt_download";
        public static final String COLUMN_ASSET_DOWNLOAD_TIMESTAMP = "asset_download_timestamp";
        public static final String COLUMN_ASSET_DOWNLOAD_DURATION = "asset_download_duration";
        public static final String COLUMN_AD_REQUEST_START_TIMESTAMP = "ad_request_start_time";
    }
}

