/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.model;

import android.content.ContentValues;
import androidx.annotation.NonNull;
import com.vungle.warren.model.AdAsset;
import com.vungle.warren.persistence.DBAdapter;
import com.vungle.warren.persistence.IdColumns;

public class AdAssetDBAdapter
implements DBAdapter<AdAsset> {
    public static final String CREATE_ASSET_TABLE_QUERY = "CREATE TABLE IF NOT EXISTS adAsset ( _id INTEGER PRIMARY KEY AUTOINCREMENT, item_id TEXT UNIQUE, paren_id TEXT , ad_identifier TEXT NOT NULL, server_path TEXT, local_path TEXT NOT NULL, file_status SHORT, file_type SHORT, file_size INT, retry_count SHORT, retry_error SHORT, unique ( local_path, ad_identifier ));";

    @Override
    public ContentValues toContentValues(AdAsset item) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("item_id", item.identifier);
        contentValues.put("ad_identifier", item.adIdentifier);
        contentValues.put("paren_id", item.parentId);
        contentValues.put("server_path", item.serverPath);
        contentValues.put("local_path", item.localPath);
        contentValues.put("file_status", Integer.valueOf(item.status));
        contentValues.put("file_type", Integer.valueOf(item.fileType));
        contentValues.put("file_size", Long.valueOf(item.fileSize));
        contentValues.put("retry_count", Integer.valueOf(item.retryCount));
        contentValues.put("retry_error", Integer.valueOf(item.retryTypeError));
        return contentValues;
    }

    @Override
    @NonNull
    public AdAsset fromContentValues(ContentValues values) {
        AdAsset item = new AdAsset(values.getAsString("ad_identifier"), values.getAsString("server_path"), values.getAsString("local_path"), values.getAsString("item_id"));
        item.status = values.getAsInteger("file_status");
        item.fileType = values.getAsInteger("file_type");
        item.fileSize = values.getAsInteger("file_size").intValue();
        item.retryCount = values.getAsInteger("retry_count");
        item.retryTypeError = values.getAsInteger("retry_error");
        item.parentId = values.getAsString("paren_id");
        return item;
    }

    @Override
    public String tableName() {
        return "adAsset";
    }

    public static interface AdAssetColumns
    extends IdColumns {
        public static final String TABLE_NAME = "adAsset";
        public static final String COLUMN_AD_ID = "ad_identifier";
        public static final String COLUMN_PARENT_ID = "paren_id";
        public static final String COLUMN_SERVER_PATH = "server_path";
        public static final String COLUMN_LOCAL_PATH = "local_path";
        public static final String COLUMN_FILE_STATUS = "file_status";
        public static final String COLUMN_FILE_TYPE = "file_type";
        public static final String COLUMN_FILE_SIZE = "file_size";
        public static final String COLUMN_RETRY_COUNT = "retry_count";
        public static final String COLUMN_RETRY_ERROR = "retry_error";
    }
}

