/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.downloader;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.vungle.warren.downloader.Downloader;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class DownloadRequest {
    public final int networkType;
    private final AtomicInteger priority = new AtomicInteger();
    public final String url;
    public final String path;
    public final boolean pauseOnConnectionLost;
    final String id;
    public final String cookieString;
    private AtomicBoolean cancelled = new AtomicBoolean(false);

    public DownloadRequest(@NonNull String url, String path) {
        this(3, 0, url, path, false, null);
    }

    public DownloadRequest(@NonNull String url, String path, String cookieString) {
        this(3, 0, url, path, false, cookieString);
    }

    public DownloadRequest(@Downloader.NetworkType int networkType, @Priority int priority, @NonNull String url, @NonNull String path, boolean pauseOnConnectionLost, String cookieString) {
        if (TextUtils.isEmpty((CharSequence)path) || TextUtils.isEmpty((CharSequence)url)) {
            throw new IllegalArgumentException("Url or path is empty");
        }
        this.networkType = networkType;
        this.priority.set(priority);
        this.url = url;
        this.path = path;
        this.id = UUID.nameUUIDFromBytes((path + "_" + url).getBytes()).toString();
        this.pauseOnConnectionLost = pauseOnConnectionLost;
        this.cookieString = cookieString;
    }

    void cancel() {
        this.cancelled.set(true);
    }

    boolean isCancelled() {
        return this.cancelled.get();
    }

    public void setPriority(@Priority int priority) {
        this.priority.set(priority);
    }

    @Priority
    public int getPriority() {
        return this.priority.get();
    }

    public static @interface Priority {
        public static final int CRITICAL = -2147483647;
        public static final int HIGHEST = 0;
        public static final int HIGH = 1;
        public static final int LOWEST = Integer.MAX_VALUE;
    }
}

