/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.downloader;

import android.util.Base64;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.vungle.warren.SizeProvider;
import com.vungle.warren.downloader.CachePolicy;
import com.vungle.warren.downloader.DownloaderCache;
import com.vungle.warren.persistence.CacheManager;
import com.vungle.warren.utility.FileUtility;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CleverCache
implements DownloaderCache {
    private static final String TAG = CleverCache.class.getSimpleName();
    public static final String CC_DIR = "clever_cache";
    static final String ASSETS_DIR = "assets";
    static final String CACHE_META = "meta";
    private static final String META_POSTFIX_EXT = ".vng_meta";
    public static final String CACHE_TOUCH_JOURNAL = "cache_touch_timestamp";
    private final HashMap<File, Long> cacheTouchTime = new HashMap();
    private final CacheManager cacheManager;
    private final CachePolicy<File> policy;
    private final long expirationAge;
    private final SizeProvider sizeProvider;
    private Map<File, Integer> trackedFiles = new ConcurrentHashMap<File, Integer>();

    public CleverCache(@NonNull CacheManager cacheManager, @NonNull CachePolicy<File> cachePolicy, @NonNull SizeProvider sizeProvider, long expirationAge) {
        this.cacheManager = cacheManager;
        this.policy = cachePolicy;
        this.sizeProvider = sizeProvider;
        this.expirationAge = Math.max(0L, expirationAge);
    }

    @Override
    public synchronized void init() {
        this.policy.load();
        this.loadTouchTimestamps();
        this.expirationCleanup();
    }

    @Override
    public synchronized void startTracking(@NonNull File file) {
        Integer count = this.trackedFiles.get(file);
        this.policy.put(file, 0L);
        this.policy.save();
        if (count == null || count <= 0) {
            count = 1;
        } else {
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
        }
        this.trackedFiles.put(file, count);
        Log.d((String)TAG, (String)("Start tracking file: " + file + " ref count " + count));
    }

    @Override
    public synchronized void stopTracking(@NonNull File file) {
        Integer count = this.trackedFiles.get(file);
        if (count == null) {
            this.trackedFiles.remove(file);
            return;
        }
        Integer n = count;
        Integer n2 = count = Integer.valueOf(count - 1);
        if (count <= 0) {
            this.trackedFiles.remove(file);
        }
        Log.d((String)TAG, (String)("Stop tracking file: " + file + " ref count " + count));
    }

    @Override
    public synchronized void onCacheHit(@NonNull File file, long score) {
        this.policy.put(file, score);
        this.policy.save();
        Log.d((String)TAG, (String)("Cache hit " + file + " cache touch updated"));
        this.purge();
    }

    @VisibleForTesting
    @NonNull
    public synchronized File getAssetsDir() {
        File assetsDir = new File(this.getCacheDir(), ASSETS_DIR);
        if (!assetsDir.isDirectory()) {
            assetsDir.delete();
        }
        if (!assetsDir.exists()) {
            assetsDir.mkdirs();
        }
        return assetsDir;
    }

    @VisibleForTesting
    public synchronized File getMetaDir() {
        File file = new File(this.getAssetsDir(), CACHE_META);
        if (!file.isDirectory()) {
            file.delete();
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    @Override
    @NonNull
    public synchronized List<File> purge() {
        long target = this.sizeProvider.getTargetSize();
        long totalSize = FileUtility.size(this.getAssetsDir());
        Log.d((String)TAG, (String)("Purge check current cache total: " + totalSize + " target: " + target));
        if (totalSize < target) {
            return Collections.emptyList();
        }
        Log.d((String)TAG, (String)"Purge start");
        ArrayList<File> deleted = new ArrayList<File>();
        List<File> files = this.policy.getOrderedCacheItems();
        this.integrityCleanup(files);
        totalSize = FileUtility.size(this.getAssetsDir());
        if (totalSize < target) {
            Log.d((String)TAG, (String)"Cleaned up not tracked files, size is ok");
            return Collections.emptyList();
        }
        for (File candidate : files) {
            if (candidate == null || this.isProtected(candidate)) continue;
            long fileSize = candidate.length();
            if (!this.deleteContents(candidate)) continue;
            deleted.add(candidate);
            Log.d((String)TAG, (String)("Deleted file: " + candidate.getName() + " size: " + fileSize + " total: " + (totalSize -= fileSize) + " target: " + target));
            this.policy.remove(candidate);
            this.cacheTouchTime.remove(candidate);
            if (totalSize >= target || totalSize >= (target = this.sizeProvider.getTargetSize())) continue;
            Log.d((String)TAG, (String)("Cleaned enough total: " + totalSize + " target: " + target));
            break;
        }
        if (deleted.size() > 0) {
            this.policy.save();
            this.saveTouchTimestamps();
        }
        Log.d((String)TAG, (String)"Purge complete");
        return deleted;
    }

    private boolean isProtected(@NonNull File candidate) {
        Integer trackedCount = this.trackedFiles.get(candidate);
        if (trackedCount != null && trackedCount > 0) {
            Log.d((String)TAG, (String)("File is tracked and protected : " + candidate));
            return true;
        }
        return false;
    }

    private void integrityCleanup(List<File> existingFiles) {
        File metaDir = this.getMetaDir();
        File[] dirFiles = this.getAssetsDir().listFiles();
        if (dirFiles != null) {
            ArrayList<File> nonTrackedByPolicy = new ArrayList<File>(Arrays.asList(dirFiles));
            nonTrackedByPolicy.removeAll(existingFiles);
            nonTrackedByPolicy.remove(metaDir);
            for (File file : nonTrackedByPolicy) {
                this.deleteContents(file);
                Log.d((String)TAG, (String)("Deleted non tracked file " + file));
            }
        }
    }

    private synchronized void expirationCleanup() {
        long before = System.currentTimeMillis() - this.expirationAge;
        File[] files = this.getAssetsDir().listFiles();
        HashSet<File> current = new HashSet<File>(this.cacheTouchTime.keySet());
        if (files != null && files.length > 0) {
            for (File file : files) {
                long savedTime = this.getCacheUpdateTimestamp(file);
                current.remove(file);
                if (this.isProtected(file) || savedTime != 0L && savedTime > before) continue;
                if (this.deleteContents(file)) {
                    this.cacheTouchTime.remove(file);
                    this.policy.remove(file);
                }
                Log.d((String)TAG, (String)("Deleted expired file " + file));
            }
            for (File file : current) {
                this.cacheTouchTime.remove(file);
            }
            this.policy.save();
            this.saveTouchTimestamps();
        }
    }

    @Override
    public synchronized long getCacheUpdateTimestamp(@NonNull File file) {
        Long lastKnown = this.cacheTouchTime.get(file);
        return lastKnown == null ? file.lastModified() : lastKnown.longValue();
    }

    @Override
    public synchronized void setCacheLastUpdateTimestamp(@NonNull File file, long timestamp) {
        this.cacheTouchTime.put(file, timestamp);
        this.saveTouchTimestamps();
    }

    @Override
    public synchronized boolean deleteAndRemove(@NonNull File file) {
        if (this.deleteContents(file)) {
            this.cacheTouchTime.remove(file);
            this.policy.remove(file);
            this.policy.save();
            this.saveTouchTimestamps();
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean deleteContents(@NonNull File file) {
        try {
            FileUtility.delete(file);
            File meta = this.getMetaFile(file);
            FileUtility.delete(meta);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    @NonNull
    public synchronized File getFile(@NonNull String url) throws IOException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(url.getBytes("UTF-8"));
            byte[] digest = md.digest();
            String name = Base64.encodeToString((byte[])digest, (int)10);
            File file = new File(this.getAssetsDir(), name);
            this.policy.put(file, 0L);
            return file;
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }

    @Override
    @NonNull
    public synchronized File getMetaFile(@NonNull File cacheFile) {
        return new File(this.getMetaDir(), cacheFile.getName() + META_POSTFIX_EXT);
    }

    @Override
    public synchronized void clear() {
        List<File> files = this.policy.getOrderedCacheItems();
        int deleteCount = 0;
        this.integrityCleanup(files);
        for (File file : files) {
            if (file == null || this.isProtected(file) || !this.deleteContents(file)) continue;
            ++deleteCount;
            this.policy.remove(file);
            this.cacheTouchTime.remove(file);
        }
        if (deleteCount > 0) {
            this.policy.save();
            this.saveTouchTimestamps();
        }
    }

    private void loadTouchTimestamps() {
        Serializable ser = (Serializable)FileUtility.readSerializable(this.getTouchTimestampsFile());
        if (!(ser instanceof HashMap)) {
            return;
        }
        try {
            HashMap oldMap = (HashMap)ser;
            this.cacheTouchTime.putAll(oldMap);
        }
        catch (ClassCastException ex) {
            this.getTouchTimestampsFile().delete();
        }
    }

    private void saveTouchTimestamps() {
        HashMap<File, Long> copy = new HashMap<File, Long>(this.cacheTouchTime);
        FileUtility.writeSerializable(this.getTouchTimestampsFile(), copy);
    }

    private File getTouchTimestampsFile() {
        return new File(this.getCacheDir(), CACHE_TOUCH_JOURNAL);
    }

    private File getCacheDir() {
        File file = new File(this.cacheManager.getCache(), CC_DIR);
        if (!file.isDirectory()) {
            file.delete();
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }
}

