/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.analytics;

import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.gson.JsonObject;
import com.vungle.warren.VungleApiClient;
import com.vungle.warren.analytics.AdAnalytics;
import com.vungle.warren.network.Call;
import com.vungle.warren.network.Callback;
import com.vungle.warren.network.Response;
import java.net.MalformedURLException;
import java.util.ArrayList;

public class VungleAnalytics
implements AdAnalytics {
    private static final String TAG = VungleAnalytics.class.getSimpleName();
    private final VungleApiClient client;

    public VungleAnalytics(VungleApiClient client) {
        this.client = client;
    }

    @Override
    public String[] ping(@NonNull String[] urls) {
        if (urls.length == 0) {
            return urls;
        }
        ArrayList<String> failed = new ArrayList<String>();
        for (String url : urls) {
            if (TextUtils.isEmpty((CharSequence)url)) continue;
            try {
                if (this.client.pingTPAT(url)) continue;
                failed.add(url);
            }
            catch (VungleApiClient.ClearTextTrafficException e) {
                Log.e((String)TAG, (String)("Cleartext Network Traffic is Blocked : " + url));
            }
            catch (MalformedURLException e) {
                Log.e((String)TAG, (String)("Invalid Url : " + url));
            }
        }
        return failed.toArray(new String[0]);
    }

    @Override
    public void ri(JsonObject object) {
        if (object == null) {
            return;
        }
        this.client.ri(object).enqueue(new Callback<JsonObject>(){

            @Override
            public void onResponse(@NonNull Call<JsonObject> call, Response<JsonObject> response) {
                Log.d((String)TAG, (String)"send RI success");
            }

            @Override
            public void onFailure(Call<JsonObject> call, Throwable t) {
                Log.d((String)TAG, (String)"send RI Failure");
            }
        });
    }
}

