/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.vungle.warren.AdConfig;
import com.vungle.warren.AdEventListener;
import com.vungle.warren.AdLoader;
import com.vungle.warren.CleverCacheSettings;
import com.vungle.warren.HeaderBiddingCallback;
import com.vungle.warren.HeaderBiddingCallbackWrapper;
import com.vungle.warren.InitCallback;
import com.vungle.warren.InitCallbackWrapper;
import com.vungle.warren.LoadAdCallback;
import com.vungle.warren.LoadAdCallbackWrapper;
import com.vungle.warren.PlayAdCallback;
import com.vungle.warren.PlayAdCallbackWrapper;
import com.vungle.warren.PresentationFactory;
import com.vungle.warren.RuntimeValues;
import com.vungle.warren.ServiceLocator;
import com.vungle.warren.SessionData;
import com.vungle.warren.VisionController;
import com.vungle.warren.VungleApiClient;
import com.vungle.warren.VungleNativeAd;
import com.vungle.warren.VungleSettings;
import com.vungle.warren.downloader.DownloadRequest;
import com.vungle.warren.downloader.Downloader;
import com.vungle.warren.error.VungleException;
import com.vungle.warren.model.Advertisement;
import com.vungle.warren.model.Cookie;
import com.vungle.warren.model.JsonUtil;
import com.vungle.warren.model.Placement;
import com.vungle.warren.network.Call;
import com.vungle.warren.network.Callback;
import com.vungle.warren.network.HttpException;
import com.vungle.warren.network.Response;
import com.vungle.warren.persistence.CacheManager;
import com.vungle.warren.persistence.DatabaseHelper;
import com.vungle.warren.persistence.FutureResult;
import com.vungle.warren.persistence.Repository;
import com.vungle.warren.tasks.CleanupJob;
import com.vungle.warren.tasks.JobRunner;
import com.vungle.warren.tasks.ReconfigJob;
import com.vungle.warren.tasks.SendReportsJob;
import com.vungle.warren.ui.VungleActivity;
import com.vungle.warren.ui.VungleFlexViewActivity;
import com.vungle.warren.ui.view.VungleNativeView;
import com.vungle.warren.utility.ActivityManager;
import com.vungle.warren.utility.Executors;
import com.vungle.warren.utility.TimeoutProvider;
import com.vungle.warren.vision.VisionConfig;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

@Keep
public class Vungle {
    static final Vungle _instance = new Vungle();
    private static final String TAG = Vungle.class.getCanonicalName();
    private static final String COM_VUNGLE_SDK = "com.vungle.sdk";
    private final AtomicReference<Consent> consent = new AtomicReference();
    private volatile String consentVersion;
    private volatile Consent ccpaStatus;
    private Map<String, Boolean> playOperations = new ConcurrentHashMap<String, Boolean>();
    private volatile String appID;
    private Context context;
    private static volatile boolean isInitialized;
    private static AtomicBoolean isInitializing;
    private static AtomicBoolean isDepInit;
    private Gson gson = new GsonBuilder().create();
    private AtomicInteger hbpOrdinalViewCount = new AtomicInteger(0);
    private static CacheManager.Listener cacheListener;

    private Vungle() {
    }

    static Context getAppContext() {
        return Vungle._instance.context;
    }

    @Deprecated
    public static void init(@NonNull Collection<String> placements, @NonNull String appId, @NonNull Context context, @NonNull InitCallback callback) throws IllegalArgumentException {
        Vungle.init(appId, context, callback, new VungleSettings.Builder().build());
    }

    public static void init(@NonNull String appId, @NonNull Context context, @NonNull InitCallback callback) throws IllegalArgumentException {
        Vungle.init(appId, context, callback, new VungleSettings.Builder().build());
    }

    public static void init(final @NonNull String appId, final @NonNull Context context, @NonNull InitCallback callback, @NonNull VungleSettings settings) throws IllegalArgumentException {
        InitCallback initCallback;
        String VUNGLE_VERSION_STRING = "!SDK-VERSION-STRING!:com.vungle:publisher-sdk-android:6.7.1";
        if (callback == null) {
            throw new IllegalArgumentException("A valid InitCallback required to ensure API calls are being made after initialize is successful");
        }
        if (context == null) {
            callback.onError(new VungleException(6));
            return;
        }
        final RuntimeValues runtimeValues = ServiceLocator.getInstance(context).getService(RuntimeValues.class);
        runtimeValues.settings.set(settings);
        final ServiceLocator serviceLocator = ServiceLocator.getInstance(context);
        Executors sdkExecutors = serviceLocator.getService(Executors.class);
        InitCallback initCallback2 = initCallback = callback instanceof InitCallbackWrapper ? callback : new InitCallbackWrapper(sdkExecutors.getUIExecutor(), callback);
        if (appId == null || appId.isEmpty()) {
            initCallback.onError(new VungleException(6));
            return;
        }
        if (!(context instanceof Application)) {
            initCallback.onError(new VungleException(7));
            return;
        }
        if (Vungle.isInitialized()) {
            Log.d((String)TAG, (String)"init already complete");
            initCallback.onSuccess();
            return;
        }
        if (isInitializing.getAndSet(true)) {
            Log.d((String)TAG, (String)"init ongoing");
            initCallback.onError(new VungleException(8));
            return;
        }
        runtimeValues.initCallback.set(initCallback);
        sdkExecutors.getBackgroundExecutor().execute(new Runnable(){

            @Override
            public void run() {
                if (!isDepInit.getAndSet(true)) {
                    CacheManager cacheManager = serviceLocator.getService(CacheManager.class);
                    VungleSettings settings = runtimeValues.settings.get();
                    InitCallback initCallback = runtimeValues.initCallback.get();
                    if (settings != null && cacheManager.getBytesAvailable() < settings.getMinimumSpaceForInit()) {
                        Vungle.onError(initCallback, new VungleException(16));
                        Vungle.deInit();
                        return;
                    }
                    cacheManager.addListener(cacheListener);
                    _instance.context = context;
                    _instance.appID = appId;
                    Repository repository = serviceLocator.getService(Repository.class);
                    try {
                        repository.init();
                    }
                    catch (DatabaseHelper.DBException e) {
                        Vungle.onError(initCallback, new VungleException(26));
                        Vungle.deInit();
                        return;
                    }
                    VungleApiClient vungleApiClient = serviceLocator.getService(VungleApiClient.class);
                    if (vungleApiClient.platformIsNotSupported()) {
                        Vungle.onError(initCallback, new VungleException(33));
                        Vungle.deInit();
                        return;
                    }
                    vungleApiClient.init(appId);
                    if (settings != null) {
                        vungleApiClient.setDefaultIdFallbackDisabled(settings.getAndroidIdOptOut());
                    }
                    JobRunner jobRunner = serviceLocator.getService(JobRunner.class);
                    AdLoader adLoader = serviceLocator.getService(AdLoader.class);
                    adLoader.init(jobRunner);
                    if (_instance.consent.get() != null) {
                        Vungle.saveGDPRConsent(repository, (Consent)((Object)_instance.consent.get()), _instance.consentVersion);
                    } else {
                        Cookie gdprConsent = repository.load("consentIsImportantToVungle", Cookie.class).get();
                        if (gdprConsent == null) {
                            _instance.consent.set(null);
                            _instance.consentVersion = null;
                        } else {
                            _instance.consent.set(Vungle.getConsent(gdprConsent));
                            _instance.consentVersion = Vungle.getConsentMessageVersion(gdprConsent);
                        }
                    }
                    if (_instance.ccpaStatus != null) {
                        Vungle.updateCCPAStatus(repository, _instance.ccpaStatus);
                    } else {
                        Cookie ccpaConsent = repository.load("ccpaIsImportantToVungle", Cookie.class).get();
                        _instance.ccpaStatus = Vungle.getCCPAStatus(ccpaConsent);
                    }
                    Cookie appIdCookie = repository.load("appId", Cookie.class).get();
                    if (appIdCookie == null) {
                        appIdCookie = new Cookie("appId");
                    }
                    appIdCookie.putValue("appId", appId);
                    try {
                        repository.save(appIdCookie);
                    }
                    catch (DatabaseHelper.DBException e) {
                        if (initCallback != null) {
                            Vungle.onError(initCallback, new VungleException(16));
                        }
                        Vungle.deInit();
                        return;
                    }
                }
                _instance.configure(runtimeValues.initCallback.get());
            }
        });
    }

    private static void onError(InitCallback initCallback, VungleException e) {
        if (initCallback != null) {
            initCallback.onError(e);
        }
    }

    static void reConfigure() {
        if (Vungle._instance.context == null) {
            return;
        }
        ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
        Executors sdkExecutors = serviceLocator.getService(Executors.class);
        final RuntimeValues runtimeValues = serviceLocator.getService(RuntimeValues.class);
        if (Vungle.isInitialized()) {
            sdkExecutors.getBackgroundExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    _instance.configure(runtimeValues.initCallback.get());
                }
            });
        } else {
            Vungle.init(Vungle._instance.appID, Vungle._instance.context, runtimeValues.initCallback.get());
        }
    }

    private void configure(@NonNull InitCallback callback) {
        try {
            JsonObject jsonObject;
            JsonArray placementsData;
            if (this.context == null) {
                throw new IllegalArgumentException("Context is null");
            }
            ServiceLocator serviceLocator = ServiceLocator.getInstance(this.context);
            VungleApiClient vungleApiClient = serviceLocator.getService(VungleApiClient.class);
            Repository repository = serviceLocator.getService(Repository.class);
            JobRunner jobRunner = serviceLocator.getService(JobRunner.class);
            Response response = vungleApiClient.config();
            if (response == null) {
                callback.onError(new VungleException(2));
                isInitializing.set(false);
                return;
            }
            if (!response.isSuccessful()) {
                long retryAfterHeaderValue = vungleApiClient.getRetryAfterHeaderValue(response);
                if (retryAfterHeaderValue > 0L) {
                    jobRunner.execute(ReconfigJob.makeJobInfo(Vungle._instance.appID).setDelay(retryAfterHeaderValue));
                    callback.onError(new VungleException(14));
                    isInitializing.set(false);
                    return;
                }
                callback.onError(new VungleException(3));
                isInitializing.set(false);
                return;
            }
            final SharedPreferences preferences = this.context.getSharedPreferences(COM_VUNGLE_SDK, 0);
            if (!preferences.getBoolean("reported", false)) {
                vungleApiClient.reportNew().enqueue(new Callback<JsonObject>(){

                    @Override
                    public void onResponse(Call<JsonObject> call, Response<JsonObject> response) {
                        if (response.isSuccessful()) {
                            SharedPreferences.Editor editor = preferences.edit();
                            editor.putBoolean("reported", true);
                            editor.apply();
                            Log.d((String)TAG, (String)"Saving reported state to shared preferences");
                        }
                    }

                    @Override
                    public void onFailure(Call<JsonObject> call, Throwable throwable) {
                    }
                });
            }
            if ((placementsData = (jsonObject = (JsonObject)response.body()).getAsJsonArray("placements")) == null) {
                callback.onError(new VungleException(3));
                isInitializing.set(false);
                return;
            }
            CleverCacheSettings settings = CleverCacheSettings.fromJson(jsonObject);
            Downloader downloader = serviceLocator.getService(Downloader.class);
            if (settings != null) {
                boolean timestampChanged;
                CleverCacheSettings currentCacheSettings = CleverCacheSettings.deserializeFromString(preferences.getString("clever_cache", null));
                boolean bl = timestampChanged = currentCacheSettings == null || currentCacheSettings.getTimestamp() != settings.getTimestamp();
                if (!settings.isEnabled() || timestampChanged) {
                    downloader.clearCache();
                }
                downloader.setCacheEnabled(settings.isEnabled());
                preferences.edit().putString("clever_cache", settings.serializeToString()).apply();
            } else {
                downloader.setCacheEnabled(true);
            }
            final AdLoader adLoader = serviceLocator.getService(AdLoader.class);
            ArrayList<Placement> newPlacements = new ArrayList<Placement>();
            for (JsonElement jsonElement : placementsData) {
                newPlacements.add(new Placement(jsonElement.getAsJsonObject()));
            }
            repository.setValidPlacements(newPlacements);
            if (jsonObject.has("gdpr")) {
                JsonObject gdprJsonObject;
                Cookie gdprConsent = repository.load("consentIsImportantToVungle", Cookie.class).get();
                if (gdprConsent == null) {
                    gdprConsent = new Cookie("consentIsImportantToVungle");
                    gdprConsent.putValue("consent_status", "unknown");
                    gdprConsent.putValue("consent_source", "no_interaction");
                    gdprConsent.putValue("timestamp", 0L);
                }
                boolean isCountryDataProtected = JsonUtil.hasNonNull((JsonElement)(gdprJsonObject = jsonObject.getAsJsonObject("gdpr")), "is_country_data_protected") && gdprJsonObject.get("is_country_data_protected").getAsBoolean();
                String consentTitle = JsonUtil.hasNonNull((JsonElement)gdprJsonObject, "consent_title") ? gdprJsonObject.get("consent_title").getAsString() : "";
                String consentMessage = JsonUtil.hasNonNull((JsonElement)gdprJsonObject, "consent_message") ? gdprJsonObject.get("consent_message").getAsString() : "";
                String consentMessageVersion = JsonUtil.hasNonNull((JsonElement)gdprJsonObject, "consent_message_version") ? gdprJsonObject.get("consent_message_version").getAsString() : "";
                String acceptText = JsonUtil.hasNonNull((JsonElement)gdprJsonObject, "button_accept") ? gdprJsonObject.get("button_accept").getAsString() : "";
                String denyText = JsonUtil.hasNonNull((JsonElement)gdprJsonObject, "button_deny") ? gdprJsonObject.get("button_deny").getAsString() : "";
                gdprConsent.putValue("is_country_data_protected", isCountryDataProtected);
                gdprConsent.putValue("consent_title", TextUtils.isEmpty((CharSequence)consentTitle) ? "Targeted Ads" : consentTitle);
                gdprConsent.putValue("consent_message", TextUtils.isEmpty((CharSequence)consentMessage) ? "To receive more relevant ad content based on your interactions with our ads, click \"I Consent\" below. Either way, you will see the same amount of ads." : consentMessage);
                String strGDPRCurrentSource = gdprConsent.getString("consent_source");
                if (!"publisher".equalsIgnoreCase(strGDPRCurrentSource)) {
                    gdprConsent.putValue("consent_message_version", TextUtils.isEmpty((CharSequence)consentMessageVersion) ? "" : consentMessageVersion);
                }
                gdprConsent.putValue("button_accept", TextUtils.isEmpty((CharSequence)acceptText) ? "I Consent" : acceptText);
                gdprConsent.putValue("button_deny", TextUtils.isEmpty((CharSequence)denyText) ? "I Do Not Consent" : denyText);
                repository.save(gdprConsent);
            }
            if (jsonObject.has("ri")) {
                Cookie configCookie = repository.load("configSettings", Cookie.class).get();
                if (configCookie == null) {
                    configCookie = new Cookie("configSettings");
                }
                boolean isReportIncentivizedEnabled = jsonObject.getAsJsonObject("ri").get("enabled").getAsBoolean();
                configCookie.putValue("isReportIncentivizedEnabled", isReportIncentivizedEnabled);
                repository.save(configCookie);
            }
            if (jsonObject.has("config")) {
                long sleep = jsonObject.getAsJsonObject("config").get("refresh_time").getAsLong();
                jobRunner.execute(ReconfigJob.makeJobInfo(this.appID).setDelay(sleep));
            }
            try {
                serviceLocator.getService(VisionController.class).setConfig(JsonUtil.hasNonNull((JsonElement)jsonObject, "vision") ? (VisionConfig)this.gson.fromJson((JsonElement)jsonObject.getAsJsonObject("vision"), VisionConfig.class) : new VisionConfig());
            }
            catch (DatabaseHelper.DBException dbException) {
                Log.e((String)TAG, (String)"not able to apply vision data config");
            }
            isInitialized = true;
            callback.onSuccess();
            isInitializing.set(false);
            SessionData sessionData = new SessionData();
            sessionData.setInitTimeStamp(System.currentTimeMillis());
            ServiceLocator.getInstance((Context)this.context).getService(RuntimeValues.class).sessionData.set(sessionData);
            Collection<Placement> placements = repository.loadValidPlacements().get();
            jobRunner.execute(CleanupJob.makeJobInfo());
            if (placements != null) {
                final ArrayList<Placement> placementList = new ArrayList<Placement>(placements);
                Collections.sort(placementList, new Comparator<Placement>(){

                    @Override
                    public int compare(Placement o1, Placement o2) {
                        return Integer.valueOf(o1.getAutoCachePriority()).compareTo(o2.getAutoCachePriority());
                    }
                });
                Log.d((String)TAG, (String)"starting jobs for autocached advs");
                ExecutorService uiExecutor = serviceLocator.getService(Executors.class).getUIExecutor();
                uiExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        for (Placement placement : placementList) {
                            if (!placement.isAutoCached()) continue;
                            adLoader.loadEndless(placement, 0L);
                        }
                    }
                });
            }
            jobRunner.execute(SendReportsJob.makeJobInfo(true));
        }
        catch (Throwable throwable) {
            isInitialized = false;
            isInitializing.set(false);
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)throwable));
            if (throwable instanceof HttpException) {
                callback.onError(new VungleException(3));
            }
            if (throwable instanceof DatabaseHelper.DBException) {
                callback.onError(new VungleException(26));
            }
            callback.onError(new VungleException(2));
        }
    }

    public static boolean isInitialized() {
        return isInitialized && Vungle._instance.context != null;
    }

    public static void setIncentivizedFields(final @Nullable String userID, final @Nullable String title, final @Nullable String body, final @Nullable String keepWatching, final @Nullable String close) {
        if (Vungle._instance.context == null) {
            Log.e((String)TAG, (String)"Vungle is not initialized, context is null");
            return;
        }
        final ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
        serviceLocator.getService(Executors.class).getBackgroundExecutor().execute(new Runnable(){

            @Override
            public void run() {
                if (!Vungle.isInitialized()) {
                    Log.e((String)TAG, (String)"Vungle is not initialized");
                    return;
                }
                Repository repository = serviceLocator.getService(Repository.class);
                Cookie incentivizedCookie = repository.load("incentivizedTextSetByPub", Cookie.class).get();
                if (incentivizedCookie == null) {
                    incentivizedCookie = new Cookie("incentivizedTextSetByPub");
                }
                boolean changed = false;
                if (!TextUtils.isEmpty((CharSequence)title)) {
                    changed = true;
                    incentivizedCookie.putValue("title", title);
                }
                if (!TextUtils.isEmpty((CharSequence)body)) {
                    changed = true;
                    incentivizedCookie.putValue("body", body);
                }
                if (!TextUtils.isEmpty((CharSequence)keepWatching)) {
                    changed = true;
                    incentivizedCookie.putValue("continue", keepWatching);
                }
                if (!TextUtils.isEmpty((CharSequence)close)) {
                    changed = true;
                    incentivizedCookie.putValue("close", close);
                }
                if (!TextUtils.isEmpty((CharSequence)userID)) {
                    changed = true;
                    incentivizedCookie.putValue("userID", userID);
                }
                if (changed) {
                    try {
                        repository.save(incentivizedCookie);
                    }
                    catch (DatabaseHelper.DBException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public static boolean canPlayAd(final @NonNull String id) {
        final Context context = Vungle._instance.context;
        if (context == null) {
            Log.e((String)TAG, (String)"Context is null");
            return false;
        }
        ServiceLocator serviceLocator = ServiceLocator.getInstance(context);
        Executors sdkExecutors = serviceLocator.getService(Executors.class);
        TimeoutProvider provider = serviceLocator.getService(TimeoutProvider.class);
        FutureResult<Boolean> futureResult = new FutureResult<Boolean>(sdkExecutors.getApiExecutor().submit(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                if (!Vungle.isInitialized()) {
                    Log.e((String)TAG, (String)"Vungle is not initialized");
                    return false;
                }
                ServiceLocator serviceLocator = ServiceLocator.getInstance(context);
                Repository repository = serviceLocator.getService(Repository.class);
                Advertisement advertisement = repository.findValidAdvertisementForPlacement(id).get();
                Placement placement = repository.load(id, Placement.class).get();
                if (advertisement == null || placement == null) {
                    return false;
                }
                if (placement.getPlacementAdType() != 0 || !AdConfig.AdSize.isDefaultAdSize(placement.getAdSize()) && !placement.getAdSize().equals((Object)advertisement.getAdConfig().getAdSize())) {
                    return false;
                }
                return Vungle.canPlayAd(advertisement);
            }
        }));
        return Boolean.TRUE.equals(futureResult.get(provider.getTimeout(), TimeUnit.MILLISECONDS));
    }

    static boolean canPlayAd(Advertisement advertisement) {
        if (Vungle._instance.context == null) {
            return false;
        }
        AdLoader adLoader = ServiceLocator.getInstance(Vungle._instance.context).getService(AdLoader.class);
        return adLoader.canPlayAd(advertisement);
    }

    public static void playAd(final @NonNull String id, final AdConfig settings, @Nullable PlayAdCallback callback) {
        if (!Vungle.isInitialized()) {
            Log.e((String)TAG, (String)"Locator is not initialized");
            if (callback != null) {
                callback.onError(id, new VungleException(9));
            }
            return;
        }
        ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
        final Executors sdkExecutors = serviceLocator.getService(Executors.class);
        final Repository repository = serviceLocator.getService(Repository.class);
        final AdLoader adLoader = serviceLocator.getService(AdLoader.class);
        final VungleApiClient vungleApiClient = serviceLocator.getService(VungleApiClient.class);
        final PlayAdCallbackWrapper listener = new PlayAdCallbackWrapper(sdkExecutors.getUIExecutor(), callback);
        sdkExecutors.getBackgroundExecutor().execute(new Runnable(){

            @Override
            public void run() {
                if (Boolean.TRUE.equals(_instance.playOperations.get(id)) || adLoader.isLoading(id)) {
                    listener.onError(id, new VungleException(8));
                    return;
                }
                final Placement placement = repository.load(id, Placement.class).get();
                if (placement == null) {
                    listener.onError(id, new VungleException(13));
                    return;
                }
                if (AdConfig.AdSize.isBannerAdSize(placement.getAdSize())) {
                    listener.onError(id, new VungleException(28));
                    return;
                }
                boolean streamingOnly = false;
                Advertisement advertisement = repository.findValidAdvertisementForPlacement(id).get();
                try {
                    if (!Vungle.canPlayAd(advertisement)) {
                        streamingOnly = true;
                        if (advertisement != null && advertisement.getState() == 1) {
                            repository.saveAndApplyState(advertisement, id, 4);
                            if (placement.isAutoCached()) {
                                adLoader.loadEndless(placement, 0L);
                            }
                        }
                    } else {
                        advertisement.configure(settings);
                        repository.save(advertisement);
                    }
                }
                catch (DatabaseHelper.DBException ignored) {
                    listener.onError(id, new VungleException(26));
                    return;
                }
                if (_instance.context != null) {
                    final boolean finalStreamingOnly = streamingOnly;
                    final Advertisement finalAdvertisement = advertisement;
                    if (vungleApiClient.canCallWillPlayAd()) {
                        vungleApiClient.willPlayAd(placement.getId(), placement.isAutoCached(), streamingOnly ? "" : advertisement.getAdToken()).enqueue(new Callback<JsonObject>(){

                            @Override
                            public void onResponse(Call<JsonObject> call, final Response<JsonObject> response) {
                                sdkExecutors.getBackgroundExecutor().execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        JsonObject responseBody;
                                        Advertisement streamingAd = null;
                                        if (response.isSuccessful() && (responseBody = (JsonObject)response.body()) != null && responseBody.has("ad")) {
                                            try {
                                                JsonObject adJson = responseBody.getAsJsonObject("ad");
                                                streamingAd = new Advertisement(adJson);
                                                streamingAd.configure(settings);
                                                repository.saveAndApplyState(streamingAd, id, 0);
                                            }
                                            catch (IllegalArgumentException e) {
                                                Log.v((String)TAG, (String)"Will Play Ad did not respond with a replacement. Move on.");
                                            }
                                            catch (Exception e) {
                                                Log.e((String)TAG, (String)"Error using will_play_ad!", (Throwable)e);
                                            }
                                        }
                                        if (finalStreamingOnly) {
                                            if (streamingAd == null) {
                                                listener.onError(id, new VungleException(1));
                                            } else {
                                                Vungle.renderAd(id, listener, placement, streamingAd);
                                            }
                                        } else {
                                            Vungle.renderAd(id, listener, placement, finalAdvertisement);
                                        }
                                    }
                                });
                            }

                            @Override
                            public void onFailure(Call<JsonObject> call, Throwable throwable) {
                                sdkExecutors.getBackgroundExecutor().execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (finalStreamingOnly) {
                                            listener.onError(id, new VungleException(1));
                                        } else {
                                            Vungle.renderAd(id, listener, placement, finalAdvertisement);
                                        }
                                    }
                                });
                            }
                        });
                    } else if (finalStreamingOnly) {
                        listener.onError(id, new VungleException(1));
                    } else {
                        Vungle.renderAd(id, listener, placement, finalAdvertisement);
                    }
                }
            }
        });
    }

    private static synchronized void renderAd(@NonNull String placementId, @Nullable PlayAdCallback listener, Placement placement, Advertisement advertisement) {
        if (!Vungle.isInitialized()) {
            Log.e((String)TAG, (String)"Sdk is not initilized");
            return;
        }
        ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
        VungleActivity.setEventListener(new AdEventListener(placementId, (Map)Vungle._instance.playOperations, listener, serviceLocator.getService(Repository.class), serviceLocator.getService(AdLoader.class), serviceLocator.getService(JobRunner.class), serviceLocator.getService(VisionController.class), placement, advertisement){

            @Override
            protected void onFinished() {
                super.onFinished();
                VungleActivity.setEventListener(null);
            }
        });
        boolean isFlex = advertisement != null && "flexview".equals(advertisement.getTemplateType());
        Intent intent = new Intent(Vungle._instance.context, isFlex ? VungleFlexViewActivity.class : VungleActivity.class);
        intent.addFlags(0x10000000);
        intent.putExtra("placement", placementId);
        if (Build.VERSION.SDK_INT >= 29) {
            Vungle._instance.context.startActivity(intent);
        } else {
            ActivityManager.startWhenForeground(Vungle._instance.context, intent);
        }
    }

    public static void loadAd(@NonNull String id, @Nullable LoadAdCallback callback) {
        Vungle.loadAd(id, new AdConfig(), callback);
    }

    public static void loadAd(@NonNull String id, @Nullable AdConfig adConfig, @Nullable LoadAdCallback callback) {
        if (!Vungle.isInitialized()) {
            Log.e((String)TAG, (String)"Vungle is not initialized");
            if (callback != null) {
                callback.onError(id, new VungleException(9));
            }
            return;
        }
        if (adConfig != null && !AdConfig.AdSize.isDefaultAdSize(adConfig.getAdSize()) && callback != null) {
            callback.onError(id, new VungleException(29));
        }
        Vungle.loadAdInternal(id, adConfig, callback);
    }

    static void loadAdInternal(@NonNull String id, @Nullable AdConfig adConfig, @Nullable LoadAdCallback callback) {
        if (!Vungle.isInitialized()) {
            Log.e((String)TAG, (String)"Vungle is not initialized");
            if (callback != null) {
                callback.onError(id, new VungleException(9));
            }
            return;
        }
        ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
        LoadAdCallbackWrapper listener = new LoadAdCallbackWrapper(serviceLocator.getService(Executors.class).getUIExecutor(), callback);
        serviceLocator.getService(AdLoader.class).load(id, adConfig == null ? new AdConfig() : adConfig, listener);
    }

    private static void clearCache() {
        if (!Vungle.isInitialized()) {
            Log.e((String)TAG, (String)"Vungle is not initialized");
            return;
        }
        final ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
        serviceLocator.getService(Executors.class).getBackgroundExecutor().execute(new Runnable(){

            @Override
            public void run() {
                serviceLocator.getService(Downloader.class).cancelAll();
                serviceLocator.getService(AdLoader.class).clear();
                serviceLocator.getService(Repository.class).clearAllData();
                _instance.playOperations.clear();
                _instance.ccpaStatus = null;
                _instance.configure(serviceLocator.getService(RuntimeValues.class).initCallback.get());
            }
        });
    }

    private static void clearAdvertisements() {
        if (!Vungle.isInitialized()) {
            Log.e((String)TAG, (String)"Vungle is not initialized");
            return;
        }
        final ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
        serviceLocator.getService(Executors.class).getBackgroundExecutor().execute(new Runnable(){

            @Override
            public void run() {
                serviceLocator.getService(Downloader.class).cancelAll();
                serviceLocator.getService(AdLoader.class).clear();
                final Repository repository = serviceLocator.getService(Repository.class);
                Executors sdkExecutors = serviceLocator.getService(Executors.class);
                sdkExecutors.getBackgroundExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        List<Advertisement> ads = repository.loadAll(Advertisement.class).get();
                        if (ads != null) {
                            for (Advertisement ad : ads) {
                                try {
                                    repository.deleteAdvertisement(ad.getId());
                                }
                                catch (DatabaseHelper.DBException dBException) {}
                            }
                        }
                    }
                });
            }
        });
    }

    @Nullable
    public static VungleNativeAd getNativeAd(@NonNull String placementId, @Nullable AdConfig adConfig, @Nullable PlayAdCallback playAdCallback) {
        if (adConfig == null) {
            adConfig = new AdConfig();
        }
        if (AdConfig.AdSize.isDefaultAdSize(adConfig.getAdSize())) {
            return Vungle.getNativeAdInternal(placementId, adConfig, playAdCallback);
        }
        if (playAdCallback != null) {
            Log.e((String)TAG, (String)"Please use Banners.getBanner(... ) to retrieve Banner Ad");
            playAdCallback.onError(placementId, new VungleException(29));
        }
        return null;
    }

    @Nullable
    static VungleNativeView getNativeAdInternal(String placementId, AdConfig adConfig, PlayAdCallback playAdCallback) {
        if (Vungle._instance.context == null) {
            Log.e((String)TAG, (String)"Vungle is not initialized, returned VungleNativeAd = null");
            if (playAdCallback != null) {
                playAdCallback.onError(placementId, new VungleException(9));
            }
            return null;
        }
        ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
        AdLoader adLoader = serviceLocator.getService(AdLoader.class);
        if (Boolean.TRUE.equals(Vungle._instance.playOperations.get(placementId)) || adLoader.isLoading(placementId)) {
            Log.e((String)TAG, (String)("Playing or Loading operation ongoing. Playing " + Vungle._instance.playOperations.get(placementId) + " Loading: " + adLoader.isLoading(placementId)));
            if (playAdCallback != null) {
                playAdCallback.onError(placementId, new VungleException(8));
            }
            return null;
        }
        return new VungleNativeView(Vungle._instance.context.getApplicationContext(), placementId, adConfig, serviceLocator.getService(PresentationFactory.class), new AdEventListener(placementId, Vungle._instance.playOperations, playAdCallback, serviceLocator.getService(Repository.class), adLoader, serviceLocator.getService(JobRunner.class), serviceLocator.getService(VisionController.class), null, null));
    }

    public static Collection<String> getValidPlacements() {
        if (!Vungle.isInitialized()) {
            Log.e((String)TAG, (String)"Vungle is not initialized return empty placements list");
            return Collections.emptyList();
        }
        ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
        Repository repository = serviceLocator.getService(Repository.class);
        TimeoutProvider provider = serviceLocator.getService(TimeoutProvider.class);
        Collection<String> placements = repository.getValidPlacementIds().get(provider.getTimeout(), TimeUnit.MILLISECONDS);
        if (placements == null) {
            return Collections.emptyList();
        }
        return placements;
    }

    @VisibleForTesting
    static Collection<Placement> getValidPlacementModels() {
        if (!Vungle.isInitialized()) {
            Log.e((String)TAG, (String)"Vungle is not initialized return empty placements list");
            return Collections.emptyList();
        }
        ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
        Repository repository = serviceLocator.getService(Repository.class);
        TimeoutProvider provider = serviceLocator.getService(TimeoutProvider.class);
        Collection<Placement> placements = repository.loadValidPlacements().get(provider.getTimeout(), TimeUnit.MILLISECONDS);
        if (placements == null) {
            return Collections.emptyList();
        }
        return placements;
    }

    public static void updateConsentStatus(@NonNull Consent status, @Nullable String consentMessageVersion) {
        if (status == null) {
            Log.e((String)TAG, (String)"Cannot set consent with a null consent, please check your code");
            return;
        }
        Vungle._instance.consent.set(status);
        Vungle._instance.consentVersion = consentMessageVersion;
        if (Vungle.isInitialized() && isDepInit.get()) {
            ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
            Repository repository = serviceLocator.getService(Repository.class);
            Vungle.saveGDPRConsent(repository, Vungle._instance.consent.get(), Vungle._instance.consentVersion);
        } else {
            Log.e((String)TAG, (String)"Vungle is not initialized");
        }
    }

    private static void saveGDPRConsent(final @NonNull Repository repository, final @NonNull Consent status, final @Nullable String consentMessageVersion) {
        repository.load("consentIsImportantToVungle", Cookie.class, new Repository.LoadCallback<Cookie>(){

            @Override
            public void onLoaded(Cookie gdprConsent) {
                if (gdprConsent == null) {
                    gdprConsent = new Cookie("consentIsImportantToVungle");
                }
                gdprConsent.putValue("consent_status", status == Consent.OPTED_IN ? "opted_in" : "opted_out");
                gdprConsent.putValue("timestamp", System.currentTimeMillis() / 1000L);
                gdprConsent.putValue("consent_source", "publisher");
                gdprConsent.putValue("consent_message_version", consentMessageVersion == null ? "" : consentMessageVersion);
                repository.save(gdprConsent, null);
            }
        });
    }

    @Nullable
    public static Consent getConsentStatus() {
        return Vungle._instance.consent.get();
    }

    public static String getConsentMessageVersion() {
        return Vungle._instance.consentVersion;
    }

    private static Consent getConsent(Cookie gdprConsent) {
        if (gdprConsent == null) {
            return null;
        }
        return "opted_in".equals(gdprConsent.getString("consent_status")) ? Consent.OPTED_IN : Consent.OPTED_OUT;
    }

    private static String getConsentMessageVersion(Cookie gdprConsent) {
        if (gdprConsent == null) {
            return null;
        }
        return gdprConsent.getString("consent_message_version");
    }

    public static void updateCCPAStatus(@NonNull Consent status) {
        if (status == null) {
            Log.e((String)TAG, (String)"Unable to update CCPA status, Invalid input parameter.");
            return;
        }
        Vungle._instance.ccpaStatus = status;
        if (!Vungle.isInitialized() || !isDepInit.get()) {
            Log.e((String)TAG, (String)"Vungle is not initialized");
            return;
        }
        ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
        Repository repository = serviceLocator.getService(Repository.class);
        Vungle.updateCCPAStatus(repository, status);
    }

    private static void updateCCPAStatus(@NonNull Repository repository, @NonNull Consent status) {
        Cookie ccpaConsent = repository.load("ccpaIsImportantToVungle", Cookie.class).get();
        if (ccpaConsent == null) {
            ccpaConsent = new Cookie("ccpaIsImportantToVungle");
        }
        ccpaConsent.putValue("ccpa_status", status == Consent.OPTED_OUT ? "opted_out" : "opted_in");
        try {
            repository.save(ccpaConsent);
        }
        catch (DatabaseHelper.DBException e) {
            Log.e((String)TAG, (String)("Unable to update CCPA status: Database exception." + e.getLocalizedMessage()));
        }
    }

    @Nullable
    public static Consent getCCPAStatus() {
        return Vungle._instance.ccpaStatus;
    }

    private static Consent getCCPAStatus(@Nullable Cookie ccpaConsent) {
        if (ccpaConsent == null) {
            return null;
        }
        return "opted_out".equals(ccpaConsent.getString("ccpa_status")) ? Consent.OPTED_OUT : Consent.OPTED_IN;
    }

    @Nullable
    public static String getAvailableBidTokens(final int maxBidTokenSize) {
        Context context = Vungle._instance.context;
        if (context == null) {
            Log.e((String)TAG, (String)"Context is null");
            return null;
        }
        ServiceLocator serviceLocator = ServiceLocator.getInstance(context);
        Executors sdkExecutors = serviceLocator.getService(Executors.class);
        TimeoutProvider provider = serviceLocator.getService(TimeoutProvider.class);
        FutureResult<String> futureResult = new FutureResult<String>(sdkExecutors.getApiExecutor().submit(new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (!Vungle.isInitialized()) {
                    Log.e((String)TAG, (String)"Vungle is not initialized, available bid token is null");
                    return null;
                }
                _instance.hbpOrdinalViewCount.incrementAndGet();
                Repository repository = ServiceLocator.getInstance(_instance.context).getService(Repository.class);
                List<String> availableBidTokens = repository.getAvailableBidTokens(maxBidTokenSize).get();
                if (availableBidTokens == null || availableBidTokens.isEmpty()) {
                    return null;
                }
                String encodeVersion = "2";
                String bidTokens = TextUtils.join((CharSequence)",", availableBidTokens);
                String bidTokensWithOrdinalViewCount = bidTokens + ":" + _instance.hbpOrdinalViewCount.toString();
                byte[] tokenBytes = Base64.encode((byte[])bidTokensWithOrdinalViewCount.getBytes(), (int)2);
                String encodedTokenChain = new String(tokenBytes, Charset.defaultCharset());
                return encodeVersion + ":" + encodedTokenChain;
            }
        }));
        return futureResult.get(provider.getTimeout(), TimeUnit.MILLISECONDS);
    }

    public static boolean closeFlexViewAd(@NonNull String placementReferenceId) {
        if (!Vungle.isInitialized()) {
            Log.e((String)TAG, (String)"Vungle is not initialized, can't close flex view ad");
            return false;
        }
        Intent broadcast = new Intent("AdvertisementBus");
        broadcast.putExtra("placement", placementReferenceId);
        broadcast.putExtra("command", "closeFlex");
        LocalBroadcastManager.getInstance((Context)Vungle._instance.context).sendBroadcast(broadcast);
        return true;
    }

    public static void setHeaderBiddingCallback(HeaderBiddingCallback headerBiddingCallback) {
        if (Vungle._instance.context == null) {
            return;
        }
        ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
        RuntimeValues runtimeValues = serviceLocator.getService(RuntimeValues.class);
        runtimeValues.headerBiddingCallback.set(new HeaderBiddingCallbackWrapper(serviceLocator.getService(Executors.class).getUIExecutor(), headerBiddingCallback));
    }

    protected static void deInit() {
        if (Vungle._instance.context != null) {
            ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
            if (serviceLocator.isCreated(CacheManager.class)) {
                serviceLocator.getService(CacheManager.class).removeListener(cacheListener);
            }
            if (serviceLocator.isCreated(Downloader.class)) {
                serviceLocator.getService(Downloader.class).cancelAll();
            }
            if (serviceLocator.isCreated(AdLoader.class)) {
                serviceLocator.getService(AdLoader.class).clear();
            }
            Vungle._instance.playOperations.clear();
        }
        ServiceLocator.deInit();
        isInitialized = false;
        isDepInit.set(false);
        isInitializing.set(false);
    }

    private static void stopPlaying() {
        if (Vungle._instance.context == null) {
            return;
        }
        Intent broadcast = new Intent("AdvertisementBus");
        broadcast.putExtra("command", "stopAll");
        LocalBroadcastManager.getInstance((Context)Vungle._instance.context).sendBroadcast(broadcast);
    }

    @Nullable
    static Context appContext() {
        if (_instance != null) {
            return Vungle._instance.context;
        }
        return null;
    }

    static {
        isInitializing = new AtomicBoolean(false);
        isDepInit = new AtomicBoolean(false);
        cacheListener = new CacheManager.Listener(){

            @Override
            public void onCacheChanged() {
                if (_instance.context == null) {
                    return;
                }
                Vungle.stopPlaying();
                ServiceLocator serviceLocator = ServiceLocator.getInstance(_instance.context);
                CacheManager cacheManager = serviceLocator.getService(CacheManager.class);
                Downloader downloader = serviceLocator.getService(Downloader.class);
                if (cacheManager.getCache() != null) {
                    List<DownloadRequest> requests = downloader.getAllRequests();
                    String newPath = cacheManager.getCache().getPath();
                    for (DownloadRequest request : requests) {
                        if (request.path.startsWith(newPath)) continue;
                        downloader.cancel(request);
                    }
                }
                downloader.init();
            }
        };
    }

    @Keep
    public static enum Consent {
        OPTED_IN,
        OPTED_OUT;

    }
}

