/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import android.annotation.TargetApi;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.vungle.warren.model.Cookie;
import com.vungle.warren.model.VisionData;
import com.vungle.warren.persistence.DatabaseHelper;
import com.vungle.warren.persistence.Repository;
import com.vungle.warren.utility.NetworkProvider;
import com.vungle.warren.vision.VisionAggregationData;
import com.vungle.warren.vision.VisionAggregationInfo;
import com.vungle.warren.vision.VisionConfig;
import java.util.List;
import java.util.concurrent.TimeUnit;

class VisionController {
    static final String VISION = "vision";
    static final String VISION_COOKIE = "visionCookie";
    static final String DATA_SCIENCE_CACHE = "data_science_cache";
    static final String AGGREGATE = "aggregate";
    static final String WINDOW = "window";
    static final String LAST_VIEWED_CREATIVE_ID = "last_viewed_creative_id";
    static final String LAST_VIEWED_CAMPAIGN_ID = "last_viewed_campaign_id";
    static final String LAST_VIEWED_ADVERTISER_ID = "last_viewed_advertiser_id";
    static final String TOTAL_VIEW_COUNT = "total_view_count";
    static final String VIEW_COUNT = "view_count";
    static final String LAST_TIME_VIEWED = "last_time_viewed";
    static final String CREATIVE_DETAILS = "creative_details";
    static final String CAMPAIGN_DETAILS = "campaign_details";
    static final String ADVERTISER_DETAILS = "advertiser_details";
    static final String FILTER_ID = "_id";
    @NonNull
    private final Repository repository;
    @NonNull
    private final NetworkProvider networkProvider;
    @NonNull
    private VisionConfig config = new VisionConfig();

    VisionController(@NonNull Repository repository, @NonNull NetworkProvider networkProvider) {
        this.repository = repository;
        this.networkProvider = networkProvider;
    }

    @Nullable
    private String getDataScienceCache() {
        Cookie cookie = this.repository.load(VISION_COOKIE, Cookie.class).get();
        return cookie == null ? null : cookie.getString(DATA_SCIENCE_CACHE);
    }

    void setDataScienceCache(@Nullable String cache) throws DatabaseHelper.DBException {
        Cookie cookie = new Cookie(VISION_COOKIE);
        if (cache != null) {
            cookie.putValue(DATA_SCIENCE_CACHE, cache);
        }
        this.repository.save(cookie);
    }

    void setConfig(@NonNull VisionConfig config) throws DatabaseHelper.DBException {
        this.config = config;
        if (config.enabled) {
            this.repository.trimVisionData(config.viewLimit != null ? config.viewLimit.device : 0);
        }
    }

    void reportData(@NonNull String creative, @NonNull String campaign, @NonNull String advertiser) throws DatabaseHelper.DBException {
        this.repository.save(new VisionData(System.currentTimeMillis(), creative, campaign, advertiser));
        this.repository.trimVisionData(this.config.viewLimit != null ? this.config.viewLimit.device : 0);
    }

    void clearData() throws DatabaseHelper.DBException {
        this.repository.trimVisionData(0);
    }

    @TargetApi(value=21)
    @NonNull
    public JsonObject getPayload() {
        JsonObject vision = new JsonObject();
        String data_science_cache = this.getDataScienceCache();
        if (data_science_cache != null) {
            vision.addProperty(DATA_SCIENCE_CACHE, data_science_cache);
        }
        int limit = 0;
        if (this.config.viewLimit != null) {
            switch (this.networkProvider.getCurrentNetworkType()) {
                case 1: 
                case 6: 
                case 9: {
                    limit = this.config.viewLimit.wifi > 0 ? this.config.viewLimit.wifi : this.config.viewLimit.device;
                    break;
                }
                case 0: 
                case 4: 
                case 7: 
                case 17: {
                    limit = this.config.viewLimit.mobile > 0 ? this.config.viewLimit.mobile : this.config.viewLimit.device;
                    break;
                }
                default: {
                    limit = this.config.viewLimit.device;
                }
            }
        }
        long start = System.currentTimeMillis();
        JsonArray windows = new JsonArray();
        vision.add(AGGREGATE, (JsonElement)windows);
        if (this.config.aggregationTimeWindows != null) {
            for (int window : this.config.aggregationTimeWindows) {
                long after = start - TimeUnit.DAYS.toMillis(window);
                VisionAggregationInfo info = this.repository.getVisionAggregationInfo(after).get();
                JsonObject windowData = new JsonObject();
                windowData.addProperty(WINDOW, (Number)window);
                windowData.addProperty(LAST_VIEWED_CREATIVE_ID, info != null ? info.lastCreative : null);
                windowData.addProperty(TOTAL_VIEW_COUNT, (Number)(info != null ? info.totalCount : 0));
                if (this.config.aggregationFilters != null) {
                    for (String filter : this.config.aggregationFilters) {
                        JsonArray details = new JsonArray();
                        windowData.add(filter, (JsonElement)details);
                        filter = this.getFilterName(filter);
                        List<VisionAggregationData> data = this.repository.getVisionAggregationData(after, limit, filter).get();
                        if (data == null) continue;
                        for (VisionAggregationData d : data) {
                            JsonObject elem = new JsonObject();
                            elem.addProperty(filter + FILTER_ID, d.id);
                            elem.addProperty(VIEW_COUNT, (Number)d.viewCount);
                            elem.addProperty(LAST_TIME_VIEWED, (Number)TimeUnit.MILLISECONDS.toSeconds(d.lastTimeStamp));
                            details.add((JsonElement)elem);
                        }
                    }
                }
                windows.add((JsonElement)windowData);
            }
        }
        return vision;
    }

    @VisibleForTesting
    String getFilterName(String filter) {
        switch (filter) {
            case "creative_details": {
                return "creative";
            }
            case "campaign_details": {
                return "campaign";
            }
            case "advertiser_details": {
                return "advertiser";
            }
        }
        return null;
    }

    @VisibleForTesting
    VisionConfig getVisionConfig() {
        return this.config;
    }

    boolean isEnabled() {
        return this.config.enabled;
    }
}

