/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vungle.warren.AdLoader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.atomic.AtomicInteger;

class OperationSequence {
    private final PriorityQueue<Entry> queue = new PriorityQueue<Entry>(11, new Comparator<Entry>(){

        @Override
        public int compare(Entry e1, Entry e2) {
            int result = Integer.valueOf(e1.operation.priority).compareTo(e2.operation.priority);
            if (result == 0) {
                return Integer.valueOf(e1.order).compareTo(e2.order);
            }
            return result;
        }
    });
    private String currentId = null;
    private Map<String, AdLoader.Operation> loadOperations;
    private Callback callback;

    OperationSequence() {
    }

    public void init(Callback callback, Map<String, AdLoader.Operation> loadOperations) {
        this.callback = callback;
        this.loadOperations = loadOperations;
    }

    @Nullable
    private Entry get(String id) {
        for (Entry op : this.queue) {
            if (!op.operation.id.equals(id)) continue;
            return op;
        }
        return null;
    }

    synchronized void offer(AdLoader.Operation op) {
        AdLoader.Operation current = this.loadOperations.get(op.id);
        if (current != null) {
            int oldPriority = current.priority;
            current.merge(op);
            if (current.priority < oldPriority) {
                this.callback.onChangePriority(current);
            }
        } else {
            Entry next = this.get(op.id);
            if (next != null) {
                this.queue.remove(next);
                next.operation.merge(op);
                op = next.operation;
            }
            if (op.priority <= 0) {
                this.callback.onLoadNext(op);
            } else {
                this.queue.offer(next == null ? new Entry(op) : next);
                this.reportFinished(null);
            }
        }
    }

    synchronized void reportFinished(String finished) {
        if (this.currentId == null || this.currentId.equals(finished)) {
            this.currentId = null;
            Entry next = this.queue.poll();
            if (next != null) {
                this.currentId = next.operation.id;
                this.callback.onLoadNext(next.operation);
            }
        }
    }

    synchronized List<AdLoader.Operation> removeAll() {
        this.currentId = null;
        ArrayList<AdLoader.Operation> ops = new ArrayList<AdLoader.Operation>();
        while (!this.queue.isEmpty()) {
            Entry e = this.queue.poll();
            if (e == null) continue;
            ops.add(e.operation);
        }
        return ops;
    }

    public synchronized boolean contains(String id) {
        return this.get(id) != null;
    }

    private static class Entry {
        private static final AtomicInteger seq = new AtomicInteger();
        private final int order = seq.incrementAndGet();
        @NonNull
        AdLoader.Operation operation;

        Entry(@NonNull AdLoader.Operation operation) {
            this.operation = operation;
        }
    }

    static interface Callback {
        public void onLoadNext(AdLoader.Operation var1);

        public void onChangePriority(AdLoader.Operation var1);
    }
}

