/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import com.vungle.warren.utility.NetworkProvider;

public class NetworkProviderReceiver
extends BroadcastReceiver {
    private static final String TAG = NetworkProviderReceiver.class.getSimpleName();

    public void onReceive(Context context, Intent intent) {
        if (context != null && "android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction())) {
            NetworkProvider.getInstance(context).onNetworkChanged();
        }
    }

    public static void enableBroadcastReceiver(Context context, boolean state) {
        PackageManager pm = context.getPackageManager();
        ComponentName componentName = new ComponentName(context, NetworkProviderReceiver.class);
        if (NetworkProviderReceiver.hasReceiver(context)) {
            pm.setComponentEnabledSetting(componentName, state ? 1 : 2, 1);
        }
    }

    public static boolean isEnabledBroadcastReceiver(Context context) {
        PackageManager pm = context.getPackageManager();
        ComponentName componentName = new ComponentName(context, NetworkProviderReceiver.class);
        return NetworkProviderReceiver.hasReceiver(context) && pm.getComponentEnabledSetting(componentName) == 1;
    }

    public static boolean hasReceiver(Context context) {
        ComponentName componentName = new ComponentName(context, NetworkProviderReceiver.class);
        PackageManager pm = context.getPackageManager();
        try {
            ActivityInfo activityInfo = pm.getReceiverInfo(componentName, 640);
            return activityInfo != null;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }
}

